/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.biopax.paxtools.controller.AbstractPropertyEditor;
import org.biopax.paxtools.controller.DataPropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class PrimitivePropertyEditor<D extends BioPAXElement, R>
extends AbstractPropertyEditor<D, R>
implements DataPropertyEditor<D, R> {
    private R unknownValue = null;

    public PrimitivePropertyEditor(String property, Method getMethod, Class<D> domain, Class<R> range, boolean multipleCardinality) {
        super(property, getMethod, domain, range, multipleCardinality);
        assert (range == Boolean.class || range.isPrimitive());
        if (range.equals(Double.TYPE)) {
            this.unknownValue = BioPAXElement.UNKNOWN_DOUBLE;
        } else if (range.equals(Float.TYPE)) {
            this.unknownValue = BioPAXElement.UNKNOWN_FLOAT;
        } else if (range.equals(Integer.TYPE)) {
            this.unknownValue = BioPAXElement.UNKNOWN_INT;
        }
    }

    @Override
    protected R parseValueFromString(String s) {
        Class range = this.getRange();
        Constable value = null;
        try {
            if (range.equals(Double.TYPE)) {
                value = Double.valueOf(s);
            } else if (range.equals(Float.TYPE)) {
                value = Float.valueOf(s);
            } else if (range.equals(Integer.TYPE)) {
                value = Integer.valueOf(s);
            } else if (range.equals(Boolean.class)) {
                value = Boolean.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalBioPAXArgumentException("Failed to convert literal " + s + " to " + range.getSimpleName() + " for " + this.property, e);
        }
        return (R)value;
    }

    @Override
    public boolean isUnknown(Object value) {
        return value instanceof Set ? this.emptySetOrContainsOnlyUnknowns((Set)value) : this.emptySetOrContainsOnlyUnknowns(Collections.singleton(value));
    }

    private boolean emptySetOrContainsOnlyUnknowns(Set value) {
        for (Object o : value) {
            if (o == this.unknownValue || o.equals(this.unknownValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public R getUnknown() {
        return this.unknownValue;
    }
}

