/*
 * Decompiled with CFR 0.152.
 */
package cpath.service.jaxb;

import cpath.service.jaxb.SearchHit;
import cpath.service.jaxb.ServiceResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="searchResponse")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SearchResponse")
public class SearchResponse
extends ServiceResponse {
    @XmlAttribute
    private Integer numHits;
    @XmlAttribute
    private Integer maxHitsPerPage;
    private List<SearchHit> searchHit;
    @XmlAttribute
    private Integer pageNo;
    @XmlAttribute
    private String comment;
    @XmlTransient
    private Set<String> providers;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<SearchHit> getSearchHit() {
        if (this.searchHit == null) {
            this.searchHit = new ArrayList<SearchHit>();
        }
        return this.searchHit;
    }

    public void setSearchHit(List<SearchHit> searchHit) {
        this.searchHit = searchHit;
    }

    public Integer getNumHits() {
        return this.numHits;
    }

    public void setNumHits(Integer numHits) {
        this.numHits = numHits;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(Integer pageNo) {
        if (pageNo < 0) {
            throw new IllegalArgumentException("Negative values are not supported");
        }
        this.pageNo = pageNo;
    }

    @Override
    @XmlTransient
    public boolean isEmpty() {
        return this.getSearchHit().isEmpty();
    }

    public Integer getMaxHitsPerPage() {
        return this.maxHitsPerPage;
    }

    public void setMaxHitsPerPage(Integer maxHitsPerPage) {
        this.maxHitsPerPage = maxHitsPerPage;
    }

    public int numPages() {
        if (this.numHits > 0 && this.maxHitsPerPage > 0) {
            return (this.numHits - 1) / this.maxHitsPerPage + 1;
        }
        return 0;
    }

    @XmlTransient
    public Set<String> getProviders() {
        if (this.providers == null) {
            this.providers = new HashSet<String>();
        }
        return this.providers;
    }

    public void setProviders(Set<String> providers) {
        this.providers = providers;
    }

    public Set<String> provenanceUris() {
        HashSet<String> provUris = new HashSet<String>();
        if (this.searchHit != null) {
            for (SearchHit hit : this.searchHit) {
                if (!"Provenance".equalsIgnoreCase(hit.getBiopaxClass())) {
                    provUris.addAll(hit.getDataSource());
                    continue;
                }
                provUris.add(hit.getUri());
            }
        }
        return provUris;
    }
}

