/*
 * Decompiled with CFR 0.152.
 */
package cpath.service;

import java.util.ArrayList;

public enum Status {
    BAD_REQUEST(452, "Bad Request (illegal or no arguments)"),
    NO_RESULTS_FOUND(460, "No Results Found"),
    INTERNAL_ERROR(500, "Internal Server Error"),
    MAINTENANCE(503, "Server is temporarily unavailable due to regular maintenance");

    private final Integer errorCode;
    private final String errorMsg;

    private Status(int errorCode, String msg) {
        this.errorCode = errorCode;
        this.errorMsg = msg;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public static ArrayList<String> getAllStatusCodes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Status statusCode : Status.values()) {
            list.add(statusCode.name());
        }
        return list;
    }

    public static Status fromCode(int code) {
        for (Status type : Status.values()) {
            if (type.getErrorCode() != code) continue;
            return type;
        }
        return null;
    }
}

