/*
 * Decompiled with CFR 0.152.
 */
package cpath.service;

import cpath.service.CmdArgs;

public enum Cmd {
    SEARCH("Full-text search for BioPAX objects. It accepts up to five parameters and returns the ordered list of search hits, which are simplified description of BioPAX elements matching the query and passing all filters. A hit's uri (same as the corresponding BioPAX object's RDF ID) can be used with other webservice commands to extract the corresponding sub-model to BioPAX or another supported format. ", "/search?q=brca*&organism=9606", "Search Response that lists Search Hits - XML (default) or JSON (when called as '/search.json?')", CmdArgs.q, CmdArgs.page, CmdArgs.type, CmdArgs.organism, CmdArgs.datasource),
    GET("Gets a BioPAX element or sub-model by ID(s).  This command has two parameters.", "/get?uri=http://identifiers.org/uniprot/P38398", "BioPAX by default, other formats as specified by the format parameter.  See the <a href=\"#valid_output_parameter\">valid values for format parameter</a> below.", CmdArgs.uri, CmdArgs.format),
    GRAPH("Executes an advanced graph query on the data within pathway commons. Returns a sub-model as the result. This command has up to six parameters.", "/graph?kind=neighborhood&source=URI1&source=URI2&...", "BioPAX by default, other formats as specified by the format parameter. See the <a href=\"#valid_output_parameter\">valid values for format parameter</a> below.", CmdArgs.kind, CmdArgs.source, CmdArgs.target, CmdArgs.format, CmdArgs.limit, CmdArgs.direction, CmdArgs.organism, CmdArgs.datasource),
    TOP_PATHWAYS("Gets Top Pathways. This command accepts optional filter by organism and by datasource values", "/top_pathways", "Search Response - XML (JSON, when called as '/top_pathways.json?') contains the list of all top pathways.", CmdArgs.organism, CmdArgs.datasource),
    TRAVERSE("Gets data property values (or elements's URIs) at the end of the property path.  This command has two parameters.", "/traverse?uri=http://identifiers.org/uniprot/P38398&path=ProteinReference/organism/displayName", "Traverse Response - XML (or JSON, when called as '/traverse.json?').", CmdArgs.path, CmdArgs.uri);

    private final CmdArgs[] args;
    private final String info;
    private final String example;
    private final String output;

    public CmdArgs[] getArgs() {
        return this.args;
    }

    public String getInfo() {
        return this.info;
    }

    public String getExample() {
        return this.example;
    }

    public String getOutput() {
        return this.output;
    }

    private Cmd(String info, String example, String output, CmdArgs ... args) {
        this.info = info;
        this.example = example;
        this.output = output;
        this.args = args;
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

