/*
 * Decompiled with CFR 0.152.
 */
package cpath.query;

import cpath.client.CPathClient;
import cpath.client.util.CPathException;
import cpath.query.BaseCPathQuery;
import cpath.query.CPathQuery;
import cpath.service.Cmd;
import cpath.service.CmdArgs;
import cpath.service.OutputFormat;
import cpath.service.jaxb.SearchResponse;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.biopax.paxtools.model.BioPAXElement;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class CPathSearchQuery
extends BaseCPathQuery<SearchResponse>
implements CPathQuery<SearchResponse> {
    private String queryString;
    private String type;
    private String[] organism;
    private String[] datasource;
    private Integer page = 0;
    private boolean multi = false;
    private static final int ALL_PAGES = -13;

    @Override
    protected MultiValueMap<String, String> getRequestParams() {
        LinkedMultiValueMap<String, String> request = new LinkedMultiValueMap<String, String>();
        if (this.queryString == null || this.queryString.isEmpty()) {
            throw new IllegalArgumentException("'queryString' parameter is required.");
        }
        request.add(CmdArgs.q.name(), this.queryString);
        if (this.type != null) {
            request.add(CmdArgs.type.name(), this.type);
        }
        if (this.page != null && this.page > 0) {
            request.add(CmdArgs.page.name(), this.page.toString());
        }
        if (this.organism != null) {
            request.put(CmdArgs.organism.name(), (String)((Object)Arrays.asList(this.organism)));
        }
        if (this.datasource != null) {
            request.put(CmdArgs.datasource.name(), (String)((Object)Arrays.asList(this.datasource)));
        }
        return request;
    }

    public CPathSearchQuery(CPathClient client) {
        this.client = client;
        this.command = Cmd.SEARCH.toString();
        this.page = 0;
        this.multi = false;
    }

    public CPathSearchQuery queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public CPathSearchQuery typeFilter(Class<? extends BioPAXElement> type) {
        this.type = type.getSimpleName();
        return this;
    }

    public CPathSearchQuery typeFilter(String type) {
        this.type = type;
        return this;
    }

    public CPathSearchQuery page(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("Negative page number");
        }
        this.page = page;
        this.multi = false;
        return this;
    }

    public CPathSearchQuery allPages() {
        this.multi = true;
        this.page = -13;
        if (this.queryString == null || this.queryString.isEmpty()) {
            this.queryString = "*";
        }
        return this;
    }

    public CPathSearchQuery topPages(int lastPage) {
        if (this.page <= 0) {
            throw new IllegalArgumentException("The last page number must be greater than zero");
        }
        this.multi = true;
        this.page = lastPage;
        return this;
    }

    public CPathSearchQuery organismFilter(String[] organisms) {
        this.organism = organisms;
        return this;
    }

    public CPathSearchQuery datasourceFilter(String[] datasources) {
        this.datasource = datasources;
        return this;
    }

    public CPathSearchQuery organismFilter(Collection<String> organisms) {
        this.organism = organisms.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    public CPathSearchQuery datasourceFilter(Collection<String> datasources) {
        this.datasource = datasources.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    @Override
    public String stringResult(OutputFormat outputFormat) throws CPathException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResponse result() throws CPathException {
        if (!this.multi) {
            return this.client.post(this.command, this.getRequestParams(), SearchResponse.class);
        }
        return this.multiPageResult();
    }

    private SearchResponse multiPageResult() throws CPathException {
        SearchResponse mulRes = null;
        Integer last = this.page;
        MultiValueMap<String, String> request = this.getRequestParams();
        assert (this.multi && last != 0) : "bug: multiPageResult is called, whereas page==0, multi==true";
        if (last == 0) {
            return this.client.post(this.command, request, SearchResponse.class);
        }
        Integer p = 0;
        do {
            request.put(CmdArgs.page.name(), (String)((Object)Arrays.asList(p.toString())));
            SearchResponse res = this.client.post(this.command, request, SearchResponse.class);
            if (res == null || res.isEmpty()) break;
            if (mulRes == null) {
                mulRes = res;
                int totPages = res.numPages();
                if (last == -13 || last >= totPages) {
                    last = totPages - 1;
                }
            } else {
                mulRes.getSearchHit().addAll(res.getSearchHit());
            }
            Integer n = p;
            Integer n2 = p = Integer.valueOf(p + 1);
        } while (p <= last);
        if (mulRes != null) {
            mulRes.setComment(mulRes.getComment() + " This result combines top hits from multiple result pages: from 0 to " + last);
        }
        return mulRes;
    }
}

