/*
 * Decompiled with CFR 0.152.
 */
package cpath.query;

import cpath.client.CPathClient;
import cpath.client.util.CPathException;
import cpath.query.BaseCPathQuery;
import cpath.query.CPathQuery;
import cpath.service.Cmd;
import cpath.service.CmdArgs;
import cpath.service.OutputFormat;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.model.Model;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class CPathGetQuery
extends BaseCPathQuery<Model>
implements CPathQuery<Model> {
    private boolean mergeEquivalentInteractions = false;
    private String[] source;

    @Override
    protected MultiValueMap<String, String> getRequestParams() {
        LinkedMultiValueMap<String, String> request = new LinkedMultiValueMap<String, String>();
        if (this.source == null || this.source.length == 0) {
            throw new IllegalArgumentException("Required list of URIs/IDs cannot be null or empty");
        }
        request.put(CmdArgs.uri.name(), (String)((Object)Arrays.asList(this.source)));
        return request;
    }

    public CPathGetQuery(CPathClient client) {
        this.client = client;
    }

    public CPathGetQuery sources(String[] sources) {
        this.source = sources;
        return this;
    }

    public CPathGetQuery sources(Collection<String> sources) {
        this.source = sources.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    public void mergeEquivalentInteractions(boolean mergeEquivalentInteractions) {
        this.mergeEquivalentInteractions = mergeEquivalentInteractions;
    }

    @Override
    public String stringResult(OutputFormat format) throws CPathException {
        MultiValueMap<String, String> request = this.getRequestParams();
        if (format == null) {
            format = OutputFormat.BIOPAX;
        }
        request.add(CmdArgs.format.name(), format.name());
        return this.client.post(Cmd.GET.toString(), request, String.class);
    }

    @Override
    public Model result() throws CPathException {
        Model model = this.client.post(Cmd.GET.toString(), this.getRequestParams(), Model.class);
        if (this.mergeEquivalentInteractions && model != null) {
            ModelUtils.mergeEquivalentInteractions(model);
        }
        return model;
    }
}

