/*
 * Decompiled with CFR 0.152.
 */
package cpath.config;

import cpath.service.Scope;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CPathSettings {
    private static final Logger LOG = LoggerFactory.getLogger(CPathSettings.class);
    private static CPathSettings instance;
    private Properties settings;
    public static final String HOME_DIR = "CPATH2_HOME";
    public static final String CPATH_PROPERTIES_FILE = "cpath2.properties";
    public static final String DATA_SUBDIR = "data";
    public static final String DOWNLOADS_SUBDIR = "downloads";
    public static final String CACHE_SUBDIR = "cache";
    public static final String INDEX_SUBDIR = "index";
    public static final String BLACKLIST_FILE = "blacklist.txt";
    public static final String METADATA_FILE = "metadata.conf";
    public static final String CPATH2_GENERATED_COMMENT = "cPath2-generated";
    public static final String PROP_ADMIN_USER = "cpath2.admin.user";
    public static final String PROP_ADMIN_PASSW = "cpath2.admin.password";
    public static final String PROP_ADMIN_ENABLED = "cpath2.admin.enabled";
    public static final String PROP_XML_BASE = "cpath2.xml.base";
    public static final String PROP_MAX_SEARCH_HITS_PER_PAGE = "cpath2.maxSearchHitsPerPage";
    public static final String PROP_DEBUG_ENABLED = "cpath2.debug.enabled";
    public static final String PROP_BLACKLIST_DEGREE_THRESHOLD = "cpath2.blacklist.degree.threshold";
    public static final String PROP_BLACKLIST_CONTROL_THRESHOLD = "cpath2.blacklist.control.threshold";
    public static final String PROP_METADATA_LOCATION = "cpath2.metadata.location";
    public static final String PROVIDER_NAME = "cpath2.provider.name";
    public static final String PROVIDER_DESCRIPTION = "cpath2.provider.description";
    public static final String PROVIDER_VERSION = "cpath2.provider.version";
    public static final String PROVIDER_URL = "cpath2.provider.url";
    public static final String PROVIDER_LOGO_URL = "cpath2.provider.logo.url";
    public static final String PROVIDER_ORGANISMS = "cpath2.provider.organisms";
    public static final String PROP_LOG_START = "cpath2.log.start";
    public static final String PROP_LOG_END = "cpath2.log.end";
    private static final DateFormat ISO_DATE_FORMAT;

    private CPathSettings() {
        String home = System.getProperty(HOME_DIR);
        if (home == null || home.isEmpty()) {
            throw new AssertionError((Object)"Java option CPATH2_HOME is undefined!");
        }
        File f = new File(home);
        if (!f.exists()) {
            f.mkdir();
        }
        Properties defaults = new Properties();
        defaults.put(PROP_XML_BASE, "http://purl.org/pc2/test/");
        defaults.put(PROVIDER_NAME, "cPath2 Demo");
        defaults.put(PROVIDER_VERSION, "0");
        defaults.put(PROVIDER_DESCRIPTION, "cPath2 Demo");
        defaults.put(PROVIDER_ORGANISMS, "homo sapiens");
        defaults.put(PROP_BLACKLIST_CONTROL_THRESHOLD, "15");
        defaults.put(PROP_BLACKLIST_DEGREE_THRESHOLD, "100");
        defaults.put(PROP_MAX_SEARCH_HITS_PER_PAGE, "500");
        defaults.put(PROP_METADATA_LOCATION, this.homeDir() + File.separator + METADATA_FILE);
        defaults.put(PROP_DEBUG_ENABLED, "false");
        defaults.put(PROP_ADMIN_ENABLED, "false");
        this.settings = new Properties(defaults);
        this.loadCPathProperties();
    }

    public static synchronized CPathSettings getInstance() {
        if (instance == null) {
            instance = new CPathSettings();
        }
        return instance;
    }

    public String getName() {
        return this.property(PROVIDER_NAME);
    }

    public void setName(String name) {
        this.setCPathProperty(PROVIDER_NAME, name);
    }

    public String getDescription() {
        return this.property(PROVIDER_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.setCPathProperty(PROVIDER_DESCRIPTION, description);
    }

    public String getLogoUrl() {
        return this.property(PROVIDER_LOGO_URL);
    }

    public void setLogoUrl(String logoUrl) {
        this.setCPathProperty(PROVIDER_LOGO_URL, logoUrl);
    }

    public String getUrl() {
        return this.property(PROVIDER_URL);
    }

    public void setUrl(String url) {
        this.setCPathProperty(PROVIDER_URL, url);
    }

    public String[] getOrganisms() {
        String orgs = this.property(PROVIDER_ORGANISMS);
        return orgs.split("\\s*,\\s*");
    }

    public void setOrganisms(String[] organisms) {
        this.setCPathProperty(PROVIDER_ORGANISMS, StringUtils.join((Object[])organisms, ','));
    }

    public String getVersion() {
        return this.property(PROVIDER_VERSION);
    }

    public void setVersion(String version) {
        this.setCPathProperty(PROVIDER_VERSION, version);
    }

    public boolean isAdminEnabled() {
        return "true".equalsIgnoreCase(this.property(PROP_ADMIN_ENABLED));
    }

    public void setAdminEnabled(boolean enabled) {
        this.setCPathProperty(PROP_ADMIN_ENABLED, Boolean.toString(enabled));
    }

    public String getMaxHitsPerPage() {
        return this.property(PROP_MAX_SEARCH_HITS_PER_PAGE);
    }

    public void setMaxHitsPerPage(String maxHitsPerPage) {
        this.setCPathProperty(PROP_MAX_SEARCH_HITS_PER_PAGE, maxHitsPerPage);
    }

    public String getXmlBase() {
        return this.property(PROP_XML_BASE);
    }

    public void setXmlBase(String xmlBase) {
        this.setCPathProperty(PROP_XML_BASE, xmlBase);
    }

    public synchronized String property(String name) {
        String val = System.getProperty(name);
        if (val == null || val.isEmpty()) {
            val = this.settings.getProperty(name);
        }
        return val;
    }

    public void loadCPathProperties() {
        String file = this.homeDir() + File.separator + CPATH_PROPERTIES_FILE;
        try {
            this.settings.load(new FileReader(file));
        }
        catch (IOException e) {
            LOG.warn("Couldn't update cPath2 properties from " + file + "; will use defaults. " + e.toString());
        }
    }

    public void saveCPathProperties() {
        if (!this.isAdminEnabled()) {
            throw new IllegalStateException("Not in Maintenance mode.");
        }
        String file = this.homeDir() + File.separator + CPATH_PROPERTIES_FILE;
        try {
            this.settings.store(new FileOutputStream(file), "cPath2 server configuration properties");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write cPath2 properties to " + file, e);
        }
    }

    public String homeDir() {
        return this.property(HOME_DIR);
    }

    public String dataDir() {
        String path = this.homeDir() + File.separator + DATA_SUBDIR;
        File f = new File(path);
        if (!f.exists()) {
            f.mkdir();
        }
        return path;
    }

    public String indexDir() {
        return this.homeDir() + File.separator + INDEX_SUBDIR;
    }

    public String blacklistFile() {
        return this.downloadsDir() + File.separator + BLACKLIST_FILE;
    }

    public synchronized void setCPathProperty(String name, String value) {
        if (PROP_ADMIN_ENABLED.equals(name) || this.isAdminEnabled()) {
            this.setProp(name, value);
        } else if (PROP_DEBUG_ENABLED.equals(name) || PROP_MAX_SEARCH_HITS_PER_PAGE.equals(name) || PROP_LOG_END.equals(name) || PROP_LOG_START.equals(name)) {
            this.setProp(name, value);
        } else {
            throw new IllegalStateException("Attempt to set property " + name + " when " + PROP_ADMIN_ENABLED + " = false");
        }
    }

    private void setProp(String name, String value) {
        if (value == null) {
            this.settings.remove(name);
            System.getProperties().remove(name);
        } else {
            System.setProperty(name, value);
            this.settings.setProperty(name, value);
        }
    }

    public boolean isDebugEnabled() {
        return "true".equalsIgnoreCase(this.property(PROP_DEBUG_ENABLED));
    }

    public void setDebugEnabled(boolean enabled) {
        this.setCPathProperty(PROP_DEBUG_ENABLED, Boolean.toString(enabled));
    }

    public String downloadsDir() {
        String path = this.homeDir() + File.separator + DOWNLOADS_SUBDIR;
        File f = new File(path);
        if (!f.exists()) {
            f.mkdir();
        }
        return path;
    }

    public String cacheDir() {
        return this.homeDir() + File.separator + CACHE_SUBDIR;
    }

    public String biopaxExportFileName(String name) {
        return this.downloadsDir() + File.separator + this.exportArchivePrefix() + name + ".BIOPAX.owl.gz";
    }

    public String exportArchivePrefix() {
        return this.property(PROVIDER_NAME) + "." + this.property(PROVIDER_VERSION) + ".";
    }

    public String mainModelFile() {
        return this.biopaxExportFileName(Scope.ALL.toString());
    }

    public String warehouseModelFile() {
        return this.biopaxExportFileName(Scope.WAREHOUSE.toString());
    }

    public String getLogStart() {
        return this.property(PROP_LOG_START);
    }

    public void setLogStart(String isoDate) {
        this.setCPathProperty(PROP_LOG_START, this.parse(isoDate));
    }

    public void setLogStart(Date isoDate) {
        if (isoDate == null) {
            this.setCPathProperty(PROP_LOG_START, null);
        } else {
            this.setCPathProperty(PROP_LOG_START, ISO_DATE_FORMAT.format(isoDate));
        }
    }

    public String getLogEnd() {
        return this.property(PROP_LOG_END);
    }

    public void setLogEnd(String isoDate) {
        this.setCPathProperty(PROP_LOG_END, this.parse(isoDate));
    }

    public void setLogEnd(Date isoDate) {
        if (isoDate == null) {
            this.setCPathProperty(PROP_LOG_END, null);
        } else {
            this.setCPathProperty(PROP_LOG_END, ISO_DATE_FORMAT.format(isoDate));
        }
    }

    private String parse(String isoDate) {
        if (isoDate != null) {
            if ((isoDate = isoDate.trim()).isEmpty()) {
                isoDate = null;
            } else {
                try {
                    ISO_DATE_FORMAT.parse(isoDate);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Not an ISO date (yyyy-MM-dd): " + isoDate, e);
                }
            }
        }
        return isoDate;
    }

    static {
        ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    }
}

