from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '1.0.3'
DESCRIPTION = 'Unofficial Exotel SDK For Python'
LONG_DESCRIPTION = 'A package that allows you to make call, send sms and manage campaigns using exotel API'

# Setting up
setup(
    name="pyexotel",
    version=VERSION,
    author="Bijay Nayak",
    author_email="<bijay6779@gmail.com>",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=['requests'],
    keywords=['exotel', 'exotel api', 'exotel sdk', 'pyexotel'],
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)
