# PROJECT : django-easy-validator
# TIME    : 18-1-2 上午9:44
# AUTHOR : Younger Shen
# EMAIL : younger.x.shen@gmail.com
# CELL : 13811754531
# WECHAT : 13811754531
# https://github.com/youngershen/

import os
from setuptools import setup, find_packages


def read(fname):
    with open(os.path.join(os.path.dirname(__file__), fname)) as f:
        return f.read()


setup(
    name='django-easy-validator',

    version='1.6.4',

    description='a very easy use django request POST/GET data validator',

    long_description=read('README.md'),

    long_description_content_type="text/markdown",

    url='https://github.com/youngershen/django-easy-validator',

    # Author details
    author='Younger Shen',
    author_email='shenyangang@163.com',
    author_qq='89198011',
    author_wechat='13811754531',
    author_cell='13811754531',

    # Choose your license
    license='MIT',

    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 5 - Production/Stable',

        # Indicate who your project is intended for
        'Intended Audience :: Developers',

        # Pick your license as you wish (should match "license" above)
        'License :: OSI Approved :: MIT License',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',

        'Framework :: Django :: 1.6',
        'Framework :: Django :: 1.7',
        'Framework :: Django :: 1.8',
        'Framework :: Django :: 1.9',
        'Framework :: Django :: 2.0',
    ],

    # What does your project relate to?
    keywords='a django request POST/GET data validator',

    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    packages=find_packages(),

    install_requires=[
        'Django',
    ],
    python_requires='>=3.6',
)
