/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.viclovsky.swagger.coverage.CoverageOutputWriter;
import com.github.viclovsky.swagger.coverage.SwaggerCoverageUtils;
import com.github.viclovsky.swagger.coverage.SwaggerCoverageWriteException;
import com.github.viclovsky.swagger.coverage.model.SwaggerCoverage2ModelJackson;
import io.swagger.models.Swagger;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class FileSystemOutputWriter
implements CoverageOutputWriter {
    private final Path outputDirectory;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper yamlMapper;

    public FileSystemOutputWriter(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.jsonMapper = SwaggerCoverage2ModelJackson.createJsonMapper();
        this.yamlMapper = SwaggerCoverage2ModelJackson.createYamlMapper();
    }

    private void createDirectories(Path directory) {
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SwaggerCoverageWriteException("Could not create Swagger output directory", e);
        }
    }

    @Override
    public void write(Swagger swagger) {
        String swaggerResultName = SwaggerCoverageUtils.generateJsonCoverageOutputName();
        this.createDirectories(this.outputDirectory);
        Path file = this.outputDirectory.resolve(swaggerResultName);
        try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW);){
            this.jsonMapper.writerWithDefaultPrettyPrinter().writeValue(os, (Object)swagger);
        }
        catch (IOException e) {
            throw new SwaggerCoverageWriteException("Could not write Swagger", e);
        }
    }

    @Override
    public void write(OpenAPI openAPI) {
        String swaggerResultName = SwaggerCoverageUtils.generateYamlCoverageOutputName();
        this.createDirectories(this.outputDirectory);
        Path file = this.outputDirectory.resolve(swaggerResultName);
        try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW);){
            this.yamlMapper.writerWithDefaultPrettyPrinter().writeValue(os, (Object)openAPI);
        }
        catch (IOException e) {
            throw new SwaggerCoverageWriteException("Could not write Swagger", e);
        }
    }
}

