/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.predicate;

import com.github.viclovsky.swagger.coverage.core.generator.SwaggerSpecificationProcessor;
import com.github.viclovsky.swagger.coverage.core.predicate.ParameterConditionPredicate;
import com.github.viclovsky.swagger.coverage.core.predicate.ParameterUtils;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ParameterValueConditionPredicate
extends ParameterConditionPredicate {
    private String name;
    private String in;
    private String reason;
    private List<String> expectedValue = new ArrayList<String>();
    private List<String> currentValue = new ArrayList<String>();

    public ParameterValueConditionPredicate(String name, String in, List<String> value) {
        this.name = name;
        this.expectedValue.addAll(value);
        this.in = in;
    }

    @Override
    public boolean check(List<Parameter> params, Map<String, ApiResponse> responses) {
        Optional<Parameter> p;
        if (params != null && (p = params.stream().filter(ParameterUtils.equalsParam(this.name, this.in)).findFirst()).isPresent()) {
            String val = SwaggerSpecificationProcessor.extractValue(p.get());
            this.currentValue.add(val);
        }
        return true;
    }

    @Override
    public boolean postCheck() {
        boolean covered = this.currentValue.containsAll(this.expectedValue);
        if (!covered) {
            this.expectedValue.removeAll(this.currentValue);
            this.reason = "Missed values " + this.expectedValue.toString();
        }
        return covered;
    }

    @Override
    public boolean hasPostCheck() {
        return true;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public String getName() {
        return this.name;
    }

    public ParameterValueConditionPredicate setName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getValue() {
        return this.expectedValue;
    }

    public ParameterValueConditionPredicate setValue(List<String> value) {
        this.expectedValue = value;
        return this;
    }
}

