/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.predicate;

import com.github.viclovsky.swagger.coverage.core.generator.SwaggerSpecificationProcessor;
import com.github.viclovsky.swagger.coverage.core.predicate.ParameterConditionPredicate;
import com.github.viclovsky.swagger.coverage.core.predicate.ParameterUtils;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class NotOnlyParameterListValueConditionPredicate
extends ParameterConditionPredicate {
    private String name;
    private String in;
    private String reason;
    private Set<String> expectedValue = new HashSet<String>();
    private Set<String> currentValue = new HashSet<String>();

    public NotOnlyParameterListValueConditionPredicate(String name, String in, List<String> value) {
        this.name = name;
        this.in = in;
        this.expectedValue.addAll(value);
        this.reason = "Checked values: -";
    }

    @Override
    public boolean check(List<Parameter> params, Map<String, ApiResponse> responses) {
        Optional<Parameter> p;
        if (params != null && (p = params.stream().filter(ParameterUtils.equalsParam(this.name, this.in)).findFirst()).isPresent()) {
            String val = SwaggerSpecificationProcessor.extractValue(p.get());
            this.currentValue.add(val);
        }
        return true;
    }

    @Override
    public boolean postCheck() {
        this.reason = "Checked values: " + this.currentValue.toString();
        this.currentValue.removeAll(this.expectedValue);
        return !this.currentValue.isEmpty();
    }

    @Override
    public boolean hasPostCheck() {
        return true;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public String getName() {
        return this.name;
    }

    public NotOnlyParameterListValueConditionPredicate setName(String name) {
        this.name = name;
        return this;
    }

    public Set<String> getValue() {
        return this.expectedValue;
    }

    public NotOnlyParameterListValueConditionPredicate setValue(Set<String> value) {
        this.expectedValue = value;
        return this;
    }
}

