/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.predicate;

import com.github.viclovsky.swagger.coverage.core.predicate.ParameterConditionPredicate;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FullStatusConditionPredicate
extends ParameterConditionPredicate {
    private Set<String> expectedStatuses;
    private Set<String> currentStatuses = new HashSet<String>();
    private String reason;

    public FullStatusConditionPredicate(Set<String> expectedStatuses) {
        this.expectedStatuses = expectedStatuses;
    }

    @Override
    public boolean check(List<Parameter> params, Map<String, ApiResponse> responses) {
        responses.forEach((key, value) -> this.currentStatuses.add((String)key));
        return true;
    }

    @Override
    public boolean postCheck() {
        if (this.currentStatuses.isEmpty() && this.expectedStatuses != null) {
            this.reason = "No call - no statuses...";
            return false;
        }
        boolean covered = this.expectedStatuses.containsAll(this.currentStatuses);
        if (!covered) {
            this.currentStatuses.removeAll(this.expectedStatuses);
            this.reason = "Undeclared status: " + String.join((CharSequence)",", this.currentStatuses);
        }
        return covered;
    }

    @Override
    public boolean hasPostCheck() {
        return true;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public Set<String> getExpectedStatuses() {
        return this.expectedStatuses;
    }

    public FullStatusConditionPredicate setExpectedStatuses(Set<String> expectedStatuses) {
        this.expectedStatuses = expectedStatuses;
        return this;
    }

    public Set<String> getCurrentStatuses() {
        return this.currentStatuses;
    }

    public FullStatusConditionPredicate setCurrentStatuses(Set<String> currentStatuses) {
        this.currentStatuses = currentStatuses;
        return this;
    }
}

