/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.predicate;

import com.github.viclovsky.swagger.coverage.core.generator.SwaggerSpecificationProcessor;
import com.github.viclovsky.swagger.coverage.core.predicate.ParameterConditionPredicate;
import com.github.viclovsky.swagger.coverage.core.predicate.ParameterUtils;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultParameterValueConditionPredicate
extends ParameterConditionPredicate {
    private String name;
    private String in;
    private String reason;
    private String expectedValue;
    private List<String> currentValue = new ArrayList<String>();

    public DefaultParameterValueConditionPredicate(String name, String in, String value) {
        this.name = name;
        this.in = in;
        this.expectedValue = value;
    }

    @Override
    public boolean check(List<Parameter> params, Map<String, ApiResponse> responses) {
        Optional<Parameter> p;
        if (params != null && (p = params.stream().filter(ParameterUtils.equalsParam(this.name, this.in)).findFirst()).isPresent()) {
            String val = SwaggerSpecificationProcessor.extractValue(p.get());
            this.currentValue.add(val);
        }
        return this.currentValue.contains(this.expectedValue);
    }

    @Override
    public boolean postCheck() {
        return false;
    }

    @Override
    public boolean hasPostCheck() {
        return false;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public String getName() {
        return this.name;
    }

    public DefaultParameterValueConditionPredicate setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.expectedValue;
    }

    public DefaultParameterValueConditionPredicate setValue(String value) {
        this.expectedValue = value;
        return this;
    }
}

