from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions
from ...... import enums
from ...... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Select:
	"""Select commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("select", core, parent)

	def set(self, demod_mode: enums.MarkerDemodMode, window=repcap.Window.Default, marker=repcap.Marker.Default) -> None:
		"""SCPI: CALCulate<n>:MARKer<m>:FUNCtion:DEModulation:SELect \n
		Snippet: driver.calculate.marker.function.demodulation.select.set(demod_mode = enums.MarkerDemodMode.AC, window = repcap.Window.Default, marker = repcap.Marker.Default) \n
		This command selects the demodulation mode at the marker position. \n
			:param demod_mode: AM AM demodulation FM FM demodulation PM FM demodulation AC AC video demodulation AUDio Audio demodulation
			:param window: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Calculate')
			:param marker: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Marker')
		"""
		param = Conversions.enum_scalar_to_str(demod_mode, enums.MarkerDemodMode)
		window_cmd_val = self._cmd_group.get_repcap_cmd_value(window, repcap.Window)
		marker_cmd_val = self._cmd_group.get_repcap_cmd_value(marker, repcap.Marker)
		self._core.io.write(f'CALCulate{window_cmd_val}:MARKer{marker_cmd_val}:FUNCtion:DEModulation:SELect {param}')
