from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions
from ...... import enums


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Pilots:
	"""Pilots commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("pilots", core, parent)

	def set(self, mode: enums.PilotSeqMode) -> None:
		"""SCPI: [SENSe]:TRACking:PILots \n
		Snippet: driver.applications.k91Wlan.sense.tracking.pilots.set(mode = enums.PilotSeqMode.DETected) \n
		In case tracking is used, the used pilot sequence has an effect on the measurement results. For details see 'Tracking the
		phase drift, timing jitter and gain'. \n
			:param mode: STANdard | DETected STANdard The pilot sequence is determined according to the corresponding WLAN standard. In case the pilot generation algorithm of the device under test (DUT) has a problem, the non-standard-conform pilot sequence might affect the measurement results, or the R&S FSW WLAN application might not synchronize at all onto the signal generated by the DUT. DETected The pilot sequence detected in the WLAN signal to be analyzed is used by the R&S FSW WLAN application. In case the pilot generation algorithm of the device under test (DUT) has a problem, the non-standard-conform pilot sequence will not affect the measurement results. In case the pilot sequence generated by the DUT is correct, it is recommended that you use the 'According to Standard' setting because it generates more accurate measurement results.
		"""
		param = Conversions.enum_scalar_to_str(mode, enums.PilotSeqMode)
		self._core.io.write(f'SENSe:TRACking:PILots {param}')

	# noinspection PyTypeChecker
	def get(self) -> enums.PilotSeqMode:
		"""SCPI: [SENSe]:TRACking:PILots \n
		Snippet: value: enums.PilotSeqMode = driver.applications.k91Wlan.sense.tracking.pilots.get() \n
		In case tracking is used, the used pilot sequence has an effect on the measurement results. For details see 'Tracking the
		phase drift, timing jitter and gain'. \n
			:return: mode: STANdard | DETected STANdard The pilot sequence is determined according to the corresponding WLAN standard. In case the pilot generation algorithm of the device under test (DUT) has a problem, the non-standard-conform pilot sequence might affect the measurement results, or the R&S FSW WLAN application might not synchronize at all onto the signal generated by the DUT. DETected The pilot sequence detected in the WLAN signal to be analyzed is used by the R&S FSW WLAN application. In case the pilot generation algorithm of the device under test (DUT) has a problem, the non-standard-conform pilot sequence will not affect the measurement results. In case the pilot sequence generated by the DUT is correct, it is recommended that you use the 'According to Standard' setting because it generates more accurate measurement results."""
		response = self._core.io.query_str(f'SENSe:TRACking:PILots?')
		return Conversions.str_to_scalar_enum(response, enums.PilotSeqMode)
