from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Ifreq:
	"""Ifreq commands group definition. 4 total commands, 4 Subgroups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("ifreq", core, parent)

	@property
	def source(self):
		"""source commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_source'):
			from .Source import Source
			self._source = Source(self._core, self._cmd_group)
		return self._source

	@property
	def ifFrequency(self):
		"""ifFrequency commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_ifFrequency'):
			from .IfFrequency import IfFrequency
			self._ifFrequency = IfFrequency(self._core, self._cmd_group)
		return self._ifFrequency

	@property
	def state(self):
		"""state commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_state'):
			from .State import State
			self._state = State(self._core, self._cmd_group)
		return self._state

	@property
	def sband(self):
		"""sband commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_sband'):
			from .Sband import Sband
			self._sband = Sband(self._core, self._cmd_group)
		return self._sband

	def clone(self) -> 'Ifreq':
		"""Clones the group by creating new object from it and its whole existing subgroups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Ifreq(self._core, self._cmd_group.parent)
		self._cmd_group.synchronize_repcaps(new_group)
		return new_group
