from .........Internal.Core import Core
from .........Internal.CommandsGroup import CommandsGroup
from .........Internal import Conversions
from ......... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class RefPosition:
	"""RefPosition commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("refPosition", core, parent)

	def set(self, position: float, window=repcap.Window.Default) -> None:
		"""SCPI: DISPlay[:WINDow<n>]:TRACe:Y[:SCALe]:RPOSition \n
		Snippet: driver.applications.k50Spurious.display.window.trace.y.scale.refPosition.set(position = 1.0, window = repcap.Window.Default) \n
		This command defines the vertical position of the reference level on the display grid (for all traces) . The R&S FSW
		adjusts the scaling of the y-axis accordingly. \n
			:param position: No help available
			:param window: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Window')
		"""
		param = Conversions.decimal_value_to_str(position)
		window_cmd_val = self._cmd_group.get_repcap_cmd_value(window, repcap.Window)
		self._core.io.write(f'DISPlay:WINDow{window_cmd_val}:TRACe:Y:SCALe:RPOSition {param}')

	def get(self, window=repcap.Window.Default) -> float:
		"""SCPI: DISPlay[:WINDow<n>]:TRACe:Y[:SCALe]:RPOSition \n
		Snippet: value: float = driver.applications.k50Spurious.display.window.trace.y.scale.refPosition.get(window = repcap.Window.Default) \n
		This command defines the vertical position of the reference level on the display grid (for all traces) . The R&S FSW
		adjusts the scaling of the y-axis accordingly. \n
			:param window: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Window')
			:return: position: No help available"""
		window_cmd_val = self._cmd_group.get_repcap_cmd_value(window, repcap.Window)
		response = self._core.io.query_str(f'DISPlay:WINDow{window_cmd_val}:TRACe:Y:SCALe:RPOSition?')
		return Conversions.str_to_float(response)
