from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions
from ...... import enums


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Morder:
	"""Morder commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("morder", core, parent)

	def set(self, state: enums.DpdOrder) -> None:
		"""SCPI: CONFigure:DPD:MORDer \n
		Snippet: driver.applications.k18AmplifierEt.configure.dpd.morder.set(state = enums.DpdOrder.AMFirst) \n
		No command help available \n
			:param state: No help available
		"""
		param = Conversions.enum_scalar_to_str(state, enums.DpdOrder)
		self._core.io.write(f'CONFigure:DPD:MORDer {param}')

	# noinspection PyTypeChecker
	def get(self) -> enums.DpdOrder:
		"""SCPI: CONFigure:DPD:MORDer \n
		Snippet: value: enums.DpdOrder = driver.applications.k18AmplifierEt.configure.dpd.morder.get() \n
		No command help available \n
			:return: state: No help available"""
		response = self._core.io.query_str(f'CONFigure:DPD:MORDer?')
		return Conversions.str_to_scalar_enum(response, enums.DpdOrder)
