from .............Internal.Core import Core
from .............Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Ptrs:
	"""Ptrs commands group definition. 9 total commands, 9 Subgroups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("ptrs", core, parent)

	@property
	def k(self):
		"""k commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_k'):
			from .K import K
			self._k = K(self._core, self._cmd_group)
		return self._k

	@property
	def lpy(self):
		"""lpy commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_lpy'):
			from .Lpy import Lpy
			self._lpy = Lpy(self._core, self._cmd_group)
		return self._lpy

	@property
	def ngroups(self):
		"""ngroups commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_ngroups'):
			from .Ngroups import Ngroups
			self._ngroups = Ngroups(self._core, self._cmd_group)
		return self._ngroups

	@property
	def nid(self):
		"""nid commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_nid'):
			from .Nid import Nid
			self._nid = Nid(self._core, self._cmd_group)
		return self._nid

	@property
	def niId(self):
		"""niId commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_niId'):
			from .NiId import NiId
			self._niId = NiId(self._core, self._cmd_group)
		return self._niId

	@property
	def nsamples(self):
		"""nsamples commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_nsamples'):
			from .Nsamples import Nsamples
			self._nsamples = Nsamples(self._core, self._cmd_group)
		return self._nsamples

	@property
	def power(self):
		"""power commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_power'):
			from .Power import Power
			self._power = Power(self._core, self._cmd_group)
		return self._power

	@property
	def reOffset(self):
		"""reOffset commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_reOffset'):
			from .ReOffset import ReOffset
			self._reOffset = ReOffset(self._core, self._cmd_group)
		return self._reOffset

	@property
	def state(self):
		"""state commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_state'):
			from .State import State
			self._state = State(self._core, self._cmd_group)
		return self._state

	def clone(self) -> 'Ptrs':
		"""Clones the group by creating new object from it and its whole existing subgroups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Ptrs(self._core, self._cmd_group.parent)
		self._cmd_group.synchronize_repcaps(new_group)
		return new_group
