from .............Internal.Core import Core
from .............Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Ccoding:
	"""Ccoding commands group definition. 4 total commands, 4 Subgroups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("ccoding", core, parent)

	@property
	def imcs(self):
		"""imcs commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_imcs'):
			from .Imcs import Imcs
			self._imcs = Imcs(self._core, self._cmd_group)
		return self._imcs

	@property
	def mcsTable(self):
		"""mcsTable commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_mcsTable'):
			from .McsTable import McsTable
			self._mcsTable = McsTable(self._core, self._cmd_group)
		return self._mcsTable

	@property
	def rvIndex(self):
		"""rvIndex commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_rvIndex'):
			from .RvIndex import RvIndex
			self._rvIndex = RvIndex(self._core, self._cmd_group)
		return self._rvIndex

	@property
	def tbSfs(self):
		"""tbSfs commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_tbSfs'):
			from .TbSfs import TbSfs
			self._tbSfs = TbSfs(self._core, self._cmd_group)
		return self._tbSfs

	def clone(self) -> 'Ccoding':
		"""Clones the group by creating new object from it and its whole existing subgroups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Ccoding(self._core, self._cmd_group.parent)
		self._cmd_group.synchronize_repcaps(new_group)
		return new_group
