from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class State:
	"""State commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("state", core, parent)

	def set(self, state: bool) -> None:
		"""SCPI: CONFigure[:LTE]:CAGGregation:STATe \n
		Snippet: driver.applications.k10Xlte.configure.lte.caggregation.state.set(state = False) \n
		This command turns carrier aggregation for time alignment error measurements on and off. You can select the number of
		component carriers with method RsFsw.Applications.K10x_Lte.Configure.Lte.NoCc.set. \n
			:param state: ON | OFF | 1 | 0
		"""
		param = Conversions.bool_to_str(state)
		self._core.io.write(f'CONFigure:LTE:CAGGregation:STATe {param}')

	def get(self) -> bool:
		"""SCPI: CONFigure[:LTE]:CAGGregation:STATe \n
		Snippet: value: bool = driver.applications.k10Xlte.configure.lte.caggregation.state.get() \n
		This command turns carrier aggregation for time alignment error measurements on and off. You can select the number of
		component carriers with method RsFsw.Applications.K10x_Lte.Configure.Lte.NoCc.set. \n
			:return: state: ON | OFF | 1 | 0"""
		response = self._core.io.query_str(f'CONFigure:LTE:CAGGregation:STATe?')
		return Conversions.str_to_bool(response)
