from setuptools import setup, find_packages
import os
# import shutil  
# js_path = os.path.join(os.path.dirname(__file__),'areix_io' ,'autoscale_cb.js')
# js_path_new = os.path.join(os.path.dirname(__file__),'dist' ,'autoscale_cb.js')
# dest = shutil.copy(js_path, js_path_new)
# print(dest,'------------')

setup(
    name='Areix_IO',
    version='0.1.4',
    description='Areix IO Backtesting Framework',
    long_description_content_type='text/markdown',
    long_description=open(os.path.join(os.path.dirname(__file__), 'README.md'),encoding='utf-8').read(),
    author='Areix',
    author_email='hellohk@areix-ai.com',
    # packages=find_packages(),
    packages=['areix_io'],
    package_dir={'areix_io': 'dist'},
    include_package_data=True,
    python_requires=">=3.7.0",
    install_requires=[
        # 'empyrical',
        'xlrd==1.2.0',
        'requests',
        'numpy',
        'pandas',
        'matplotlib',
        'bokeh',
        'pyjwt',
        'yfinance',
        'ccxt',
        'scipy'
    ],
    zip_safe=False,
    # url='', # homepage
    # project_urls={
    #     'Documentation': '',
    #     'Source': '',
    #     'Tracker': '',
    # },
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'Intended Audience :: Financial and Insurance Industry',
        'Intended Audience :: Information Technology',
        'Topic :: Software Development :: Build Tools',
        'Topic :: Office/Business :: Financial :: Investment',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Operating System :: OS Independent',
        'Environment :: Console'
    ],
    keywords=[
        'areix',
        'areix_io',
        'alpha_gen',
        'alphagen',
        'wealthx',
        'algo',
        'algorithmic',
        'backtest',
        'backtesting',
        'bitcoin',
        'crypto',
        'bokeh',
        'bonds',
        'candle',
        'candlestick',
        'cboe',
        'chart',
        'cme',
        'commodities',
        'crash',
        'currency',
        'drawdown',
        'equity',
        'etf',
        'ethereum',
        'exchange',
        'finance',
        'financial',
        'forecast',
        'forex',
        'fund',
        'futures',
        'fx',
        'gold',
        'historical',
        'indicator',
        'invest',
        'investing',
        'investment',
        'macd',
        'market',
        'money',
        'ohlc',
        'ohlcv',
        'order',
        'price',
        'profit',
        'quant',
        'quantitative',
        'rsi',
        'pnl',
        'stocks',
        'strategy',
        'ticker',
        'trader',
        'trading',
        'tradingview',
        'usd',
        'binance'
    ],
)
