"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const resource_arn_suffix_1 = require("../resource-arn-suffix");
/**
 * A Step Functions Task to to modify an InstanceFleet on an EMR Cluster.
 *
 * @experimental
 */
class EmrModifyInstanceFleetByName {
    constructor(props) {
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: resource_arn_suffix_1.getResourceArn('elasticmapreduce', 'modifyInstanceFleetByName', sfn.ServiceIntegrationPattern.FIRE_AND_FORGET),
            policyStatements: [
                new iam.PolicyStatement({
                    actions: [
                        'elasticmapreduce:ModifyInstanceFleet',
                        'elasticmapreduce:ListInstanceFleets',
                    ],
                    resources: [`arn:aws:elasticmapreduce:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:cluster/*`],
                }),
            ],
            parameters: {
                ClusterId: this.props.clusterId,
                InstanceFleetName: this.props.instanceFleetName,
                InstanceFleet: {
                    TargetOnDemandCapacity: this.props.targetOnDemandCapacity,
                    TargetSpotCapacity: this.props.targetSpotCapacity,
                },
            },
        };
    }
}
exports.EmrModifyInstanceFleetByName = EmrModifyInstanceFleetByName;
//# sourceMappingURL=data:application/json;base64,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