"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafSwitch = exports.WafSwitchProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const waf_generated_1 = require("./waf.generated");
Object.defineProperty(exports, "WafSwitchProperty", { enumerable: true, get: function () { return waf_generated_1.RosWafSwitch; } });
/**
 * A ROS resource type:  `ALIYUN::WAF::WafSwitch`
 */
class WafSwitch extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::WAF::WafSwitch`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosWafSwitch = new waf_generated_1.RosWafSwitch(this, id, {
            instanceId: props.instanceId,
            region: props.region,
            serviceOn: props.serviceOn,
            domain: props.domain,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWafSwitch;
    }
}
exports.WafSwitch = WafSwitch;
//# sourceMappingURL=data:application/json;base64,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