"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const waf_generated_1 = require("./waf.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return waf_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::WAF::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::WAF::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new waf_generated_1.RosInstance(this, id, {
            bigScreen: props.bigScreen,
            prefessionalService: props.prefessionalService,
            extDomainPackage: props.extDomainPackage,
            logTime: props.logTime,
            renewalStatus: props.renewalStatus,
            renewPeriod: props.renewPeriod,
            period: props.period,
            exclusiveIpPackage: props.exclusiveIpPackage,
            logStorage: props.logStorage,
            subscriptionType: props.subscriptionType,
            extBandwidth: props.extBandwidth,
            wafLog: props.wafLog,
            packageCode: props.packageCode,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrEndDate = rosInstance.attrEndDate;
        this.attrInDebt = rosInstance.attrInDebt;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrRemainDay = rosInstance.attrRemainDay;
        this.attrSubscriptionType = rosInstance.attrSubscriptionType;
        this.attrTrial = rosInstance.attrTrial;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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