"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainConfig = exports.DomainConfigProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const waf_generated_1 = require("./waf.generated");
Object.defineProperty(exports, "DomainConfigProperty", { enumerable: true, get: function () { return waf_generated_1.RosDomainConfig; } });
/**
 * A ROS resource type:  `ALIYUN::WAF::DomainConfig`
 */
class DomainConfig extends ros.Resource {
    /**
     * Create a new `ALIYUN::WAF::DomainConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDomainConfig = new waf_generated_1.RosDomainConfig(this, id, {
            httpToUserIp: props.httpToUserIp,
            httpPort: props.httpPort,
            isAccessProduct: props.isAccessProduct,
            rsType: props.rsType,
            protocols: props.protocols,
            instanceId: props.instanceId,
            sourceIps: props.sourceIps,
            httpsRedirect: props.httpsRedirect,
            region: props.region,
            domain: props.domain,
            loadBalancing: props.loadBalancing,
            httpsPort: props.httpsPort,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomainConfig;
        this.attrCname = rosDomainConfig.attrCname;
        this.attrProtocolType = rosDomainConfig.attrProtocolType;
    }
}
exports.DomainConfig = DomainConfig;
//# sourceMappingURL=data:application/json;base64,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