"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = exports.DomainProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const waf_generated_1 = require("./waf.generated");
Object.defineProperty(exports, "DomainProperty", { enumerable: true, get: function () { return waf_generated_1.RosDomain; } });
/**
 * A ROS resource type:  `ALIYUN::WAF::Domain`
 */
class Domain extends ros.Resource {
    /**
     * Create a new `ALIYUN::WAF::Domain`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDomain = new waf_generated_1.RosDomain(this, id, {
            httpToUserIp: props.httpToUserIp,
            httpPort: props.httpPort,
            isAccessProduct: props.isAccessProduct,
            resourceGroupId: props.resourceGroupId,
            domainName: props.domainName,
            instanceId: props.instanceId,
            sourceIps: props.sourceIps,
            readTime: props.readTime,
            clusterType: props.clusterType,
            loadBalancing: props.loadBalancing,
            logHeaders: props.logHeaders,
            writeTime: props.writeTime,
            http2Port: props.http2Port,
            connectionTime: props.connectionTime,
            httpsRedirect: props.httpsRedirect,
            httpsPort: props.httpsPort,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomain;
        this.attrClusterType = rosDomain.attrClusterType;
        this.attrCname = rosDomain.attrCname;
        this.attrDomainName = rosDomain.attrDomainName;
        this.attrHttp2Port = rosDomain.attrHttp2Port;
        this.attrHttpPort = rosDomain.attrHttpPort;
        this.attrHttpToUserIp = rosDomain.attrHttpToUserIp;
        this.attrHttpsPort = rosDomain.attrHttpsPort;
        this.attrHttpsRedirect = rosDomain.attrHttpsRedirect;
        this.attrInstanceId = rosDomain.attrInstanceId;
        this.attrIsAccessProduct = rosDomain.attrIsAccessProduct;
        this.attrLoadBalancing = rosDomain.attrLoadBalancing;
        this.attrLogHeaders = rosDomain.attrLogHeaders;
        this.attrResourceGroupId = rosDomain.attrResourceGroupId;
        this.attrSourceIps = rosDomain.attrSourceIps;
        this.attrVersion = rosDomain.attrVersion;
    }
}
exports.Domain = Domain;
//# sourceMappingURL=data:application/json;base64,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