"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AclRule = exports.AclRuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const waf_generated_1 = require("./waf.generated");
Object.defineProperty(exports, "AclRuleProperty", { enumerable: true, get: function () { return waf_generated_1.RosAclRule; } });
/**
 * A ROS resource type:  `ALIYUN::WAF::AclRule`
 */
class AclRule extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::WAF::AclRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAclRule = new waf_generated_1.RosAclRule(this, id, {
            instanceId: props.instanceId,
            ruleId: props.ruleId,
            region: props.region,
            domain: props.domain,
            rules: props.rules,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAclRule;
    }
}
exports.AclRule = AclRule;
//# sourceMappingURL=data:application/json;base64,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