"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExposedSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Exposed secret for log configuration
 */
class ExposedSecret {
    constructor(optionName, secretArn) {
        this.optionName = optionName;
        this.secretArn = secretArn;
    }
    /**
     * Use Secrets Manager Secret
     * @param optionName - The name of the option
     * @param secret - A secret from secrets manager
     */
    static fromSecretsManager(optionName, secret) {
        return new ExposedSecret(optionName, secret.secretArn);
    }
    /**
     * User Parameters Store Parameter
     * @param optionName - The name of the option
     * @param parameter - A parameter from parameters store
     */
    static fromParametersStore(optionName, parameter) {
        return new ExposedSecret(optionName, parameter.parameterArn);
    }
}
exports.ExposedSecret = ExposedSecret;
_a = JSII_RTTI_SYMBOL_1;
ExposedSecret[_a] = { fqn: "@aws-cdk/aws-batch-alpha.ExposedSecret", version: "2.32.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhwb3NlZC1zZWNyZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJleHBvc2VkLXNlY3JldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBOztHQUVHO0FBQ0gsTUFBYSxhQUFhO0lBNkJ4QixZQUFZLFVBQWtCLEVBQUUsU0FBaUI7UUFDL0MsSUFBSSxDQUFDLFVBQVUsR0FBRyxVQUFVLENBQUM7UUFDN0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7S0FDNUI7SUEvQkQ7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxVQUFrQixFQUFFLE1BQThCO1FBQ2pGLE9BQU8sSUFBSSxhQUFhLENBQUMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBQztLQUN4RDtJQUVEOzs7O09BSUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsVUFBa0IsRUFBRSxTQUF5QjtRQUM3RSxPQUFPLElBQUksYUFBYSxDQUFDLFVBQVUsRUFBRSxTQUFTLENBQUMsWUFBWSxDQUFDLENBQUM7S0FDOUQ7O0FBakJILHNDQWlDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHNlY3JldHNtYW5hZ2VyIGZyb20gJ2F3cy1jZGstbGliL2F3cy1zZWNyZXRzbWFuYWdlcic7XG5pbXBvcnQgKiBhcyBzc20gZnJvbSAnYXdzLWNkay1saWIvYXdzLXNzbSc7XG5cbi8qKlxuICogRXhwb3NlZCBzZWNyZXQgZm9yIGxvZyBjb25maWd1cmF0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBFeHBvc2VkU2VjcmV0IHtcbiAgLyoqXG4gICAqIFVzZSBTZWNyZXRzIE1hbmFnZXIgU2VjcmV0XG4gICAqIEBwYXJhbSBvcHRpb25OYW1lIC0gVGhlIG5hbWUgb2YgdGhlIG9wdGlvblxuICAgKiBAcGFyYW0gc2VjcmV0IC0gQSBzZWNyZXQgZnJvbSBzZWNyZXRzIG1hbmFnZXJcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVNlY3JldHNNYW5hZ2VyKG9wdGlvbk5hbWU6IHN0cmluZywgc2VjcmV0OiBzZWNyZXRzbWFuYWdlci5JU2VjcmV0KTogRXhwb3NlZFNlY3JldCB7XG4gICAgcmV0dXJuIG5ldyBFeHBvc2VkU2VjcmV0KG9wdGlvbk5hbWUsIHNlY3JldC5zZWNyZXRBcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZXIgUGFyYW1ldGVycyBTdG9yZSBQYXJhbWV0ZXJcbiAgICogQHBhcmFtIG9wdGlvbk5hbWUgLSBUaGUgbmFtZSBvZiB0aGUgb3B0aW9uXG4gICAqIEBwYXJhbSBwYXJhbWV0ZXIgLSBBIHBhcmFtZXRlciBmcm9tIHBhcmFtZXRlcnMgc3RvcmVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVBhcmFtZXRlcnNTdG9yZShvcHRpb25OYW1lOiBzdHJpbmcsIHBhcmFtZXRlcjogc3NtLklQYXJhbWV0ZXIpOiBFeHBvc2VkU2VjcmV0IHtcbiAgICByZXR1cm4gbmV3IEV4cG9zZWRTZWNyZXQob3B0aW9uTmFtZSwgcGFyYW1ldGVyLnBhcmFtZXRlckFybik7XG4gIH1cblxuICAvKipcbiAgICogTmFtZSBvZiB0aGUgb3B0aW9uXG4gICAqL1xuICBwdWJsaWMgb3B0aW9uTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBUk4gb2YgdGhlIHNlY3JldCBvcHRpb25cbiAgICovXG4gIHB1YmxpYyBzZWNyZXRBcm46IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihvcHRpb25OYW1lOiBzdHJpbmcsIHNlY3JldEFybjogc3RyaW5nKSB7XG4gICAgdGhpcy5vcHRpb25OYW1lID0gb3B0aW9uTmFtZTtcbiAgICB0aGlzLnNlY3JldEFybiA9IHNlY3JldEFybjtcbiAgfVxufVxuIl19