#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Oct 28 21:10:10 2014 by generateDS.py version 2.12e.
#
# Command line options:
#   ('-o', 'schema/vchs/ondemand/sc/sc/instanceType.py')
#
# Command line arguments:
#   schema/vchs/ondemand/sc/sc/instance.xsd
#
# Command line:
#   ./generateDS-2.12e/generateDS.py -o "schema/vchs/ondemand/sc/sc/instanceType.py" schema/vchs/ondemand/sc/sc/instance.xsd
#
# Current working directory (os.getcwd()):
#   vchs-api-cli-cli
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class InstanceSpecParamsType(GeneratedsSuper):
    """5.7 Input parameters for creation of instance. Requires details like
    service group id, plan id, name of the instance, etc."""
    subclass = None
    superclass = None
    def __init__(self, name=None, description=None, planId=None, serviceGroupId=None, instanceSpec=None, instanceDefaultSpec=None, bindingSpec=None):
        self.original_tagname_ = None
        self.name = name
        self.description = description
        self.planId = planId
        self.serviceGroupId = serviceGroupId
        self.instanceSpec = instanceSpec
        self.instanceDefaultSpec = instanceDefaultSpec
        self.bindingSpec = bindingSpec
    def factory(*args_, **kwargs_):
        if InstanceSpecParamsType.subclass:
            return InstanceSpecParamsType.subclass(*args_, **kwargs_)
        else:
            return InstanceSpecParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_planId(self): return self.planId
    def set_planId(self, planId): self.planId = planId
    def get_serviceGroupId(self): return self.serviceGroupId
    def set_serviceGroupId(self, serviceGroupId): self.serviceGroupId = serviceGroupId
    def get_instanceSpec(self): return self.instanceSpec
    def set_instanceSpec(self, instanceSpec): self.instanceSpec = instanceSpec
    def get_instanceDefaultSpec(self): return self.instanceDefaultSpec
    def set_instanceDefaultSpec(self, instanceDefaultSpec): self.instanceDefaultSpec = instanceDefaultSpec
    def get_bindingSpec(self): return self.bindingSpec
    def set_bindingSpec(self, bindingSpec): self.bindingSpec = bindingSpec
    def validate_NonEmptyString(self, value):
        # Validate type NonEmptyString, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.description is not None or
            self.planId is not None or
            self.serviceGroupId is not None or
            self.instanceSpec is not None or
            self.instanceDefaultSpec is not None or
            self.bindingSpec is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='instance:', name_='InstanceSpecParamsType', namespacedef_='xmlns:instance="http://www.vmware.com/vchs/sc/instance/v1" xmlns:common="http://www.vmware.com/vchs/sc/common/v1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InstanceSpecParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='instance:', name_='InstanceSpecParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='instance:', name_='InstanceSpecParamsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='instance:', name_='InstanceSpecParamsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.planId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splanId>%s</%splanId>%s' % (namespace_, self.gds_format_string(quote_xml(self.planId).encode(ExternalEncoding), input_name='planId'), namespace_, eol_))
        if self.serviceGroupId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserviceGroupId>%s</%sserviceGroupId>%s' % (namespace_, self.gds_format_string(quote_xml(self.serviceGroupId).encode(ExternalEncoding), input_name='serviceGroupId'), namespace_, eol_))
        if self.instanceSpec is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstanceSpec>%s</%sinstanceSpec>%s' % (namespace_, self.gds_format_string(quote_xml(self.instanceSpec).encode(ExternalEncoding), input_name='instanceSpec'), namespace_, eol_))
        if self.instanceDefaultSpec is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstanceDefaultSpec>%s</%sinstanceDefaultSpec>%s' % (namespace_, self.gds_format_string(quote_xml(self.instanceDefaultSpec).encode(ExternalEncoding), input_name='instanceDefaultSpec'), namespace_, eol_))
        if self.bindingSpec is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbindingSpec>%s</%sbindingSpec>%s' % (namespace_, self.gds_format_string(quote_xml(self.bindingSpec).encode(ExternalEncoding), input_name='bindingSpec'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='InstanceSpecParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.planId is not None:
            showIndent(outfile, level)
            outfile.write('planId=%s,\n' % quote_python(self.planId).encode(ExternalEncoding))
        if self.serviceGroupId is not None:
            showIndent(outfile, level)
            outfile.write('serviceGroupId=%s,\n' % quote_python(self.serviceGroupId).encode(ExternalEncoding))
        if self.instanceSpec is not None:
            showIndent(outfile, level)
            outfile.write('instanceSpec=%s,\n' % quote_python(self.instanceSpec).encode(ExternalEncoding))
        if self.instanceDefaultSpec is not None:
            showIndent(outfile, level)
            outfile.write('instanceDefaultSpec=%s,\n' % quote_python(self.instanceDefaultSpec).encode(ExternalEncoding))
        if self.bindingSpec is not None:
            showIndent(outfile, level)
            outfile.write('bindingSpec=%s,\n' % quote_python(self.bindingSpec).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
            self.validate_NonEmptyString(self.name)    # validate type NonEmptyString
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
            self.validate_NonEmptyString(self.description)    # validate type NonEmptyString
        elif nodeName_ == 'planId':
            planId_ = child_.text
            planId_ = self.gds_validate_string(planId_, node, 'planId')
            self.planId = planId_
            self.validate_NonEmptyString(self.planId)    # validate type NonEmptyString
        elif nodeName_ == 'serviceGroupId':
            serviceGroupId_ = child_.text
            serviceGroupId_ = self.gds_validate_string(serviceGroupId_, node, 'serviceGroupId')
            self.serviceGroupId = serviceGroupId_
            self.validate_NonEmptyString(self.serviceGroupId)    # validate type NonEmptyString
        elif nodeName_ == 'instanceSpec':
            instanceSpec_ = child_.text
            instanceSpec_ = self.gds_validate_string(instanceSpec_, node, 'instanceSpec')
            self.instanceSpec = instanceSpec_
            self.validate_NonEmptyString(self.instanceSpec)    # validate type NonEmptyString
        elif nodeName_ == 'instanceDefaultSpec':
            instanceDefaultSpec_ = child_.text
            instanceDefaultSpec_ = self.gds_validate_string(instanceDefaultSpec_, node, 'instanceDefaultSpec')
            self.instanceDefaultSpec = instanceDefaultSpec_
            self.validate_NonEmptyString(self.instanceDefaultSpec)    # validate type NonEmptyString
        elif nodeName_ == 'bindingSpec':
            bindingSpec_ = child_.text
            bindingSpec_ = self.gds_validate_string(bindingSpec_, node, 'bindingSpec')
            self.bindingSpec = bindingSpec_
            self.validate_NonEmptyString(self.bindingSpec)    # validate type NonEmptyString
# end class InstanceSpecParamsType


class InstanceListType(GeneratedsSuper):
    """5.7 Represents list of vCHS instances."""
    subclass = None
    superclass = None
    def __init__(self, instances=None):
        self.original_tagname_ = None
        if instances is None:
            self.instances = []
        else:
            self.instances = instances
    def factory(*args_, **kwargs_):
        if InstanceListType.subclass:
            return InstanceListType.subclass(*args_, **kwargs_)
        else:
            return InstanceListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_instances(self): return self.instances
    def set_instances(self, instances): self.instances = instances
    def add_instances(self, value): self.instances.append(value)
    def insert_instances_at(self, index, value): self.instances.insert(index, value)
    def replace_instances_at(self, index, value): self.instances[index] = value
    def hasContent_(self):
        if (
            self.instances
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='instance:', name_='InstanceListType', namespacedef_='xmlns:instance="http://www.vmware.com/vchs/sc/instance/v1"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InstanceListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='instance:', name_='InstanceListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='instance:', name_='InstanceListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='instance:', name_='InstanceListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for instances_ in self.instances:
            instances_.export(outfile, level, namespace_, name_='instances', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='InstanceListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('instances=[\n')
        level += 1
        for instances_ in self.instances:
            showIndent(outfile, level)
            outfile.write('model_.InstanceType(\n')
            instances_.exportLiteral(outfile, level, name_='InstanceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'instances':
            obj_ = InstanceType.factory()
            obj_.build(child_)
            self.instances.append(obj_)
            obj_.original_tagname_ = 'instances'
# end class InstanceListType


class ResourceType(GeneratedsSuper):
    """The resource identifier.The value of this attribute uniquely
    identifies the resource, persists for the life of the entity,
    and is never reused. Contains the name of the the entity."""
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, link=None, extensiontype_=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        if link is None:
            self.link = []
        else:
            self.link = link
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ResourceType.subclass:
            return ResourceType.subclass(*args_, **kwargs_)
        else:
            return ResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def add_link(self, value): self.link.append(value)
    def insert_link_at(self, index, value): self.link.insert(index, value)
    def replace_link_at(self, index, value): self.link[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.link
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='instance:', name_='ResourceType', namespacedef_='xmlns:instance="http://www.vmware.com/vchs/sc/instance/v1" xmlns:common="http://www.vmware.com/vchs/sc/common/v1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='instance:', name_='ResourceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='instance:', name_='ResourceType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='instance:', name_='ResourceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for link_ in self.link:
            link_.export(outfile, level, namespace_, name_='link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id=%s,\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('link=[\n')
        level += 1
        for link_ in self.link:
            showIndent(outfile, level)
            outfile.write('model_.LinkType(\n')
            link_.exportLiteral(outfile, level, name_='LinkType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'link':
            obj_ = LinkType.factory()
            obj_.build(child_)
            self.link.append(obj_)
            obj_.original_tagname_ = 'link'
# end class ResourceType


class LinkType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, href=None, type_=None, id=None, rel=None, name=None):
        self.original_tagname_ = None
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.rel = _cast(None, rel)
        self.name = _cast(None, name)
    def factory(*args_, **kwargs_):
        if LinkType.subclass:
            return LinkType.subclass(*args_, **kwargs_)
        else:
            return LinkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='instance:', name_='LinkType', namespacedef_='xmlns:instance="http://www.vmware.com/vchs/sc/instance/v1"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='instance:', name_='LinkType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='instance:', name_='LinkType'):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (quote_attrib(self.rel), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
    def exportChildren(self, outfile, level, namespace_='instance:', name_='LinkType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='LinkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id=%s,\n' % (self.id,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel=%s,\n' % (self.rel,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class LinkType


class InstanceType(ResourceType):
    """5.7 Provides the details of the instance. Includes details like id
    of the instance, Api endpoint of the instance, service group id
    of the instance, service plan id used to create the instance,
    etc."""
    subclass = None
    superclass = ResourceType
    def __init__(self, id=None, name=None, link=None, description=None, region=None, instanceVersion=None, planId=None, serviceGroupId=None, apiUrl=None, dashboardUrl=None, instanceAttributes=None):
        self.original_tagname_ = None
        super(InstanceType, self).__init__(id, name, link, )
        self.description = description
        self.region = region
        self.instanceVersion = instanceVersion
        self.planId = planId
        self.serviceGroupId = serviceGroupId
        self.apiUrl = apiUrl
        self.dashboardUrl = dashboardUrl
        self.instanceAttributes = instanceAttributes
    def factory(*args_, **kwargs_):
        if InstanceType.subclass:
            return InstanceType.subclass(*args_, **kwargs_)
        else:
            return InstanceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_region(self): return self.region
    def set_region(self, region): self.region = region
    def get_instanceVersion(self): return self.instanceVersion
    def set_instanceVersion(self, instanceVersion): self.instanceVersion = instanceVersion
    def get_planId(self): return self.planId
    def set_planId(self, planId): self.planId = planId
    def get_serviceGroupId(self): return self.serviceGroupId
    def set_serviceGroupId(self, serviceGroupId): self.serviceGroupId = serviceGroupId
    def get_apiUrl(self): return self.apiUrl
    def set_apiUrl(self, apiUrl): self.apiUrl = apiUrl
    def get_dashboardUrl(self): return self.dashboardUrl
    def set_dashboardUrl(self, dashboardUrl): self.dashboardUrl = dashboardUrl
    def get_instanceAttributes(self): return self.instanceAttributes
    def set_instanceAttributes(self, instanceAttributes): self.instanceAttributes = instanceAttributes
    def validate_NonEmptyString(self, value):
        # Validate type NonEmptyString, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.description is not None or
            self.region is not None or
            self.instanceVersion is not None or
            self.planId is not None or
            self.serviceGroupId is not None or
            self.apiUrl is not None or
            self.dashboardUrl is not None or
            self.instanceAttributes is not None or
            super(InstanceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='instance:', name_='InstanceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InstanceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='instance:', name_='InstanceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='instance:', name_='InstanceType'):
        super(InstanceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='InstanceType')
    def exportChildren(self, outfile, level, namespace_='instance:', name_='InstanceType', fromsubclass_=False, pretty_print=True):
        super(InstanceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.region is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sregion>%s</%sregion>%s' % (namespace_, self.gds_format_string(quote_xml(self.region).encode(ExternalEncoding), input_name='region'), namespace_, eol_))
        if self.instanceVersion is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstanceVersion>%s</%sinstanceVersion>%s' % (namespace_, self.gds_format_string(quote_xml(self.instanceVersion).encode(ExternalEncoding), input_name='instanceVersion'), namespace_, eol_))
        if self.planId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splanId>%s</%splanId>%s' % (namespace_, self.gds_format_string(quote_xml(self.planId).encode(ExternalEncoding), input_name='planId'), namespace_, eol_))
        if self.serviceGroupId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserviceGroupId>%s</%sserviceGroupId>%s' % (namespace_, self.gds_format_string(quote_xml(self.serviceGroupId).encode(ExternalEncoding), input_name='serviceGroupId'), namespace_, eol_))
        if self.apiUrl is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapiUrl>%s</%sapiUrl>%s' % (namespace_, self.gds_format_string(quote_xml(self.apiUrl).encode(ExternalEncoding), input_name='apiUrl'), namespace_, eol_))
        if self.dashboardUrl is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdashboardUrl>%s</%sdashboardUrl>%s' % (namespace_, self.gds_format_string(quote_xml(self.dashboardUrl).encode(ExternalEncoding), input_name='dashboardUrl'), namespace_, eol_))
        if self.instanceAttributes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstanceAttributes>%s</%sinstanceAttributes>%s' % (namespace_, self.gds_format_string(quote_xml(self.instanceAttributes).encode(ExternalEncoding), input_name='instanceAttributes'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='InstanceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(InstanceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(InstanceType, self).exportLiteralChildren(outfile, level, name_)
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.region is not None:
            showIndent(outfile, level)
            outfile.write('region=%s,\n' % quote_python(self.region).encode(ExternalEncoding))
        if self.instanceVersion is not None:
            showIndent(outfile, level)
            outfile.write('instanceVersion=%s,\n' % quote_python(self.instanceVersion).encode(ExternalEncoding))
        if self.planId is not None:
            showIndent(outfile, level)
            outfile.write('planId=%s,\n' % quote_python(self.planId).encode(ExternalEncoding))
        if self.serviceGroupId is not None:
            showIndent(outfile, level)
            outfile.write('serviceGroupId=%s,\n' % quote_python(self.serviceGroupId).encode(ExternalEncoding))
        if self.apiUrl is not None:
            showIndent(outfile, level)
            outfile.write('apiUrl=%s,\n' % quote_python(self.apiUrl).encode(ExternalEncoding))
        if self.dashboardUrl is not None:
            showIndent(outfile, level)
            outfile.write('dashboardUrl=%s,\n' % quote_python(self.dashboardUrl).encode(ExternalEncoding))
        if self.instanceAttributes is not None:
            showIndent(outfile, level)
            outfile.write('instanceAttributes=%s,\n' % quote_python(self.instanceAttributes).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(InstanceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
            self.validate_NonEmptyString(self.description)    # validate type NonEmptyString
        elif nodeName_ == 'region':
            region_ = child_.text
            region_ = self.gds_validate_string(region_, node, 'region')
            self.region = region_
            self.validate_NonEmptyString(self.region)    # validate type NonEmptyString
        elif nodeName_ == 'instanceVersion':
            instanceVersion_ = child_.text
            instanceVersion_ = self.gds_validate_string(instanceVersion_, node, 'instanceVersion')
            self.instanceVersion = instanceVersion_
            self.validate_NonEmptyString(self.instanceVersion)    # validate type NonEmptyString
        elif nodeName_ == 'planId':
            planId_ = child_.text
            planId_ = self.gds_validate_string(planId_, node, 'planId')
            self.planId = planId_
            self.validate_NonEmptyString(self.planId)    # validate type NonEmptyString
        elif nodeName_ == 'serviceGroupId':
            serviceGroupId_ = child_.text
            serviceGroupId_ = self.gds_validate_string(serviceGroupId_, node, 'serviceGroupId')
            self.serviceGroupId = serviceGroupId_
            self.validate_NonEmptyString(self.serviceGroupId)    # validate type NonEmptyString
        elif nodeName_ == 'apiUrl':
            apiUrl_ = child_.text
            apiUrl_ = self.gds_validate_string(apiUrl_, node, 'apiUrl')
            self.apiUrl = apiUrl_
        elif nodeName_ == 'dashboardUrl':
            dashboardUrl_ = child_.text
            dashboardUrl_ = self.gds_validate_string(dashboardUrl_, node, 'dashboardUrl')
            self.dashboardUrl = dashboardUrl_
        elif nodeName_ == 'instanceAttributes':
            instanceAttributes_ = child_.text
            instanceAttributes_ = self.gds_validate_string(instanceAttributes_, node, 'instanceAttributes')
            self.instanceAttributes = instanceAttributes_
            self.validate_NonEmptyString(self.instanceAttributes)    # validate type NonEmptyString
        super(InstanceType, self).buildChildren(child_, node, nodeName_, True)
# end class InstanceType


GDSClassesMapping = {
    'Resource': ResourceType,
    'instances': InstanceType,
    'InstanceList': InstanceListType,
    'Instance': InstanceType,
    'link': LinkType,
    'Link': LinkType,
    'InstanceSpecParams': InstanceSpecParamsType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'InstanceSpecParamsType'
        rootClass = InstanceSpecParamsType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:instance="http://www.vmware.com/vchs/sc/instance/v1"',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'InstanceSpecParamsType'
        rootClass = InstanceSpecParamsType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'InstanceSpecParamsType'
        rootClass = InstanceSpecParamsType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:instance="http://www.vmware.com/vchs/sc/instance/v1"')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'InstanceSpecParamsType'
        rootClass = InstanceSpecParamsType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from instanceType import *\n\n')
        sys.stdout.write('import instanceType as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "InstanceListType",
    "InstanceSpecParamsType",
    "InstanceType",
    "LinkType",
    "ResourceType"
]
