# VMware vCloud Python SDK
# Copyright (c) 2014 VMware, Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Fri Dec  5 15:46:04 2014 by generateDS.py version 2.14a.
#
# Command line options:
#   ('-o', 'schema/vcd/v1_5/schemas/vcloud/organizationListType.py')
#
# Command line arguments:
#   schema/vcd/v1_5/schemas/vcloud/organizationList.xsd
#
# Command line:
#   ../bin/generateDS.py -o "schema/vcd/v1_5/schemas/vcloud/organizationListType.py" schema/vcd/v1_5/schemas/vcloud/organizationList.xsd
#
# Current working directory (os.getcwd()):
#   pyvcloud
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_


Validate_simpletypes_ = True


etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class VCloudExtensionType(GeneratedsSuper):
    """0.9 General purpose extension element. Not related to extension
    services. always True if the request should fail when the server
    does not understand the extension. false"""
    subclass = None
    superclass = None
    def __init__(self, required=True, anytypeobjs_=None):
        self.original_tagname_ = None
        self.required = _cast(bool, required)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if VCloudExtensionType.subclass:
            return VCloudExtensionType.subclass(*args_, **kwargs_)
        else:
            return VCloudExtensionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VCloudExtensionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VCloudExtensionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VCloudExtensionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VCloudExtensionType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.required, input_name='required'))
    def exportChildren(self, outfile, level, namespace_='', name_='VCloudExtensionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VCloudExtensionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            showIndent(outfile, level)
            outfile.write('required=%s,\n' % (self.required,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.add('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'VCloudExtensionType')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class VCloudExtensionType


class VCloudExtensibleType(GeneratedsSuper):
    """0.9 A base abstract type for all complex types that support
    extensions."""
    subclass = None
    superclass = None
    def __init__(self, VCloudExtension=None, extensiontype_=None):
        self.original_tagname_ = None
        if VCloudExtension is None:
            self.VCloudExtension = []
        else:
            self.VCloudExtension = VCloudExtension
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if VCloudExtensibleType.subclass:
            return VCloudExtensibleType.subclass(*args_, **kwargs_)
        else:
            return VCloudExtensibleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_VCloudExtension(self): return self.VCloudExtension
    def set_VCloudExtension(self, VCloudExtension): self.VCloudExtension = VCloudExtension
    def add_VCloudExtension(self, value): self.VCloudExtension.append(value)
    def insert_VCloudExtension_at(self, index, value): self.VCloudExtension.insert(index, value)
    def replace_VCloudExtension_at(self, index, value): self.VCloudExtension[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.VCloudExtension
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VCloudExtensibleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VCloudExtensibleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VCloudExtensibleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VCloudExtensibleType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VCloudExtensibleType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for VCloudExtension_ in self.VCloudExtension:
            VCloudExtension_.export(outfile, level, namespace_, name_='VCloudExtension', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VCloudExtensibleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('VCloudExtension=[\n')
        level += 1
        for VCloudExtension_ in self.VCloudExtension:
            showIndent(outfile, level)
            outfile.write('model_.VCloudExtensionType(\n')
            VCloudExtension_.exportLiteral(outfile, level, name_='VCloudExtensionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'VCloudExtension':
            obj_ = VCloudExtensionType.factory()
            obj_.build(child_)
            self.VCloudExtension.append(obj_)
            obj_.original_tagname_ = 'VCloudExtension'
# end class VCloudExtensibleType


class ErrorType(VCloudExtensibleType):
    """0.9 The standard error message type used in the vCloud REST API.
    none An one line, human-readable message describing the error
    that occurred. truenone The class of the error. Matches the HTTP
    status code. truenone Resource-specific error code. truenone A
    vendor- or implementation-specific error code that can reference
    specific modules or source lines for diagnostic purposes.
    false1.0none The stack trace of the exception. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, vendorSpecificErrorCode=None, stackTrace=None, message=None, minorErrorCode=None, majorErrorCode=None):
        self.original_tagname_ = None
        super(ErrorType, self).__init__(VCloudExtension, )
        self.vendorSpecificErrorCode = _cast(None, vendorSpecificErrorCode)
        self.stackTrace = _cast(None, stackTrace)
        self.message = _cast(None, message)
        self.minorErrorCode = _cast(None, minorErrorCode)
        self.majorErrorCode = _cast(int, majorErrorCode)
    def factory(*args_, **kwargs_):
        if ErrorType.subclass:
            return ErrorType.subclass(*args_, **kwargs_)
        else:
            return ErrorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vendorSpecificErrorCode(self): return self.vendorSpecificErrorCode
    def set_vendorSpecificErrorCode(self, vendorSpecificErrorCode): self.vendorSpecificErrorCode = vendorSpecificErrorCode
    def get_stackTrace(self): return self.stackTrace
    def set_stackTrace(self, stackTrace): self.stackTrace = stackTrace
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def get_minorErrorCode(self): return self.minorErrorCode
    def set_minorErrorCode(self, minorErrorCode): self.minorErrorCode = minorErrorCode
    def get_majorErrorCode(self): return self.majorErrorCode
    def set_majorErrorCode(self, majorErrorCode): self.majorErrorCode = majorErrorCode
    def hasContent_(self):
        if (
            super(ErrorType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ErrorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ErrorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ErrorType'):
        super(ErrorType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorType')
        if self.vendorSpecificErrorCode is not None and 'vendorSpecificErrorCode' not in already_processed:
            already_processed.add('vendorSpecificErrorCode')
            outfile.write(' vendorSpecificErrorCode=%s' % (self.gds_format_string(quote_attrib(self.vendorSpecificErrorCode).encode(ExternalEncoding), input_name='vendorSpecificErrorCode'), ))
        if self.stackTrace is not None and 'stackTrace' not in already_processed:
            already_processed.add('stackTrace')
            outfile.write(' stackTrace=%s' % (self.gds_format_string(quote_attrib(self.stackTrace).encode(ExternalEncoding), input_name='stackTrace'), ))
        if self.message is not None and 'message' not in already_processed:
            already_processed.add('message')
            outfile.write(' message=%s' % (self.gds_format_string(quote_attrib(self.message).encode(ExternalEncoding), input_name='message'), ))
        if self.minorErrorCode is not None and 'minorErrorCode' not in already_processed:
            already_processed.add('minorErrorCode')
            outfile.write(' minorErrorCode=%s' % (self.gds_format_string(quote_attrib(self.minorErrorCode).encode(ExternalEncoding), input_name='minorErrorCode'), ))
        if self.majorErrorCode is not None and 'majorErrorCode' not in already_processed:
            already_processed.add('majorErrorCode')
            outfile.write(' majorErrorCode="%s"' % self.gds_format_integer(self.majorErrorCode, input_name='majorErrorCode'))
    def exportChildren(self, outfile, level, namespace_='', name_='ErrorType', fromsubclass_=False, pretty_print=True):
        super(ErrorType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ErrorType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vendorSpecificErrorCode is not None and 'vendorSpecificErrorCode' not in already_processed:
            already_processed.add('vendorSpecificErrorCode')
            showIndent(outfile, level)
            outfile.write('vendorSpecificErrorCode="%s",\n' % (self.vendorSpecificErrorCode,))
        if self.stackTrace is not None and 'stackTrace' not in already_processed:
            already_processed.add('stackTrace')
            showIndent(outfile, level)
            outfile.write('stackTrace="%s",\n' % (self.stackTrace,))
        if self.message is not None and 'message' not in already_processed:
            already_processed.add('message')
            showIndent(outfile, level)
            outfile.write('message="%s",\n' % (self.message,))
        if self.minorErrorCode is not None and 'minorErrorCode' not in already_processed:
            already_processed.add('minorErrorCode')
            showIndent(outfile, level)
            outfile.write('minorErrorCode="%s",\n' % (self.minorErrorCode,))
        if self.majorErrorCode is not None and 'majorErrorCode' not in already_processed:
            already_processed.add('majorErrorCode')
            showIndent(outfile, level)
            outfile.write('majorErrorCode=%d,\n' % (self.majorErrorCode,))
        super(ErrorType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ErrorType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vendorSpecificErrorCode', node)
        if value is not None and 'vendorSpecificErrorCode' not in already_processed:
            already_processed.add('vendorSpecificErrorCode')
            self.vendorSpecificErrorCode = value
        value = find_attr_value_('stackTrace', node)
        if value is not None and 'stackTrace' not in already_processed:
            already_processed.add('stackTrace')
            self.stackTrace = value
        value = find_attr_value_('message', node)
        if value is not None and 'message' not in already_processed:
            already_processed.add('message')
            self.message = value
        value = find_attr_value_('minorErrorCode', node)
        if value is not None and 'minorErrorCode' not in already_processed:
            already_processed.add('minorErrorCode')
            self.minorErrorCode = value
        value = find_attr_value_('majorErrorCode', node)
        if value is not None and 'majorErrorCode' not in already_processed:
            already_processed.add('majorErrorCode')
            try:
                self.majorErrorCode = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(ErrorType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ErrorType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ErrorType


class ResourceType(VCloudExtensibleType):
    """0.9 The base type for all objects in the vCloud model. Has an
    optional list of links and href and type attributes. always The
    URI of the entity. falsealways The MIME type of the entity.
    false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ResourceType, self).__init__(VCloudExtension, extensiontype_, )
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        if Link is None:
            self.Link = []
        else:
            self.Link = Link
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ResourceType.subclass:
            return ResourceType.subclass(*args_, **kwargs_)
        else:
            return ResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Link(self): return self.Link
    def set_Link(self, Link): self.Link = Link
    def add_Link(self, value): self.Link.append(value)
    def insert_Link_at(self, index, value): self.Link.insert(index, value)
    def replace_Link_at(self, index, value): self.Link[index] = value
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Link or
            super(ResourceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ResourceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ResourceType'):
        super(ResourceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceType')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ResourceType', fromsubclass_=False, pretty_print=True):
        super(ResourceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Link_ in self.Link:
            Link_.export(outfile, level, namespace_, name_='Link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        super(ResourceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ResourceType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Link=[\n')
        level += 1
        for Link_ in self.Link:
            showIndent(outfile, level)
            outfile.write('model_.LinkType(\n')
            Link_.exportLiteral(outfile, level, name_='LinkType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ResourceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Link':
            obj_ = LinkType.factory()
            obj_.build(child_)
            self.Link.append(obj_)
            obj_.original_tagname_ = 'Link'
        super(ResourceType, self).buildChildren(child_, node, nodeName_, True)
# end class ResourceType


class IdentifiableResourceType(ResourceType):
    """0.9 The base type for all resource types which contain an id
    attribute. none The entity identifier, expressed in URN format.
    The value of this attribute uniquely identifies the entity,
    persists for the life of the entity, and is never reused.
    falsecreate Optional unique identifier to support idempotent
    semantics for create and delete operations. false"""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IdentifiableResourceType, self).__init__(VCloudExtension, href, type_, Link, extensiontype_, )
        self.operationKey = _cast(None, operationKey)
        self.id = _cast(None, id)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if IdentifiableResourceType.subclass:
            return IdentifiableResourceType.subclass(*args_, **kwargs_)
        else:
            return IdentifiableResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_operationKey(self): return self.operationKey
    def set_operationKey(self, operationKey): self.operationKey = operationKey
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(IdentifiableResourceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IdentifiableResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IdentifiableResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IdentifiableResourceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IdentifiableResourceType'):
        super(IdentifiableResourceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IdentifiableResourceType')
        if self.operationKey is not None and 'operationKey' not in already_processed:
            already_processed.add('operationKey')
            outfile.write(' operationKey=%s' % (self.gds_format_string(quote_attrib(self.operationKey).encode(ExternalEncoding), input_name='operationKey'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IdentifiableResourceType', fromsubclass_=False, pretty_print=True):
        super(IdentifiableResourceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IdentifiableResourceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.operationKey is not None and 'operationKey' not in already_processed:
            already_processed.add('operationKey')
            showIndent(outfile, level)
            outfile.write('operationKey="%s",\n' % (self.operationKey,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        super(IdentifiableResourceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IdentifiableResourceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('operationKey', node)
        if value is not None and 'operationKey' not in already_processed:
            already_processed.add('operationKey')
            self.operationKey = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IdentifiableResourceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IdentifiableResourceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IdentifiableResourceType


class ParamsType(VCloudExtensibleType):
    """0.9 A basic type used to specify request parameters. always
    Typically used to name or identify the subject of the request.
    For example, the name of the object being created or modified.
    false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, name=None, Description=None):
        self.original_tagname_ = None
        super(ParamsType, self).__init__(VCloudExtension, )
        self.name = _cast(None, name)
        self.Description = Description
    def factory(*args_, **kwargs_):
        if ParamsType.subclass:
            return ParamsType.subclass(*args_, **kwargs_)
        else:
            return ParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            self.Description is not None or
            super(ParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ParamsType'):
        super(ParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ParamsType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ParamsType', fromsubclass_=False, pretty_print=True):
        super(ParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(ParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ParamsType, self).exportLiteralChildren(outfile, level, name_)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(ParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        super(ParamsType, self).buildChildren(child_, node, nodeName_, True)
# end class ParamsType


class ReferenceType(VCloudExtensibleType):
    """0.9 A reference to a resource. Contains an href attribute and
    optional name and type attributes. always Contains the URI to
    the entity. truealways The resource identifier, expressed in URN
    format. The value of this attribute uniquely identifies the
    resource, persists for the life of the resource, and is never
    reused. falsealways Contains the type of the the entity.
    falsealways Contains the name of the the entity. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, href=None, type_=None, id=None, name=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ReferenceType, self).__init__(VCloudExtension, extensiontype_, )
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ReferenceType.subclass:
            return ReferenceType.subclass(*args_, **kwargs_)
        else:
            return ReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(ReferenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReferenceType'):
        super(ReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReferenceType')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ReferenceType', fromsubclass_=False, pretty_print=True):
        super(ReferenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(ReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReferenceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ReferenceType


class ResourceReferenceType(ReferenceType):
    """0.9 Represents a reference to a resource. Contains an href
    attribute, a resource status attribute, and optional name and
    type attributes. none Status of a resource. false"""
    subclass = None
    superclass = ReferenceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, id=None, name=None, status=None):
        self.original_tagname_ = None
        super(ResourceReferenceType, self).__init__(VCloudExtension, href, type_, id, name, )
        self.status = _cast(int, status)
    def factory(*args_, **kwargs_):
        if ResourceReferenceType.subclass:
            return ResourceReferenceType.subclass(*args_, **kwargs_)
        else:
            return ResourceReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def hasContent_(self):
        if (
            super(ResourceReferenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ResourceReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ResourceReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ResourceReferenceType'):
        super(ResourceReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceReferenceType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status="%s"' % self.gds_format_integer(self.status, input_name='status'))
    def exportChildren(self, outfile, level, namespace_='', name_='ResourceReferenceType', fromsubclass_=False, pretty_print=True):
        super(ResourceReferenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status=%d,\n' % (self.status,))
        super(ResourceReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ResourceReferenceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            try:
                self.status = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(ResourceReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ResourceReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ResourceReferenceType


class ContainerType(ResourceType):
    """Container for query result sets. none Query name that generated this
    result set. falsenone Page of the result set that this container
    holds. The first page is page number 1. falsenone Page size, as
    a number of records or references. falsenone Total number of
    records or references in the container. false"""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, total=None, name=None, pageSize=None, page=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ContainerType, self).__init__(VCloudExtension, href, type_, Link, extensiontype_, )
        self.total = _cast(int, total)
        self.name = _cast(None, name)
        self.pageSize = _cast(int, pageSize)
        self.page = _cast(int, page)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ContainerType.subclass:
            return ContainerType.subclass(*args_, **kwargs_)
        else:
            return ContainerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_pageSize(self): return self.pageSize
    def set_pageSize(self, pageSize): self.pageSize = pageSize
    def get_page(self): return self.page
    def set_page(self, page): self.page = page
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(ContainerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ContainerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContainerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ContainerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContainerType'):
        super(ContainerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContainerType')
        if self.total is not None and 'total' not in already_processed:
            already_processed.add('total')
            outfile.write(' total="%s"' % self.gds_format_integer(self.total, input_name='total'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.pageSize is not None and 'pageSize' not in already_processed:
            already_processed.add('pageSize')
            outfile.write(' pageSize="%s"' % self.gds_format_integer(self.pageSize, input_name='pageSize'))
        if self.page is not None and 'page' not in already_processed:
            already_processed.add('page')
            outfile.write(' page="%s"' % self.gds_format_integer(self.page, input_name='page'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ContainerType', fromsubclass_=False, pretty_print=True):
        super(ContainerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ContainerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.total is not None and 'total' not in already_processed:
            already_processed.add('total')
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % (self.total,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.pageSize is not None and 'pageSize' not in already_processed:
            already_processed.add('pageSize')
            showIndent(outfile, level)
            outfile.write('pageSize=%d,\n' % (self.pageSize,))
        if self.page is not None and 'page' not in already_processed:
            already_processed.add('page')
            showIndent(outfile, level)
            outfile.write('page=%d,\n' % (self.page,))
        super(ContainerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContainerType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('total', node)
        if value is not None and 'total' not in already_processed:
            already_processed.add('total')
            try:
                self.total = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('pageSize', node)
        if value is not None and 'pageSize' not in already_processed:
            already_processed.add('pageSize')
            try:
                self.pageSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('page', node)
        if value is not None and 'page' not in already_processed:
            already_processed.add('page')
            try:
                self.page = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ContainerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ContainerType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ContainerType


class CapacityType(VCloudExtensibleType):
    """0.9 Represents the capacity of a given resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Units=None, Allocated=None, Limit=None, extensiontype_=None):
        self.original_tagname_ = None
        super(CapacityType, self).__init__(VCloudExtension, extensiontype_, )
        self.Units = Units
        self.Allocated = Allocated
        self.Limit = Limit
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CapacityType.subclass:
            return CapacityType.subclass(*args_, **kwargs_)
        else:
            return CapacityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Units(self): return self.Units
    def set_Units(self, Units): self.Units = Units
    def get_Allocated(self): return self.Allocated
    def set_Allocated(self, Allocated): self.Allocated = Allocated
    def get_Limit(self): return self.Limit
    def set_Limit(self, Limit): self.Limit = Limit
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Units is not None or
            self.Allocated is not None or
            self.Limit is not None or
            super(CapacityType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CapacityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CapacityType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CapacityType'):
        super(CapacityType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='CapacityType', fromsubclass_=False, pretty_print=True):
        super(CapacityType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Units is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUnits>%s</%sUnits>%s' % (namespace_, self.gds_format_string(quote_xml(self.Units).encode(ExternalEncoding), input_name='Units'), namespace_, eol_))
        if self.Allocated is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAllocated>%s</%sAllocated>%s' % (namespace_, self.gds_format_integer(self.Allocated, input_name='Allocated'), namespace_, eol_))
        if self.Limit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLimit>%s</%sLimit>%s' % (namespace_, self.gds_format_integer(self.Limit, input_name='Limit'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CapacityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CapacityType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CapacityType, self).exportLiteralChildren(outfile, level, name_)
        if self.Units is not None:
            showIndent(outfile, level)
            outfile.write('Units=%s,\n' % quote_python(self.Units).encode(ExternalEncoding))
        if self.Allocated is not None:
            showIndent(outfile, level)
            outfile.write('Allocated=%d,\n' % self.Allocated)
        if self.Limit is not None:
            showIndent(outfile, level)
            outfile.write('Limit=%d,\n' % self.Limit)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(CapacityType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Units':
            Units_ = child_.text
            Units_ = self.gds_validate_string(Units_, node, 'Units')
            self.Units = Units_
        elif nodeName_ == 'Allocated':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Allocated')
            self.Allocated = ival_
        elif nodeName_ == 'Limit':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Limit')
            self.Limit = ival_
        super(CapacityType, self).buildChildren(child_, node, nodeName_, True)
# end class CapacityType


class CapacityWithUsageType(CapacityType):
    """0.9 Represents a capacity and usage of a given resource."""
    subclass = None
    superclass = CapacityType
    def __init__(self, VCloudExtension=None, Units=None, Allocated=None, Limit=None, Reserved=None, Used=None, Overhead=None):
        self.original_tagname_ = None
        super(CapacityWithUsageType, self).__init__(VCloudExtension, Units, Allocated, Limit, )
        self.Reserved = Reserved
        self.Used = Used
        self.Overhead = Overhead
    def factory(*args_, **kwargs_):
        if CapacityWithUsageType.subclass:
            return CapacityWithUsageType.subclass(*args_, **kwargs_)
        else:
            return CapacityWithUsageType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reserved(self): return self.Reserved
    def set_Reserved(self, Reserved): self.Reserved = Reserved
    def get_Used(self): return self.Used
    def set_Used(self, Used): self.Used = Used
    def get_Overhead(self): return self.Overhead
    def set_Overhead(self, Overhead): self.Overhead = Overhead
    def hasContent_(self):
        if (
            self.Reserved is not None or
            self.Used is not None or
            self.Overhead is not None or
            super(CapacityWithUsageType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CapacityWithUsageType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityWithUsageType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CapacityWithUsageType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CapacityWithUsageType'):
        super(CapacityWithUsageType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityWithUsageType')
    def exportChildren(self, outfile, level, namespace_='', name_='CapacityWithUsageType', fromsubclass_=False, pretty_print=True):
        super(CapacityWithUsageType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Reserved is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReserved>%s</%sReserved>%s' % (namespace_, self.gds_format_integer(self.Reserved, input_name='Reserved'), namespace_, eol_))
        if self.Used is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUsed>%s</%sUsed>%s' % (namespace_, self.gds_format_integer(self.Used, input_name='Used'), namespace_, eol_))
        if self.Overhead is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOverhead>%s</%sOverhead>%s' % (namespace_, self.gds_format_integer(self.Overhead, input_name='Overhead'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CapacityWithUsageType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CapacityWithUsageType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CapacityWithUsageType, self).exportLiteralChildren(outfile, level, name_)
        if self.Reserved is not None:
            showIndent(outfile, level)
            outfile.write('Reserved=%d,\n' % self.Reserved)
        if self.Used is not None:
            showIndent(outfile, level)
            outfile.write('Used=%d,\n' % self.Used)
        if self.Overhead is not None:
            showIndent(outfile, level)
            outfile.write('Overhead=%d,\n' % self.Overhead)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(CapacityWithUsageType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reserved':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Reserved')
            self.Reserved = ival_
        elif nodeName_ == 'Used':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Used')
            self.Used = ival_
        elif nodeName_ == 'Overhead':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Overhead')
            self.Overhead = ival_
        super(CapacityWithUsageType, self).buildChildren(child_, node, nodeName_, True)
# end class CapacityWithUsageType


class AccessSettingType(VCloudExtensibleType):
    """0.9 Controls access to the resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Subject=None, AccessLevel=None):
        self.original_tagname_ = None
        super(AccessSettingType, self).__init__(VCloudExtension, )
        self.Subject = Subject
        self.AccessLevel = AccessLevel
    def factory(*args_, **kwargs_):
        if AccessSettingType.subclass:
            return AccessSettingType.subclass(*args_, **kwargs_)
        else:
            return AccessSettingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Subject(self): return self.Subject
    def set_Subject(self, Subject): self.Subject = Subject
    def get_AccessLevel(self): return self.AccessLevel
    def set_AccessLevel(self, AccessLevel): self.AccessLevel = AccessLevel
    def hasContent_(self):
        if (
            self.Subject is not None or
            self.AccessLevel is not None or
            super(AccessSettingType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AccessSettingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AccessSettingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AccessSettingType'):
        super(AccessSettingType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingType')
    def exportChildren(self, outfile, level, namespace_='', name_='AccessSettingType', fromsubclass_=False, pretty_print=True):
        super(AccessSettingType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Subject is not None:
            self.Subject.export(outfile, level, namespace_, name_='Subject', pretty_print=pretty_print)
        if self.AccessLevel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccessLevel>%s</%sAccessLevel>%s' % (namespace_, self.gds_format_string(quote_xml(self.AccessLevel).encode(ExternalEncoding), input_name='AccessLevel'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='AccessSettingType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AccessSettingType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AccessSettingType, self).exportLiteralChildren(outfile, level, name_)
        if self.Subject is not None:
            showIndent(outfile, level)
            outfile.write('Subject=model_.ReferenceType(\n')
            self.Subject.exportLiteral(outfile, level, name_='Subject')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AccessLevel is not None:
            showIndent(outfile, level)
            outfile.write('AccessLevel=%s,\n' % quote_python(self.AccessLevel).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AccessSettingType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Subject':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Subject = obj_
            obj_.original_tagname_ = 'Subject'
        elif nodeName_ == 'AccessLevel':
            AccessLevel_ = child_.text
            AccessLevel_ = self.gds_validate_string(AccessLevel_, node, 'AccessLevel')
            self.AccessLevel = AccessLevel_
        super(AccessSettingType, self).buildChildren(child_, node, nodeName_, True)
# end class AccessSettingType


class AccessSettingsType(VCloudExtensibleType):
    """0.9 A list of access settings for a resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, AccessSetting=None):
        self.original_tagname_ = None
        super(AccessSettingsType, self).__init__(VCloudExtension, )
        if AccessSetting is None:
            self.AccessSetting = []
        else:
            self.AccessSetting = AccessSetting
    def factory(*args_, **kwargs_):
        if AccessSettingsType.subclass:
            return AccessSettingsType.subclass(*args_, **kwargs_)
        else:
            return AccessSettingsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AccessSetting(self): return self.AccessSetting
    def set_AccessSetting(self, AccessSetting): self.AccessSetting = AccessSetting
    def add_AccessSetting(self, value): self.AccessSetting.append(value)
    def insert_AccessSetting_at(self, index, value): self.AccessSetting.insert(index, value)
    def replace_AccessSetting_at(self, index, value): self.AccessSetting[index] = value
    def hasContent_(self):
        if (
            self.AccessSetting or
            super(AccessSettingsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AccessSettingsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AccessSettingsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AccessSettingsType'):
        super(AccessSettingsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingsType')
    def exportChildren(self, outfile, level, namespace_='', name_='AccessSettingsType', fromsubclass_=False, pretty_print=True):
        super(AccessSettingsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for AccessSetting_ in self.AccessSetting:
            AccessSetting_.export(outfile, level, namespace_, name_='AccessSetting', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AccessSettingsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AccessSettingsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AccessSettingsType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('AccessSetting=[\n')
        level += 1
        for AccessSetting_ in self.AccessSetting:
            showIndent(outfile, level)
            outfile.write('model_.AccessSettingType(\n')
            AccessSetting_.exportLiteral(outfile, level, name_='AccessSettingType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AccessSettingsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AccessSetting':
            obj_ = AccessSettingType.factory()
            obj_.build(child_)
            self.AccessSetting.append(obj_)
            obj_.original_tagname_ = 'AccessSetting'
        super(AccessSettingsType, self).buildChildren(child_, node, nodeName_, True)
# end class AccessSettingsType


class ControlAccessParamsType(VCloudExtensibleType):
    """0.9 Specifies access controls for a resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IsSharedToEveryone=None, EveryoneAccessLevel=None, AccessSettings=None):
        self.original_tagname_ = None
        super(ControlAccessParamsType, self).__init__(VCloudExtension, )
        self.IsSharedToEveryone = IsSharedToEveryone
        self.EveryoneAccessLevel = EveryoneAccessLevel
        self.AccessSettings = AccessSettings
    def factory(*args_, **kwargs_):
        if ControlAccessParamsType.subclass:
            return ControlAccessParamsType.subclass(*args_, **kwargs_)
        else:
            return ControlAccessParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsSharedToEveryone(self): return self.IsSharedToEveryone
    def set_IsSharedToEveryone(self, IsSharedToEveryone): self.IsSharedToEveryone = IsSharedToEveryone
    def get_EveryoneAccessLevel(self): return self.EveryoneAccessLevel
    def set_EveryoneAccessLevel(self, EveryoneAccessLevel): self.EveryoneAccessLevel = EveryoneAccessLevel
    def get_AccessSettings(self): return self.AccessSettings
    def set_AccessSettings(self, AccessSettings): self.AccessSettings = AccessSettings
    def hasContent_(self):
        if (
            self.IsSharedToEveryone is not None or
            self.EveryoneAccessLevel is not None or
            self.AccessSettings is not None or
            super(ControlAccessParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ControlAccessParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ControlAccessParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ControlAccessParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ControlAccessParamsType'):
        super(ControlAccessParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ControlAccessParamsType')
    def exportChildren(self, outfile, level, namespace_='', name_='ControlAccessParamsType', fromsubclass_=False, pretty_print=True):
        super(ControlAccessParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsSharedToEveryone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsSharedToEveryone>%s</%sIsSharedToEveryone>%s' % (namespace_, self.gds_format_boolean(self.IsSharedToEveryone, input_name='IsSharedToEveryone'), namespace_, eol_))
        if self.EveryoneAccessLevel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEveryoneAccessLevel>%s</%sEveryoneAccessLevel>%s' % (namespace_, self.gds_format_string(quote_xml(self.EveryoneAccessLevel).encode(ExternalEncoding), input_name='EveryoneAccessLevel'), namespace_, eol_))
        if self.AccessSettings is not None:
            self.AccessSettings.export(outfile, level, namespace_, name_='AccessSettings', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ControlAccessParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ControlAccessParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ControlAccessParamsType, self).exportLiteralChildren(outfile, level, name_)
        if self.IsSharedToEveryone is not None:
            showIndent(outfile, level)
            outfile.write('IsSharedToEveryone=%s,\n' % self.IsSharedToEveryone)
        if self.EveryoneAccessLevel is not None:
            showIndent(outfile, level)
            outfile.write('EveryoneAccessLevel=%s,\n' % quote_python(self.EveryoneAccessLevel).encode(ExternalEncoding))
        if self.AccessSettings is not None:
            showIndent(outfile, level)
            outfile.write('AccessSettings=model_.AccessSettingsType(\n')
            self.AccessSettings.exportLiteral(outfile, level, name_='AccessSettings')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ControlAccessParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsSharedToEveryone':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsSharedToEveryone')
            self.IsSharedToEveryone = ival_
        elif nodeName_ == 'EveryoneAccessLevel':
            EveryoneAccessLevel_ = child_.text
            EveryoneAccessLevel_ = self.gds_validate_string(EveryoneAccessLevel_, node, 'EveryoneAccessLevel')
            self.EveryoneAccessLevel = EveryoneAccessLevel_
        elif nodeName_ == 'AccessSettings':
            obj_ = AccessSettingsType.factory()
            obj_.build(child_)
            self.AccessSettings = obj_
            obj_.original_tagname_ = 'AccessSettings'
        super(ControlAccessParamsType, self).buildChildren(child_, node, nodeName_, True)
# end class ControlAccessParamsType


class OwnerType(ResourceType):
    """1.5 Represents the owner of this entity."""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, User=None):
        self.original_tagname_ = None
        super(OwnerType, self).__init__(VCloudExtension, href, type_, Link, )
        self.User = User
    def factory(*args_, **kwargs_):
        if OwnerType.subclass:
            return OwnerType.subclass(*args_, **kwargs_)
        else:
            return OwnerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def hasContent_(self):
        if (
            self.User is not None or
            super(OwnerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OwnerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OwnerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OwnerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OwnerType'):
        super(OwnerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OwnerType')
    def exportChildren(self, outfile, level, namespace_='', name_='OwnerType', fromsubclass_=False, pretty_print=True):
        super(OwnerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.User is not None:
            self.User.export(outfile, level, namespace_, name_='User', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OwnerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(OwnerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(OwnerType, self).exportLiteralChildren(outfile, level, name_)
        if self.User is not None:
            showIndent(outfile, level)
            outfile.write('User=model_.ReferenceType(\n')
            self.User.exportLiteral(outfile, level, name_='User')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OwnerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'User':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.User = obj_
            obj_.original_tagname_ = 'User'
        super(OwnerType, self).buildChildren(child_, node, nodeName_, True)
# end class OwnerType


class ReferencesType(ContainerType):
    """Container for query results returned in references format."""
    subclass = None
    superclass = ContainerType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, total=None, name=None, pageSize=None, page=None, Reference=None):
        self.original_tagname_ = None
        super(ReferencesType, self).__init__(VCloudExtension, href, type_, Link, total, name, pageSize, page, )
        if Reference is None:
            self.Reference = []
        else:
            self.Reference = Reference
    def factory(*args_, **kwargs_):
        if ReferencesType.subclass:
            return ReferencesType.subclass(*args_, **kwargs_)
        else:
            return ReferencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reference(self): return self.Reference
    def set_Reference(self, Reference): self.Reference = Reference
    def add_Reference(self, value): self.Reference.append(value)
    def insert_Reference_at(self, index, value): self.Reference.insert(index, value)
    def replace_Reference_at(self, index, value): self.Reference[index] = value
    def hasContent_(self):
        if (
            self.Reference or
            super(ReferencesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReferencesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReferencesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ReferencesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReferencesType'):
        super(ReferencesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReferencesType')
    def exportChildren(self, outfile, level, namespace_='', name_='ReferencesType', fromsubclass_=False, pretty_print=True):
        super(ReferencesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Reference_ in self.Reference:
            Reference_.export(outfile, level, namespace_, name_='Reference', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ReferencesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ReferencesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReferencesType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Reference=[\n')
        level += 1
        for Reference_ in self.Reference:
            showIndent(outfile, level)
            outfile.write('model_.Reference(\n')
            Reference_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ReferencesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reference':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Reference.append(obj_)
            obj_.original_tagname_ = 'Reference'
        super(ReferencesType, self).buildChildren(child_, node, nodeName_, True)
# end class ReferencesType


class QueryListType(ContainerType):
    """Container for the list of typed queries available to the requesting
    user."""
    subclass = None
    superclass = ContainerType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, total=None, name=None, pageSize=None, page=None):
        self.original_tagname_ = None
        super(QueryListType, self).__init__(VCloudExtension, href, type_, Link, total, name, pageSize, page, )
    def factory(*args_, **kwargs_):
        if QueryListType.subclass:
            return QueryListType.subclass(*args_, **kwargs_)
        else:
            return QueryListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(QueryListType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryListType'):
        super(QueryListType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryListType')
    def exportChildren(self, outfile, level, namespace_='', name_='QueryListType', fromsubclass_=False, pretty_print=True):
        super(QueryListType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(QueryListType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryListType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(QueryListType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryListType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryListType


class MetadataDomainTagType(GeneratedsSuper):
    """A value of SYSTEM places this MetadataEntry in the SYSTEM domain.
    Omit or leave empty to place this MetadataEntry in the GENERAL
    domain. true One of:<br> PRIVATE<br> READONLY"""
    subclass = None
    superclass = None
    def __init__(self, visibility=None, valueOf_=None):
        self.original_tagname_ = None
        self.visibility = _cast(None, visibility)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MetadataDomainTagType.subclass:
            return MetadataDomainTagType.subclass(*args_, **kwargs_)
        else:
            return MetadataDomainTagType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_visibility(self): return self.visibility
    def set_visibility(self, visibility): self.visibility = visibility
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataDomainTagType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataDomainTagType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataDomainTagType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataDomainTagType'):
        if self.visibility is not None and 'visibility' not in already_processed:
            already_processed.add('visibility')
            outfile.write(' visibility=%s' % (self.gds_format_string(quote_attrib(self.visibility).encode(ExternalEncoding), input_name='visibility'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataDomainTagType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MetadataDomainTagType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.visibility is not None and 'visibility' not in already_processed:
            already_processed.add('visibility')
            showIndent(outfile, level)
            outfile.write('visibility="%s",\n' % (self.visibility,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('visibility', node)
        if value is not None and 'visibility' not in already_processed:
            already_processed.add('visibility')
            self.visibility = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MetadataDomainTagType


class MetadataEntryType(ResourceType):
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, Domain=None, Key=None, Value=None, TypedValue=None):
        self.original_tagname_ = None
        super(MetadataEntryType, self).__init__(VCloudExtension, href, type_, Link, )
        self.Domain = Domain
        self.Key = Key
        self.Value = Value
        self.TypedValue = TypedValue
    def factory(*args_, **kwargs_):
        if MetadataEntryType.subclass:
            return MetadataEntryType.subclass(*args_, **kwargs_)
        else:
            return MetadataEntryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def get_Key(self): return self.Key
    def set_Key(self, Key): self.Key = Key
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_TypedValue(self): return self.TypedValue
    def set_TypedValue(self, TypedValue): self.TypedValue = TypedValue
    def hasContent_(self):
        if (
            self.Domain is not None or
            self.Key is not None or
            self.Value is not None or
            self.TypedValue is not None or
            super(MetadataEntryType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataEntryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataEntryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataEntryType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataEntryType'):
        super(MetadataEntryType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataEntryType')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataEntryType', fromsubclass_=False, pretty_print=True):
        super(MetadataEntryType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Domain is not None:
            self.Domain.export(outfile, level, namespace_, name_='Domain', pretty_print=pretty_print)
        if self.Key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sKey>%s</%sKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.Key).encode(ExternalEncoding), input_name='Key'), namespace_, eol_))
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
        if self.TypedValue is not None:
            self.TypedValue.export(outfile, level, namespace_, name_='TypedValue', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MetadataEntryType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataEntryType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataEntryType, self).exportLiteralChildren(outfile, level, name_)
        if self.Domain is not None:
            showIndent(outfile, level)
            outfile.write('Domain=model_.MetadataDomainTagType(\n')
            self.Domain.exportLiteral(outfile, level, name_='Domain')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('Key=%s,\n' % quote_python(self.Key).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
        if self.MetadataTypedValue is not None:
            showIndent(outfile, level)
            outfile.write('MetadataTypedValue=model_.MetadataTypedValue(\n')
            self.MetadataTypedValue.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataEntryType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Domain':
            obj_ = MetadataDomainTagType.factory()
            obj_.build(child_)
            self.Domain = obj_
            obj_.original_tagname_ = 'Domain'
        elif nodeName_ == 'Key':
            Key_ = child_.text
            Key_ = self.gds_validate_string(Key_, node, 'Key')
            self.Key = Key_
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'TypedValue':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <TypedValue> element')
            self.TypedValue = obj_
            obj_.original_tagname_ = 'TypedValue'
        super(MetadataEntryType, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataEntryType


class MetadataTypedValue(GeneratedsSuper):
    """One of:<br> MetadataStringValue<br> MetadataNumberValue<br>
    MetadataBooleanValue<br> MetadataDateTimeValue"""
    subclass = None
    superclass = None
    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if MetadataTypedValue.subclass:
            return MetadataTypedValue.subclass(*args_, **kwargs_)
        else:
            return MetadataTypedValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataTypedValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataTypedValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataTypedValue', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataTypedValue'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataTypedValue', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MetadataTypedValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MetadataTypedValue


class MetadataStringValue(MetadataTypedValue):
    """UTF-8 character set. Strings longer than 1000 characters cannot be
    searched for in a query."""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataStringValue, self).__init__()
        self.Value = Value
    def factory(*args_, **kwargs_):
        if MetadataStringValue.subclass:
            return MetadataStringValue.subclass(*args_, **kwargs_)
        else:
            return MetadataStringValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataStringValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataStringValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataStringValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataStringValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataStringValue'):
        super(MetadataStringValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataStringValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataStringValue', fromsubclass_=False, pretty_print=True):
        super(MetadataStringValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataStringValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataStringValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataStringValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataStringValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        super(MetadataStringValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataStringValue


class MetadataNumberValue(MetadataTypedValue):
    """A signed 8-byte integer."""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataNumberValue, self).__init__()
        self.Value = Value
    def factory(*args_, **kwargs_):
        if MetadataNumberValue.subclass:
            return MetadataNumberValue.subclass(*args_, **kwargs_)
        else:
            return MetadataNumberValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataNumberValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataNumberValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataNumberValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataNumberValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataNumberValue'):
        super(MetadataNumberValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataNumberValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataNumberValue', fromsubclass_=False, pretty_print=True):
        super(MetadataNumberValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_integer(self.Value, input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataNumberValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataNumberValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataNumberValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%d,\n' % self.Value)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataNumberValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Value')
            self.Value = ival_
        super(MetadataNumberValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataNumberValue


class MetadataBooleanValue(MetadataTypedValue):
    """One of: 1, 0, true, false"""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataBooleanValue, self).__init__()
        self.Value = Value
    def factory(*args_, **kwargs_):
        if MetadataBooleanValue.subclass:
            return MetadataBooleanValue.subclass(*args_, **kwargs_)
        else:
            return MetadataBooleanValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataBooleanValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataBooleanValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataBooleanValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataBooleanValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataBooleanValue'):
        super(MetadataBooleanValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataBooleanValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataBooleanValue', fromsubclass_=False, pretty_print=True):
        super(MetadataBooleanValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_boolean(self.Value, input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataBooleanValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataBooleanValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataBooleanValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % self.Value)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataBooleanValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Value')
            self.Value = ival_
        super(MetadataBooleanValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataBooleanValue


class MetadataDateTimeValue(MetadataTypedValue):
    """UTC format. For example 2012-06-18T12:00:00-05:00"""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataDateTimeValue, self).__init__()
        if isinstance(Value, basestring):
            initvalue_ = datetime_.datetime.strptime(Value, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Value
        self.Value = initvalue_
    def factory(*args_, **kwargs_):
        if MetadataDateTimeValue.subclass:
            return MetadataDateTimeValue.subclass(*args_, **kwargs_)
        else:
            return MetadataDateTimeValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataDateTimeValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataDateTimeValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataDateTimeValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataDateTimeValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataDateTimeValue'):
        super(MetadataDateTimeValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataDateTimeValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataDateTimeValue', fromsubclass_=False, pretty_print=True):
        super(MetadataDateTimeValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_datetime(self.Value, input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataDateTimeValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataDateTimeValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataDateTimeValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.Value, input_name='Value'))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataDateTimeValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Value = dval_
        super(MetadataDateTimeValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataDateTimeValue


class MetadataType(ResourceType):
    """User-defined metadata associated with with an object."""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, MetadataEntry=None):
        self.original_tagname_ = None
        super(MetadataType, self).__init__(VCloudExtension, href, type_, Link, )
        if MetadataEntry is None:
            self.MetadataEntry = []
        else:
            self.MetadataEntry = MetadataEntry
    def factory(*args_, **kwargs_):
        if MetadataType.subclass:
            return MetadataType.subclass(*args_, **kwargs_)
        else:
            return MetadataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MetadataEntry(self): return self.MetadataEntry
    def set_MetadataEntry(self, MetadataEntry): self.MetadataEntry = MetadataEntry
    def add_MetadataEntry(self, value): self.MetadataEntry.append(value)
    def insert_MetadataEntry_at(self, index, value): self.MetadataEntry.insert(index, value)
    def replace_MetadataEntry_at(self, index, value): self.MetadataEntry[index] = value
    def hasContent_(self):
        if (
            self.MetadataEntry or
            super(MetadataType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataType'):
        super(MetadataType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataType')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataType', fromsubclass_=False, pretty_print=True):
        super(MetadataType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for MetadataEntry_ in self.MetadataEntry:
            MetadataEntry_.export(outfile, level, namespace_, name_='MetadataEntry', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MetadataType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('MetadataEntry=[\n')
        level += 1
        for MetadataEntry_ in self.MetadataEntry:
            showIndent(outfile, level)
            outfile.write('model_.MetadataEntryType(\n')
            MetadataEntry_.exportLiteral(outfile, level, name_='MetadataEntryType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MetadataEntry':
            obj_ = MetadataEntryType.factory()
            obj_.build(child_)
            self.MetadataEntry.append(obj_)
            obj_.original_tagname_ = 'MetadataEntry'
        super(MetadataType, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataType


class MetadataValueType(ResourceType):
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, Domain=None, Value=None, TypedValue=None):
        self.original_tagname_ = None
        super(MetadataValueType, self).__init__(VCloudExtension, href, type_, Link, )
        self.Domain = Domain
        self.Value = Value
        self.TypedValue = TypedValue
    def factory(*args_, **kwargs_):
        if MetadataValueType.subclass:
            return MetadataValueType.subclass(*args_, **kwargs_)
        else:
            return MetadataValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_TypedValue(self): return self.TypedValue
    def set_TypedValue(self, TypedValue): self.TypedValue = TypedValue
    def hasContent_(self):
        if (
            self.Domain is not None or
            self.Value is not None or
            self.TypedValue is not None or
            super(MetadataValueType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataValueType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataValueType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataValueType'):
        super(MetadataValueType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataValueType')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataValueType', fromsubclass_=False, pretty_print=True):
        super(MetadataValueType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Domain is not None:
            self.Domain.export(outfile, level, namespace_, name_='Domain', pretty_print=pretty_print)
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
        if self.TypedValue is not None:
            self.TypedValue.export(outfile, level, namespace_, name_='TypedValue', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MetadataValueType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataValueType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataValueType, self).exportLiteralChildren(outfile, level, name_)
        if self.Domain is not None:
            showIndent(outfile, level)
            outfile.write('Domain=model_.MetadataDomainTagType(\n')
            self.Domain.exportLiteral(outfile, level, name_='Domain')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
        if self.MetadataTypedValue is not None:
            showIndent(outfile, level)
            outfile.write('MetadataTypedValue=model_.MetadataTypedValue(\n')
            self.MetadataTypedValue.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataValueType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Domain':
            obj_ = MetadataDomainTagType.factory()
            obj_.build(child_)
            self.Domain = obj_
            obj_.original_tagname_ = 'Domain'
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'TypedValue':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <TypedValue> element')
            self.TypedValue = obj_
            obj_.original_tagname_ = 'TypedValue'
        super(MetadataValueType, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataValueType


class FileUploadParamsType(VCloudExtensibleType):
    """5.1 Parameters for initializing file upload session. create Size in
    bytes of the file which will be uploaded. true"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, fileSize=None):
        self.original_tagname_ = None
        super(FileUploadParamsType, self).__init__(VCloudExtension, )
        self.fileSize = _cast(int, fileSize)
    def factory(*args_, **kwargs_):
        if FileUploadParamsType.subclass:
            return FileUploadParamsType.subclass(*args_, **kwargs_)
        else:
            return FileUploadParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fileSize(self): return self.fileSize
    def set_fileSize(self, fileSize): self.fileSize = fileSize
    def hasContent_(self):
        if (
            super(FileUploadParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FileUploadParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FileUploadParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FileUploadParamsType'):
        super(FileUploadParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadParamsType')
        if self.fileSize is not None and 'fileSize' not in already_processed:
            already_processed.add('fileSize')
            outfile.write(' fileSize="%s"' % self.gds_format_integer(self.fileSize, input_name='fileSize'))
    def exportChildren(self, outfile, level, namespace_='', name_='FileUploadParamsType', fromsubclass_=False, pretty_print=True):
        super(FileUploadParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FileUploadParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.fileSize is not None and 'fileSize' not in already_processed:
            already_processed.add('fileSize')
            showIndent(outfile, level)
            outfile.write('fileSize=%d,\n' % (self.fileSize,))
        super(FileUploadParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FileUploadParamsType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fileSize', node)
        if value is not None and 'fileSize' not in already_processed:
            already_processed.add('fileSize')
            try:
                self.fileSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(FileUploadParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FileUploadParamsType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FileUploadParamsType


class FileUploadSocketType(VCloudExtensibleType):
    """5.1 Parameters for initiating file upload. none URL where the file
    must be uploaded. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, uploadLocation=None, Task=None):
        self.original_tagname_ = None
        super(FileUploadSocketType, self).__init__(VCloudExtension, )
        self.uploadLocation = _cast(None, uploadLocation)
        self.Task = Task
    def factory(*args_, **kwargs_):
        if FileUploadSocketType.subclass:
            return FileUploadSocketType.subclass(*args_, **kwargs_)
        else:
            return FileUploadSocketType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Task(self): return self.Task
    def set_Task(self, Task): self.Task = Task
    def get_uploadLocation(self): return self.uploadLocation
    def set_uploadLocation(self, uploadLocation): self.uploadLocation = uploadLocation
    def hasContent_(self):
        if (
            self.Task is not None or
            super(FileUploadSocketType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FileUploadSocketType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadSocketType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FileUploadSocketType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FileUploadSocketType'):
        super(FileUploadSocketType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadSocketType')
        if self.uploadLocation is not None and 'uploadLocation' not in already_processed:
            already_processed.add('uploadLocation')
            outfile.write(' uploadLocation=%s' % (self.gds_format_string(quote_attrib(self.uploadLocation).encode(ExternalEncoding), input_name='uploadLocation'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FileUploadSocketType', fromsubclass_=False, pretty_print=True):
        super(FileUploadSocketType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Task is not None:
            self.Task.export(outfile, level, namespace_, name_='Task', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FileUploadSocketType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.uploadLocation is not None and 'uploadLocation' not in already_processed:
            already_processed.add('uploadLocation')
            showIndent(outfile, level)
            outfile.write('uploadLocation="%s",\n' % (self.uploadLocation,))
        super(FileUploadSocketType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FileUploadSocketType, self).exportLiteralChildren(outfile, level, name_)
        if self.Task is not None:
            showIndent(outfile, level)
            outfile.write('Task=model_.TaskType(\n')
            self.Task.exportLiteral(outfile, level, name_='Task')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('uploadLocation', node)
        if value is not None and 'uploadLocation' not in already_processed:
            already_processed.add('uploadLocation')
            self.uploadLocation = value
        super(FileUploadSocketType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Task':
            obj_ = TaskType.factory()
            obj_.build(child_)
            self.Task = obj_
            obj_.original_tagname_ = 'Task'
        super(FileUploadSocketType, self).buildChildren(child_, node, nodeName_, True)
# end class FileUploadSocketType


class TaskOperationListType(ResourceType):
    """List of operation names. 1.5"""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, Operation=None):
        self.original_tagname_ = None
        super(TaskOperationListType, self).__init__(VCloudExtension, href, type_, Link, )
        if Operation is None:
            self.Operation = []
        else:
            self.Operation = Operation
    def factory(*args_, **kwargs_):
        if TaskOperationListType.subclass:
            return TaskOperationListType.subclass(*args_, **kwargs_)
        else:
            return TaskOperationListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Operation(self): return self.Operation
    def set_Operation(self, Operation): self.Operation = Operation
    def add_Operation(self, value): self.Operation.append(value)
    def insert_Operation_at(self, index, value): self.Operation.insert(index, value)
    def replace_Operation_at(self, index, value): self.Operation[index] = value
    def hasContent_(self):
        if (
            self.Operation or
            super(TaskOperationListType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TaskOperationListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskOperationListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TaskOperationListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TaskOperationListType'):
        super(TaskOperationListType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskOperationListType')
    def exportChildren(self, outfile, level, namespace_='', name_='TaskOperationListType', fromsubclass_=False, pretty_print=True):
        super(TaskOperationListType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Operation_ in self.Operation:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOperation>%s</%sOperation>%s' % (namespace_, self.gds_format_string(quote_xml(Operation_).encode(ExternalEncoding), input_name='Operation'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TaskOperationListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(TaskOperationListType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskOperationListType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Operation=[\n')
        level += 1
        for Operation_ in self.Operation:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Operation_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TaskOperationListType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Operation':
            Operation_ = child_.text
            Operation_ = self.gds_validate_string(Operation_, node, 'Operation')
            self.Operation.append(Operation_)
        super(TaskOperationListType, self).buildChildren(child_, node, nodeName_, True)
# end class TaskOperationListType


class EntityType(IdentifiableResourceType):
    """0.9 Basic entity type in the vCloud object model. Includes a name,
    an optional description, and an optional list of links. always
    The name of the entity. true"""
    subclass = None
    superclass = IdentifiableResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, extensiontype_=None):
        self.original_tagname_ = None
        super(EntityType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, extensiontype_, )
        self.name = _cast(None, name)
        self.Description = Description
        self.Tasks = Tasks
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if EntityType.subclass:
            return EntityType.subclass(*args_, **kwargs_)
        else:
            return EntityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Tasks(self): return self.Tasks
    def set_Tasks(self, Tasks): self.Tasks = Tasks
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Tasks is not None or
            super(EntityType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityType'):
        super(EntityType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EntityType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='EntityType', fromsubclass_=False, pretty_print=True):
        super(EntityType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        if self.Tasks is not None:
            self.Tasks.export(outfile, level, namespace_, name_='Tasks', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(EntityType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EntityType, self).exportLiteralChildren(outfile, level, name_)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.Tasks is not None:
            showIndent(outfile, level)
            outfile.write('Tasks=model_.TasksInProgressType(\n')
            self.Tasks.exportLiteral(outfile, level, name_='Tasks')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(EntityType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Tasks':
            obj_ = TasksInProgressType.factory()
            obj_.build(child_)
            self.Tasks = obj_
            obj_.original_tagname_ = 'Tasks'
        super(EntityType, self).buildChildren(child_, node, nodeName_, True)
# end class EntityType


class EntityReferenceType(VCloudExtensibleType):
    """1.5 A reference to a vCloud entity. none The object identifier,
    expressed in URN format. The value of this attribute uniquely
    identifies the object, persists for the life of the object, and
    is never reused. This context-free identifier can apply to any
    object in any system. truealways The type of the the referenced
    object. falsealways The name of the referenced object. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, type_=None, id=None, name=None, extensiontype_=None):
        self.original_tagname_ = None
        super(EntityReferenceType, self).__init__(VCloudExtension, extensiontype_, )
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if EntityReferenceType.subclass:
            return EntityReferenceType.subclass(*args_, **kwargs_)
        else:
            return EntityReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(EntityReferenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityReferenceType'):
        super(EntityReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EntityReferenceType')
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='EntityReferenceType', fromsubclass_=False, pretty_print=True):
        super(EntityReferenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(EntityReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EntityReferenceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(EntityReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(EntityReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class EntityReferenceType


class EntityLinkType(EntityReferenceType):
    """1.5 Extends EntityReference type by adding relation attribute.
    always Defines the relationship of the link to the object that
    contains it. A relationship can be the name of an operation on
    the object, a reference to a contained or containing object, or
    a reference to an alternate representation of the object. The
    relationship value implies the HTTP verb to use when you use the
    link's href value as a request URL. true"""
    subclass = None
    superclass = EntityReferenceType
    def __init__(self, VCloudExtension=None, type_=None, id=None, name=None, rel=None):
        self.original_tagname_ = None
        super(EntityLinkType, self).__init__(VCloudExtension, type_, id, name, )
        self.rel = _cast(None, rel)
    def factory(*args_, **kwargs_):
        if EntityLinkType.subclass:
            return EntityLinkType.subclass(*args_, **kwargs_)
        else:
            return EntityLinkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def hasContent_(self):
        if (
            super(EntityLinkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityLinkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityLinkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityLinkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityLinkType'):
        super(EntityLinkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EntityLinkType')
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='EntityLinkType', fromsubclass_=False, pretty_print=True):
        super(EntityLinkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityLinkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel="%s",\n' % (self.rel,))
        super(EntityLinkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EntityLinkType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        super(EntityLinkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(EntityLinkType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class EntityLinkType


class TasksInProgressType(VCloudExtensibleType):
    """0.9 A list of queued, running, or recently completed tasks."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Task=None):
        self.original_tagname_ = None
        super(TasksInProgressType, self).__init__(VCloudExtension, )
        if Task is None:
            self.Task = []
        else:
            self.Task = Task
    def factory(*args_, **kwargs_):
        if TasksInProgressType.subclass:
            return TasksInProgressType.subclass(*args_, **kwargs_)
        else:
            return TasksInProgressType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Task(self): return self.Task
    def set_Task(self, Task): self.Task = Task
    def add_Task(self, value): self.Task.append(value)
    def insert_Task_at(self, index, value): self.Task.insert(index, value)
    def replace_Task_at(self, index, value): self.Task[index] = value
    def hasContent_(self):
        if (
            self.Task or
            super(TasksInProgressType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TasksInProgressType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TasksInProgressType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TasksInProgressType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TasksInProgressType'):
        super(TasksInProgressType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TasksInProgressType')
    def exportChildren(self, outfile, level, namespace_='', name_='TasksInProgressType', fromsubclass_=False, pretty_print=True):
        super(TasksInProgressType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Task_ in self.Task:
            Task_.export(outfile, level, namespace_, name_='Task', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='TasksInProgressType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(TasksInProgressType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TasksInProgressType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Task=[\n')
        level += 1
        for Task_ in self.Task:
            showIndent(outfile, level)
            outfile.write('model_.TaskType(\n')
            Task_.exportLiteral(outfile, level, name_='TaskType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TasksInProgressType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Task':
            obj_ = TaskType.factory()
            obj_.build(child_)
            self.Task.append(obj_)
            obj_.original_tagname_ = 'Task'
        super(TasksInProgressType, self).buildChildren(child_, node, nodeName_, True)
# end class TasksInProgressType


class TaskType(EntityType):
    """0.9 Represents an asynchronous operation in vCloud Director. none
    The execution status of the task. One of:<br> <b>queued</b> (The
    task has been queued for execution)<br> <b>preRunning</b> (The
    task is awaiting preprocessing or administrative action.)<br>
    <b>running</b> (The task is running.)<br> <b>success</b> (The
    task completed with a status of success.)<br> <b>error</b> (The
    task encountered an error while running.)<br> <b>canceled</b>
    (The task was canceled by the owner or an administrator.)<br>
    <b>aborted</b> (The task was aborted by an administrative
    action.) truealways A message describing the operation that is
    tracked by this task. falsenone The short name of the operation
    that is tracked by this task. false5.1createtrue Identifier of
    the service that created the task. It must not start with
    com.vmware.vcloud and the length must be between 1 and 128
    symbols. none The date and time the system started executing the
    task. May not be present if the task has not been executed yet.
    falsenone The date and time that processing of the task was
    completed. May not be present if the task is still being
    executed. falsenone The date and time at which the task resource
    will be destroyed and no longer available for retrieval. May not
    be present if the task has not been executed or is still being
    executed. false5.1nonefalse Whether user has requested this
    processing to be canceled."""
    subclass = None
    superclass = EntityType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, status=None, operationName=None, expiryTime=None, cancelRequested=None, startTime=None, operation=None, endTime=None, serviceNamespace=None, Owner=None, Error=None, User=None, Organization=None, Progress=None, Params=None, Details=None):
        self.original_tagname_ = None
        super(TaskType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, name, Description, Tasks, )
        self.status = _cast(None, status)
        self.operationName = _cast(None, operationName)
        if isinstance(expiryTime, basestring):
            initvalue_ = datetime_.datetime.strptime(expiryTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = expiryTime
        self.expiryTime = initvalue_
        self.cancelRequested = _cast(bool, cancelRequested)
        if isinstance(startTime, basestring):
            initvalue_ = datetime_.datetime.strptime(startTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = startTime
        self.startTime = initvalue_
        self.operation = _cast(None, operation)
        if isinstance(endTime, basestring):
            initvalue_ = datetime_.datetime.strptime(endTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = endTime
        self.endTime = initvalue_
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.Owner = Owner
        self.Error = Error
        self.User = User
        self.Organization = Organization
        self.Progress = Progress
        self.Params = Params
        self.Details = Details
    def factory(*args_, **kwargs_):
        if TaskType.subclass:
            return TaskType.subclass(*args_, **kwargs_)
        else:
            return TaskType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Owner(self): return self.Owner
    def set_Owner(self, Owner): self.Owner = Owner
    def get_Error(self): return self.Error
    def set_Error(self, Error): self.Error = Error
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def get_Organization(self): return self.Organization
    def set_Organization(self, Organization): self.Organization = Organization
    def get_Progress(self): return self.Progress
    def set_Progress(self, Progress): self.Progress = Progress
    def get_Params(self): return self.Params
    def set_Params(self, Params): self.Params = Params
    def get_Details(self): return self.Details
    def set_Details(self, Details): self.Details = Details
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_operationName(self): return self.operationName
    def set_operationName(self, operationName): self.operationName = operationName
    def get_expiryTime(self): return self.expiryTime
    def set_expiryTime(self, expiryTime): self.expiryTime = expiryTime
    def get_cancelRequested(self): return self.cancelRequested
    def set_cancelRequested(self, cancelRequested): self.cancelRequested = cancelRequested
    def get_startTime(self): return self.startTime
    def set_startTime(self, startTime): self.startTime = startTime
    def get_operation(self): return self.operation
    def set_operation(self, operation): self.operation = operation
    def get_endTime(self): return self.endTime
    def set_endTime(self, endTime): self.endTime = endTime
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def hasContent_(self):
        if (
            self.Owner is not None or
            self.Error is not None or
            self.User is not None or
            self.Organization is not None or
            self.Progress is not None or
            self.Params is not None or
            self.Details is not None or
            super(TaskType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TaskType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TaskType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TaskType'):
        super(TaskType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.operationName is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            outfile.write(' operationName=%s' % (self.gds_format_string(quote_attrib(self.operationName).encode(ExternalEncoding), input_name='operationName'), ))
        if self.expiryTime is not None and 'expiryTime' not in already_processed:
            already_processed.add('expiryTime')
            outfile.write(' expiryTime="%s"' % self.gds_format_datetime(self.expiryTime, input_name='expiryTime'))
        if self.cancelRequested is not None and 'cancelRequested' not in already_processed:
            already_processed.add('cancelRequested')
            outfile.write(' cancelRequested="%s"' % self.gds_format_boolean(self.cancelRequested, input_name='cancelRequested'))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            outfile.write(' startTime="%s"' % self.gds_format_datetime(self.startTime, input_name='startTime'))
        if self.operation is not None and 'operation' not in already_processed:
            already_processed.add('operation')
            outfile.write(' operation=%s' % (self.gds_format_string(quote_attrib(self.operation).encode(ExternalEncoding), input_name='operation'), ))
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            outfile.write(' endTime="%s"' % self.gds_format_datetime(self.endTime, input_name='endTime'))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TaskType', fromsubclass_=False, pretty_print=True):
        super(TaskType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Owner is not None:
            self.Owner.export(outfile, level, namespace_, name_='Owner', pretty_print=pretty_print)
        if self.Error is not None:
            self.Error.export(outfile, level, namespace_, name_='Error', pretty_print=pretty_print)
        if self.User is not None:
            self.User.export(outfile, level, namespace_, name_='User', pretty_print=pretty_print)
        if self.Organization is not None:
            self.Organization.export(outfile, level, namespace_, name_='Organization', pretty_print=pretty_print)
        if self.Progress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProgress>%s</%sProgress>%s' % (namespace_, self.gds_format_integer(self.Progress, input_name='Progress'), namespace_, eol_))
        if self.Params is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sParams>%s</%sParams>%s' % (namespace_, self.gds_format_string(quote_xml(self.Params).encode(ExternalEncoding), input_name='Params'), namespace_, eol_))
        if self.Details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDetails>%s</%sDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.Details).encode(ExternalEncoding), input_name='Details'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TaskType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.operationName is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            showIndent(outfile, level)
            outfile.write('operationName="%s",\n' % (self.operationName,))
        if self.expiryTime is not None and 'expiryTime' not in already_processed:
            already_processed.add('expiryTime')
            showIndent(outfile, level)
            outfile.write('expiryTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.expiryTime, input_name='expiryTime'))
        if self.cancelRequested is not None and 'cancelRequested' not in already_processed:
            already_processed.add('cancelRequested')
            showIndent(outfile, level)
            outfile.write('cancelRequested=%s,\n' % (self.cancelRequested,))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            showIndent(outfile, level)
            outfile.write('startTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.startTime, input_name='startTime'))
        if self.operation is not None and 'operation' not in already_processed:
            already_processed.add('operation')
            showIndent(outfile, level)
            outfile.write('operation="%s",\n' % (self.operation,))
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            showIndent(outfile, level)
            outfile.write('endTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.endTime, input_name='endTime'))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        super(TaskType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskType, self).exportLiteralChildren(outfile, level, name_)
        if self.Owner is not None:
            showIndent(outfile, level)
            outfile.write('Owner=model_.ReferenceType(\n')
            self.Owner.exportLiteral(outfile, level, name_='Owner')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Error is not None:
            showIndent(outfile, level)
            outfile.write('Error=model_.ErrorType(\n')
            self.Error.exportLiteral(outfile, level, name_='Error')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.User is not None:
            showIndent(outfile, level)
            outfile.write('User=model_.ReferenceType(\n')
            self.User.exportLiteral(outfile, level, name_='User')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Organization is not None:
            showIndent(outfile, level)
            outfile.write('Organization=model_.ReferenceType(\n')
            self.Organization.exportLiteral(outfile, level, name_='Organization')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Progress is not None:
            showIndent(outfile, level)
            outfile.write('Progress=%d,\n' % self.Progress)
        if self.Params is not None:
            showIndent(outfile, level)
            outfile.write('Params=%s,\n' % quote_python(self.Params).encode(ExternalEncoding))
        if self.Details is not None:
            showIndent(outfile, level)
            outfile.write('Details=%s,\n' % quote_python(self.Details).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('operationName', node)
        if value is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            self.operationName = value
        value = find_attr_value_('expiryTime', node)
        if value is not None and 'expiryTime' not in already_processed:
            already_processed.add('expiryTime')
            try:
                self.expiryTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (expiryTime): %s' % exp)
        value = find_attr_value_('cancelRequested', node)
        if value is not None and 'cancelRequested' not in already_processed:
            already_processed.add('cancelRequested')
            if value in ('true', '1'):
                self.cancelRequested = True
            elif value in ('false', '0'):
                self.cancelRequested = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('startTime', node)
        if value is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            try:
                self.startTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (startTime): %s' % exp)
        value = find_attr_value_('operation', node)
        if value is not None and 'operation' not in already_processed:
            already_processed.add('operation')
            self.operation = value
        value = find_attr_value_('endTime', node)
        if value is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            try:
                self.endTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (endTime): %s' % exp)
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        super(TaskType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Owner':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Owner = obj_
            obj_.original_tagname_ = 'Owner'
        elif nodeName_ == 'Error':
            obj_ = ErrorType.factory()
            obj_.build(child_)
            self.Error = obj_
            obj_.original_tagname_ = 'Error'
        elif nodeName_ == 'User':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.User = obj_
            obj_.original_tagname_ = 'User'
        elif nodeName_ == 'Organization':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Organization = obj_
            obj_.original_tagname_ = 'Organization'
        elif nodeName_ == 'Progress':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Progress')
            self.Progress = ival_
        elif nodeName_ == 'Params':
            Params_ = child_.text
            Params_ = self.gds_validate_string(Params_, node, 'Params')
            self.Params = Params_
        elif nodeName_ == 'Details':
            Details_ = child_.text
            Details_ = self.gds_validate_string(Details_, node, 'Details')
            self.Details = Details_
        super(TaskType, self).buildChildren(child_, node, nodeName_, True)
# end class TaskType


class LinkType(ReferenceType):
    """0.9 Extends reference type by adding relation attribute. Defines a
    hyper-link with a relationship, hyper-link reference, and an
    optional MIME type. always Defines the relationship of the link
    to the object that contains it. A relationship can be the name
    of an operation on the object, a reference to a contained or
    containing object, or a reference to an alternate representation
    of the object. The relationship value implies the HTTP verb to
    use when you use the link's href as a request URL. See the
    vCloud API Programming Guide for a list of links and link
    relations. true"""
    subclass = None
    superclass = ReferenceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, id=None, name=None, rel=None):
        self.original_tagname_ = None
        super(LinkType, self).__init__(VCloudExtension, href, type_, id, name, )
        self.rel = _cast(None, rel)
    def factory(*args_, **kwargs_):
        if LinkType.subclass:
            return LinkType.subclass(*args_, **kwargs_)
        else:
            return LinkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def hasContent_(self):
        if (
            super(LinkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LinkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LinkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LinkType'):
        super(LinkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LinkType')
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LinkType', fromsubclass_=False, pretty_print=True):
        super(LinkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LinkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel="%s",\n' % (self.rel,))
        super(LinkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LinkType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        super(LinkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(LinkType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class LinkType


class OrgType(EntityType):
    """0.9 Represents the user view of a vCloud Director organization."""
    subclass = None
    superclass = EntityType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, FullName=None, IsEnabled=None):
        self.original_tagname_ = None
        super(OrgType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, name, Description, Tasks, )
        self.FullName = FullName
        self.IsEnabled = IsEnabled
    def factory(*args_, **kwargs_):
        if OrgType.subclass:
            return OrgType.subclass(*args_, **kwargs_)
        else:
            return OrgType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_FullName(self): return self.FullName
    def set_FullName(self, FullName): self.FullName = FullName
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def hasContent_(self):
        if (
            self.FullName is not None or
            self.IsEnabled is not None or
            super(OrgType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OrgType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OrgType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OrgType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OrgType'):
        super(OrgType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OrgType')
    def exportChildren(self, outfile, level, namespace_='', name_='OrgType', fromsubclass_=False, pretty_print=True):
        super(OrgType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.FullName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFullName>%s</%sFullName>%s' % (namespace_, self.gds_format_string(quote_xml(self.FullName).encode(ExternalEncoding), input_name='FullName'), namespace_, eol_))
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='OrgType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(OrgType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(OrgType, self).exportLiteralChildren(outfile, level, name_)
        if self.FullName is not None:
            showIndent(outfile, level)
            outfile.write('FullName=%s,\n' % quote_python(self.FullName).encode(ExternalEncoding))
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OrgType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'FullName':
            FullName_ = child_.text
            FullName_ = self.gds_validate_string(FullName_, node, 'FullName')
            self.FullName = FullName_
        elif nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        super(OrgType, self).buildChildren(child_, node, nodeName_, True)
# end class OrgType


class OrgListType(ResourceType):
    """0.9 Represents a list of organizations."""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, Org=None):
        self.original_tagname_ = None
        super(OrgListType, self).__init__(VCloudExtension, href, type_, Link, )
        if Org is None:
            self.Org = []
        else:
            self.Org = Org
    def factory(*args_, **kwargs_):
        if OrgListType.subclass:
            return OrgListType.subclass(*args_, **kwargs_)
        else:
            return OrgListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Org(self): return self.Org
    def set_Org(self, Org): self.Org = Org
    def add_Org(self, value): self.Org.append(value)
    def insert_Org_at(self, index, value): self.Org.insert(index, value)
    def replace_Org_at(self, index, value): self.Org[index] = value
    def hasContent_(self):
        if (
            self.Org or
            super(OrgListType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OrgListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OrgListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OrgListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OrgListType'):
        super(OrgListType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OrgListType')
    def exportChildren(self, outfile, level, namespace_='', name_='OrgListType', fromsubclass_=False, pretty_print=True):
        super(OrgListType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Org_ in self.Org:
            Org_.export(outfile, level, namespace_, name_='Org', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OrgListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(OrgListType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(OrgListType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Org=[\n')
        level += 1
        for Org_ in self.Org:
            showIndent(outfile, level)
            outfile.write('model_.ReferenceType(\n')
            Org_.exportLiteral(outfile, level, name_='ReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OrgListType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Org':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Org.append(obj_)
            obj_.original_tagname_ = 'Org'
        super(OrgListType, self).buildChildren(child_, node, nodeName_, True)
# end class OrgListType


GDSClassesMapping = {
    'ControlAccessParams': ControlAccessParamsType,
    'Task': TaskType,
    'Metadata': MetadataType,
    'MetadataValue': MetadataValueType,
    'QueryList': QueryListType,
    'Link': LinkType,
    'User': ReferenceType,
    'Org': OrgType,
    'VCloudExtension': VCloudExtensionType,
    'AccessSettings': AccessSettingsType,
    'TypedValue': MetadataTypedValue,
    'Error': ErrorType,
    'Organization': ReferenceType,
    'Domain': MetadataDomainTagType,
    'Tasks': TasksInProgressType,
    'Reference': ReferenceType,
    'AccessSetting': AccessSettingType,
    'OrgList': OrgListType,
    'MetadataEntry': MetadataEntryType,
    'Entity': EntityType,
    'References': ReferencesType,
    'Owner': ReferenceType,
    'Subject': ReferenceType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'OrgListType'
        rootClass = OrgListType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'OrgListType'
        rootClass = OrgListType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'OrgListType'
        rootClass = OrgListType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'OrgListType'
        rootClass = OrgListType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from organizationListType import *\n\n')
        sys.stdout.write('import organizationListType as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "AccessSettingType",
    "AccessSettingsType",
    "CapacityType",
    "CapacityWithUsageType",
    "ContainerType",
    "ControlAccessParamsType",
    "EntityLinkType",
    "EntityReferenceType",
    "EntityType",
    "ErrorType",
    "FileUploadParamsType",
    "FileUploadSocketType",
    "IdentifiableResourceType",
    "LinkType",
    "MetadataBooleanValue",
    "MetadataDateTimeValue",
    "MetadataDomainTagType",
    "MetadataEntryType",
    "MetadataNumberValue",
    "MetadataStringValue",
    "MetadataType",
    "MetadataTypedValue",
    "MetadataValueType",
    "OrgListType",
    "OrgType",
    "OwnerType",
    "ParamsType",
    "QueryListType",
    "ReferenceType",
    "ReferencesType",
    "ResourceReferenceType",
    "ResourceType",
    "TaskOperationListType",
    "TaskType",
    "TasksInProgressType",
    "VCloudExtensibleType",
    "VCloudExtensionType"
]
