# VMware vCloud Python SDK
# Copyright (c) 2014 VMware, Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Nov  4 09:24:21 2014 by generateDS.py version 2.13a.
#
# Command line options:
#   ('-o', 'schema/vcd/v1_5/schemas/vcloud/networkType.py')
#
# Command line arguments:
#   schema/vcd/v1_5/schemas/vcloud/network.xsd
#
# Command line:
#   ../env/bin/generateDS.py -o "schema/vcd/v1_5/schemas/vcloud/networkType.py" schema/vcd/v1_5/schemas/vcloud/network.xsd
#
# Current working directory (os.getcwd()):
#   src
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class NetworkFeaturesType(GeneratedsSuper):
    """Represents features of a network."""
    subclass = None
    superclass = None
    def __init__(self, NetworkService=None):
        self.original_tagname_ = None
        if NetworkService is None:
            self.NetworkService = []
        else:
            self.NetworkService = NetworkService
    def factory(*args_, **kwargs_):
        if NetworkFeaturesType.subclass:
            return NetworkFeaturesType.subclass(*args_, **kwargs_)
        else:
            return NetworkFeaturesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NetworkService(self): return self.NetworkService
    def set_NetworkService(self, NetworkService): self.NetworkService = NetworkService
    def add_NetworkService(self, value): self.NetworkService.append(value)
    def insert_NetworkService_at(self, index, value): self.NetworkService.insert(index, value)
    def replace_NetworkService_at(self, index, value): self.NetworkService[index] = value
    def hasContent_(self):
        if (
            self.NetworkService
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkFeaturesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkFeaturesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NetworkFeaturesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkFeaturesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkFeaturesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for NetworkService_ in self.NetworkService:
            NetworkService_.export(outfile, level, namespace_, name_='NetworkService', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NetworkFeaturesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('NetworkService=[\n')
        level += 1
        for NetworkService_ in self.NetworkService:
            showIndent(outfile, level)
            outfile.write('model_.NetworkService(\n')
            NetworkService_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NetworkService':
            class_obj_ = self.get_class_obj_(child_, NetworkServiceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'NetworkService'
        elif nodeName_ == 'DhcpService':
            obj_ = DhcpServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'DhcpService'
        elif nodeName_ == 'FirewallService':
            obj_ = FirewallServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'FirewallService'
        elif nodeName_ == 'NatService':
            obj_ = NatServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'NatService'
        elif nodeName_ == 'IpsecVpnService':
            obj_ = IpsecVpnServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'IpsecVpnService'
        elif nodeName_ == 'StaticRoutingService':
            obj_ = StaticRoutingServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'StaticRoutingService'
        elif nodeName_ == 'GatewayIpsecVpnService':
            obj_ = GatewayIpsecVpnServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'GatewayIpsecVpnService'
        elif nodeName_ == 'LoadBalancerService':
            obj_ = LoadBalancerServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'LoadBalancerService'
        elif nodeName_ == 'GatewayDhcpService':
            obj_ = GatewayDhcpServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'GatewayDhcpService'
# end class NetworkFeaturesType


class RouterInfoType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ExternalIp=None):
        self.original_tagname_ = None
        self.ExternalIp = ExternalIp
    def factory(*args_, **kwargs_):
        if RouterInfoType.subclass:
            return RouterInfoType.subclass(*args_, **kwargs_)
        else:
            return RouterInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ExternalIp(self): return self.ExternalIp
    def set_ExternalIp(self, ExternalIp): self.ExternalIp = ExternalIp
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.ExternalIp is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RouterInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RouterInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='RouterInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RouterInfoType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='RouterInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ExternalIp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExternalIp>%s</%sExternalIp>%s' % (namespace_, self.gds_format_string(quote_xml(self.ExternalIp).encode(ExternalEncoding), input_name='ExternalIp'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='RouterInfoType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.ExternalIp is not None:
            showIndent(outfile, level)
            outfile.write('ExternalIp=%s,\n' % quote_python(self.ExternalIp).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ExternalIp':
            ExternalIp_ = child_.text
            ExternalIp_ = self.gds_validate_string(ExternalIp_, node, 'ExternalIp')
            self.ExternalIp = ExternalIp_
            self.validate_IpAddressType(self.ExternalIp)    # validate type IpAddressType
# end class RouterInfoType


class SyslogServerSettingsType(GeneratedsSuper):
    """1.5 Syslog server settings. If logging is configured for firewall
    rules, the logs will be directed to these syslog servers."""
    subclass = None
    superclass = None
    def __init__(self, SyslogServerIp1=None, SyslogServerIp2=None):
        self.original_tagname_ = None
        self.SyslogServerIp1 = SyslogServerIp1
        self.SyslogServerIp2 = SyslogServerIp2
    def factory(*args_, **kwargs_):
        if SyslogServerSettingsType.subclass:
            return SyslogServerSettingsType.subclass(*args_, **kwargs_)
        else:
            return SyslogServerSettingsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SyslogServerIp1(self): return self.SyslogServerIp1
    def set_SyslogServerIp1(self, SyslogServerIp1): self.SyslogServerIp1 = SyslogServerIp1
    def get_SyslogServerIp2(self): return self.SyslogServerIp2
    def set_SyslogServerIp2(self, SyslogServerIp2): self.SyslogServerIp2 = SyslogServerIp2
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.SyslogServerIp1 is not None or
            self.SyslogServerIp2 is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SyslogServerSettingsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SyslogServerSettingsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SyslogServerSettingsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SyslogServerSettingsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SyslogServerSettingsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SyslogServerIp1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSyslogServerIp1>%s</%sSyslogServerIp1>%s' % (namespace_, self.gds_format_string(quote_xml(self.SyslogServerIp1).encode(ExternalEncoding), input_name='SyslogServerIp1'), namespace_, eol_))
        if self.SyslogServerIp2 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSyslogServerIp2>%s</%sSyslogServerIp2>%s' % (namespace_, self.gds_format_string(quote_xml(self.SyslogServerIp2).encode(ExternalEncoding), input_name='SyslogServerIp2'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='SyslogServerSettingsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.SyslogServerIp1 is not None:
            showIndent(outfile, level)
            outfile.write('SyslogServerIp1=%s,\n' % quote_python(self.SyslogServerIp1).encode(ExternalEncoding))
        if self.SyslogServerIp2 is not None:
            showIndent(outfile, level)
            outfile.write('SyslogServerIp2=%s,\n' % quote_python(self.SyslogServerIp2).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SyslogServerIp1':
            SyslogServerIp1_ = child_.text
            SyslogServerIp1_ = self.gds_validate_string(SyslogServerIp1_, node, 'SyslogServerIp1')
            self.SyslogServerIp1 = SyslogServerIp1_
            self.validate_IpAddressType(self.SyslogServerIp1)    # validate type IpAddressType
        elif nodeName_ == 'SyslogServerIp2':
            SyslogServerIp2_ = child_.text
            SyslogServerIp2_ = self.gds_validate_string(SyslogServerIp2_, node, 'SyslogServerIp2')
            self.SyslogServerIp2 = SyslogServerIp2_
            self.validate_IpAddressType(self.SyslogServerIp2)    # validate type IpAddressType
# end class SyslogServerSettingsType


class VCloudExtensionType(GeneratedsSuper):
    """0.9 General purpose extension element. Not related to extension
    services. always True if the request should fail when the server
    does not understand the extension. false"""
    subclass = None
    superclass = None
    def __init__(self, required=True, anytypeobjs_=None):
        self.original_tagname_ = None
        self.required = _cast(bool, required)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if VCloudExtensionType.subclass:
            return VCloudExtensionType.subclass(*args_, **kwargs_)
        else:
            return VCloudExtensionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VCloudExtensionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VCloudExtensionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VCloudExtensionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VCloudExtensionType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.required, input_name='required'))
    def exportChildren(self, outfile, level, namespace_='', name_='VCloudExtensionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VCloudExtensionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            showIndent(outfile, level)
            outfile.write('required=%s,\n' % (self.required,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.add('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'VCloudExtensionType')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class VCloudExtensionType


class VCloudExtensibleType(GeneratedsSuper):
    """0.9 A base abstract type for all complex types that support
    extensions."""
    subclass = None
    superclass = None
    def __init__(self, VCloudExtension=None, extensiontype_=None):
        self.original_tagname_ = None
        if VCloudExtension is None:
            self.VCloudExtension = []
        else:
            self.VCloudExtension = VCloudExtension
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if VCloudExtensibleType.subclass:
            return VCloudExtensibleType.subclass(*args_, **kwargs_)
        else:
            return VCloudExtensibleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_VCloudExtension(self): return self.VCloudExtension
    def set_VCloudExtension(self, VCloudExtension): self.VCloudExtension = VCloudExtension
    def add_VCloudExtension(self, value): self.VCloudExtension.append(value)
    def insert_VCloudExtension_at(self, index, value): self.VCloudExtension.insert(index, value)
    def replace_VCloudExtension_at(self, index, value): self.VCloudExtension[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.VCloudExtension
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VCloudExtensibleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VCloudExtensibleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VCloudExtensibleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VCloudExtensibleType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VCloudExtensibleType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for VCloudExtension_ in self.VCloudExtension:
            VCloudExtension_.export(outfile, level, namespace_, name_='VCloudExtension', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VCloudExtensibleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('VCloudExtension=[\n')
        level += 1
        for VCloudExtension_ in self.VCloudExtension:
            showIndent(outfile, level)
            outfile.write('model_.VCloudExtensionType(\n')
            VCloudExtension_.exportLiteral(outfile, level, name_='VCloudExtensionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'VCloudExtension':
            obj_ = VCloudExtensionType.factory()
            obj_.build(child_)
            self.VCloudExtension.append(obj_)
            obj_.original_tagname_ = 'VCloudExtension'
# end class VCloudExtensibleType


class ErrorType(VCloudExtensibleType):
    """0.9 The standard error message type used in the vCloud REST API.
    none An one line, human-readable message describing the error
    that occurred. truenone The class of the error. Matches the HTTP
    status code. truenone Resource-specific error code. truenone A
    vendor- or implementation-specific error code that can reference
    specific modules or source lines for diagnostic purposes.
    false1.0none The stack trace of the exception. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, vendorSpecificErrorCode=None, stackTrace=None, message=None, minorErrorCode=None, majorErrorCode=None):
        self.original_tagname_ = None
        super(ErrorType, self).__init__(VCloudExtension, )
        self.vendorSpecificErrorCode = _cast(None, vendorSpecificErrorCode)
        self.stackTrace = _cast(None, stackTrace)
        self.message = _cast(None, message)
        self.minorErrorCode = _cast(None, minorErrorCode)
        self.majorErrorCode = _cast(int, majorErrorCode)
    def factory(*args_, **kwargs_):
        if ErrorType.subclass:
            return ErrorType.subclass(*args_, **kwargs_)
        else:
            return ErrorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vendorSpecificErrorCode(self): return self.vendorSpecificErrorCode
    def set_vendorSpecificErrorCode(self, vendorSpecificErrorCode): self.vendorSpecificErrorCode = vendorSpecificErrorCode
    def get_stackTrace(self): return self.stackTrace
    def set_stackTrace(self, stackTrace): self.stackTrace = stackTrace
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def get_minorErrorCode(self): return self.minorErrorCode
    def set_minorErrorCode(self, minorErrorCode): self.minorErrorCode = minorErrorCode
    def get_majorErrorCode(self): return self.majorErrorCode
    def set_majorErrorCode(self, majorErrorCode): self.majorErrorCode = majorErrorCode
    def hasContent_(self):
        if (
            super(ErrorType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ErrorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ErrorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ErrorType'):
        super(ErrorType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorType')
        if self.vendorSpecificErrorCode is not None and 'vendorSpecificErrorCode' not in already_processed:
            already_processed.add('vendorSpecificErrorCode')
            outfile.write(' vendorSpecificErrorCode=%s' % (self.gds_format_string(quote_attrib(self.vendorSpecificErrorCode).encode(ExternalEncoding), input_name='vendorSpecificErrorCode'), ))
        if self.stackTrace is not None and 'stackTrace' not in already_processed:
            already_processed.add('stackTrace')
            outfile.write(' stackTrace=%s' % (self.gds_format_string(quote_attrib(self.stackTrace).encode(ExternalEncoding), input_name='stackTrace'), ))
        if self.message is not None and 'message' not in already_processed:
            already_processed.add('message')
            outfile.write(' message=%s' % (self.gds_format_string(quote_attrib(self.message).encode(ExternalEncoding), input_name='message'), ))
        if self.minorErrorCode is not None and 'minorErrorCode' not in already_processed:
            already_processed.add('minorErrorCode')
            outfile.write(' minorErrorCode=%s' % (self.gds_format_string(quote_attrib(self.minorErrorCode).encode(ExternalEncoding), input_name='minorErrorCode'), ))
        if self.majorErrorCode is not None and 'majorErrorCode' not in already_processed:
            already_processed.add('majorErrorCode')
            outfile.write(' majorErrorCode="%s"' % self.gds_format_integer(self.majorErrorCode, input_name='majorErrorCode'))
    def exportChildren(self, outfile, level, namespace_='', name_='ErrorType', fromsubclass_=False, pretty_print=True):
        super(ErrorType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ErrorType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vendorSpecificErrorCode is not None and 'vendorSpecificErrorCode' not in already_processed:
            already_processed.add('vendorSpecificErrorCode')
            showIndent(outfile, level)
            outfile.write('vendorSpecificErrorCode="%s",\n' % (self.vendorSpecificErrorCode,))
        if self.stackTrace is not None and 'stackTrace' not in already_processed:
            already_processed.add('stackTrace')
            showIndent(outfile, level)
            outfile.write('stackTrace="%s",\n' % (self.stackTrace,))
        if self.message is not None and 'message' not in already_processed:
            already_processed.add('message')
            showIndent(outfile, level)
            outfile.write('message="%s",\n' % (self.message,))
        if self.minorErrorCode is not None and 'minorErrorCode' not in already_processed:
            already_processed.add('minorErrorCode')
            showIndent(outfile, level)
            outfile.write('minorErrorCode="%s",\n' % (self.minorErrorCode,))
        if self.majorErrorCode is not None and 'majorErrorCode' not in already_processed:
            already_processed.add('majorErrorCode')
            showIndent(outfile, level)
            outfile.write('majorErrorCode=%d,\n' % (self.majorErrorCode,))
        super(ErrorType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ErrorType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vendorSpecificErrorCode', node)
        if value is not None and 'vendorSpecificErrorCode' not in already_processed:
            already_processed.add('vendorSpecificErrorCode')
            self.vendorSpecificErrorCode = value
        value = find_attr_value_('stackTrace', node)
        if value is not None and 'stackTrace' not in already_processed:
            already_processed.add('stackTrace')
            self.stackTrace = value
        value = find_attr_value_('message', node)
        if value is not None and 'message' not in already_processed:
            already_processed.add('message')
            self.message = value
        value = find_attr_value_('minorErrorCode', node)
        if value is not None and 'minorErrorCode' not in already_processed:
            already_processed.add('minorErrorCode')
            self.minorErrorCode = value
        value = find_attr_value_('majorErrorCode', node)
        if value is not None and 'majorErrorCode' not in already_processed:
            already_processed.add('majorErrorCode')
            try:
                self.majorErrorCode = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(ErrorType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ErrorType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ErrorType


class ResourceType(VCloudExtensibleType):
    """0.9 The base type for all objects in the vCloud model. Has an
    optional list of links and href and type attributes. always The
    URI of the entity. falsealways The MIME type of the entity.
    false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ResourceType, self).__init__(VCloudExtension, extensiontype_, )
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        if Link is None:
            self.Link = []
        else:
            self.Link = Link
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ResourceType.subclass:
            return ResourceType.subclass(*args_, **kwargs_)
        else:
            return ResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Link(self): return self.Link
    def set_Link(self, Link): self.Link = Link
    def add_Link(self, value): self.Link.append(value)
    def insert_Link_at(self, index, value): self.Link.insert(index, value)
    def replace_Link_at(self, index, value): self.Link[index] = value
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Link or
            super(ResourceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ResourceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ResourceType'):
        super(ResourceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceType')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ResourceType', fromsubclass_=False, pretty_print=True):
        super(ResourceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Link_ in self.Link:
            Link_.export(outfile, level, namespace_, name_='Link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        super(ResourceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ResourceType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Link=[\n')
        level += 1
        for Link_ in self.Link:
            showIndent(outfile, level)
            outfile.write('model_.LinkType(\n')
            Link_.exportLiteral(outfile, level, name_='LinkType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ResourceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Link':
            obj_ = LinkType.factory()
            obj_.build(child_)
            self.Link.append(obj_)
            obj_.original_tagname_ = 'Link'
        super(ResourceType, self).buildChildren(child_, node, nodeName_, True)
# end class ResourceType


class IdentifiableResourceType(ResourceType):
    """0.9 The base type for all resource types which contain an id
    attribute. none The entity identifier, expressed in URN format.
    The value of this attribute uniquely identifies the entity,
    persists for the life of the entity, and is never reused.
    falsecreate Optional unique identifier to support idempotent
    semantics for create and delete operations. false"""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IdentifiableResourceType, self).__init__(VCloudExtension, href, type_, Link, extensiontype_, )
        self.operationKey = _cast(None, operationKey)
        self.id = _cast(None, id)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if IdentifiableResourceType.subclass:
            return IdentifiableResourceType.subclass(*args_, **kwargs_)
        else:
            return IdentifiableResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_operationKey(self): return self.operationKey
    def set_operationKey(self, operationKey): self.operationKey = operationKey
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(IdentifiableResourceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IdentifiableResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IdentifiableResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IdentifiableResourceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IdentifiableResourceType'):
        super(IdentifiableResourceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IdentifiableResourceType')
        if self.operationKey is not None and 'operationKey' not in already_processed:
            already_processed.add('operationKey')
            outfile.write(' operationKey=%s' % (self.gds_format_string(quote_attrib(self.operationKey).encode(ExternalEncoding), input_name='operationKey'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IdentifiableResourceType', fromsubclass_=False, pretty_print=True):
        super(IdentifiableResourceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IdentifiableResourceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.operationKey is not None and 'operationKey' not in already_processed:
            already_processed.add('operationKey')
            showIndent(outfile, level)
            outfile.write('operationKey="%s",\n' % (self.operationKey,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        super(IdentifiableResourceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IdentifiableResourceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('operationKey', node)
        if value is not None and 'operationKey' not in already_processed:
            already_processed.add('operationKey')
            self.operationKey = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IdentifiableResourceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IdentifiableResourceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IdentifiableResourceType


class ParamsType(VCloudExtensibleType):
    """0.9 A basic type used to specify request parameters. always
    Typically used to name or identify the subject of the request.
    For example, the name of the object being created or modified.
    false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, name=None, Description=None):
        self.original_tagname_ = None
        super(ParamsType, self).__init__(VCloudExtension, )
        self.name = _cast(None, name)
        self.Description = Description
    def factory(*args_, **kwargs_):
        if ParamsType.subclass:
            return ParamsType.subclass(*args_, **kwargs_)
        else:
            return ParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            self.Description is not None or
            super(ParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ParamsType'):
        super(ParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ParamsType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ParamsType', fromsubclass_=False, pretty_print=True):
        super(ParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(ParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ParamsType, self).exportLiteralChildren(outfile, level, name_)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(ParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        super(ParamsType, self).buildChildren(child_, node, nodeName_, True)
# end class ParamsType


class ReferenceType(VCloudExtensibleType):
    """0.9 A reference to a resource. Contains an href attribute and
    optional name and type attributes. always Contains the URI to
    the entity. truealways The resource identifier, expressed in URN
    format. The value of this attribute uniquely identifies the
    resource, persists for the life of the resource, and is never
    reused. falsealways Contains the type of the the entity.
    falsealways Contains the name of the the entity. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, href=None, type_=None, id=None, name=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ReferenceType, self).__init__(VCloudExtension, extensiontype_, )
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ReferenceType.subclass:
            return ReferenceType.subclass(*args_, **kwargs_)
        else:
            return ReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(ReferenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReferenceType'):
        super(ReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReferenceType')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ReferenceType', fromsubclass_=False, pretty_print=True):
        super(ReferenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(ReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReferenceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ReferenceType


class ResourceReferenceType(ReferenceType):
    """0.9 Represents a reference to a resource. Contains an href
    attribute, a resource status attribute, and optional name and
    type attributes. none Status of a resource. false"""
    subclass = None
    superclass = ReferenceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, id=None, name=None, status=None):
        self.original_tagname_ = None
        super(ResourceReferenceType, self).__init__(VCloudExtension, href, type_, id, name, )
        self.status = _cast(int, status)
    def factory(*args_, **kwargs_):
        if ResourceReferenceType.subclass:
            return ResourceReferenceType.subclass(*args_, **kwargs_)
        else:
            return ResourceReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def hasContent_(self):
        if (
            super(ResourceReferenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ResourceReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ResourceReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ResourceReferenceType'):
        super(ResourceReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceReferenceType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status="%s"' % self.gds_format_integer(self.status, input_name='status'))
    def exportChildren(self, outfile, level, namespace_='', name_='ResourceReferenceType', fromsubclass_=False, pretty_print=True):
        super(ResourceReferenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status=%d,\n' % (self.status,))
        super(ResourceReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ResourceReferenceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            try:
                self.status = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(ResourceReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ResourceReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ResourceReferenceType


class ContainerType(ResourceType):
    """Container for query result sets. none Query name that generated this
    result set. falsenone Page of the result set that this container
    holds. The first page is page number 1. falsenone Page size, as
    a number of records or references. falsenone Total number of
    records or references in the container. false"""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, total=None, name=None, pageSize=None, page=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ContainerType, self).__init__(VCloudExtension, href, type_, Link, extensiontype_, )
        self.total = _cast(int, total)
        self.name = _cast(None, name)
        self.pageSize = _cast(int, pageSize)
        self.page = _cast(int, page)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ContainerType.subclass:
            return ContainerType.subclass(*args_, **kwargs_)
        else:
            return ContainerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_pageSize(self): return self.pageSize
    def set_pageSize(self, pageSize): self.pageSize = pageSize
    def get_page(self): return self.page
    def set_page(self, page): self.page = page
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(ContainerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ContainerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContainerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ContainerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContainerType'):
        super(ContainerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContainerType')
        if self.total is not None and 'total' not in already_processed:
            already_processed.add('total')
            outfile.write(' total="%s"' % self.gds_format_integer(self.total, input_name='total'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.pageSize is not None and 'pageSize' not in already_processed:
            already_processed.add('pageSize')
            outfile.write(' pageSize="%s"' % self.gds_format_integer(self.pageSize, input_name='pageSize'))
        if self.page is not None and 'page' not in already_processed:
            already_processed.add('page')
            outfile.write(' page="%s"' % self.gds_format_integer(self.page, input_name='page'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ContainerType', fromsubclass_=False, pretty_print=True):
        super(ContainerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ContainerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.total is not None and 'total' not in already_processed:
            already_processed.add('total')
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % (self.total,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.pageSize is not None and 'pageSize' not in already_processed:
            already_processed.add('pageSize')
            showIndent(outfile, level)
            outfile.write('pageSize=%d,\n' % (self.pageSize,))
        if self.page is not None and 'page' not in already_processed:
            already_processed.add('page')
            showIndent(outfile, level)
            outfile.write('page=%d,\n' % (self.page,))
        super(ContainerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContainerType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('total', node)
        if value is not None and 'total' not in already_processed:
            already_processed.add('total')
            try:
                self.total = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('pageSize', node)
        if value is not None and 'pageSize' not in already_processed:
            already_processed.add('pageSize')
            try:
                self.pageSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('page', node)
        if value is not None and 'page' not in already_processed:
            already_processed.add('page')
            try:
                self.page = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ContainerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ContainerType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ContainerType


class CapacityType(VCloudExtensibleType):
    """0.9 Represents the capacity of a given resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Units=None, Allocated=None, Limit=None, extensiontype_=None):
        self.original_tagname_ = None
        super(CapacityType, self).__init__(VCloudExtension, extensiontype_, )
        self.Units = Units
        self.Allocated = Allocated
        self.Limit = Limit
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CapacityType.subclass:
            return CapacityType.subclass(*args_, **kwargs_)
        else:
            return CapacityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Units(self): return self.Units
    def set_Units(self, Units): self.Units = Units
    def get_Allocated(self): return self.Allocated
    def set_Allocated(self, Allocated): self.Allocated = Allocated
    def get_Limit(self): return self.Limit
    def set_Limit(self, Limit): self.Limit = Limit
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Units is not None or
            self.Allocated is not None or
            self.Limit is not None or
            super(CapacityType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CapacityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CapacityType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CapacityType'):
        super(CapacityType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='CapacityType', fromsubclass_=False, pretty_print=True):
        super(CapacityType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Units is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUnits>%s</%sUnits>%s' % (namespace_, self.gds_format_string(quote_xml(self.Units).encode(ExternalEncoding), input_name='Units'), namespace_, eol_))
        if self.Allocated is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAllocated>%s</%sAllocated>%s' % (namespace_, self.gds_format_integer(self.Allocated, input_name='Allocated'), namespace_, eol_))
        if self.Limit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLimit>%s</%sLimit>%s' % (namespace_, self.gds_format_integer(self.Limit, input_name='Limit'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CapacityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CapacityType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CapacityType, self).exportLiteralChildren(outfile, level, name_)
        if self.Units is not None:
            showIndent(outfile, level)
            outfile.write('Units=%s,\n' % quote_python(self.Units).encode(ExternalEncoding))
        if self.Allocated is not None:
            showIndent(outfile, level)
            outfile.write('Allocated=%d,\n' % self.Allocated)
        if self.Limit is not None:
            showIndent(outfile, level)
            outfile.write('Limit=%d,\n' % self.Limit)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(CapacityType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Units':
            Units_ = child_.text
            Units_ = self.gds_validate_string(Units_, node, 'Units')
            self.Units = Units_
        elif nodeName_ == 'Allocated':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Allocated')
            self.Allocated = ival_
        elif nodeName_ == 'Limit':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Limit')
            self.Limit = ival_
        super(CapacityType, self).buildChildren(child_, node, nodeName_, True)
# end class CapacityType


class CapacityWithUsageType(CapacityType):
    """0.9 Represents a capacity and usage of a given resource."""
    subclass = None
    superclass = CapacityType
    def __init__(self, VCloudExtension=None, Units=None, Allocated=None, Limit=None, Reserved=None, Used=None, Overhead=None):
        self.original_tagname_ = None
        super(CapacityWithUsageType, self).__init__(VCloudExtension, Units, Allocated, Limit, )
        self.Reserved = Reserved
        self.Used = Used
        self.Overhead = Overhead
    def factory(*args_, **kwargs_):
        if CapacityWithUsageType.subclass:
            return CapacityWithUsageType.subclass(*args_, **kwargs_)
        else:
            return CapacityWithUsageType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reserved(self): return self.Reserved
    def set_Reserved(self, Reserved): self.Reserved = Reserved
    def get_Used(self): return self.Used
    def set_Used(self, Used): self.Used = Used
    def get_Overhead(self): return self.Overhead
    def set_Overhead(self, Overhead): self.Overhead = Overhead
    def hasContent_(self):
        if (
            self.Reserved is not None or
            self.Used is not None or
            self.Overhead is not None or
            super(CapacityWithUsageType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CapacityWithUsageType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityWithUsageType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CapacityWithUsageType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CapacityWithUsageType'):
        super(CapacityWithUsageType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityWithUsageType')
    def exportChildren(self, outfile, level, namespace_='', name_='CapacityWithUsageType', fromsubclass_=False, pretty_print=True):
        super(CapacityWithUsageType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Reserved is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReserved>%s</%sReserved>%s' % (namespace_, self.gds_format_integer(self.Reserved, input_name='Reserved'), namespace_, eol_))
        if self.Used is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUsed>%s</%sUsed>%s' % (namespace_, self.gds_format_integer(self.Used, input_name='Used'), namespace_, eol_))
        if self.Overhead is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOverhead>%s</%sOverhead>%s' % (namespace_, self.gds_format_integer(self.Overhead, input_name='Overhead'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CapacityWithUsageType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CapacityWithUsageType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CapacityWithUsageType, self).exportLiteralChildren(outfile, level, name_)
        if self.Reserved is not None:
            showIndent(outfile, level)
            outfile.write('Reserved=%d,\n' % self.Reserved)
        if self.Used is not None:
            showIndent(outfile, level)
            outfile.write('Used=%d,\n' % self.Used)
        if self.Overhead is not None:
            showIndent(outfile, level)
            outfile.write('Overhead=%d,\n' % self.Overhead)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(CapacityWithUsageType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reserved':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Reserved')
            self.Reserved = ival_
        elif nodeName_ == 'Used':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Used')
            self.Used = ival_
        elif nodeName_ == 'Overhead':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Overhead')
            self.Overhead = ival_
        super(CapacityWithUsageType, self).buildChildren(child_, node, nodeName_, True)
# end class CapacityWithUsageType


class AccessSettingType(VCloudExtensibleType):
    """0.9 Controls access to the resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Subject=None, AccessLevel=None):
        self.original_tagname_ = None
        super(AccessSettingType, self).__init__(VCloudExtension, )
        self.Subject = Subject
        self.AccessLevel = AccessLevel
    def factory(*args_, **kwargs_):
        if AccessSettingType.subclass:
            return AccessSettingType.subclass(*args_, **kwargs_)
        else:
            return AccessSettingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Subject(self): return self.Subject
    def set_Subject(self, Subject): self.Subject = Subject
    def get_AccessLevel(self): return self.AccessLevel
    def set_AccessLevel(self, AccessLevel): self.AccessLevel = AccessLevel
    def hasContent_(self):
        if (
            self.Subject is not None or
            self.AccessLevel is not None or
            super(AccessSettingType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AccessSettingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AccessSettingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AccessSettingType'):
        super(AccessSettingType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingType')
    def exportChildren(self, outfile, level, namespace_='', name_='AccessSettingType', fromsubclass_=False, pretty_print=True):
        super(AccessSettingType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Subject is not None:
            self.Subject.export(outfile, level, namespace_, name_='Subject', pretty_print=pretty_print)
        if self.AccessLevel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccessLevel>%s</%sAccessLevel>%s' % (namespace_, self.gds_format_string(quote_xml(self.AccessLevel).encode(ExternalEncoding), input_name='AccessLevel'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='AccessSettingType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AccessSettingType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AccessSettingType, self).exportLiteralChildren(outfile, level, name_)
        if self.Subject is not None:
            showIndent(outfile, level)
            outfile.write('Subject=model_.ReferenceType(\n')
            self.Subject.exportLiteral(outfile, level, name_='Subject')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AccessLevel is not None:
            showIndent(outfile, level)
            outfile.write('AccessLevel=%s,\n' % quote_python(self.AccessLevel).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AccessSettingType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Subject':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Subject = obj_
            obj_.original_tagname_ = 'Subject'
        elif nodeName_ == 'AccessLevel':
            AccessLevel_ = child_.text
            AccessLevel_ = self.gds_validate_string(AccessLevel_, node, 'AccessLevel')
            self.AccessLevel = AccessLevel_
        super(AccessSettingType, self).buildChildren(child_, node, nodeName_, True)
# end class AccessSettingType


class AccessSettingsType(VCloudExtensibleType):
    """0.9 A list of access settings for a resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, AccessSetting=None):
        self.original_tagname_ = None
        super(AccessSettingsType, self).__init__(VCloudExtension, )
        if AccessSetting is None:
            self.AccessSetting = []
        else:
            self.AccessSetting = AccessSetting
    def factory(*args_, **kwargs_):
        if AccessSettingsType.subclass:
            return AccessSettingsType.subclass(*args_, **kwargs_)
        else:
            return AccessSettingsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AccessSetting(self): return self.AccessSetting
    def set_AccessSetting(self, AccessSetting): self.AccessSetting = AccessSetting
    def add_AccessSetting(self, value): self.AccessSetting.append(value)
    def insert_AccessSetting_at(self, index, value): self.AccessSetting.insert(index, value)
    def replace_AccessSetting_at(self, index, value): self.AccessSetting[index] = value
    def hasContent_(self):
        if (
            self.AccessSetting or
            super(AccessSettingsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AccessSettingsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AccessSettingsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AccessSettingsType'):
        super(AccessSettingsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingsType')
    def exportChildren(self, outfile, level, namespace_='', name_='AccessSettingsType', fromsubclass_=False, pretty_print=True):
        super(AccessSettingsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for AccessSetting_ in self.AccessSetting:
            AccessSetting_.export(outfile, level, namespace_, name_='AccessSetting', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AccessSettingsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AccessSettingsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AccessSettingsType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('AccessSetting=[\n')
        level += 1
        for AccessSetting_ in self.AccessSetting:
            showIndent(outfile, level)
            outfile.write('model_.AccessSettingType(\n')
            AccessSetting_.exportLiteral(outfile, level, name_='AccessSettingType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AccessSettingsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AccessSetting':
            obj_ = AccessSettingType.factory()
            obj_.build(child_)
            self.AccessSetting.append(obj_)
            obj_.original_tagname_ = 'AccessSetting'
        super(AccessSettingsType, self).buildChildren(child_, node, nodeName_, True)
# end class AccessSettingsType


class ControlAccessParamsType(VCloudExtensibleType):
    """0.9 Specifies access controls for a resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IsSharedToEveryone=None, EveryoneAccessLevel=None, AccessSettings=None):
        self.original_tagname_ = None
        super(ControlAccessParamsType, self).__init__(VCloudExtension, )
        self.IsSharedToEveryone = IsSharedToEveryone
        self.EveryoneAccessLevel = EveryoneAccessLevel
        self.AccessSettings = AccessSettings
    def factory(*args_, **kwargs_):
        if ControlAccessParamsType.subclass:
            return ControlAccessParamsType.subclass(*args_, **kwargs_)
        else:
            return ControlAccessParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsSharedToEveryone(self): return self.IsSharedToEveryone
    def set_IsSharedToEveryone(self, IsSharedToEveryone): self.IsSharedToEveryone = IsSharedToEveryone
    def get_EveryoneAccessLevel(self): return self.EveryoneAccessLevel
    def set_EveryoneAccessLevel(self, EveryoneAccessLevel): self.EveryoneAccessLevel = EveryoneAccessLevel
    def get_AccessSettings(self): return self.AccessSettings
    def set_AccessSettings(self, AccessSettings): self.AccessSettings = AccessSettings
    def hasContent_(self):
        if (
            self.IsSharedToEveryone is not None or
            self.EveryoneAccessLevel is not None or
            self.AccessSettings is not None or
            super(ControlAccessParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ControlAccessParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ControlAccessParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ControlAccessParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ControlAccessParamsType'):
        super(ControlAccessParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ControlAccessParamsType')
    def exportChildren(self, outfile, level, namespace_='', name_='ControlAccessParamsType', fromsubclass_=False, pretty_print=True):
        super(ControlAccessParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsSharedToEveryone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsSharedToEveryone>%s</%sIsSharedToEveryone>%s' % (namespace_, self.gds_format_boolean(self.IsSharedToEveryone, input_name='IsSharedToEveryone'), namespace_, eol_))
        if self.EveryoneAccessLevel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEveryoneAccessLevel>%s</%sEveryoneAccessLevel>%s' % (namespace_, self.gds_format_string(quote_xml(self.EveryoneAccessLevel).encode(ExternalEncoding), input_name='EveryoneAccessLevel'), namespace_, eol_))
        if self.AccessSettings is not None:
            self.AccessSettings.export(outfile, level, namespace_, name_='AccessSettings', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ControlAccessParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ControlAccessParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ControlAccessParamsType, self).exportLiteralChildren(outfile, level, name_)
        if self.IsSharedToEveryone is not None:
            showIndent(outfile, level)
            outfile.write('IsSharedToEveryone=%s,\n' % self.IsSharedToEveryone)
        if self.EveryoneAccessLevel is not None:
            showIndent(outfile, level)
            outfile.write('EveryoneAccessLevel=%s,\n' % quote_python(self.EveryoneAccessLevel).encode(ExternalEncoding))
        if self.AccessSettings is not None:
            showIndent(outfile, level)
            outfile.write('AccessSettings=model_.AccessSettingsType(\n')
            self.AccessSettings.exportLiteral(outfile, level, name_='AccessSettings')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ControlAccessParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsSharedToEveryone':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsSharedToEveryone')
            self.IsSharedToEveryone = ival_
        elif nodeName_ == 'EveryoneAccessLevel':
            EveryoneAccessLevel_ = child_.text
            EveryoneAccessLevel_ = self.gds_validate_string(EveryoneAccessLevel_, node, 'EveryoneAccessLevel')
            self.EveryoneAccessLevel = EveryoneAccessLevel_
        elif nodeName_ == 'AccessSettings':
            obj_ = AccessSettingsType.factory()
            obj_.build(child_)
            self.AccessSettings = obj_
            obj_.original_tagname_ = 'AccessSettings'
        super(ControlAccessParamsType, self).buildChildren(child_, node, nodeName_, True)
# end class ControlAccessParamsType


class OwnerType(ResourceType):
    """1.5 Represents the owner of this entity."""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, User=None):
        self.original_tagname_ = None
        super(OwnerType, self).__init__(VCloudExtension, href, type_, Link, )
        self.User = User
    def factory(*args_, **kwargs_):
        if OwnerType.subclass:
            return OwnerType.subclass(*args_, **kwargs_)
        else:
            return OwnerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def hasContent_(self):
        if (
            self.User is not None or
            super(OwnerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OwnerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OwnerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OwnerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OwnerType'):
        super(OwnerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OwnerType')
    def exportChildren(self, outfile, level, namespace_='', name_='OwnerType', fromsubclass_=False, pretty_print=True):
        super(OwnerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.User is not None:
            self.User.export(outfile, level, namespace_, name_='User', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OwnerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(OwnerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(OwnerType, self).exportLiteralChildren(outfile, level, name_)
        if self.User is not None:
            showIndent(outfile, level)
            outfile.write('User=model_.ReferenceType(\n')
            self.User.exportLiteral(outfile, level, name_='User')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OwnerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'User':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.User = obj_
            obj_.original_tagname_ = 'User'
        super(OwnerType, self).buildChildren(child_, node, nodeName_, True)
# end class OwnerType


class ReferencesType(ContainerType):
    """Container for query results returned in references format."""
    subclass = None
    superclass = ContainerType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, total=None, name=None, pageSize=None, page=None, Reference=None):
        self.original_tagname_ = None
        super(ReferencesType, self).__init__(VCloudExtension, href, type_, Link, total, name, pageSize, page, )
        if Reference is None:
            self.Reference = []
        else:
            self.Reference = Reference
    def factory(*args_, **kwargs_):
        if ReferencesType.subclass:
            return ReferencesType.subclass(*args_, **kwargs_)
        else:
            return ReferencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reference(self): return self.Reference
    def set_Reference(self, Reference): self.Reference = Reference
    def add_Reference(self, value): self.Reference.append(value)
    def insert_Reference_at(self, index, value): self.Reference.insert(index, value)
    def replace_Reference_at(self, index, value): self.Reference[index] = value
    def hasContent_(self):
        if (
            self.Reference or
            super(ReferencesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReferencesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReferencesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ReferencesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReferencesType'):
        super(ReferencesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReferencesType')
    def exportChildren(self, outfile, level, namespace_='', name_='ReferencesType', fromsubclass_=False, pretty_print=True):
        super(ReferencesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Reference_ in self.Reference:
            Reference_.export(outfile, level, namespace_, name_='Reference', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ReferencesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ReferencesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReferencesType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Reference=[\n')
        level += 1
        for Reference_ in self.Reference:
            showIndent(outfile, level)
            outfile.write('model_.Reference(\n')
            Reference_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ReferencesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reference':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Reference.append(obj_)
            obj_.original_tagname_ = 'Reference'
        super(ReferencesType, self).buildChildren(child_, node, nodeName_, True)
# end class ReferencesType


class QueryListType(ContainerType):
    """Container for the list of typed queries available to the requesting
    user."""
    subclass = None
    superclass = ContainerType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, total=None, name=None, pageSize=None, page=None):
        self.original_tagname_ = None
        super(QueryListType, self).__init__(VCloudExtension, href, type_, Link, total, name, pageSize, page, )
    def factory(*args_, **kwargs_):
        if QueryListType.subclass:
            return QueryListType.subclass(*args_, **kwargs_)
        else:
            return QueryListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(QueryListType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryListType'):
        super(QueryListType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryListType')
    def exportChildren(self, outfile, level, namespace_='', name_='QueryListType', fromsubclass_=False, pretty_print=True):
        super(QueryListType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(QueryListType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryListType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(QueryListType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryListType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryListType


class MetadataDomainTagType(GeneratedsSuper):
    """A value of SYSTEM places this MetadataEntry in the SYSTEM domain.
    Omit or leave empty to place this MetadataEntry in the GENERAL
    domain. true One of:<br> PRIVATE<br> READONLY"""
    subclass = None
    superclass = None
    def __init__(self, visibility=None, valueOf_=None):
        self.original_tagname_ = None
        self.visibility = _cast(None, visibility)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MetadataDomainTagType.subclass:
            return MetadataDomainTagType.subclass(*args_, **kwargs_)
        else:
            return MetadataDomainTagType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_visibility(self): return self.visibility
    def set_visibility(self, visibility): self.visibility = visibility
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataDomainTagType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataDomainTagType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataDomainTagType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataDomainTagType'):
        if self.visibility is not None and 'visibility' not in already_processed:
            already_processed.add('visibility')
            outfile.write(' visibility=%s' % (self.gds_format_string(quote_attrib(self.visibility).encode(ExternalEncoding), input_name='visibility'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataDomainTagType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MetadataDomainTagType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.visibility is not None and 'visibility' not in already_processed:
            already_processed.add('visibility')
            showIndent(outfile, level)
            outfile.write('visibility="%s",\n' % (self.visibility,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('visibility', node)
        if value is not None and 'visibility' not in already_processed:
            already_processed.add('visibility')
            self.visibility = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MetadataDomainTagType


class MetadataEntryType(ResourceType):
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, Domain=None, Key=None, Value=None, TypedValue=None):
        self.original_tagname_ = None
        super(MetadataEntryType, self).__init__(VCloudExtension, href, type_, Link, )
        self.Domain = Domain
        self.Key = Key
        self.Value = Value
        self.TypedValue = TypedValue
    def factory(*args_, **kwargs_):
        if MetadataEntryType.subclass:
            return MetadataEntryType.subclass(*args_, **kwargs_)
        else:
            return MetadataEntryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def get_Key(self): return self.Key
    def set_Key(self, Key): self.Key = Key
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_TypedValue(self): return self.TypedValue
    def set_TypedValue(self, TypedValue): self.TypedValue = TypedValue
    def hasContent_(self):
        if (
            self.Domain is not None or
            self.Key is not None or
            self.Value is not None or
            self.TypedValue is not None or
            super(MetadataEntryType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataEntryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataEntryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataEntryType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataEntryType'):
        super(MetadataEntryType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataEntryType')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataEntryType', fromsubclass_=False, pretty_print=True):
        super(MetadataEntryType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Domain is not None:
            self.Domain.export(outfile, level, namespace_, name_='Domain', pretty_print=pretty_print)
        if self.Key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sKey>%s</%sKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.Key).encode(ExternalEncoding), input_name='Key'), namespace_, eol_))
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
        if self.TypedValue is not None:
            self.TypedValue.export(outfile, level, namespace_, name_='TypedValue', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MetadataEntryType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataEntryType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataEntryType, self).exportLiteralChildren(outfile, level, name_)
        if self.Domain is not None:
            showIndent(outfile, level)
            outfile.write('Domain=model_.MetadataDomainTagType(\n')
            self.Domain.exportLiteral(outfile, level, name_='Domain')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('Key=%s,\n' % quote_python(self.Key).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
        if self.MetadataTypedValue is not None:
            showIndent(outfile, level)
            outfile.write('MetadataTypedValue=model_.MetadataTypedValue(\n')
            self.MetadataTypedValue.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataEntryType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Domain':
            obj_ = MetadataDomainTagType.factory()
            obj_.build(child_)
            self.Domain = obj_
            obj_.original_tagname_ = 'Domain'
        elif nodeName_ == 'Key':
            Key_ = child_.text
            Key_ = self.gds_validate_string(Key_, node, 'Key')
            self.Key = Key_
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'TypedValue':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <TypedValue> element')
            self.TypedValue = obj_
            obj_.original_tagname_ = 'TypedValue'
        super(MetadataEntryType, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataEntryType


class MetadataTypedValue(GeneratedsSuper):
    """One of:<br> MetadataStringValue<br> MetadataNumberValue<br>
    MetadataBooleanValue<br> MetadataDateTimeValue"""
    subclass = None
    superclass = None
    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if MetadataTypedValue.subclass:
            return MetadataTypedValue.subclass(*args_, **kwargs_)
        else:
            return MetadataTypedValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataTypedValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataTypedValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataTypedValue', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataTypedValue'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataTypedValue', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MetadataTypedValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MetadataTypedValue


class MetadataStringValue(MetadataTypedValue):
    """UTF-8 character set. Strings longer than 1000 characters cannot be
    searched for in a query."""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataStringValue, self).__init__()
        self.Value = Value
    def factory(*args_, **kwargs_):
        if MetadataStringValue.subclass:
            return MetadataStringValue.subclass(*args_, **kwargs_)
        else:
            return MetadataStringValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataStringValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataStringValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataStringValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataStringValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataStringValue'):
        super(MetadataStringValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataStringValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataStringValue', fromsubclass_=False, pretty_print=True):
        super(MetadataStringValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataStringValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataStringValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataStringValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataStringValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        super(MetadataStringValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataStringValue


class MetadataNumberValue(MetadataTypedValue):
    """A signed 8-byte integer."""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataNumberValue, self).__init__()
        self.Value = Value
    def factory(*args_, **kwargs_):
        if MetadataNumberValue.subclass:
            return MetadataNumberValue.subclass(*args_, **kwargs_)
        else:
            return MetadataNumberValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataNumberValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataNumberValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataNumberValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataNumberValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataNumberValue'):
        super(MetadataNumberValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataNumberValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataNumberValue', fromsubclass_=False, pretty_print=True):
        super(MetadataNumberValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_integer(self.Value, input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataNumberValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataNumberValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataNumberValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%d,\n' % self.Value)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataNumberValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Value')
            self.Value = ival_
        super(MetadataNumberValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataNumberValue


class MetadataBooleanValue(MetadataTypedValue):
    """One of: 1, 0, true, false"""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataBooleanValue, self).__init__()
        self.Value = Value
    def factory(*args_, **kwargs_):
        if MetadataBooleanValue.subclass:
            return MetadataBooleanValue.subclass(*args_, **kwargs_)
        else:
            return MetadataBooleanValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataBooleanValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataBooleanValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataBooleanValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataBooleanValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataBooleanValue'):
        super(MetadataBooleanValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataBooleanValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataBooleanValue', fromsubclass_=False, pretty_print=True):
        super(MetadataBooleanValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_boolean(self.Value, input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataBooleanValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataBooleanValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataBooleanValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % self.Value)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataBooleanValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Value')
            self.Value = ival_
        super(MetadataBooleanValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataBooleanValue


class MetadataDateTimeValue(MetadataTypedValue):
    """UTC format. For example 2012-06-18T12:00:00-05:00"""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataDateTimeValue, self).__init__()
        if isinstance(Value, basestring):
            initvalue_ = datetime_.datetime.strptime(Value, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Value
        self.Value = initvalue_
    def factory(*args_, **kwargs_):
        if MetadataDateTimeValue.subclass:
            return MetadataDateTimeValue.subclass(*args_, **kwargs_)
        else:
            return MetadataDateTimeValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataDateTimeValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataDateTimeValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataDateTimeValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataDateTimeValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataDateTimeValue'):
        super(MetadataDateTimeValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataDateTimeValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataDateTimeValue', fromsubclass_=False, pretty_print=True):
        super(MetadataDateTimeValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_datetime(self.Value, input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataDateTimeValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataDateTimeValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataDateTimeValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.Value, input_name='Value'))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataDateTimeValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Value = dval_
        super(MetadataDateTimeValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataDateTimeValue


class MetadataType(ResourceType):
    """User-defined metadata associated with with an object."""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, MetadataEntry=None):
        self.original_tagname_ = None
        super(MetadataType, self).__init__(VCloudExtension, href, type_, Link, )
        if MetadataEntry is None:
            self.MetadataEntry = []
        else:
            self.MetadataEntry = MetadataEntry
    def factory(*args_, **kwargs_):
        if MetadataType.subclass:
            return MetadataType.subclass(*args_, **kwargs_)
        else:
            return MetadataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MetadataEntry(self): return self.MetadataEntry
    def set_MetadataEntry(self, MetadataEntry): self.MetadataEntry = MetadataEntry
    def add_MetadataEntry(self, value): self.MetadataEntry.append(value)
    def insert_MetadataEntry_at(self, index, value): self.MetadataEntry.insert(index, value)
    def replace_MetadataEntry_at(self, index, value): self.MetadataEntry[index] = value
    def hasContent_(self):
        if (
            self.MetadataEntry or
            super(MetadataType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataType'):
        super(MetadataType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataType')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataType', fromsubclass_=False, pretty_print=True):
        super(MetadataType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for MetadataEntry_ in self.MetadataEntry:
            MetadataEntry_.export(outfile, level, namespace_, name_='MetadataEntry', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MetadataType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('MetadataEntry=[\n')
        level += 1
        for MetadataEntry_ in self.MetadataEntry:
            showIndent(outfile, level)
            outfile.write('model_.MetadataEntryType(\n')
            MetadataEntry_.exportLiteral(outfile, level, name_='MetadataEntryType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MetadataEntry':
            obj_ = MetadataEntryType.factory()
            obj_.build(child_)
            self.MetadataEntry.append(obj_)
            obj_.original_tagname_ = 'MetadataEntry'
        super(MetadataType, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataType


class MetadataValueType(ResourceType):
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, Domain=None, Value=None, TypedValue=None):
        self.original_tagname_ = None
        super(MetadataValueType, self).__init__(VCloudExtension, href, type_, Link, )
        self.Domain = Domain
        self.Value = Value
        self.TypedValue = TypedValue
    def factory(*args_, **kwargs_):
        if MetadataValueType.subclass:
            return MetadataValueType.subclass(*args_, **kwargs_)
        else:
            return MetadataValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_TypedValue(self): return self.TypedValue
    def set_TypedValue(self, TypedValue): self.TypedValue = TypedValue
    def hasContent_(self):
        if (
            self.Domain is not None or
            self.Value is not None or
            self.TypedValue is not None or
            super(MetadataValueType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataValueType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataValueType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataValueType'):
        super(MetadataValueType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataValueType')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataValueType', fromsubclass_=False, pretty_print=True):
        super(MetadataValueType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Domain is not None:
            self.Domain.export(outfile, level, namespace_, name_='Domain', pretty_print=pretty_print)
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
        if self.TypedValue is not None:
            self.TypedValue.export(outfile, level, namespace_, name_='TypedValue', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MetadataValueType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataValueType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataValueType, self).exportLiteralChildren(outfile, level, name_)
        if self.Domain is not None:
            showIndent(outfile, level)
            outfile.write('Domain=model_.MetadataDomainTagType(\n')
            self.Domain.exportLiteral(outfile, level, name_='Domain')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
        if self.MetadataTypedValue is not None:
            showIndent(outfile, level)
            outfile.write('MetadataTypedValue=model_.MetadataTypedValue(\n')
            self.MetadataTypedValue.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataValueType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Domain':
            obj_ = MetadataDomainTagType.factory()
            obj_.build(child_)
            self.Domain = obj_
            obj_.original_tagname_ = 'Domain'
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'TypedValue':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <TypedValue> element')
            self.TypedValue = obj_
            obj_.original_tagname_ = 'TypedValue'
        super(MetadataValueType, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataValueType


class FileUploadParamsType(VCloudExtensibleType):
    """5.1 Parameters for initializing file upload session. create Size in
    bytes of the file which will be uploaded. true"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, fileSize=None):
        self.original_tagname_ = None
        super(FileUploadParamsType, self).__init__(VCloudExtension, )
        self.fileSize = _cast(int, fileSize)
    def factory(*args_, **kwargs_):
        if FileUploadParamsType.subclass:
            return FileUploadParamsType.subclass(*args_, **kwargs_)
        else:
            return FileUploadParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fileSize(self): return self.fileSize
    def set_fileSize(self, fileSize): self.fileSize = fileSize
    def hasContent_(self):
        if (
            super(FileUploadParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FileUploadParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FileUploadParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FileUploadParamsType'):
        super(FileUploadParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadParamsType')
        if self.fileSize is not None and 'fileSize' not in already_processed:
            already_processed.add('fileSize')
            outfile.write(' fileSize="%s"' % self.gds_format_integer(self.fileSize, input_name='fileSize'))
    def exportChildren(self, outfile, level, namespace_='', name_='FileUploadParamsType', fromsubclass_=False, pretty_print=True):
        super(FileUploadParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FileUploadParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.fileSize is not None and 'fileSize' not in already_processed:
            already_processed.add('fileSize')
            showIndent(outfile, level)
            outfile.write('fileSize=%d,\n' % (self.fileSize,))
        super(FileUploadParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FileUploadParamsType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fileSize', node)
        if value is not None and 'fileSize' not in already_processed:
            already_processed.add('fileSize')
            try:
                self.fileSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(FileUploadParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FileUploadParamsType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FileUploadParamsType


class FileUploadSocketType(VCloudExtensibleType):
    """5.1 Parameters for initiating file upload. none URL where the file
    must be uploaded. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, uploadLocation=None, Task=None):
        self.original_tagname_ = None
        super(FileUploadSocketType, self).__init__(VCloudExtension, )
        self.uploadLocation = _cast(None, uploadLocation)
        self.Task = Task
    def factory(*args_, **kwargs_):
        if FileUploadSocketType.subclass:
            return FileUploadSocketType.subclass(*args_, **kwargs_)
        else:
            return FileUploadSocketType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Task(self): return self.Task
    def set_Task(self, Task): self.Task = Task
    def get_uploadLocation(self): return self.uploadLocation
    def set_uploadLocation(self, uploadLocation): self.uploadLocation = uploadLocation
    def hasContent_(self):
        if (
            self.Task is not None or
            super(FileUploadSocketType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FileUploadSocketType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadSocketType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FileUploadSocketType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FileUploadSocketType'):
        super(FileUploadSocketType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadSocketType')
        if self.uploadLocation is not None and 'uploadLocation' not in already_processed:
            already_processed.add('uploadLocation')
            outfile.write(' uploadLocation=%s' % (self.gds_format_string(quote_attrib(self.uploadLocation).encode(ExternalEncoding), input_name='uploadLocation'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FileUploadSocketType', fromsubclass_=False, pretty_print=True):
        super(FileUploadSocketType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Task is not None:
            self.Task.export(outfile, level, namespace_, name_='Task', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FileUploadSocketType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.uploadLocation is not None and 'uploadLocation' not in already_processed:
            already_processed.add('uploadLocation')
            showIndent(outfile, level)
            outfile.write('uploadLocation="%s",\n' % (self.uploadLocation,))
        super(FileUploadSocketType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FileUploadSocketType, self).exportLiteralChildren(outfile, level, name_)
        if self.Task is not None:
            showIndent(outfile, level)
            outfile.write('Task=model_.TaskType(\n')
            self.Task.exportLiteral(outfile, level, name_='Task')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('uploadLocation', node)
        if value is not None and 'uploadLocation' not in already_processed:
            already_processed.add('uploadLocation')
            self.uploadLocation = value
        super(FileUploadSocketType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Task':
            obj_ = TaskType.factory()
            obj_.build(child_)
            self.Task = obj_
            obj_.original_tagname_ = 'Task'
        super(FileUploadSocketType, self).buildChildren(child_, node, nodeName_, True)
# end class FileUploadSocketType


class TaskOperationListType(ResourceType):
    """List of operation names. 1.5"""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, Operation=None):
        self.original_tagname_ = None
        super(TaskOperationListType, self).__init__(VCloudExtension, href, type_, Link, )
        if Operation is None:
            self.Operation = []
        else:
            self.Operation = Operation
    def factory(*args_, **kwargs_):
        if TaskOperationListType.subclass:
            return TaskOperationListType.subclass(*args_, **kwargs_)
        else:
            return TaskOperationListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Operation(self): return self.Operation
    def set_Operation(self, Operation): self.Operation = Operation
    def add_Operation(self, value): self.Operation.append(value)
    def insert_Operation_at(self, index, value): self.Operation.insert(index, value)
    def replace_Operation_at(self, index, value): self.Operation[index] = value
    def hasContent_(self):
        if (
            self.Operation or
            super(TaskOperationListType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TaskOperationListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskOperationListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TaskOperationListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TaskOperationListType'):
        super(TaskOperationListType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskOperationListType')
    def exportChildren(self, outfile, level, namespace_='', name_='TaskOperationListType', fromsubclass_=False, pretty_print=True):
        super(TaskOperationListType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Operation_ in self.Operation:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOperation>%s</%sOperation>%s' % (namespace_, self.gds_format_string(quote_xml(Operation_).encode(ExternalEncoding), input_name='Operation'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TaskOperationListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(TaskOperationListType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskOperationListType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Operation=[\n')
        level += 1
        for Operation_ in self.Operation:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Operation_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TaskOperationListType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Operation':
            Operation_ = child_.text
            Operation_ = self.gds_validate_string(Operation_, node, 'Operation')
            self.Operation.append(Operation_)
        super(TaskOperationListType, self).buildChildren(child_, node, nodeName_, True)
# end class TaskOperationListType


class EntityType(IdentifiableResourceType):
    """0.9 Basic entity type in the vCloud object model. Includes a name,
    an optional description, and an optional list of links. always
    The name of the entity. true"""
    subclass = None
    superclass = IdentifiableResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, extensiontype_=None):
        self.original_tagname_ = None
        super(EntityType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, extensiontype_, )
        self.name = _cast(None, name)
        self.Description = Description
        self.Tasks = Tasks
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if EntityType.subclass:
            return EntityType.subclass(*args_, **kwargs_)
        else:
            return EntityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Tasks(self): return self.Tasks
    def set_Tasks(self, Tasks): self.Tasks = Tasks
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Tasks is not None or
            super(EntityType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityType'):
        super(EntityType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EntityType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='EntityType', fromsubclass_=False, pretty_print=True):
        super(EntityType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        if self.Tasks is not None:
            self.Tasks.export(outfile, level, namespace_, name_='Tasks', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(EntityType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EntityType, self).exportLiteralChildren(outfile, level, name_)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.Tasks is not None:
            showIndent(outfile, level)
            outfile.write('Tasks=model_.TasksInProgressType(\n')
            self.Tasks.exportLiteral(outfile, level, name_='Tasks')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(EntityType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Tasks':
            obj_ = TasksInProgressType.factory()
            obj_.build(child_)
            self.Tasks = obj_
            obj_.original_tagname_ = 'Tasks'
        super(EntityType, self).buildChildren(child_, node, nodeName_, True)
# end class EntityType


class EntityReferenceType(VCloudExtensibleType):
    """1.5 A reference to a vCloud entity. none The object identifier,
    expressed in URN format. The value of this attribute uniquely
    identifies the object, persists for the life of the object, and
    is never reused. This context-free identifier can apply to any
    object in any system. truealways The type of the the referenced
    object. falsealways The name of the referenced object. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, type_=None, id=None, name=None, extensiontype_=None):
        self.original_tagname_ = None
        super(EntityReferenceType, self).__init__(VCloudExtension, extensiontype_, )
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if EntityReferenceType.subclass:
            return EntityReferenceType.subclass(*args_, **kwargs_)
        else:
            return EntityReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(EntityReferenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityReferenceType'):
        super(EntityReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EntityReferenceType')
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='EntityReferenceType', fromsubclass_=False, pretty_print=True):
        super(EntityReferenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(EntityReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EntityReferenceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(EntityReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(EntityReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class EntityReferenceType


class EntityLinkType(EntityReferenceType):
    """1.5 Extends EntityReference type by adding relation attribute.
    always Defines the relationship of the link to the object that
    contains it. A relationship can be the name of an operation on
    the object, a reference to a contained or containing object, or
    a reference to an alternate representation of the object. The
    relationship value implies the HTTP verb to use when you use the
    link's href value as a request URL. true"""
    subclass = None
    superclass = EntityReferenceType
    def __init__(self, VCloudExtension=None, type_=None, id=None, name=None, rel=None):
        self.original_tagname_ = None
        super(EntityLinkType, self).__init__(VCloudExtension, type_, id, name, )
        self.rel = _cast(None, rel)
    def factory(*args_, **kwargs_):
        if EntityLinkType.subclass:
            return EntityLinkType.subclass(*args_, **kwargs_)
        else:
            return EntityLinkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def hasContent_(self):
        if (
            super(EntityLinkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityLinkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityLinkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityLinkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityLinkType'):
        super(EntityLinkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EntityLinkType')
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='EntityLinkType', fromsubclass_=False, pretty_print=True):
        super(EntityLinkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityLinkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel="%s",\n' % (self.rel,))
        super(EntityLinkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EntityLinkType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        super(EntityLinkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(EntityLinkType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class EntityLinkType


class TasksInProgressType(VCloudExtensibleType):
    """0.9 A list of queued, running, or recently completed tasks."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Task=None):
        self.original_tagname_ = None
        super(TasksInProgressType, self).__init__(VCloudExtension, )
        if Task is None:
            self.Task = []
        else:
            self.Task = Task
    def factory(*args_, **kwargs_):
        if TasksInProgressType.subclass:
            return TasksInProgressType.subclass(*args_, **kwargs_)
        else:
            return TasksInProgressType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Task(self): return self.Task
    def set_Task(self, Task): self.Task = Task
    def add_Task(self, value): self.Task.append(value)
    def insert_Task_at(self, index, value): self.Task.insert(index, value)
    def replace_Task_at(self, index, value): self.Task[index] = value
    def hasContent_(self):
        if (
            self.Task or
            super(TasksInProgressType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TasksInProgressType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TasksInProgressType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TasksInProgressType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TasksInProgressType'):
        super(TasksInProgressType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TasksInProgressType')
    def exportChildren(self, outfile, level, namespace_='', name_='TasksInProgressType', fromsubclass_=False, pretty_print=True):
        super(TasksInProgressType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Task_ in self.Task:
            Task_.export(outfile, level, namespace_, name_='Task', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='TasksInProgressType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(TasksInProgressType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TasksInProgressType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Task=[\n')
        level += 1
        for Task_ in self.Task:
            showIndent(outfile, level)
            outfile.write('model_.TaskType(\n')
            Task_.exportLiteral(outfile, level, name_='TaskType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TasksInProgressType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Task':
            obj_ = TaskType.factory()
            obj_.build(child_)
            self.Task.append(obj_)
            obj_.original_tagname_ = 'Task'
        super(TasksInProgressType, self).buildChildren(child_, node, nodeName_, True)
# end class TasksInProgressType


class VendorServicesType(GeneratedsSuper):
    """5.1 Vendor services available for service insertion on networks or
    edge gateways."""
    subclass = None
    superclass = None
    def __init__(self, NetworkServices=None, EdgeGatewayServices=None):
        self.original_tagname_ = None
        if NetworkServices is None:
            self.NetworkServices = []
        else:
            self.NetworkServices = NetworkServices
        if EdgeGatewayServices is None:
            self.EdgeGatewayServices = []
        else:
            self.EdgeGatewayServices = EdgeGatewayServices
    def factory(*args_, **kwargs_):
        if VendorServicesType.subclass:
            return VendorServicesType.subclass(*args_, **kwargs_)
        else:
            return VendorServicesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NetworkServices(self): return self.NetworkServices
    def set_NetworkServices(self, NetworkServices): self.NetworkServices = NetworkServices
    def add_NetworkServices(self, value): self.NetworkServices.append(value)
    def insert_NetworkServices_at(self, index, value): self.NetworkServices.insert(index, value)
    def replace_NetworkServices_at(self, index, value): self.NetworkServices[index] = value
    def get_EdgeGatewayServices(self): return self.EdgeGatewayServices
    def set_EdgeGatewayServices(self, EdgeGatewayServices): self.EdgeGatewayServices = EdgeGatewayServices
    def add_EdgeGatewayServices(self, value): self.EdgeGatewayServices.append(value)
    def insert_EdgeGatewayServices_at(self, index, value): self.EdgeGatewayServices.insert(index, value)
    def replace_EdgeGatewayServices_at(self, index, value): self.EdgeGatewayServices[index] = value
    def hasContent_(self):
        if (
            self.NetworkServices or
            self.EdgeGatewayServices
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VendorServicesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VendorServicesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VendorServicesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VendorServicesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VendorServicesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for NetworkServices_ in self.NetworkServices:
            NetworkServices_.export(outfile, level, namespace_, name_='NetworkServices', pretty_print=pretty_print)
        for EdgeGatewayServices_ in self.EdgeGatewayServices:
            EdgeGatewayServices_.export(outfile, level, namespace_, name_='EdgeGatewayServices', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VendorServicesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('NetworkServices=[\n')
        level += 1
        for NetworkServices_ in self.NetworkServices:
            showIndent(outfile, level)
            outfile.write('model_.NetworkServiceInsertionType(\n')
            NetworkServices_.exportLiteral(outfile, level, name_='NetworkServiceInsertionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('EdgeGatewayServices=[\n')
        level += 1
        for EdgeGatewayServices_ in self.EdgeGatewayServices:
            showIndent(outfile, level)
            outfile.write('model_.NetworkServiceInsertionType(\n')
            EdgeGatewayServices_.exportLiteral(outfile, level, name_='NetworkServiceInsertionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NetworkServices':
            obj_ = NetworkServiceInsertionType.factory()
            obj_.build(child_)
            self.NetworkServices.append(obj_)
            obj_.original_tagname_ = 'NetworkServices'
        elif nodeName_ == 'EdgeGatewayServices':
            obj_ = NetworkServiceInsertionType.factory()
            obj_.build(child_)
            self.EdgeGatewayServices.append(obj_)
            obj_.original_tagname_ = 'EdgeGatewayServices'
# end class VendorServicesType


class NetworkServiceInsertionType(VCloudExtensibleType):
    """5.1 always Information about a network service that has been
    inserted"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Name=None, Id=None, Category=None, CategoryType=None, VendorTemplates=None):
        self.original_tagname_ = None
        super(NetworkServiceInsertionType, self).__init__(VCloudExtension, )
        self.Name = Name
        self.Id = Id
        self.Category = Category
        self.CategoryType = CategoryType
        if VendorTemplates is None:
            self.VendorTemplates = []
        else:
            self.VendorTemplates = VendorTemplates
    def factory(*args_, **kwargs_):
        if NetworkServiceInsertionType.subclass:
            return NetworkServiceInsertionType.subclass(*args_, **kwargs_)
        else:
            return NetworkServiceInsertionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Category(self): return self.Category
    def set_Category(self, Category): self.Category = Category
    def get_CategoryType(self): return self.CategoryType
    def set_CategoryType(self, CategoryType): self.CategoryType = CategoryType
    def get_VendorTemplates(self): return self.VendorTemplates
    def set_VendorTemplates(self, VendorTemplates): self.VendorTemplates = VendorTemplates
    def add_VendorTemplates(self, value): self.VendorTemplates.append(value)
    def insert_VendorTemplates_at(self, index, value): self.VendorTemplates.insert(index, value)
    def replace_VendorTemplates_at(self, index, value): self.VendorTemplates[index] = value
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Id is not None or
            self.Category is not None or
            self.CategoryType is not None or
            self.VendorTemplates or
            super(NetworkServiceInsertionType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkServiceInsertionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkServiceInsertionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NetworkServiceInsertionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkServiceInsertionType'):
        super(NetworkServiceInsertionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkServiceInsertionType')
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkServiceInsertionType', fromsubclass_=False, pretty_print=True):
        super(NetworkServiceInsertionType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sId>%s</%sId>%s' % (namespace_, self.gds_format_string(quote_xml(self.Id).encode(ExternalEncoding), input_name='Id'), namespace_, eol_))
        if self.Category is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCategory>%s</%sCategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.Category).encode(ExternalEncoding), input_name='Category'), namespace_, eol_))
        if self.CategoryType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCategoryType>%s</%sCategoryType>%s' % (namespace_, self.gds_format_string(quote_xml(self.CategoryType).encode(ExternalEncoding), input_name='CategoryType'), namespace_, eol_))
        for VendorTemplates_ in self.VendorTemplates:
            VendorTemplates_.export(outfile, level, namespace_, name_='VendorTemplates', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NetworkServiceInsertionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NetworkServiceInsertionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NetworkServiceInsertionType, self).exportLiteralChildren(outfile, level, name_)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Id is not None:
            showIndent(outfile, level)
            outfile.write('Id=%s,\n' % quote_python(self.Id).encode(ExternalEncoding))
        if self.Category is not None:
            showIndent(outfile, level)
            outfile.write('Category=%s,\n' % quote_python(self.Category).encode(ExternalEncoding))
        if self.CategoryType is not None:
            showIndent(outfile, level)
            outfile.write('CategoryType=%s,\n' % quote_python(self.CategoryType).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('VendorTemplates=[\n')
        level += 1
        for VendorTemplates_ in self.VendorTemplates:
            showIndent(outfile, level)
            outfile.write('model_.VendorTemplateType(\n')
            VendorTemplates_.exportLiteral(outfile, level, name_='VendorTemplateType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NetworkServiceInsertionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Category':
            Category_ = child_.text
            Category_ = self.gds_validate_string(Category_, node, 'Category')
            self.Category = Category_
        elif nodeName_ == 'CategoryType':
            CategoryType_ = child_.text
            CategoryType_ = self.gds_validate_string(CategoryType_, node, 'CategoryType')
            self.CategoryType = CategoryType_
        elif nodeName_ == 'VendorTemplates':
            obj_ = VendorTemplateType.factory()
            obj_.build(child_)
            self.VendorTemplates.append(obj_)
            obj_.original_tagname_ = 'VendorTemplates'
        super(NetworkServiceInsertionType, self).buildChildren(child_, node, nodeName_, True)
# end class NetworkServiceInsertionType


class VendorTemplateType(VCloudExtensibleType):
    """5.1 always Information about a vendor service template. This is
    optional."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Name=None, Id=None, VendorTemplateAttributes=None):
        self.original_tagname_ = None
        super(VendorTemplateType, self).__init__(VCloudExtension, )
        self.Name = Name
        self.Id = Id
        if VendorTemplateAttributes is None:
            self.VendorTemplateAttributes = []
        else:
            self.VendorTemplateAttributes = VendorTemplateAttributes
    def factory(*args_, **kwargs_):
        if VendorTemplateType.subclass:
            return VendorTemplateType.subclass(*args_, **kwargs_)
        else:
            return VendorTemplateType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_VendorTemplateAttributes(self): return self.VendorTemplateAttributes
    def set_VendorTemplateAttributes(self, VendorTemplateAttributes): self.VendorTemplateAttributes = VendorTemplateAttributes
    def add_VendorTemplateAttributes(self, value): self.VendorTemplateAttributes.append(value)
    def insert_VendorTemplateAttributes_at(self, index, value): self.VendorTemplateAttributes.insert(index, value)
    def replace_VendorTemplateAttributes_at(self, index, value): self.VendorTemplateAttributes[index] = value
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Id is not None or
            self.VendorTemplateAttributes or
            super(VendorTemplateType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VendorTemplateType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VendorTemplateType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VendorTemplateType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VendorTemplateType'):
        super(VendorTemplateType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VendorTemplateType')
    def exportChildren(self, outfile, level, namespace_='', name_='VendorTemplateType', fromsubclass_=False, pretty_print=True):
        super(VendorTemplateType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sId>%s</%sId>%s' % (namespace_, self.gds_format_string(quote_xml(self.Id).encode(ExternalEncoding), input_name='Id'), namespace_, eol_))
        for VendorTemplateAttributes_ in self.VendorTemplateAttributes:
            VendorTemplateAttributes_.export(outfile, level, namespace_, name_='VendorTemplateAttributes', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VendorTemplateType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VendorTemplateType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VendorTemplateType, self).exportLiteralChildren(outfile, level, name_)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Id is not None:
            showIndent(outfile, level)
            outfile.write('Id=%s,\n' % quote_python(self.Id).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('VendorTemplateAttributes=[\n')
        level += 1
        for VendorTemplateAttributes_ in self.VendorTemplateAttributes:
            showIndent(outfile, level)
            outfile.write('model_.VendorTemplateAttributesType(\n')
            VendorTemplateAttributes_.exportLiteral(outfile, level, name_='VendorTemplateAttributesType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VendorTemplateType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'VendorTemplateAttributes':
            obj_ = VendorTemplateAttributesType.factory()
            obj_.build(child_)
            self.VendorTemplateAttributes.append(obj_)
            obj_.original_tagname_ = 'VendorTemplateAttributes'
        super(VendorTemplateType, self).buildChildren(child_, node, nodeName_, True)
# end class VendorTemplateType


class VendorTemplateAttributesType(VCloudExtensibleType):
    """5.1 always Information about vendor template attributes"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Name=None, Key=None, Value=None):
        self.original_tagname_ = None
        super(VendorTemplateAttributesType, self).__init__(VCloudExtension, )
        self.Name = Name
        self.Key = Key
        self.Value = Value
    def factory(*args_, **kwargs_):
        if VendorTemplateAttributesType.subclass:
            return VendorTemplateAttributesType.subclass(*args_, **kwargs_)
        else:
            return VendorTemplateAttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Key(self): return self.Key
    def set_Key(self, Key): self.Key = Key
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Key is not None or
            self.Value is not None or
            super(VendorTemplateAttributesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VendorTemplateAttributesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VendorTemplateAttributesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VendorTemplateAttributesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VendorTemplateAttributesType'):
        super(VendorTemplateAttributesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VendorTemplateAttributesType')
    def exportChildren(self, outfile, level, namespace_='', name_='VendorTemplateAttributesType', fromsubclass_=False, pretty_print=True):
        super(VendorTemplateAttributesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sKey>%s</%sKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.Key).encode(ExternalEncoding), input_name='Key'), namespace_, eol_))
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VendorTemplateAttributesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VendorTemplateAttributesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VendorTemplateAttributesType, self).exportLiteralChildren(outfile, level, name_)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('Key=%s,\n' % quote_python(self.Key).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VendorTemplateAttributesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Key':
            Key_ = child_.text
            Key_ = self.gds_validate_string(Key_, node, 'Key')
            self.Key = Key_
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        super(VendorTemplateAttributesType, self).buildChildren(child_, node, nodeName_, True)
# end class VendorTemplateAttributesType


class ProtocolsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Tcp=None, Udp=None, Icmp=None, Any=None, Other=None):
        self.original_tagname_ = None
        self.Tcp = Tcp
        self.Udp = Udp
        self.Icmp = Icmp
        self.Any = Any
        self.Other = Other
    def factory(*args_, **kwargs_):
        if ProtocolsType.subclass:
            return ProtocolsType.subclass(*args_, **kwargs_)
        else:
            return ProtocolsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Tcp(self): return self.Tcp
    def set_Tcp(self, Tcp): self.Tcp = Tcp
    def get_Udp(self): return self.Udp
    def set_Udp(self, Udp): self.Udp = Udp
    def get_Icmp(self): return self.Icmp
    def set_Icmp(self, Icmp): self.Icmp = Icmp
    def get_Any(self): return self.Any
    def set_Any(self, Any): self.Any = Any
    def get_Other(self): return self.Other
    def set_Other(self, Other): self.Other = Other
    def hasContent_(self):
        if (
            self.Tcp is not None or
            self.Udp is not None or
            self.Icmp is not None or
            self.Any is not None or
            self.Other is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ProtocolsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProtocolsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ProtocolsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ProtocolsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ProtocolsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Tcp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTcp>%s</%sTcp>%s' % (namespace_, self.gds_format_boolean(self.Tcp, input_name='Tcp'), namespace_, eol_))
        if self.Udp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUdp>%s</%sUdp>%s' % (namespace_, self.gds_format_boolean(self.Udp, input_name='Udp'), namespace_, eol_))
        if self.Icmp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIcmp>%s</%sIcmp>%s' % (namespace_, self.gds_format_boolean(self.Icmp, input_name='Icmp'), namespace_, eol_))
        if self.Any is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAny>%s</%sAny>%s' % (namespace_, self.gds_format_boolean(self.Any, input_name='Any'), namespace_, eol_))
        if self.Other is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOther>%s</%sOther>%s' % (namespace_, self.gds_format_string(quote_xml(self.Other).encode(ExternalEncoding), input_name='Other'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ProtocolsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Tcp is not None:
            showIndent(outfile, level)
            outfile.write('Tcp=%s,\n' % self.Tcp)
        if self.Udp is not None:
            showIndent(outfile, level)
            outfile.write('Udp=%s,\n' % self.Udp)
        if self.Icmp is not None:
            showIndent(outfile, level)
            outfile.write('Icmp=%s,\n' % self.Icmp)
        if self.Any is not None:
            showIndent(outfile, level)
            outfile.write('Any=%s,\n' % self.Any)
        if self.Other is not None:
            showIndent(outfile, level)
            outfile.write('Other=%s,\n' % quote_python(self.Other).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Tcp':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Tcp')
            self.Tcp = ival_
        elif nodeName_ == 'Udp':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Udp')
            self.Udp = ival_
        elif nodeName_ == 'Icmp':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Icmp')
            self.Icmp = ival_
        elif nodeName_ == 'Any':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Any')
            self.Any = ival_
        elif nodeName_ == 'Other':
            Other_ = child_.text
            Other_ = self.gds_validate_string(Other_, node, 'Other')
            self.Other = Other_
# end class ProtocolsType


class TaskType(EntityType):
    """0.9 Represents an asynchronous operation in vCloud Director. none
    The execution status of the task. One of:<br> <b>queued</b> (The
    task has been queued for execution)<br> <b>preRunning</b> (The
    task is awaiting preprocessing or administrative action.)<br>
    <b>running</b> (The task is running.)<br> <b>success</b> (The
    task completed with a status of success.)<br> <b>error</b> (The
    task encountered an error while running.)<br> <b>canceled</b>
    (The task was canceled by the owner or an administrator.)<br>
    <b>aborted</b> (The task was aborted by an administrative
    action.) truealways A message describing the operation that is
    tracked by this task. falsenone The short name of the operation
    that is tracked by this task. false5.1createtrue Identifier of
    the service that created the task. It must not start with
    com.vmware.vcloud and the length must be between 1 and 128
    symbols. none The date and time the system started executing the
    task. May not be present if the task has not been executed yet.
    falsenone The date and time that processing of the task was
    completed. May not be present if the task is still being
    executed. falsenone The date and time at which the task resource
    will be destroyed and no longer available for retrieval. May not
    be present if the task has not been executed or is still being
    executed. false5.1nonefalse Whether user has requested this
    processing to be canceled."""
    subclass = None
    superclass = EntityType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, status=None, operationName=None, expiryTime=None, cancelRequested=None, startTime=None, operation=None, endTime=None, serviceNamespace=None, Owner=None, Error=None, User=None, Organization=None, Progress=None, Params=None, Details=None):
        self.original_tagname_ = None
        super(TaskType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, name, Description, Tasks, )
        self.status = _cast(None, status)
        self.operationName = _cast(None, operationName)
        if isinstance(expiryTime, basestring):
            initvalue_ = datetime_.datetime.strptime(expiryTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = expiryTime
        self.expiryTime = initvalue_
        self.cancelRequested = _cast(bool, cancelRequested)
        if isinstance(startTime, basestring):
            initvalue_ = datetime_.datetime.strptime(startTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = startTime
        self.startTime = initvalue_
        self.operation = _cast(None, operation)
        if isinstance(endTime, basestring):
            initvalue_ = datetime_.datetime.strptime(endTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = endTime
        self.endTime = initvalue_
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.Owner = Owner
        self.Error = Error
        self.User = User
        self.Organization = Organization
        self.Progress = Progress
        self.Params = Params
        self.Details = Details
    def factory(*args_, **kwargs_):
        if TaskType.subclass:
            return TaskType.subclass(*args_, **kwargs_)
        else:
            return TaskType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Owner(self): return self.Owner
    def set_Owner(self, Owner): self.Owner = Owner
    def get_Error(self): return self.Error
    def set_Error(self, Error): self.Error = Error
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def get_Organization(self): return self.Organization
    def set_Organization(self, Organization): self.Organization = Organization
    def get_Progress(self): return self.Progress
    def set_Progress(self, Progress): self.Progress = Progress
    def get_Params(self): return self.Params
    def set_Params(self, Params): self.Params = Params
    def get_Details(self): return self.Details
    def set_Details(self, Details): self.Details = Details
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_operationName(self): return self.operationName
    def set_operationName(self, operationName): self.operationName = operationName
    def get_expiryTime(self): return self.expiryTime
    def set_expiryTime(self, expiryTime): self.expiryTime = expiryTime
    def get_cancelRequested(self): return self.cancelRequested
    def set_cancelRequested(self, cancelRequested): self.cancelRequested = cancelRequested
    def get_startTime(self): return self.startTime
    def set_startTime(self, startTime): self.startTime = startTime
    def get_operation(self): return self.operation
    def set_operation(self, operation): self.operation = operation
    def get_endTime(self): return self.endTime
    def set_endTime(self, endTime): self.endTime = endTime
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def hasContent_(self):
        if (
            self.Owner is not None or
            self.Error is not None or
            self.User is not None or
            self.Organization is not None or
            self.Progress is not None or
            self.Params is not None or
            self.Details is not None or
            super(TaskType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TaskType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TaskType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TaskType'):
        super(TaskType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.operationName is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            outfile.write(' operationName=%s' % (self.gds_format_string(quote_attrib(self.operationName).encode(ExternalEncoding), input_name='operationName'), ))
        if self.expiryTime is not None and 'expiryTime' not in already_processed:
            already_processed.add('expiryTime')
            outfile.write(' expiryTime="%s"' % self.gds_format_datetime(self.expiryTime, input_name='expiryTime'))
        if self.cancelRequested is not None and 'cancelRequested' not in already_processed:
            already_processed.add('cancelRequested')
            outfile.write(' cancelRequested="%s"' % self.gds_format_boolean(self.cancelRequested, input_name='cancelRequested'))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            outfile.write(' startTime="%s"' % self.gds_format_datetime(self.startTime, input_name='startTime'))
        if self.operation is not None and 'operation' not in already_processed:
            already_processed.add('operation')
            outfile.write(' operation=%s' % (self.gds_format_string(quote_attrib(self.operation).encode(ExternalEncoding), input_name='operation'), ))
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            outfile.write(' endTime="%s"' % self.gds_format_datetime(self.endTime, input_name='endTime'))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TaskType', fromsubclass_=False, pretty_print=True):
        super(TaskType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Owner is not None:
            self.Owner.export(outfile, level, namespace_, name_='Owner', pretty_print=pretty_print)
        if self.Error is not None:
            self.Error.export(outfile, level, namespace_, name_='Error', pretty_print=pretty_print)
        if self.User is not None:
            self.User.export(outfile, level, namespace_, name_='User', pretty_print=pretty_print)
        if self.Organization is not None:
            self.Organization.export(outfile, level, namespace_, name_='Organization', pretty_print=pretty_print)
        if self.Progress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProgress>%s</%sProgress>%s' % (namespace_, self.gds_format_integer(self.Progress, input_name='Progress'), namespace_, eol_))
        if self.Params is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sParams>%s</%sParams>%s' % (namespace_, self.gds_format_string(quote_xml(self.Params).encode(ExternalEncoding), input_name='Params'), namespace_, eol_))
        if self.Details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDetails>%s</%sDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.Details).encode(ExternalEncoding), input_name='Details'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TaskType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.operationName is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            showIndent(outfile, level)
            outfile.write('operationName="%s",\n' % (self.operationName,))
        if self.expiryTime is not None and 'expiryTime' not in already_processed:
            already_processed.add('expiryTime')
            showIndent(outfile, level)
            outfile.write('expiryTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.expiryTime, input_name='expiryTime'))
        if self.cancelRequested is not None and 'cancelRequested' not in already_processed:
            already_processed.add('cancelRequested')
            showIndent(outfile, level)
            outfile.write('cancelRequested=%s,\n' % (self.cancelRequested,))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            showIndent(outfile, level)
            outfile.write('startTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.startTime, input_name='startTime'))
        if self.operation is not None and 'operation' not in already_processed:
            already_processed.add('operation')
            showIndent(outfile, level)
            outfile.write('operation="%s",\n' % (self.operation,))
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            showIndent(outfile, level)
            outfile.write('endTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.endTime, input_name='endTime'))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        super(TaskType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskType, self).exportLiteralChildren(outfile, level, name_)
        if self.Owner is not None:
            showIndent(outfile, level)
            outfile.write('Owner=model_.ReferenceType(\n')
            self.Owner.exportLiteral(outfile, level, name_='Owner')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Error is not None:
            showIndent(outfile, level)
            outfile.write('Error=model_.ErrorType(\n')
            self.Error.exportLiteral(outfile, level, name_='Error')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.User is not None:
            showIndent(outfile, level)
            outfile.write('User=model_.ReferenceType(\n')
            self.User.exportLiteral(outfile, level, name_='User')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Organization is not None:
            showIndent(outfile, level)
            outfile.write('Organization=model_.ReferenceType(\n')
            self.Organization.exportLiteral(outfile, level, name_='Organization')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Progress is not None:
            showIndent(outfile, level)
            outfile.write('Progress=%d,\n' % self.Progress)
        if self.Params is not None:
            showIndent(outfile, level)
            outfile.write('Params=%s,\n' % quote_python(self.Params).encode(ExternalEncoding))
        if self.Details is not None:
            showIndent(outfile, level)
            outfile.write('Details=%s,\n' % quote_python(self.Details).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('operationName', node)
        if value is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            self.operationName = value
        value = find_attr_value_('expiryTime', node)
        if value is not None and 'expiryTime' not in already_processed:
            already_processed.add('expiryTime')
            try:
                self.expiryTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (expiryTime): %s' % exp)
        value = find_attr_value_('cancelRequested', node)
        if value is not None and 'cancelRequested' not in already_processed:
            already_processed.add('cancelRequested')
            if value in ('true', '1'):
                self.cancelRequested = True
            elif value in ('false', '0'):
                self.cancelRequested = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('startTime', node)
        if value is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            try:
                self.startTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (startTime): %s' % exp)
        value = find_attr_value_('operation', node)
        if value is not None and 'operation' not in already_processed:
            already_processed.add('operation')
            self.operation = value
        value = find_attr_value_('endTime', node)
        if value is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            try:
                self.endTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (endTime): %s' % exp)
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        super(TaskType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Owner':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Owner = obj_
            obj_.original_tagname_ = 'Owner'
        elif nodeName_ == 'Error':
            obj_ = ErrorType.factory()
            obj_.build(child_)
            self.Error = obj_
            obj_.original_tagname_ = 'Error'
        elif nodeName_ == 'User':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.User = obj_
            obj_.original_tagname_ = 'User'
        elif nodeName_ == 'Organization':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Organization = obj_
            obj_.original_tagname_ = 'Organization'
        elif nodeName_ == 'Progress':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Progress')
            self.Progress = ival_
        elif nodeName_ == 'Params':
            Params_ = child_.text
            Params_ = self.gds_validate_string(Params_, node, 'Params')
            self.Params = Params_
        elif nodeName_ == 'Details':
            Details_ = child_.text
            Details_ = self.gds_validate_string(Details_, node, 'Details')
            self.Details = Details_
        super(TaskType, self).buildChildren(child_, node, nodeName_, True)
# end class TaskType


class LinkType(ReferenceType):
    """0.9 Extends reference type by adding relation attribute. Defines a
    hyper-link with a relationship, hyper-link reference, and an
    optional MIME type. always Defines the relationship of the link
    to the object that contains it. A relationship can be the name
    of an operation on the object, a reference to a contained or
    containing object, or a reference to an alternate representation
    of the object. The relationship value implies the HTTP verb to
    use when you use the link's href as a request URL. See the
    vCloud API Programming Guide for a list of links and link
    relations. true"""
    subclass = None
    superclass = ReferenceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, id=None, name=None, rel=None):
        self.original_tagname_ = None
        super(LinkType, self).__init__(VCloudExtension, href, type_, id, name, )
        self.rel = _cast(None, rel)
    def factory(*args_, **kwargs_):
        if LinkType.subclass:
            return LinkType.subclass(*args_, **kwargs_)
        else:
            return LinkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def hasContent_(self):
        if (
            super(LinkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LinkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LinkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LinkType'):
        super(LinkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LinkType')
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LinkType', fromsubclass_=False, pretty_print=True):
        super(LinkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LinkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel="%s",\n' % (self.rel,))
        super(LinkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LinkType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        super(LinkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(LinkType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class LinkType


class SubnetParticipationType(VCloudExtensibleType):
    """5.1 Allows to chose which subnets a gateway can be part of"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Gateway=None, Netmask=None, IpAddress=None, IpRanges=None):
        self.original_tagname_ = None
        super(SubnetParticipationType, self).__init__(VCloudExtension, )
        self.Gateway = Gateway
        self.Netmask = Netmask
        self.IpAddress = IpAddress
        self.IpRanges = IpRanges
    def factory(*args_, **kwargs_):
        if SubnetParticipationType.subclass:
            return SubnetParticipationType.subclass(*args_, **kwargs_)
        else:
            return SubnetParticipationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Gateway(self): return self.Gateway
    def set_Gateway(self, Gateway): self.Gateway = Gateway
    def get_Netmask(self): return self.Netmask
    def set_Netmask(self, Netmask): self.Netmask = Netmask
    def get_IpAddress(self): return self.IpAddress
    def set_IpAddress(self, IpAddress): self.IpAddress = IpAddress
    def get_IpRanges(self): return self.IpRanges
    def set_IpRanges(self, IpRanges): self.IpRanges = IpRanges
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Gateway is not None or
            self.Netmask is not None or
            self.IpAddress is not None or
            self.IpRanges is not None or
            super(SubnetParticipationType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SubnetParticipationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SubnetParticipationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SubnetParticipationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SubnetParticipationType'):
        super(SubnetParticipationType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SubnetParticipationType')
    def exportChildren(self, outfile, level, namespace_='', name_='SubnetParticipationType', fromsubclass_=False, pretty_print=True):
        super(SubnetParticipationType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Gateway is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sGateway>%s</%sGateway>%s' % (namespace_, self.gds_format_string(quote_xml(self.Gateway).encode(ExternalEncoding), input_name='Gateway'), namespace_, eol_))
        if self.Netmask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNetmask>%s</%sNetmask>%s' % (namespace_, self.gds_format_string(quote_xml(self.Netmask).encode(ExternalEncoding), input_name='Netmask'), namespace_, eol_))
        if self.IpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIpAddress>%s</%sIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.IpAddress).encode(ExternalEncoding), input_name='IpAddress'), namespace_, eol_))
        if self.IpRanges is not None:
            self.IpRanges.export(outfile, level, namespace_, name_='IpRanges', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SubnetParticipationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SubnetParticipationType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SubnetParticipationType, self).exportLiteralChildren(outfile, level, name_)
        if self.Gateway is not None:
            showIndent(outfile, level)
            outfile.write('Gateway=%s,\n' % quote_python(self.Gateway).encode(ExternalEncoding))
        if self.Netmask is not None:
            showIndent(outfile, level)
            outfile.write('Netmask=%s,\n' % quote_python(self.Netmask).encode(ExternalEncoding))
        if self.IpAddress is not None:
            showIndent(outfile, level)
            outfile.write('IpAddress=%s,\n' % quote_python(self.IpAddress).encode(ExternalEncoding))
        if self.IpRanges is not None:
            showIndent(outfile, level)
            outfile.write('IpRanges=model_.IpRangesType(\n')
            self.IpRanges.exportLiteral(outfile, level, name_='IpRanges')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SubnetParticipationType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Gateway':
            Gateway_ = child_.text
            Gateway_ = self.gds_validate_string(Gateway_, node, 'Gateway')
            self.Gateway = Gateway_
            self.validate_IpAddressType(self.Gateway)    # validate type IpAddressType
        elif nodeName_ == 'Netmask':
            Netmask_ = child_.text
            Netmask_ = self.gds_validate_string(Netmask_, node, 'Netmask')
            self.Netmask = Netmask_
            self.validate_IpAddressType(self.Netmask)    # validate type IpAddressType
        elif nodeName_ == 'IpAddress':
            IpAddress_ = child_.text
            IpAddress_ = self.gds_validate_string(IpAddress_, node, 'IpAddress')
            self.IpAddress = IpAddress_
            self.validate_IpAddressType(self.IpAddress)    # validate type IpAddressType
        elif nodeName_ == 'IpRanges':
            obj_ = IpRangesType.factory()
            obj_.build(child_)
            self.IpRanges = obj_
            obj_.original_tagname_ = 'IpRanges'
        super(SubnetParticipationType, self).buildChildren(child_, node, nodeName_, True)
# end class SubnetParticipationType


class GatewayFeaturesType(VCloudExtensibleType):
    """5.1 Represents edge gateway services."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, NetworkService=None):
        self.original_tagname_ = None
        super(GatewayFeaturesType, self).__init__(VCloudExtension, )
        if NetworkService is None:
            self.NetworkService = []
        else:
            self.NetworkService = NetworkService
    def factory(*args_, **kwargs_):
        if GatewayFeaturesType.subclass:
            return GatewayFeaturesType.subclass(*args_, **kwargs_)
        else:
            return GatewayFeaturesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NetworkService(self): return self.NetworkService
    def set_NetworkService(self, NetworkService): self.NetworkService = NetworkService
    def add_NetworkService(self, value): self.NetworkService.append(value)
    def insert_NetworkService_at(self, index, value): self.NetworkService.insert(index, value)
    def replace_NetworkService_at(self, index, value): self.NetworkService[index] = value
    def hasContent_(self):
        if (
            self.NetworkService or
            super(GatewayFeaturesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayFeaturesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayFeaturesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayFeaturesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayFeaturesType'):
        super(GatewayFeaturesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayFeaturesType')
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayFeaturesType', fromsubclass_=False, pretty_print=True):
        super(GatewayFeaturesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for NetworkService_ in self.NetworkService:
            NetworkService_.export(outfile, level, namespace_, name_='NetworkService', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GatewayFeaturesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GatewayFeaturesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayFeaturesType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('NetworkService=[\n')
        level += 1
        for NetworkService_ in self.NetworkService:
            showIndent(outfile, level)
            outfile.write('model_.NetworkService(\n')
            NetworkService_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GatewayFeaturesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NetworkService':
            class_obj_ = self.get_class_obj_(child_, NetworkServiceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'NetworkService'
        elif nodeName_ == 'DhcpService':
            obj_ = DhcpServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'DhcpService'
        elif nodeName_ == 'FirewallService':
            obj_ = FirewallServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'FirewallService'
        elif nodeName_ == 'NatService':
            obj_ = NatServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'NatService'
        elif nodeName_ == 'IpsecVpnService':
            obj_ = IpsecVpnServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'IpsecVpnService'
        elif nodeName_ == 'StaticRoutingService':
            obj_ = StaticRoutingServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'StaticRoutingService'
        elif nodeName_ == 'GatewayIpsecVpnService':
            obj_ = GatewayIpsecVpnServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'GatewayIpsecVpnService'
        elif nodeName_ == 'LoadBalancerService':
            obj_ = LoadBalancerServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'LoadBalancerService'
        elif nodeName_ == 'GatewayDhcpService':
            obj_ = GatewayDhcpServiceType.factory()
            obj_.build(child_)
            self.NetworkService.append(obj_)
            obj_.original_tagname_ = 'GatewayDhcpService'
        super(GatewayFeaturesType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayFeaturesType


class GatewayInterfaceType(VCloudExtensibleType):
    """5.1 Gateway Interface configuration."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Name=None, DisplayName=None, Network=None, InterfaceType=None, SubnetParticipation=None, ApplyRateLimit=None, InRateLimit=None, OutRateLimit=None, UseForDefaultRoute=None):
        self.original_tagname_ = None
        super(GatewayInterfaceType, self).__init__(VCloudExtension, )
        self.Name = Name
        self.DisplayName = DisplayName
        self.Network = Network
        self.InterfaceType = InterfaceType
        if SubnetParticipation is None:
            self.SubnetParticipation = []
        else:
            self.SubnetParticipation = SubnetParticipation
        self.ApplyRateLimit = ApplyRateLimit
        self.InRateLimit = InRateLimit
        self.OutRateLimit = OutRateLimit
        self.UseForDefaultRoute = UseForDefaultRoute
    def factory(*args_, **kwargs_):
        if GatewayInterfaceType.subclass:
            return GatewayInterfaceType.subclass(*args_, **kwargs_)
        else:
            return GatewayInterfaceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_DisplayName(self): return self.DisplayName
    def set_DisplayName(self, DisplayName): self.DisplayName = DisplayName
    def get_Network(self): return self.Network
    def set_Network(self, Network): self.Network = Network
    def get_InterfaceType(self): return self.InterfaceType
    def set_InterfaceType(self, InterfaceType): self.InterfaceType = InterfaceType
    def get_SubnetParticipation(self): return self.SubnetParticipation
    def set_SubnetParticipation(self, SubnetParticipation): self.SubnetParticipation = SubnetParticipation
    def add_SubnetParticipation(self, value): self.SubnetParticipation.append(value)
    def insert_SubnetParticipation_at(self, index, value): self.SubnetParticipation.insert(index, value)
    def replace_SubnetParticipation_at(self, index, value): self.SubnetParticipation[index] = value
    def get_ApplyRateLimit(self): return self.ApplyRateLimit
    def set_ApplyRateLimit(self, ApplyRateLimit): self.ApplyRateLimit = ApplyRateLimit
    def get_InRateLimit(self): return self.InRateLimit
    def set_InRateLimit(self, InRateLimit): self.InRateLimit = InRateLimit
    def get_OutRateLimit(self): return self.OutRateLimit
    def set_OutRateLimit(self, OutRateLimit): self.OutRateLimit = OutRateLimit
    def get_UseForDefaultRoute(self): return self.UseForDefaultRoute
    def set_UseForDefaultRoute(self, UseForDefaultRoute): self.UseForDefaultRoute = UseForDefaultRoute
    def hasContent_(self):
        if (
            self.Name is not None or
            self.DisplayName is not None or
            self.Network is not None or
            self.InterfaceType is not None or
            self.SubnetParticipation or
            self.ApplyRateLimit is not None or
            self.InRateLimit is not None or
            self.OutRateLimit is not None or
            self.UseForDefaultRoute is not None or
            super(GatewayInterfaceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayInterfaceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayInterfaceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayInterfaceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayInterfaceType'):
        super(GatewayInterfaceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayInterfaceType')
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayInterfaceType', fromsubclass_=False, pretty_print=True):
        super(GatewayInterfaceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.DisplayName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDisplayName>%s</%sDisplayName>%s' % (namespace_, self.gds_format_string(quote_xml(self.DisplayName).encode(ExternalEncoding), input_name='DisplayName'), namespace_, eol_))
        if self.Network is not None:
            self.Network.export(outfile, level, namespace_, name_='Network', pretty_print=pretty_print)
        if self.InterfaceType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInterfaceType>%s</%sInterfaceType>%s' % (namespace_, self.gds_format_string(quote_xml(self.InterfaceType).encode(ExternalEncoding), input_name='InterfaceType'), namespace_, eol_))
        for SubnetParticipation_ in self.SubnetParticipation:
            SubnetParticipation_.export(outfile, level, namespace_, name_='SubnetParticipation', pretty_print=pretty_print)
        if self.ApplyRateLimit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sApplyRateLimit>%s</%sApplyRateLimit>%s' % (namespace_, self.gds_format_boolean(self.ApplyRateLimit, input_name='ApplyRateLimit'), namespace_, eol_))
        if self.InRateLimit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInRateLimit>%s</%sInRateLimit>%s' % (namespace_, self.gds_format_double(self.InRateLimit, input_name='InRateLimit'), namespace_, eol_))
        if self.OutRateLimit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOutRateLimit>%s</%sOutRateLimit>%s' % (namespace_, self.gds_format_double(self.OutRateLimit, input_name='OutRateLimit'), namespace_, eol_))
        if self.UseForDefaultRoute is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUseForDefaultRoute>%s</%sUseForDefaultRoute>%s' % (namespace_, self.gds_format_boolean(self.UseForDefaultRoute, input_name='UseForDefaultRoute'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='GatewayInterfaceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GatewayInterfaceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayInterfaceType, self).exportLiteralChildren(outfile, level, name_)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.DisplayName is not None:
            showIndent(outfile, level)
            outfile.write('DisplayName=%s,\n' % quote_python(self.DisplayName).encode(ExternalEncoding))
        if self.Network is not None:
            showIndent(outfile, level)
            outfile.write('Network=model_.ReferenceType(\n')
            self.Network.exportLiteral(outfile, level, name_='Network')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.InterfaceType is not None:
            showIndent(outfile, level)
            outfile.write('InterfaceType=%s,\n' % quote_python(self.InterfaceType).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('SubnetParticipation=[\n')
        level += 1
        for SubnetParticipation_ in self.SubnetParticipation:
            showIndent(outfile, level)
            outfile.write('model_.SubnetParticipationType(\n')
            SubnetParticipation_.exportLiteral(outfile, level, name_='SubnetParticipationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.ApplyRateLimit is not None:
            showIndent(outfile, level)
            outfile.write('ApplyRateLimit=%s,\n' % self.ApplyRateLimit)
        if self.InRateLimit is not None:
            showIndent(outfile, level)
            outfile.write('InRateLimit=%e,\n' % self.InRateLimit)
        if self.OutRateLimit is not None:
            showIndent(outfile, level)
            outfile.write('OutRateLimit=%e,\n' % self.OutRateLimit)
        if self.UseForDefaultRoute is not None:
            showIndent(outfile, level)
            outfile.write('UseForDefaultRoute=%s,\n' % self.UseForDefaultRoute)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GatewayInterfaceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'DisplayName':
            DisplayName_ = child_.text
            DisplayName_ = self.gds_validate_string(DisplayName_, node, 'DisplayName')
            self.DisplayName = DisplayName_
        elif nodeName_ == 'Network':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Network = obj_
            obj_.original_tagname_ = 'Network'
        elif nodeName_ == 'InterfaceType':
            InterfaceType_ = child_.text
            InterfaceType_ = self.gds_validate_string(InterfaceType_, node, 'InterfaceType')
            self.InterfaceType = InterfaceType_
        elif nodeName_ == 'SubnetParticipation':
            obj_ = SubnetParticipationType.factory()
            obj_.build(child_)
            self.SubnetParticipation.append(obj_)
            obj_.original_tagname_ = 'SubnetParticipation'
        elif nodeName_ == 'ApplyRateLimit':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ApplyRateLimit')
            self.ApplyRateLimit = ival_
        elif nodeName_ == 'InRateLimit':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'InRateLimit')
            self.InRateLimit = fval_
        elif nodeName_ == 'OutRateLimit':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'OutRateLimit')
            self.OutRateLimit = fval_
        elif nodeName_ == 'UseForDefaultRoute':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'UseForDefaultRoute')
            self.UseForDefaultRoute = ival_
        super(GatewayInterfaceType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayInterfaceType


class GatewayInterfacesType(VCloudExtensibleType):
    """5.1 A list of Gateway Interfaces."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, GatewayInterface=None):
        self.original_tagname_ = None
        super(GatewayInterfacesType, self).__init__(VCloudExtension, )
        if GatewayInterface is None:
            self.GatewayInterface = []
        else:
            self.GatewayInterface = GatewayInterface
    def factory(*args_, **kwargs_):
        if GatewayInterfacesType.subclass:
            return GatewayInterfacesType.subclass(*args_, **kwargs_)
        else:
            return GatewayInterfacesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_GatewayInterface(self): return self.GatewayInterface
    def set_GatewayInterface(self, GatewayInterface): self.GatewayInterface = GatewayInterface
    def add_GatewayInterface(self, value): self.GatewayInterface.append(value)
    def insert_GatewayInterface_at(self, index, value): self.GatewayInterface.insert(index, value)
    def replace_GatewayInterface_at(self, index, value): self.GatewayInterface[index] = value
    def hasContent_(self):
        if (
            self.GatewayInterface or
            super(GatewayInterfacesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayInterfacesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayInterfacesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayInterfacesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayInterfacesType'):
        super(GatewayInterfacesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayInterfacesType')
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayInterfacesType', fromsubclass_=False, pretty_print=True):
        super(GatewayInterfacesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for GatewayInterface_ in self.GatewayInterface:
            GatewayInterface_.export(outfile, level, namespace_, name_='GatewayInterface', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GatewayInterfacesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GatewayInterfacesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayInterfacesType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('GatewayInterface=[\n')
        level += 1
        for GatewayInterface_ in self.GatewayInterface:
            showIndent(outfile, level)
            outfile.write('model_.GatewayInterfaceType(\n')
            GatewayInterface_.exportLiteral(outfile, level, name_='GatewayInterfaceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GatewayInterfacesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'GatewayInterface':
            obj_ = GatewayInterfaceType.factory()
            obj_.build(child_)
            self.GatewayInterface.append(obj_)
            obj_.original_tagname_ = 'GatewayInterface'
        super(GatewayInterfacesType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayInterfacesType


class GatewayConfigurationType(VCloudExtensibleType):
    """5.1 Gateway Configuration."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, BackwardCompatibilityMode=None, GatewayBackingConfig=None, GatewayInterfaces=None, EdgeGatewayServiceConfiguration=None, HaEnabled=None, UseDefaultRouteForDnsRelay=None):
        self.original_tagname_ = None
        super(GatewayConfigurationType, self).__init__(VCloudExtension, )
        self.BackwardCompatibilityMode = BackwardCompatibilityMode
        self.GatewayBackingConfig = GatewayBackingConfig
        self.GatewayInterfaces = GatewayInterfaces
        self.EdgeGatewayServiceConfiguration = EdgeGatewayServiceConfiguration
        self.HaEnabled = HaEnabled
        self.UseDefaultRouteForDnsRelay = UseDefaultRouteForDnsRelay
    def factory(*args_, **kwargs_):
        if GatewayConfigurationType.subclass:
            return GatewayConfigurationType.subclass(*args_, **kwargs_)
        else:
            return GatewayConfigurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BackwardCompatibilityMode(self): return self.BackwardCompatibilityMode
    def set_BackwardCompatibilityMode(self, BackwardCompatibilityMode): self.BackwardCompatibilityMode = BackwardCompatibilityMode
    def get_GatewayBackingConfig(self): return self.GatewayBackingConfig
    def set_GatewayBackingConfig(self, GatewayBackingConfig): self.GatewayBackingConfig = GatewayBackingConfig
    def get_GatewayInterfaces(self): return self.GatewayInterfaces
    def set_GatewayInterfaces(self, GatewayInterfaces): self.GatewayInterfaces = GatewayInterfaces
    def get_EdgeGatewayServiceConfiguration(self): return self.EdgeGatewayServiceConfiguration
    def set_EdgeGatewayServiceConfiguration(self, EdgeGatewayServiceConfiguration): self.EdgeGatewayServiceConfiguration = EdgeGatewayServiceConfiguration
    def get_HaEnabled(self): return self.HaEnabled
    def set_HaEnabled(self, HaEnabled): self.HaEnabled = HaEnabled
    def get_UseDefaultRouteForDnsRelay(self): return self.UseDefaultRouteForDnsRelay
    def set_UseDefaultRouteForDnsRelay(self, UseDefaultRouteForDnsRelay): self.UseDefaultRouteForDnsRelay = UseDefaultRouteForDnsRelay
    def hasContent_(self):
        if (
            self.BackwardCompatibilityMode is not None or
            self.GatewayBackingConfig is not None or
            self.GatewayInterfaces is not None or
            self.EdgeGatewayServiceConfiguration is not None or
            self.HaEnabled is not None or
            self.UseDefaultRouteForDnsRelay is not None or
            super(GatewayConfigurationType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayConfigurationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayConfigurationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayConfigurationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayConfigurationType'):
        super(GatewayConfigurationType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayConfigurationType')
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayConfigurationType', fromsubclass_=False, pretty_print=True):
        super(GatewayConfigurationType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.BackwardCompatibilityMode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBackwardCompatibilityMode>%s</%sBackwardCompatibilityMode>%s' % (namespace_, self.gds_format_boolean(self.BackwardCompatibilityMode, input_name='BackwardCompatibilityMode'), namespace_, eol_))
        if self.GatewayBackingConfig is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sGatewayBackingConfig>%s</%sGatewayBackingConfig>%s' % (namespace_, self.gds_format_string(quote_xml(self.GatewayBackingConfig).encode(ExternalEncoding), input_name='GatewayBackingConfig'), namespace_, eol_))
        if self.GatewayInterfaces is not None:
            self.GatewayInterfaces.export(outfile, level, namespace_, name_='GatewayInterfaces', pretty_print=pretty_print)
        if self.EdgeGatewayServiceConfiguration is not None:
            self.EdgeGatewayServiceConfiguration.export(outfile, level, namespace_, name_='EdgeGatewayServiceConfiguration', pretty_print=pretty_print)
        if self.HaEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHaEnabled>%s</%sHaEnabled>%s' % (namespace_, self.gds_format_boolean(self.HaEnabled, input_name='HaEnabled'), namespace_, eol_))
        if self.UseDefaultRouteForDnsRelay is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUseDefaultRouteForDnsRelay>%s</%sUseDefaultRouteForDnsRelay>%s' % (namespace_, self.gds_format_boolean(self.UseDefaultRouteForDnsRelay, input_name='UseDefaultRouteForDnsRelay'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='GatewayConfigurationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GatewayConfigurationType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayConfigurationType, self).exportLiteralChildren(outfile, level, name_)
        if self.BackwardCompatibilityMode is not None:
            showIndent(outfile, level)
            outfile.write('BackwardCompatibilityMode=%s,\n' % self.BackwardCompatibilityMode)
        if self.GatewayBackingConfig is not None:
            showIndent(outfile, level)
            outfile.write('GatewayBackingConfig=%s,\n' % quote_python(self.GatewayBackingConfig).encode(ExternalEncoding))
        if self.GatewayInterfaces is not None:
            showIndent(outfile, level)
            outfile.write('GatewayInterfaces=model_.GatewayInterfacesType(\n')
            self.GatewayInterfaces.exportLiteral(outfile, level, name_='GatewayInterfaces')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.EdgeGatewayServiceConfiguration is not None:
            showIndent(outfile, level)
            outfile.write('EdgeGatewayServiceConfiguration=model_.GatewayFeaturesType(\n')
            self.EdgeGatewayServiceConfiguration.exportLiteral(outfile, level, name_='EdgeGatewayServiceConfiguration')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.HaEnabled is not None:
            showIndent(outfile, level)
            outfile.write('HaEnabled=%s,\n' % self.HaEnabled)
        if self.UseDefaultRouteForDnsRelay is not None:
            showIndent(outfile, level)
            outfile.write('UseDefaultRouteForDnsRelay=%s,\n' % self.UseDefaultRouteForDnsRelay)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GatewayConfigurationType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BackwardCompatibilityMode':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'BackwardCompatibilityMode')
            self.BackwardCompatibilityMode = ival_
        elif nodeName_ == 'GatewayBackingConfig':
            GatewayBackingConfig_ = child_.text
            GatewayBackingConfig_ = self.gds_validate_string(GatewayBackingConfig_, node, 'GatewayBackingConfig')
            self.GatewayBackingConfig = GatewayBackingConfig_
        elif nodeName_ == 'GatewayInterfaces':
            obj_ = GatewayInterfacesType.factory()
            obj_.build(child_)
            self.GatewayInterfaces = obj_
            obj_.original_tagname_ = 'GatewayInterfaces'
        elif nodeName_ == 'EdgeGatewayServiceConfiguration':
            obj_ = GatewayFeaturesType.factory()
            obj_.build(child_)
            self.EdgeGatewayServiceConfiguration = obj_
            obj_.original_tagname_ = 'EdgeGatewayServiceConfiguration'
        elif nodeName_ == 'HaEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'HaEnabled')
            self.HaEnabled = ival_
        elif nodeName_ == 'UseDefaultRouteForDnsRelay':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'UseDefaultRouteForDnsRelay')
            self.UseDefaultRouteForDnsRelay = ival_
        super(GatewayConfigurationType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayConfigurationType


class GatewayType(EntityType):
    """5.1 Represents a gateway. none Creation status of the gateway. One
    of:<br> 0 (The gateway is still being created)<br> 1 (The
    gateway is ready)<br> -1 (There was an error while creating the
    gateway). false"""
    subclass = None
    superclass = EntityType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, status=None, Configuration=None):
        self.original_tagname_ = None
        super(GatewayType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, name, Description, Tasks, )
        self.status = _cast(int, status)
        self.Configuration = Configuration
    def factory(*args_, **kwargs_):
        if GatewayType.subclass:
            return GatewayType.subclass(*args_, **kwargs_)
        else:
            return GatewayType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Configuration(self): return self.Configuration
    def set_Configuration(self, Configuration): self.Configuration = Configuration
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def hasContent_(self):
        if (
            self.Configuration is not None or
            super(GatewayType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayType'):
        super(GatewayType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status="%s"' % self.gds_format_integer(self.status, input_name='status'))
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayType', fromsubclass_=False, pretty_print=True):
        super(GatewayType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Configuration is not None:
            self.Configuration.export(outfile, level, namespace_, name_='Configuration', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GatewayType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status=%d,\n' % (self.status,))
        super(GatewayType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayType, self).exportLiteralChildren(outfile, level, name_)
        if self.Configuration is not None:
            showIndent(outfile, level)
            outfile.write('Configuration=model_.GatewayConfigurationType(\n')
            self.Configuration.exportLiteral(outfile, level, name_='Configuration')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            try:
                self.status = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(GatewayType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Configuration':
            obj_ = GatewayConfigurationType.factory()
            obj_.build(child_)
            self.Configuration = obj_
            obj_.original_tagname_ = 'Configuration'
        super(GatewayType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayType


class IpScopesType(VCloudExtensibleType):
    """5.1 Represents a list of IP scopes."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IpScope=None):
        self.original_tagname_ = None
        super(IpScopesType, self).__init__(VCloudExtension, )
        if IpScope is None:
            self.IpScope = []
        else:
            self.IpScope = IpScope
    def factory(*args_, **kwargs_):
        if IpScopesType.subclass:
            return IpScopesType.subclass(*args_, **kwargs_)
        else:
            return IpScopesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IpScope(self): return self.IpScope
    def set_IpScope(self, IpScope): self.IpScope = IpScope
    def add_IpScope(self, value): self.IpScope.append(value)
    def insert_IpScope_at(self, index, value): self.IpScope.insert(index, value)
    def replace_IpScope_at(self, index, value): self.IpScope[index] = value
    def hasContent_(self):
        if (
            self.IpScope or
            super(IpScopesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpScopesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpScopesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpScopesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpScopesType'):
        super(IpScopesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpScopesType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpScopesType', fromsubclass_=False, pretty_print=True):
        super(IpScopesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for IpScope_ in self.IpScope:
            IpScope_.export(outfile, level, namespace_, name_='IpScope', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IpScopesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpScopesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpScopesType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('IpScope=[\n')
        level += 1
        for IpScope_ in self.IpScope:
            showIndent(outfile, level)
            outfile.write('model_.IpScopeType(\n')
            IpScope_.exportLiteral(outfile, level, name_='IpScopeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpScopesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IpScope':
            obj_ = IpScopeType.factory()
            obj_.build(child_)
            self.IpScope.append(obj_)
            obj_.original_tagname_ = 'IpScope'
        super(IpScopesType, self).buildChildren(child_, node, nodeName_, True)
# end class IpScopesType


class IpScopeType(VCloudExtensibleType):
    """0.9 Specify network settings like gateway, network mask, DNS
    servers, IP ranges, etc."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IsInherited=None, Gateway=None, Netmask=None, Dns1=None, Dns2=None, DnsSuffix=None, IsEnabled=None, IpRanges=None, AllocatedIpAddresses=None, SubAllocations=None):
        self.original_tagname_ = None
        super(IpScopeType, self).__init__(VCloudExtension, )
        self.IsInherited = IsInherited
        self.Gateway = Gateway
        self.Netmask = Netmask
        self.Dns1 = Dns1
        self.Dns2 = Dns2
        self.DnsSuffix = DnsSuffix
        self.IsEnabled = IsEnabled
        self.IpRanges = IpRanges
        self.AllocatedIpAddresses = AllocatedIpAddresses
        self.SubAllocations = SubAllocations
    def factory(*args_, **kwargs_):
        if IpScopeType.subclass:
            return IpScopeType.subclass(*args_, **kwargs_)
        else:
            return IpScopeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsInherited(self): return self.IsInherited
    def set_IsInherited(self, IsInherited): self.IsInherited = IsInherited
    def get_Gateway(self): return self.Gateway
    def set_Gateway(self, Gateway): self.Gateway = Gateway
    def get_Netmask(self): return self.Netmask
    def set_Netmask(self, Netmask): self.Netmask = Netmask
    def get_Dns1(self): return self.Dns1
    def set_Dns1(self, Dns1): self.Dns1 = Dns1
    def get_Dns2(self): return self.Dns2
    def set_Dns2(self, Dns2): self.Dns2 = Dns2
    def get_DnsSuffix(self): return self.DnsSuffix
    def set_DnsSuffix(self, DnsSuffix): self.DnsSuffix = DnsSuffix
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_IpRanges(self): return self.IpRanges
    def set_IpRanges(self, IpRanges): self.IpRanges = IpRanges
    def get_AllocatedIpAddresses(self): return self.AllocatedIpAddresses
    def set_AllocatedIpAddresses(self, AllocatedIpAddresses): self.AllocatedIpAddresses = AllocatedIpAddresses
    def get_SubAllocations(self): return self.SubAllocations
    def set_SubAllocations(self, SubAllocations): self.SubAllocations = SubAllocations
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.IsInherited is not None or
            self.Gateway is not None or
            self.Netmask is not None or
            self.Dns1 is not None or
            self.Dns2 is not None or
            self.DnsSuffix is not None or
            self.IsEnabled is not None or
            self.IpRanges is not None or
            self.AllocatedIpAddresses is not None or
            self.SubAllocations is not None or
            super(IpScopeType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpScopeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpScopeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpScopeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpScopeType'):
        super(IpScopeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpScopeType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpScopeType', fromsubclass_=False, pretty_print=True):
        super(IpScopeType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsInherited is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsInherited>%s</%sIsInherited>%s' % (namespace_, self.gds_format_boolean(self.IsInherited, input_name='IsInherited'), namespace_, eol_))
        if self.Gateway is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sGateway>%s</%sGateway>%s' % (namespace_, self.gds_format_string(quote_xml(self.Gateway).encode(ExternalEncoding), input_name='Gateway'), namespace_, eol_))
        if self.Netmask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNetmask>%s</%sNetmask>%s' % (namespace_, self.gds_format_string(quote_xml(self.Netmask).encode(ExternalEncoding), input_name='Netmask'), namespace_, eol_))
        if self.Dns1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDns1>%s</%sDns1>%s' % (namespace_, self.gds_format_string(quote_xml(self.Dns1).encode(ExternalEncoding), input_name='Dns1'), namespace_, eol_))
        if self.Dns2 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDns2>%s</%sDns2>%s' % (namespace_, self.gds_format_string(quote_xml(self.Dns2).encode(ExternalEncoding), input_name='Dns2'), namespace_, eol_))
        if self.DnsSuffix is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDnsSuffix>%s</%sDnsSuffix>%s' % (namespace_, self.gds_format_string(quote_xml(self.DnsSuffix).encode(ExternalEncoding), input_name='DnsSuffix'), namespace_, eol_))
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
        if self.IpRanges is not None:
            self.IpRanges.export(outfile, level, namespace_, name_='IpRanges', pretty_print=pretty_print)
        if self.AllocatedIpAddresses is not None:
            self.AllocatedIpAddresses.export(outfile, level, namespace_, name_='AllocatedIpAddresses', pretty_print=pretty_print)
        if self.SubAllocations is not None:
            self.SubAllocations.export(outfile, level, namespace_, name_='SubAllocations', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IpScopeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpScopeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpScopeType, self).exportLiteralChildren(outfile, level, name_)
        if self.IsInherited is not None:
            showIndent(outfile, level)
            outfile.write('IsInherited=%s,\n' % self.IsInherited)
        if self.Gateway is not None:
            showIndent(outfile, level)
            outfile.write('Gateway=%s,\n' % quote_python(self.Gateway).encode(ExternalEncoding))
        if self.Netmask is not None:
            showIndent(outfile, level)
            outfile.write('Netmask=%s,\n' % quote_python(self.Netmask).encode(ExternalEncoding))
        if self.Dns1 is not None:
            showIndent(outfile, level)
            outfile.write('Dns1=%s,\n' % quote_python(self.Dns1).encode(ExternalEncoding))
        if self.Dns2 is not None:
            showIndent(outfile, level)
            outfile.write('Dns2=%s,\n' % quote_python(self.Dns2).encode(ExternalEncoding))
        if self.DnsSuffix is not None:
            showIndent(outfile, level)
            outfile.write('DnsSuffix=%s,\n' % quote_python(self.DnsSuffix).encode(ExternalEncoding))
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
        if self.IpRanges is not None:
            showIndent(outfile, level)
            outfile.write('IpRanges=model_.IpRangesType(\n')
            self.IpRanges.exportLiteral(outfile, level, name_='IpRanges')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AllocatedIpAddresses is not None:
            showIndent(outfile, level)
            outfile.write('AllocatedIpAddresses=model_.IpAddressesType(\n')
            self.AllocatedIpAddresses.exportLiteral(outfile, level, name_='AllocatedIpAddresses')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SubAllocations is not None:
            showIndent(outfile, level)
            outfile.write('SubAllocations=model_.SubAllocationsType(\n')
            self.SubAllocations.exportLiteral(outfile, level, name_='SubAllocations')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpScopeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsInherited':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsInherited')
            self.IsInherited = ival_
        elif nodeName_ == 'Gateway':
            Gateway_ = child_.text
            Gateway_ = self.gds_validate_string(Gateway_, node, 'Gateway')
            self.Gateway = Gateway_
            self.validate_IpAddressType(self.Gateway)    # validate type IpAddressType
        elif nodeName_ == 'Netmask':
            Netmask_ = child_.text
            Netmask_ = self.gds_validate_string(Netmask_, node, 'Netmask')
            self.Netmask = Netmask_
            self.validate_IpAddressType(self.Netmask)    # validate type IpAddressType
        elif nodeName_ == 'Dns1':
            Dns1_ = child_.text
            Dns1_ = self.gds_validate_string(Dns1_, node, 'Dns1')
            self.Dns1 = Dns1_
            self.validate_IpAddressType(self.Dns1)    # validate type IpAddressType
        elif nodeName_ == 'Dns2':
            Dns2_ = child_.text
            Dns2_ = self.gds_validate_string(Dns2_, node, 'Dns2')
            self.Dns2 = Dns2_
            self.validate_IpAddressType(self.Dns2)    # validate type IpAddressType
        elif nodeName_ == 'DnsSuffix':
            DnsSuffix_ = child_.text
            DnsSuffix_ = self.gds_validate_string(DnsSuffix_, node, 'DnsSuffix')
            self.DnsSuffix = DnsSuffix_
        elif nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'IpRanges':
            obj_ = IpRangesType.factory()
            obj_.build(child_)
            self.IpRanges = obj_
            obj_.original_tagname_ = 'IpRanges'
        elif nodeName_ == 'AllocatedIpAddresses':
            obj_ = IpAddressesType.factory()
            obj_.build(child_)
            self.AllocatedIpAddresses = obj_
            obj_.original_tagname_ = 'AllocatedIpAddresses'
        elif nodeName_ == 'SubAllocations':
            obj_ = SubAllocationsType.factory()
            obj_.build(child_)
            self.SubAllocations = obj_
            obj_.original_tagname_ = 'SubAllocations'
        super(IpScopeType, self).buildChildren(child_, node, nodeName_, True)
# end class IpScopeType


class IpRangesType(VCloudExtensibleType):
    """0.9 Represents a list of IP ranges."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IpRange=None):
        self.original_tagname_ = None
        super(IpRangesType, self).__init__(VCloudExtension, )
        if IpRange is None:
            self.IpRange = []
        else:
            self.IpRange = IpRange
    def factory(*args_, **kwargs_):
        if IpRangesType.subclass:
            return IpRangesType.subclass(*args_, **kwargs_)
        else:
            return IpRangesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IpRange(self): return self.IpRange
    def set_IpRange(self, IpRange): self.IpRange = IpRange
    def add_IpRange(self, value): self.IpRange.append(value)
    def insert_IpRange_at(self, index, value): self.IpRange.insert(index, value)
    def replace_IpRange_at(self, index, value): self.IpRange[index] = value
    def hasContent_(self):
        if (
            self.IpRange or
            super(IpRangesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpRangesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpRangesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpRangesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpRangesType'):
        super(IpRangesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpRangesType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpRangesType', fromsubclass_=False, pretty_print=True):
        super(IpRangesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for IpRange_ in self.IpRange:
            IpRange_.export(outfile, level, namespace_, name_='IpRange', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IpRangesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpRangesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpRangesType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('IpRange=[\n')
        level += 1
        for IpRange_ in self.IpRange:
            showIndent(outfile, level)
            outfile.write('model_.IpRangeType(\n')
            IpRange_.exportLiteral(outfile, level, name_='IpRangeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpRangesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IpRange':
            obj_ = IpRangeType.factory()
            obj_.build(child_)
            self.IpRange.append(obj_)
            obj_.original_tagname_ = 'IpRange'
        super(IpRangesType, self).buildChildren(child_, node, nodeName_, True)
# end class IpRangesType


class IpRangeType(VCloudExtensibleType):
    """0.9 Represents a range of IP addresses, start and end inclusive."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, StartAddress=None, EndAddress=None):
        self.original_tagname_ = None
        super(IpRangeType, self).__init__(VCloudExtension, )
        self.StartAddress = StartAddress
        self.EndAddress = EndAddress
    def factory(*args_, **kwargs_):
        if IpRangeType.subclass:
            return IpRangeType.subclass(*args_, **kwargs_)
        else:
            return IpRangeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_StartAddress(self): return self.StartAddress
    def set_StartAddress(self, StartAddress): self.StartAddress = StartAddress
    def get_EndAddress(self): return self.EndAddress
    def set_EndAddress(self, EndAddress): self.EndAddress = EndAddress
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.StartAddress is not None or
            self.EndAddress is not None or
            super(IpRangeType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpRangeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpRangeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpRangeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpRangeType'):
        super(IpRangeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpRangeType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpRangeType', fromsubclass_=False, pretty_print=True):
        super(IpRangeType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.StartAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStartAddress>%s</%sStartAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.StartAddress).encode(ExternalEncoding), input_name='StartAddress'), namespace_, eol_))
        if self.EndAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEndAddress>%s</%sEndAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.EndAddress).encode(ExternalEncoding), input_name='EndAddress'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IpRangeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpRangeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpRangeType, self).exportLiteralChildren(outfile, level, name_)
        if self.StartAddress is not None:
            showIndent(outfile, level)
            outfile.write('StartAddress=%s,\n' % quote_python(self.StartAddress).encode(ExternalEncoding))
        if self.EndAddress is not None:
            showIndent(outfile, level)
            outfile.write('EndAddress=%s,\n' % quote_python(self.EndAddress).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpRangeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'StartAddress':
            StartAddress_ = child_.text
            StartAddress_ = self.gds_validate_string(StartAddress_, node, 'StartAddress')
            self.StartAddress = StartAddress_
            self.validate_IpAddressType(self.StartAddress)    # validate type IpAddressType
        elif nodeName_ == 'EndAddress':
            EndAddress_ = child_.text
            EndAddress_ = self.gds_validate_string(EndAddress_, node, 'EndAddress')
            self.EndAddress = EndAddress_
            self.validate_IpAddressType(self.EndAddress)    # validate type IpAddressType
        super(IpRangeType, self).buildChildren(child_, node, nodeName_, True)
# end class IpRangeType


class SubAllocationType(VCloudExtensibleType):
    """IP range sub allocated to an edge gateway."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, EdgeGateway=None, IpRanges=None):
        self.original_tagname_ = None
        super(SubAllocationType, self).__init__(VCloudExtension, )
        self.EdgeGateway = EdgeGateway
        self.IpRanges = IpRanges
    def factory(*args_, **kwargs_):
        if SubAllocationType.subclass:
            return SubAllocationType.subclass(*args_, **kwargs_)
        else:
            return SubAllocationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_EdgeGateway(self): return self.EdgeGateway
    def set_EdgeGateway(self, EdgeGateway): self.EdgeGateway = EdgeGateway
    def get_IpRanges(self): return self.IpRanges
    def set_IpRanges(self, IpRanges): self.IpRanges = IpRanges
    def hasContent_(self):
        if (
            self.EdgeGateway is not None or
            self.IpRanges is not None or
            super(SubAllocationType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SubAllocationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SubAllocationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SubAllocationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SubAllocationType'):
        super(SubAllocationType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SubAllocationType')
    def exportChildren(self, outfile, level, namespace_='', name_='SubAllocationType', fromsubclass_=False, pretty_print=True):
        super(SubAllocationType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.EdgeGateway is not None:
            self.EdgeGateway.export(outfile, level, namespace_, name_='EdgeGateway', pretty_print=pretty_print)
        if self.IpRanges is not None:
            self.IpRanges.export(outfile, level, namespace_, name_='IpRanges', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SubAllocationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SubAllocationType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SubAllocationType, self).exportLiteralChildren(outfile, level, name_)
        if self.EdgeGateway is not None:
            showIndent(outfile, level)
            outfile.write('EdgeGateway=model_.ReferenceType(\n')
            self.EdgeGateway.exportLiteral(outfile, level, name_='EdgeGateway')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IpRanges is not None:
            showIndent(outfile, level)
            outfile.write('IpRanges=model_.IpRangesType(\n')
            self.IpRanges.exportLiteral(outfile, level, name_='IpRanges')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SubAllocationType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'EdgeGateway':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.EdgeGateway = obj_
            obj_.original_tagname_ = 'EdgeGateway'
        elif nodeName_ == 'IpRanges':
            obj_ = IpRangesType.factory()
            obj_.build(child_)
            self.IpRanges = obj_
            obj_.original_tagname_ = 'IpRanges'
        super(SubAllocationType, self).buildChildren(child_, node, nodeName_, True)
# end class SubAllocationType


class SubAllocationsType(ResourceType):
    """5.1A list of IP addresses that are sub allocated to edge gateways."""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, SubAllocation=None):
        self.original_tagname_ = None
        super(SubAllocationsType, self).__init__(VCloudExtension, href, type_, Link, )
        if SubAllocation is None:
            self.SubAllocation = []
        else:
            self.SubAllocation = SubAllocation
    def factory(*args_, **kwargs_):
        if SubAllocationsType.subclass:
            return SubAllocationsType.subclass(*args_, **kwargs_)
        else:
            return SubAllocationsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SubAllocation(self): return self.SubAllocation
    def set_SubAllocation(self, SubAllocation): self.SubAllocation = SubAllocation
    def add_SubAllocation(self, value): self.SubAllocation.append(value)
    def insert_SubAllocation_at(self, index, value): self.SubAllocation.insert(index, value)
    def replace_SubAllocation_at(self, index, value): self.SubAllocation[index] = value
    def hasContent_(self):
        if (
            self.SubAllocation or
            super(SubAllocationsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SubAllocationsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SubAllocationsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SubAllocationsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SubAllocationsType'):
        super(SubAllocationsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SubAllocationsType')
    def exportChildren(self, outfile, level, namespace_='', name_='SubAllocationsType', fromsubclass_=False, pretty_print=True):
        super(SubAllocationsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for SubAllocation_ in self.SubAllocation:
            SubAllocation_.export(outfile, level, namespace_, name_='SubAllocation', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SubAllocationsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SubAllocationsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SubAllocationsType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('SubAllocation=[\n')
        level += 1
        for SubAllocation_ in self.SubAllocation:
            showIndent(outfile, level)
            outfile.write('model_.SubAllocationType(\n')
            SubAllocation_.exportLiteral(outfile, level, name_='SubAllocationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SubAllocationsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SubAllocation':
            obj_ = SubAllocationType.factory()
            obj_.build(child_)
            self.SubAllocation.append(obj_)
            obj_.original_tagname_ = 'SubAllocation'
        super(SubAllocationsType, self).buildChildren(child_, node, nodeName_, True)
# end class SubAllocationsType


class AllocatedIpAddressesType(ResourceType):
    """5.1A list of information for allocated IP addresses."""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, IpAddress=None):
        self.original_tagname_ = None
        super(AllocatedIpAddressesType, self).__init__(VCloudExtension, href, type_, Link, )
        if IpAddress is None:
            self.IpAddress = []
        else:
            self.IpAddress = IpAddress
    def factory(*args_, **kwargs_):
        if AllocatedIpAddressesType.subclass:
            return AllocatedIpAddressesType.subclass(*args_, **kwargs_)
        else:
            return AllocatedIpAddressesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IpAddress(self): return self.IpAddress
    def set_IpAddress(self, IpAddress): self.IpAddress = IpAddress
    def add_IpAddress(self, value): self.IpAddress.append(value)
    def insert_IpAddress_at(self, index, value): self.IpAddress.insert(index, value)
    def replace_IpAddress_at(self, index, value): self.IpAddress[index] = value
    def hasContent_(self):
        if (
            self.IpAddress or
            super(AllocatedIpAddressesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AllocatedIpAddressesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AllocatedIpAddressesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AllocatedIpAddressesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AllocatedIpAddressesType'):
        super(AllocatedIpAddressesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AllocatedIpAddressesType')
    def exportChildren(self, outfile, level, namespace_='', name_='AllocatedIpAddressesType', fromsubclass_=False, pretty_print=True):
        super(AllocatedIpAddressesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for IpAddress_ in self.IpAddress:
            IpAddress_.export(outfile, level, namespace_, name_='IpAddress', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AllocatedIpAddressesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AllocatedIpAddressesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AllocatedIpAddressesType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('IpAddress=[\n')
        level += 1
        for IpAddress_ in self.IpAddress:
            showIndent(outfile, level)
            outfile.write('model_.AllocatedIpAddressType(\n')
            IpAddress_.exportLiteral(outfile, level, name_='AllocatedIpAddressType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AllocatedIpAddressesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IpAddress':
            obj_ = AllocatedIpAddressType.factory()
            obj_.build(child_)
            self.IpAddress.append(obj_)
            obj_.original_tagname_ = 'IpAddress'
        super(AllocatedIpAddressesType, self).buildChildren(child_, node, nodeName_, True)
# end class AllocatedIpAddressesType


class AllocatedIpAddressType(ResourceType):
    """5.1 Represents an information for allocated IP address 5.1 True if
    vApp is deployed. falsealways One of: vmAllocated (IP is
    allocated by VM), natRouted (IP is NAT routed) vsmAllocated (IP
    is allocated for vShieldManager) false"""
    subclass = None
    superclass = ResourceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, allocationType=None, isDeployed=None, IpAddress=None):
        self.original_tagname_ = None
        super(AllocatedIpAddressType, self).__init__(VCloudExtension, href, type_, Link, )
        self.allocationType = _cast(None, allocationType)
        self.isDeployed = _cast(bool, isDeployed)
        self.IpAddress = IpAddress
    def factory(*args_, **kwargs_):
        if AllocatedIpAddressType.subclass:
            return AllocatedIpAddressType.subclass(*args_, **kwargs_)
        else:
            return AllocatedIpAddressType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IpAddress(self): return self.IpAddress
    def set_IpAddress(self, IpAddress): self.IpAddress = IpAddress
    def get_allocationType(self): return self.allocationType
    def set_allocationType(self, allocationType): self.allocationType = allocationType
    def get_isDeployed(self): return self.isDeployed
    def set_isDeployed(self, isDeployed): self.isDeployed = isDeployed
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.IpAddress is not None or
            super(AllocatedIpAddressType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AllocatedIpAddressType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AllocatedIpAddressType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AllocatedIpAddressType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AllocatedIpAddressType'):
        super(AllocatedIpAddressType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AllocatedIpAddressType')
        if self.allocationType is not None and 'allocationType' not in already_processed:
            already_processed.add('allocationType')
            outfile.write(' allocationType=%s' % (self.gds_format_string(quote_attrib(self.allocationType).encode(ExternalEncoding), input_name='allocationType'), ))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            outfile.write(' isDeployed="%s"' % self.gds_format_boolean(self.isDeployed, input_name='isDeployed'))
    def exportChildren(self, outfile, level, namespace_='', name_='AllocatedIpAddressType', fromsubclass_=False, pretty_print=True):
        super(AllocatedIpAddressType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIpAddress>%s</%sIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.IpAddress).encode(ExternalEncoding), input_name='IpAddress'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='AllocatedIpAddressType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.allocationType is not None and 'allocationType' not in already_processed:
            already_processed.add('allocationType')
            showIndent(outfile, level)
            outfile.write('allocationType="%s",\n' % (self.allocationType,))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            showIndent(outfile, level)
            outfile.write('isDeployed=%s,\n' % (self.isDeployed,))
        super(AllocatedIpAddressType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AllocatedIpAddressType, self).exportLiteralChildren(outfile, level, name_)
        if self.IpAddress is not None:
            showIndent(outfile, level)
            outfile.write('IpAddress=%s,\n' % quote_python(self.IpAddress).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('allocationType', node)
        if value is not None and 'allocationType' not in already_processed:
            already_processed.add('allocationType')
            self.allocationType = value
        value = find_attr_value_('isDeployed', node)
        if value is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            if value in ('true', '1'):
                self.isDeployed = True
            elif value in ('false', '0'):
                self.isDeployed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(AllocatedIpAddressType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IpAddress':
            IpAddress_ = child_.text
            IpAddress_ = self.gds_validate_string(IpAddress_, node, 'IpAddress')
            self.IpAddress = IpAddress_
            self.validate_IpAddressType(self.IpAddress)    # validate type IpAddressType
        super(AllocatedIpAddressType, self).buildChildren(child_, node, nodeName_, True)
# end class AllocatedIpAddressType


class IpAddressesType(VCloudExtensibleType):
    """0.9 A list of IP addresses."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IpAddress=None):
        self.original_tagname_ = None
        super(IpAddressesType, self).__init__(VCloudExtension, )
        if IpAddress is None:
            self.IpAddress = []
        else:
            self.IpAddress = IpAddress
    def factory(*args_, **kwargs_):
        if IpAddressesType.subclass:
            return IpAddressesType.subclass(*args_, **kwargs_)
        else:
            return IpAddressesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IpAddress(self): return self.IpAddress
    def set_IpAddress(self, IpAddress): self.IpAddress = IpAddress
    def add_IpAddress(self, value): self.IpAddress.append(value)
    def insert_IpAddress_at(self, index, value): self.IpAddress.insert(index, value)
    def replace_IpAddress_at(self, index, value): self.IpAddress[index] = value
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.IpAddress or
            super(IpAddressesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpAddressesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpAddressesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpAddressesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpAddressesType'):
        super(IpAddressesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpAddressesType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpAddressesType', fromsubclass_=False, pretty_print=True):
        super(IpAddressesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for IpAddress_ in self.IpAddress:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIpAddress>%s</%sIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(IpAddress_).encode(ExternalEncoding), input_name='IpAddress'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IpAddressesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpAddressesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpAddressesType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('IpAddress=[\n')
        level += 1
        for IpAddress_ in self.IpAddress:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(IpAddress_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpAddressesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IpAddress':
            IpAddress_ = child_.text
            IpAddress_ = self.gds_validate_string(IpAddress_, node, 'IpAddress')
            self.IpAddress.append(IpAddress_)
            self.validate_IpAddressType(self.IpAddress)    # validate type IpAddressType
        super(IpAddressesType, self).buildChildren(child_, node, nodeName_, True)
# end class IpAddressesType


class NetworkConfigurationType(VCloudExtensibleType):
    """0.9 The configurations applied to a network. This is an abstract
    base type. The concrete types include those for vApp and
    Organization wide networks."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, BackwardCompatibilityMode=None, IpScope=None, IpScopes=None, ParentNetwork=None, FenceMode=None, RetainNetInfoAcrossDeployments=None, Features=None, SyslogServerSettings=None, RouterInfo=None):
        self.original_tagname_ = None
        super(NetworkConfigurationType, self).__init__(VCloudExtension, )
        self.BackwardCompatibilityMode = BackwardCompatibilityMode
        self.IpScope = IpScope
        self.IpScopes = IpScopes
        self.ParentNetwork = ParentNetwork
        self.FenceMode = FenceMode
        self.RetainNetInfoAcrossDeployments = RetainNetInfoAcrossDeployments
        self.Features = Features
        self.SyslogServerSettings = SyslogServerSettings
        self.RouterInfo = RouterInfo
    def factory(*args_, **kwargs_):
        if NetworkConfigurationType.subclass:
            return NetworkConfigurationType.subclass(*args_, **kwargs_)
        else:
            return NetworkConfigurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BackwardCompatibilityMode(self): return self.BackwardCompatibilityMode
    def set_BackwardCompatibilityMode(self, BackwardCompatibilityMode): self.BackwardCompatibilityMode = BackwardCompatibilityMode
    def get_IpScope(self): return self.IpScope
    def set_IpScope(self, IpScope): self.IpScope = IpScope
    def get_IpScopes(self): return self.IpScopes
    def set_IpScopes(self, IpScopes): self.IpScopes = IpScopes
    def get_ParentNetwork(self): return self.ParentNetwork
    def set_ParentNetwork(self, ParentNetwork): self.ParentNetwork = ParentNetwork
    def get_FenceMode(self): return self.FenceMode
    def set_FenceMode(self, FenceMode): self.FenceMode = FenceMode
    def get_RetainNetInfoAcrossDeployments(self): return self.RetainNetInfoAcrossDeployments
    def set_RetainNetInfoAcrossDeployments(self, RetainNetInfoAcrossDeployments): self.RetainNetInfoAcrossDeployments = RetainNetInfoAcrossDeployments
    def get_Features(self): return self.Features
    def set_Features(self, Features): self.Features = Features
    def get_SyslogServerSettings(self): return self.SyslogServerSettings
    def set_SyslogServerSettings(self, SyslogServerSettings): self.SyslogServerSettings = SyslogServerSettings
    def get_RouterInfo(self): return self.RouterInfo
    def set_RouterInfo(self, RouterInfo): self.RouterInfo = RouterInfo
    def hasContent_(self):
        if (
            self.BackwardCompatibilityMode is not None or
            self.IpScope is not None or
            self.IpScopes is not None or
            self.ParentNetwork is not None or
            self.FenceMode is not None or
            self.RetainNetInfoAcrossDeployments is not None or
            self.Features is not None or
            self.SyslogServerSettings is not None or
            self.RouterInfo is not None or
            super(NetworkConfigurationType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkConfigurationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConfigurationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NetworkConfigurationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkConfigurationType'):
        super(NetworkConfigurationType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkConfigurationType')
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkConfigurationType', fromsubclass_=False, pretty_print=True):
        super(NetworkConfigurationType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.BackwardCompatibilityMode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBackwardCompatibilityMode>%s</%sBackwardCompatibilityMode>%s' % (namespace_, self.gds_format_boolean(self.BackwardCompatibilityMode, input_name='BackwardCompatibilityMode'), namespace_, eol_))
        if self.IpScope is not None:
            self.IpScope.export(outfile, level, namespace_, name_='IpScope', pretty_print=pretty_print)
        if self.IpScopes is not None:
            self.IpScopes.export(outfile, level, namespace_, name_='IpScopes', pretty_print=pretty_print)
        if self.ParentNetwork is not None:
            self.ParentNetwork.export(outfile, level, namespace_, name_='ParentNetwork', pretty_print=pretty_print)
        if self.FenceMode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFenceMode>%s</%sFenceMode>%s' % (namespace_, self.gds_format_string(quote_xml(self.FenceMode).encode(ExternalEncoding), input_name='FenceMode'), namespace_, eol_))
        if self.RetainNetInfoAcrossDeployments is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRetainNetInfoAcrossDeployments>%s</%sRetainNetInfoAcrossDeployments>%s' % (namespace_, self.gds_format_boolean(self.RetainNetInfoAcrossDeployments, input_name='RetainNetInfoAcrossDeployments'), namespace_, eol_))
        if self.Features is not None:
            self.Features.export(outfile, level, namespace_, name_='Features', pretty_print=pretty_print)
        if self.SyslogServerSettings is not None:
            self.SyslogServerSettings.export(outfile, level, namespace_, name_='SyslogServerSettings', pretty_print=pretty_print)
        if self.RouterInfo is not None:
            self.RouterInfo.export(outfile, level, namespace_, name_='RouterInfo', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NetworkConfigurationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NetworkConfigurationType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NetworkConfigurationType, self).exportLiteralChildren(outfile, level, name_)
        if self.BackwardCompatibilityMode is not None:
            showIndent(outfile, level)
            outfile.write('BackwardCompatibilityMode=%s,\n' % self.BackwardCompatibilityMode)
        if self.IpScope is not None:
            showIndent(outfile, level)
            outfile.write('IpScope=model_.IpScopeType(\n')
            self.IpScope.exportLiteral(outfile, level, name_='IpScope')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IpScopes is not None:
            showIndent(outfile, level)
            outfile.write('IpScopes=model_.IpScopesType(\n')
            self.IpScopes.exportLiteral(outfile, level, name_='IpScopes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ParentNetwork is not None:
            showIndent(outfile, level)
            outfile.write('ParentNetwork=model_.ReferenceType(\n')
            self.ParentNetwork.exportLiteral(outfile, level, name_='ParentNetwork')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FenceMode is not None:
            showIndent(outfile, level)
            outfile.write('FenceMode=%s,\n' % quote_python(self.FenceMode).encode(ExternalEncoding))
        if self.RetainNetInfoAcrossDeployments is not None:
            showIndent(outfile, level)
            outfile.write('RetainNetInfoAcrossDeployments=%s,\n' % self.RetainNetInfoAcrossDeployments)
        if self.Features is not None:
            showIndent(outfile, level)
            outfile.write('Features=model_.NetworkFeaturesType(\n')
            self.Features.exportLiteral(outfile, level, name_='Features')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SyslogServerSettings is not None:
            showIndent(outfile, level)
            outfile.write('SyslogServerSettings=model_.SyslogServerSettingsType(\n')
            self.SyslogServerSettings.exportLiteral(outfile, level, name_='SyslogServerSettings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.RouterInfo is not None:
            showIndent(outfile, level)
            outfile.write('RouterInfo=model_.RouterInfoType(\n')
            self.RouterInfo.exportLiteral(outfile, level, name_='RouterInfo')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NetworkConfigurationType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BackwardCompatibilityMode':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'BackwardCompatibilityMode')
            self.BackwardCompatibilityMode = ival_
        elif nodeName_ == 'IpScope':
            obj_ = IpScopeType.factory()
            obj_.build(child_)
            self.IpScope = obj_
            obj_.original_tagname_ = 'IpScope'
        elif nodeName_ == 'IpScopes':
            obj_ = IpScopesType.factory()
            obj_.build(child_)
            self.IpScopes = obj_
            obj_.original_tagname_ = 'IpScopes'
        elif nodeName_ == 'ParentNetwork':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ParentNetwork = obj_
            obj_.original_tagname_ = 'ParentNetwork'
        elif nodeName_ == 'FenceMode':
            FenceMode_ = child_.text
            FenceMode_ = self.gds_validate_string(FenceMode_, node, 'FenceMode')
            self.FenceMode = FenceMode_
        elif nodeName_ == 'RetainNetInfoAcrossDeployments':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'RetainNetInfoAcrossDeployments')
            self.RetainNetInfoAcrossDeployments = ival_
        elif nodeName_ == 'Features':
            obj_ = NetworkFeaturesType.factory()
            obj_.build(child_)
            self.Features = obj_
            obj_.original_tagname_ = 'Features'
        elif nodeName_ == 'SyslogServerSettings':
            obj_ = SyslogServerSettingsType.factory()
            obj_.build(child_)
            self.SyslogServerSettings = obj_
            obj_.original_tagname_ = 'SyslogServerSettings'
        elif nodeName_ == 'RouterInfo':
            obj_ = RouterInfoType.factory()
            obj_.build(child_)
            self.RouterInfo = obj_
            obj_.original_tagname_ = 'RouterInfo'
        super(NetworkConfigurationType, self).buildChildren(child_, node, nodeName_, True)
# end class NetworkConfigurationType


class IpsecVpnSubnetType(VCloudExtensibleType):
    """5.1 Represents subnet details."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Name=None, Gateway=None, Netmask=None):
        self.original_tagname_ = None
        super(IpsecVpnSubnetType, self).__init__(VCloudExtension, )
        self.Name = Name
        self.Gateway = Gateway
        self.Netmask = Netmask
    def factory(*args_, **kwargs_):
        if IpsecVpnSubnetType.subclass:
            return IpsecVpnSubnetType.subclass(*args_, **kwargs_)
        else:
            return IpsecVpnSubnetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Gateway(self): return self.Gateway
    def set_Gateway(self, Gateway): self.Gateway = Gateway
    def get_Netmask(self): return self.Netmask
    def set_Netmask(self, Netmask): self.Netmask = Netmask
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Gateway is not None or
            self.Netmask is not None or
            super(IpsecVpnSubnetType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpsecVpnSubnetType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnSubnetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpsecVpnSubnetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpsecVpnSubnetType'):
        super(IpsecVpnSubnetType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnSubnetType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpsecVpnSubnetType', fromsubclass_=False, pretty_print=True):
        super(IpsecVpnSubnetType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Gateway is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sGateway>%s</%sGateway>%s' % (namespace_, self.gds_format_string(quote_xml(self.Gateway).encode(ExternalEncoding), input_name='Gateway'), namespace_, eol_))
        if self.Netmask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNetmask>%s</%sNetmask>%s' % (namespace_, self.gds_format_string(quote_xml(self.Netmask).encode(ExternalEncoding), input_name='Netmask'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IpsecVpnSubnetType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpsecVpnSubnetType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpsecVpnSubnetType, self).exportLiteralChildren(outfile, level, name_)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Gateway is not None:
            showIndent(outfile, level)
            outfile.write('Gateway=%s,\n' % quote_python(self.Gateway).encode(ExternalEncoding))
        if self.Netmask is not None:
            showIndent(outfile, level)
            outfile.write('Netmask=%s,\n' % quote_python(self.Netmask).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpsecVpnSubnetType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Gateway':
            Gateway_ = child_.text
            Gateway_ = self.gds_validate_string(Gateway_, node, 'Gateway')
            self.Gateway = Gateway_
            self.validate_IpAddressType(self.Gateway)    # validate type IpAddressType
        elif nodeName_ == 'Netmask':
            Netmask_ = child_.text
            Netmask_ = self.gds_validate_string(Netmask_, node, 'Netmask')
            self.Netmask = Netmask_
            self.validate_IpAddressType(self.Netmask)    # validate type IpAddressType
        super(IpsecVpnSubnetType, self).buildChildren(child_, node, nodeName_, True)
# end class IpsecVpnSubnetType


class GatewayIpsecVpnTunnelType(VCloudExtensibleType):
    """5.1 Represents an IPSec VPN tunnel."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Name=None, Description=None, IpsecVpnPeer=None, PeerIpAddress=None, PeerId=None, LocalIpAddress=None, LocalId=None, LocalSubnet=None, PeerSubnet=None, SharedSecret=None, SharedSecretEncrypted=None, EncryptionProtocol=None, Mtu=None, IsEnabled=None, IsOperational=None, ErrorDetails=None):
        self.original_tagname_ = None
        super(GatewayIpsecVpnTunnelType, self).__init__(VCloudExtension, )
        self.Name = Name
        self.Description = Description
        self.IpsecVpnPeer = IpsecVpnPeer
        self.PeerIpAddress = PeerIpAddress
        self.PeerId = PeerId
        self.LocalIpAddress = LocalIpAddress
        self.LocalId = LocalId
        if LocalSubnet is None:
            self.LocalSubnet = []
        else:
            self.LocalSubnet = LocalSubnet
        if PeerSubnet is None:
            self.PeerSubnet = []
        else:
            self.PeerSubnet = PeerSubnet
        self.SharedSecret = SharedSecret
        self.SharedSecretEncrypted = SharedSecretEncrypted
        self.EncryptionProtocol = EncryptionProtocol
        self.Mtu = Mtu
        self.IsEnabled = IsEnabled
        self.IsOperational = IsOperational
        self.ErrorDetails = ErrorDetails
    def factory(*args_, **kwargs_):
        if GatewayIpsecVpnTunnelType.subclass:
            return GatewayIpsecVpnTunnelType.subclass(*args_, **kwargs_)
        else:
            return GatewayIpsecVpnTunnelType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_IpsecVpnPeer(self): return self.IpsecVpnPeer
    def set_IpsecVpnPeer(self, IpsecVpnPeer): self.IpsecVpnPeer = IpsecVpnPeer
    def get_PeerIpAddress(self): return self.PeerIpAddress
    def set_PeerIpAddress(self, PeerIpAddress): self.PeerIpAddress = PeerIpAddress
    def get_PeerId(self): return self.PeerId
    def set_PeerId(self, PeerId): self.PeerId = PeerId
    def get_LocalIpAddress(self): return self.LocalIpAddress
    def set_LocalIpAddress(self, LocalIpAddress): self.LocalIpAddress = LocalIpAddress
    def get_LocalId(self): return self.LocalId
    def set_LocalId(self, LocalId): self.LocalId = LocalId
    def get_LocalSubnet(self): return self.LocalSubnet
    def set_LocalSubnet(self, LocalSubnet): self.LocalSubnet = LocalSubnet
    def add_LocalSubnet(self, value): self.LocalSubnet.append(value)
    def insert_LocalSubnet_at(self, index, value): self.LocalSubnet.insert(index, value)
    def replace_LocalSubnet_at(self, index, value): self.LocalSubnet[index] = value
    def get_PeerSubnet(self): return self.PeerSubnet
    def set_PeerSubnet(self, PeerSubnet): self.PeerSubnet = PeerSubnet
    def add_PeerSubnet(self, value): self.PeerSubnet.append(value)
    def insert_PeerSubnet_at(self, index, value): self.PeerSubnet.insert(index, value)
    def replace_PeerSubnet_at(self, index, value): self.PeerSubnet[index] = value
    def get_SharedSecret(self): return self.SharedSecret
    def set_SharedSecret(self, SharedSecret): self.SharedSecret = SharedSecret
    def get_SharedSecretEncrypted(self): return self.SharedSecretEncrypted
    def set_SharedSecretEncrypted(self, SharedSecretEncrypted): self.SharedSecretEncrypted = SharedSecretEncrypted
    def get_EncryptionProtocol(self): return self.EncryptionProtocol
    def set_EncryptionProtocol(self, EncryptionProtocol): self.EncryptionProtocol = EncryptionProtocol
    def get_Mtu(self): return self.Mtu
    def set_Mtu(self, Mtu): self.Mtu = Mtu
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_IsOperational(self): return self.IsOperational
    def set_IsOperational(self, IsOperational): self.IsOperational = IsOperational
    def get_ErrorDetails(self): return self.ErrorDetails
    def set_ErrorDetails(self, ErrorDetails): self.ErrorDetails = ErrorDetails
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Description is not None or
            self.IpsecVpnPeer is not None or
            self.PeerIpAddress is not None or
            self.PeerId is not None or
            self.LocalIpAddress is not None or
            self.LocalId is not None or
            self.LocalSubnet or
            self.PeerSubnet or
            self.SharedSecret is not None or
            self.SharedSecretEncrypted is not None or
            self.EncryptionProtocol is not None or
            self.Mtu is not None or
            self.IsEnabled is not None or
            self.IsOperational is not None or
            self.ErrorDetails is not None or
            super(GatewayIpsecVpnTunnelType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayIpsecVpnTunnelType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayIpsecVpnTunnelType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayIpsecVpnTunnelType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayIpsecVpnTunnelType'):
        super(GatewayIpsecVpnTunnelType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayIpsecVpnTunnelType')
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayIpsecVpnTunnelType', fromsubclass_=False, pretty_print=True):
        super(GatewayIpsecVpnTunnelType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        if self.IpsecVpnPeer is not None:
            self.IpsecVpnPeer.export(outfile, level, namespace_, name_='IpsecVpnPeer', pretty_print=pretty_print)
        if self.PeerIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPeerIpAddress>%s</%sPeerIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.PeerIpAddress).encode(ExternalEncoding), input_name='PeerIpAddress'), namespace_, eol_))
        if self.PeerId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPeerId>%s</%sPeerId>%s' % (namespace_, self.gds_format_string(quote_xml(self.PeerId).encode(ExternalEncoding), input_name='PeerId'), namespace_, eol_))
        if self.LocalIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLocalIpAddress>%s</%sLocalIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.LocalIpAddress).encode(ExternalEncoding), input_name='LocalIpAddress'), namespace_, eol_))
        if self.LocalId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLocalId>%s</%sLocalId>%s' % (namespace_, self.gds_format_string(quote_xml(self.LocalId).encode(ExternalEncoding), input_name='LocalId'), namespace_, eol_))
        for LocalSubnet_ in self.LocalSubnet:
            LocalSubnet_.export(outfile, level, namespace_, name_='LocalSubnet', pretty_print=pretty_print)
        for PeerSubnet_ in self.PeerSubnet:
            PeerSubnet_.export(outfile, level, namespace_, name_='PeerSubnet', pretty_print=pretty_print)
        if self.SharedSecret is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSharedSecret>%s</%sSharedSecret>%s' % (namespace_, self.gds_format_string(quote_xml(self.SharedSecret).encode(ExternalEncoding), input_name='SharedSecret'), namespace_, eol_))
        if self.SharedSecretEncrypted is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSharedSecretEncrypted>%s</%sSharedSecretEncrypted>%s' % (namespace_, self.gds_format_boolean(self.SharedSecretEncrypted, input_name='SharedSecretEncrypted'), namespace_, eol_))
        if self.EncryptionProtocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEncryptionProtocol>%s</%sEncryptionProtocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.EncryptionProtocol).encode(ExternalEncoding), input_name='EncryptionProtocol'), namespace_, eol_))
        if self.Mtu is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMtu>%s</%sMtu>%s' % (namespace_, self.gds_format_integer(self.Mtu, input_name='Mtu'), namespace_, eol_))
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
        if self.IsOperational is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsOperational>%s</%sIsOperational>%s' % (namespace_, self.gds_format_boolean(self.IsOperational, input_name='IsOperational'), namespace_, eol_))
        if self.ErrorDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sErrorDetails>%s</%sErrorDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.ErrorDetails).encode(ExternalEncoding), input_name='ErrorDetails'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='GatewayIpsecVpnTunnelType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GatewayIpsecVpnTunnelType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayIpsecVpnTunnelType, self).exportLiteralChildren(outfile, level, name_)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.IpsecVpnPeer is not None:
            showIndent(outfile, level)
            outfile.write('IpsecVpnPeer=model_.IpsecVpnPeer(\n')
            self.IpsecVpnPeer.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PeerIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('PeerIpAddress=%s,\n' % quote_python(self.PeerIpAddress).encode(ExternalEncoding))
        if self.PeerId is not None:
            showIndent(outfile, level)
            outfile.write('PeerId=%s,\n' % quote_python(self.PeerId).encode(ExternalEncoding))
        if self.LocalIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('LocalIpAddress=%s,\n' % quote_python(self.LocalIpAddress).encode(ExternalEncoding))
        if self.LocalId is not None:
            showIndent(outfile, level)
            outfile.write('LocalId=%s,\n' % quote_python(self.LocalId).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('LocalSubnet=[\n')
        level += 1
        for LocalSubnet_ in self.LocalSubnet:
            showIndent(outfile, level)
            outfile.write('model_.IpsecVpnSubnetType(\n')
            LocalSubnet_.exportLiteral(outfile, level, name_='IpsecVpnSubnetType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('PeerSubnet=[\n')
        level += 1
        for PeerSubnet_ in self.PeerSubnet:
            showIndent(outfile, level)
            outfile.write('model_.IpsecVpnSubnetType(\n')
            PeerSubnet_.exportLiteral(outfile, level, name_='IpsecVpnSubnetType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.SharedSecret is not None:
            showIndent(outfile, level)
            outfile.write('SharedSecret=%s,\n' % quote_python(self.SharedSecret).encode(ExternalEncoding))
        if self.SharedSecretEncrypted is not None:
            showIndent(outfile, level)
            outfile.write('SharedSecretEncrypted=%s,\n' % self.SharedSecretEncrypted)
        if self.EncryptionProtocol is not None:
            showIndent(outfile, level)
            outfile.write('EncryptionProtocol=%s,\n' % quote_python(self.EncryptionProtocol).encode(ExternalEncoding))
        if self.Mtu is not None:
            showIndent(outfile, level)
            outfile.write('Mtu=%d,\n' % self.Mtu)
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
        if self.IsOperational is not None:
            showIndent(outfile, level)
            outfile.write('IsOperational=%s,\n' % self.IsOperational)
        if self.ErrorDetails is not None:
            showIndent(outfile, level)
            outfile.write('ErrorDetails=%s,\n' % quote_python(self.ErrorDetails).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GatewayIpsecVpnTunnelType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'IpsecVpnPeer':
            class_obj_ = self.get_class_obj_(child_, IpsecVpnPeerType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.IpsecVpnPeer = obj_
            obj_.original_tagname_ = 'IpsecVpnPeer'
        elif nodeName_ == 'IpsecVpnLocalPeer':
            obj_ = IpsecVpnLocalPeerType.factory()
            obj_.build(child_)
            self.IpsecVpnPeer = obj_
            obj_.original_tagname_ = 'IpsecVpnLocalPeer'
        elif nodeName_ == 'IpsecVpnRemotePeer':
            obj_ = IpsecVpnRemotePeerType.factory()
            obj_.build(child_)
            self.IpsecVpnPeer = obj_
            obj_.original_tagname_ = 'IpsecVpnRemotePeer'
        elif nodeName_ == 'IpsecVpnThirdPartyPeer':
            obj_ = IpsecVpnThirdPartyPeerType.factory()
            obj_.build(child_)
            self.IpsecVpnPeer = obj_
            obj_.original_tagname_ = 'IpsecVpnThirdPartyPeer'
        elif nodeName_ == 'PeerIpAddress':
            PeerIpAddress_ = child_.text
            PeerIpAddress_ = self.gds_validate_string(PeerIpAddress_, node, 'PeerIpAddress')
            self.PeerIpAddress = PeerIpAddress_
            self.validate_IpAddressType(self.PeerIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'PeerId':
            PeerId_ = child_.text
            PeerId_ = self.gds_validate_string(PeerId_, node, 'PeerId')
            self.PeerId = PeerId_
        elif nodeName_ == 'LocalIpAddress':
            LocalIpAddress_ = child_.text
            LocalIpAddress_ = self.gds_validate_string(LocalIpAddress_, node, 'LocalIpAddress')
            self.LocalIpAddress = LocalIpAddress_
            self.validate_IpAddressType(self.LocalIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'LocalId':
            LocalId_ = child_.text
            LocalId_ = self.gds_validate_string(LocalId_, node, 'LocalId')
            self.LocalId = LocalId_
        elif nodeName_ == 'LocalSubnet':
            obj_ = IpsecVpnSubnetType.factory()
            obj_.build(child_)
            self.LocalSubnet.append(obj_)
            obj_.original_tagname_ = 'LocalSubnet'
        elif nodeName_ == 'PeerSubnet':
            obj_ = IpsecVpnSubnetType.factory()
            obj_.build(child_)
            self.PeerSubnet.append(obj_)
            obj_.original_tagname_ = 'PeerSubnet'
        elif nodeName_ == 'SharedSecret':
            SharedSecret_ = child_.text
            SharedSecret_ = self.gds_validate_string(SharedSecret_, node, 'SharedSecret')
            self.SharedSecret = SharedSecret_
        elif nodeName_ == 'SharedSecretEncrypted':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SharedSecretEncrypted')
            self.SharedSecretEncrypted = ival_
        elif nodeName_ == 'EncryptionProtocol':
            EncryptionProtocol_ = child_.text
            EncryptionProtocol_ = self.gds_validate_string(EncryptionProtocol_, node, 'EncryptionProtocol')
            self.EncryptionProtocol = EncryptionProtocol_
        elif nodeName_ == 'Mtu':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Mtu')
            self.Mtu = ival_
        elif nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'IsOperational':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsOperational')
            self.IsOperational = ival_
        elif nodeName_ == 'ErrorDetails':
            ErrorDetails_ = child_.text
            ErrorDetails_ = self.gds_validate_string(ErrorDetails_, node, 'ErrorDetails')
            self.ErrorDetails = ErrorDetails_
        super(GatewayIpsecVpnTunnelType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayIpsecVpnTunnelType


class GatewayIpsecVpnEndpointType(VCloudExtensibleType):
    """5.1 Represents an IPSec VPN endpoint."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Network=None, PublicIp=None):
        self.original_tagname_ = None
        super(GatewayIpsecVpnEndpointType, self).__init__(VCloudExtension, )
        self.Network = Network
        self.PublicIp = PublicIp
    def factory(*args_, **kwargs_):
        if GatewayIpsecVpnEndpointType.subclass:
            return GatewayIpsecVpnEndpointType.subclass(*args_, **kwargs_)
        else:
            return GatewayIpsecVpnEndpointType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Network(self): return self.Network
    def set_Network(self, Network): self.Network = Network
    def get_PublicIp(self): return self.PublicIp
    def set_PublicIp(self, PublicIp): self.PublicIp = PublicIp
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Network is not None or
            self.PublicIp is not None or
            super(GatewayIpsecVpnEndpointType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayIpsecVpnEndpointType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayIpsecVpnEndpointType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayIpsecVpnEndpointType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayIpsecVpnEndpointType'):
        super(GatewayIpsecVpnEndpointType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayIpsecVpnEndpointType')
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayIpsecVpnEndpointType', fromsubclass_=False, pretty_print=True):
        super(GatewayIpsecVpnEndpointType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Network is not None:
            self.Network.export(outfile, level, namespace_, name_='Network', pretty_print=pretty_print)
        if self.PublicIp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPublicIp>%s</%sPublicIp>%s' % (namespace_, self.gds_format_string(quote_xml(self.PublicIp).encode(ExternalEncoding), input_name='PublicIp'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='GatewayIpsecVpnEndpointType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GatewayIpsecVpnEndpointType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayIpsecVpnEndpointType, self).exportLiteralChildren(outfile, level, name_)
        if self.Network is not None:
            showIndent(outfile, level)
            outfile.write('Network=model_.ReferenceType(\n')
            self.Network.exportLiteral(outfile, level, name_='Network')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PublicIp is not None:
            showIndent(outfile, level)
            outfile.write('PublicIp=%s,\n' % quote_python(self.PublicIp).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GatewayIpsecVpnEndpointType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Network':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Network = obj_
            obj_.original_tagname_ = 'Network'
        elif nodeName_ == 'PublicIp':
            PublicIp_ = child_.text
            PublicIp_ = self.gds_validate_string(PublicIp_, node, 'PublicIp')
            self.PublicIp = PublicIp_
            self.validate_IpAddressType(self.PublicIp)    # validate type IpAddressType
        super(GatewayIpsecVpnEndpointType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayIpsecVpnEndpointType


class LBPoolHealthCheckType(VCloudExtensibleType):
    """5.1 Represents a service port health check list."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Mode=None, Uri=None, HealthThreshold=None, UnhealthThreshold=None, Interval=None, Timeout=None):
        self.original_tagname_ = None
        super(LBPoolHealthCheckType, self).__init__(VCloudExtension, )
        self.Mode = Mode
        self.Uri = Uri
        self.HealthThreshold = HealthThreshold
        self.UnhealthThreshold = UnhealthThreshold
        self.Interval = Interval
        self.Timeout = Timeout
    def factory(*args_, **kwargs_):
        if LBPoolHealthCheckType.subclass:
            return LBPoolHealthCheckType.subclass(*args_, **kwargs_)
        else:
            return LBPoolHealthCheckType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Mode(self): return self.Mode
    def set_Mode(self, Mode): self.Mode = Mode
    def get_Uri(self): return self.Uri
    def set_Uri(self, Uri): self.Uri = Uri
    def get_HealthThreshold(self): return self.HealthThreshold
    def set_HealthThreshold(self, HealthThreshold): self.HealthThreshold = HealthThreshold
    def get_UnhealthThreshold(self): return self.UnhealthThreshold
    def set_UnhealthThreshold(self, UnhealthThreshold): self.UnhealthThreshold = UnhealthThreshold
    def get_Interval(self): return self.Interval
    def set_Interval(self, Interval): self.Interval = Interval
    def get_Timeout(self): return self.Timeout
    def set_Timeout(self, Timeout): self.Timeout = Timeout
    def hasContent_(self):
        if (
            self.Mode is not None or
            self.Uri is not None or
            self.HealthThreshold is not None or
            self.UnhealthThreshold is not None or
            self.Interval is not None or
            self.Timeout is not None or
            super(LBPoolHealthCheckType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LBPoolHealthCheckType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LBPoolHealthCheckType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LBPoolHealthCheckType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LBPoolHealthCheckType'):
        super(LBPoolHealthCheckType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LBPoolHealthCheckType')
    def exportChildren(self, outfile, level, namespace_='', name_='LBPoolHealthCheckType', fromsubclass_=False, pretty_print=True):
        super(LBPoolHealthCheckType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Mode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMode>%s</%sMode>%s' % (namespace_, self.gds_format_string(quote_xml(self.Mode).encode(ExternalEncoding), input_name='Mode'), namespace_, eol_))
        if self.Uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUri>%s</%sUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.Uri).encode(ExternalEncoding), input_name='Uri'), namespace_, eol_))
        if self.HealthThreshold is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHealthThreshold>%s</%sHealthThreshold>%s' % (namespace_, self.gds_format_string(quote_xml(self.HealthThreshold).encode(ExternalEncoding), input_name='HealthThreshold'), namespace_, eol_))
        if self.UnhealthThreshold is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUnhealthThreshold>%s</%sUnhealthThreshold>%s' % (namespace_, self.gds_format_string(quote_xml(self.UnhealthThreshold).encode(ExternalEncoding), input_name='UnhealthThreshold'), namespace_, eol_))
        if self.Interval is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInterval>%s</%sInterval>%s' % (namespace_, self.gds_format_string(quote_xml(self.Interval).encode(ExternalEncoding), input_name='Interval'), namespace_, eol_))
        if self.Timeout is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTimeout>%s</%sTimeout>%s' % (namespace_, self.gds_format_string(quote_xml(self.Timeout).encode(ExternalEncoding), input_name='Timeout'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='LBPoolHealthCheckType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LBPoolHealthCheckType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LBPoolHealthCheckType, self).exportLiteralChildren(outfile, level, name_)
        if self.Mode is not None:
            showIndent(outfile, level)
            outfile.write('Mode=%s,\n' % quote_python(self.Mode).encode(ExternalEncoding))
        if self.Uri is not None:
            showIndent(outfile, level)
            outfile.write('Uri=%s,\n' % quote_python(self.Uri).encode(ExternalEncoding))
        if self.HealthThreshold is not None:
            showIndent(outfile, level)
            outfile.write('HealthThreshold=%s,\n' % quote_python(self.HealthThreshold).encode(ExternalEncoding))
        if self.UnhealthThreshold is not None:
            showIndent(outfile, level)
            outfile.write('UnhealthThreshold=%s,\n' % quote_python(self.UnhealthThreshold).encode(ExternalEncoding))
        if self.Interval is not None:
            showIndent(outfile, level)
            outfile.write('Interval=%s,\n' % quote_python(self.Interval).encode(ExternalEncoding))
        if self.Timeout is not None:
            showIndent(outfile, level)
            outfile.write('Timeout=%s,\n' % quote_python(self.Timeout).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LBPoolHealthCheckType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Mode':
            Mode_ = child_.text
            Mode_ = self.gds_validate_string(Mode_, node, 'Mode')
            self.Mode = Mode_
        elif nodeName_ == 'Uri':
            Uri_ = child_.text
            Uri_ = self.gds_validate_string(Uri_, node, 'Uri')
            self.Uri = Uri_
        elif nodeName_ == 'HealthThreshold':
            HealthThreshold_ = child_.text
            HealthThreshold_ = self.gds_validate_string(HealthThreshold_, node, 'HealthThreshold')
            self.HealthThreshold = HealthThreshold_
        elif nodeName_ == 'UnhealthThreshold':
            UnhealthThreshold_ = child_.text
            UnhealthThreshold_ = self.gds_validate_string(UnhealthThreshold_, node, 'UnhealthThreshold')
            self.UnhealthThreshold = UnhealthThreshold_
        elif nodeName_ == 'Interval':
            Interval_ = child_.text
            Interval_ = self.gds_validate_string(Interval_, node, 'Interval')
            self.Interval = Interval_
        elif nodeName_ == 'Timeout':
            Timeout_ = child_.text
            Timeout_ = self.gds_validate_string(Timeout_, node, 'Timeout')
            self.Timeout = Timeout_
        super(LBPoolHealthCheckType, self).buildChildren(child_, node, nodeName_, True)
# end class LBPoolHealthCheckType


class LBPoolMemberType(VCloudExtensibleType):
    """5.1 Represents a member in a load balancer pool."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IpAddress=None, Weight=None, ServicePort=None):
        self.original_tagname_ = None
        super(LBPoolMemberType, self).__init__(VCloudExtension, )
        self.IpAddress = IpAddress
        self.Weight = Weight
        if ServicePort is None:
            self.ServicePort = []
        else:
            self.ServicePort = ServicePort
    def factory(*args_, **kwargs_):
        if LBPoolMemberType.subclass:
            return LBPoolMemberType.subclass(*args_, **kwargs_)
        else:
            return LBPoolMemberType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IpAddress(self): return self.IpAddress
    def set_IpAddress(self, IpAddress): self.IpAddress = IpAddress
    def get_Weight(self): return self.Weight
    def set_Weight(self, Weight): self.Weight = Weight
    def get_ServicePort(self): return self.ServicePort
    def set_ServicePort(self, ServicePort): self.ServicePort = ServicePort
    def add_ServicePort(self, value): self.ServicePort.append(value)
    def insert_ServicePort_at(self, index, value): self.ServicePort.insert(index, value)
    def replace_ServicePort_at(self, index, value): self.ServicePort[index] = value
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.IpAddress is not None or
            self.Weight is not None or
            self.ServicePort or
            super(LBPoolMemberType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LBPoolMemberType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LBPoolMemberType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LBPoolMemberType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LBPoolMemberType'):
        super(LBPoolMemberType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LBPoolMemberType')
    def exportChildren(self, outfile, level, namespace_='', name_='LBPoolMemberType', fromsubclass_=False, pretty_print=True):
        super(LBPoolMemberType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIpAddress>%s</%sIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.IpAddress).encode(ExternalEncoding), input_name='IpAddress'), namespace_, eol_))
        if self.Weight is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespace_, self.gds_format_string(quote_xml(self.Weight).encode(ExternalEncoding), input_name='Weight'), namespace_, eol_))
        for ServicePort_ in self.ServicePort:
            ServicePort_.export(outfile, level, namespace_, name_='ServicePort', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LBPoolMemberType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LBPoolMemberType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LBPoolMemberType, self).exportLiteralChildren(outfile, level, name_)
        if self.IpAddress is not None:
            showIndent(outfile, level)
            outfile.write('IpAddress=%s,\n' % quote_python(self.IpAddress).encode(ExternalEncoding))
        if self.Weight is not None:
            showIndent(outfile, level)
            outfile.write('Weight=%s,\n' % quote_python(self.Weight).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('ServicePort=[\n')
        level += 1
        for ServicePort_ in self.ServicePort:
            showIndent(outfile, level)
            outfile.write('model_.LBPoolServicePortType(\n')
            ServicePort_.exportLiteral(outfile, level, name_='LBPoolServicePortType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LBPoolMemberType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IpAddress':
            IpAddress_ = child_.text
            IpAddress_ = self.gds_validate_string(IpAddress_, node, 'IpAddress')
            self.IpAddress = IpAddress_
            self.validate_IpAddressType(self.IpAddress)    # validate type IpAddressType
        elif nodeName_ == 'Weight':
            Weight_ = child_.text
            Weight_ = self.gds_validate_string(Weight_, node, 'Weight')
            self.Weight = Weight_
        elif nodeName_ == 'ServicePort':
            obj_ = LBPoolServicePortType.factory()
            obj_.build(child_)
            self.ServicePort.append(obj_)
            obj_.original_tagname_ = 'ServicePort'
        super(LBPoolMemberType, self).buildChildren(child_, node, nodeName_, True)
# end class LBPoolMemberType


class LBPersistenceType(VCloudExtensibleType):
    """5.1 Represents persistence type for a load balancer service profile."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Method=None, CookieName=None, CookieMode=None):
        self.original_tagname_ = None
        super(LBPersistenceType, self).__init__(VCloudExtension, )
        self.Method = Method
        self.CookieName = CookieName
        self.CookieMode = CookieMode
    def factory(*args_, **kwargs_):
        if LBPersistenceType.subclass:
            return LBPersistenceType.subclass(*args_, **kwargs_)
        else:
            return LBPersistenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Method(self): return self.Method
    def set_Method(self, Method): self.Method = Method
    def get_CookieName(self): return self.CookieName
    def set_CookieName(self, CookieName): self.CookieName = CookieName
    def get_CookieMode(self): return self.CookieMode
    def set_CookieMode(self, CookieMode): self.CookieMode = CookieMode
    def hasContent_(self):
        if (
            self.Method is not None or
            self.CookieName is not None or
            self.CookieMode is not None or
            super(LBPersistenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LBPersistenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LBPersistenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LBPersistenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LBPersistenceType'):
        super(LBPersistenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LBPersistenceType')
    def exportChildren(self, outfile, level, namespace_='', name_='LBPersistenceType', fromsubclass_=False, pretty_print=True):
        super(LBPersistenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMethod>%s</%sMethod>%s' % (namespace_, self.gds_format_string(quote_xml(self.Method).encode(ExternalEncoding), input_name='Method'), namespace_, eol_))
        if self.CookieName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCookieName>%s</%sCookieName>%s' % (namespace_, self.gds_format_string(quote_xml(self.CookieName).encode(ExternalEncoding), input_name='CookieName'), namespace_, eol_))
        if self.CookieMode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCookieMode>%s</%sCookieMode>%s' % (namespace_, self.gds_format_string(quote_xml(self.CookieMode).encode(ExternalEncoding), input_name='CookieMode'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='LBPersistenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LBPersistenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LBPersistenceType, self).exportLiteralChildren(outfile, level, name_)
        if self.Method is not None:
            showIndent(outfile, level)
            outfile.write('Method=%s,\n' % quote_python(self.Method).encode(ExternalEncoding))
        if self.CookieName is not None:
            showIndent(outfile, level)
            outfile.write('CookieName=%s,\n' % quote_python(self.CookieName).encode(ExternalEncoding))
        if self.CookieMode is not None:
            showIndent(outfile, level)
            outfile.write('CookieMode=%s,\n' % quote_python(self.CookieMode).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LBPersistenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Method':
            Method_ = child_.text
            Method_ = self.gds_validate_string(Method_, node, 'Method')
            self.Method = Method_
        elif nodeName_ == 'CookieName':
            CookieName_ = child_.text
            CookieName_ = self.gds_validate_string(CookieName_, node, 'CookieName')
            self.CookieName = CookieName_
        elif nodeName_ == 'CookieMode':
            CookieMode_ = child_.text
            CookieMode_ = self.gds_validate_string(CookieMode_, node, 'CookieMode')
            self.CookieMode = CookieMode_
        super(LBPersistenceType, self).buildChildren(child_, node, nodeName_, True)
# end class LBPersistenceType


class LBVirtualServerServiceProfileType(VCloudExtensibleType):
    """5.1 Represents service profile for a load balancing virtual server."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IsEnabled=None, Protocol=None, Port=None, Persistence=None):
        self.original_tagname_ = None
        super(LBVirtualServerServiceProfileType, self).__init__(VCloudExtension, )
        self.IsEnabled = IsEnabled
        self.Protocol = Protocol
        self.Port = Port
        self.Persistence = Persistence
    def factory(*args_, **kwargs_):
        if LBVirtualServerServiceProfileType.subclass:
            return LBVirtualServerServiceProfileType.subclass(*args_, **kwargs_)
        else:
            return LBVirtualServerServiceProfileType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_Protocol(self): return self.Protocol
    def set_Protocol(self, Protocol): self.Protocol = Protocol
    def get_Port(self): return self.Port
    def set_Port(self, Port): self.Port = Port
    def get_Persistence(self): return self.Persistence
    def set_Persistence(self, Persistence): self.Persistence = Persistence
    def hasContent_(self):
        if (
            self.IsEnabled is not None or
            self.Protocol is not None or
            self.Port is not None or
            self.Persistence is not None or
            super(LBVirtualServerServiceProfileType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LBVirtualServerServiceProfileType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LBVirtualServerServiceProfileType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LBVirtualServerServiceProfileType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LBVirtualServerServiceProfileType'):
        super(LBVirtualServerServiceProfileType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LBVirtualServerServiceProfileType')
    def exportChildren(self, outfile, level, namespace_='', name_='LBVirtualServerServiceProfileType', fromsubclass_=False, pretty_print=True):
        super(LBVirtualServerServiceProfileType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
        if self.Protocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProtocol>%s</%sProtocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.Protocol).encode(ExternalEncoding), input_name='Protocol'), namespace_, eol_))
        if self.Port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPort>%s</%sPort>%s' % (namespace_, self.gds_format_string(quote_xml(self.Port).encode(ExternalEncoding), input_name='Port'), namespace_, eol_))
        if self.Persistence is not None:
            self.Persistence.export(outfile, level, namespace_, name_='Persistence', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LBVirtualServerServiceProfileType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LBVirtualServerServiceProfileType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LBVirtualServerServiceProfileType, self).exportLiteralChildren(outfile, level, name_)
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
        if self.Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Protocol=%s,\n' % quote_python(self.Protocol).encode(ExternalEncoding))
        if self.Port is not None:
            showIndent(outfile, level)
            outfile.write('Port=%s,\n' % quote_python(self.Port).encode(ExternalEncoding))
        if self.Persistence is not None:
            showIndent(outfile, level)
            outfile.write('Persistence=model_.LBPersistenceType(\n')
            self.Persistence.exportLiteral(outfile, level, name_='Persistence')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LBVirtualServerServiceProfileType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'Protocol':
            Protocol_ = child_.text
            Protocol_ = self.gds_validate_string(Protocol_, node, 'Protocol')
            self.Protocol = Protocol_
        elif nodeName_ == 'Port':
            Port_ = child_.text
            Port_ = self.gds_validate_string(Port_, node, 'Port')
            self.Port = Port_
        elif nodeName_ == 'Persistence':
            obj_ = LBPersistenceType.factory()
            obj_.build(child_)
            self.Persistence = obj_
            obj_.original_tagname_ = 'Persistence'
        super(LBVirtualServerServiceProfileType, self).buildChildren(child_, node, nodeName_, True)
# end class LBVirtualServerServiceProfileType


class LBPoolServicePortType(VCloudExtensibleType):
    """5.1 Represents a service port in a load balancer pool."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IsEnabled=None, Protocol=None, Algorithm=None, Port=None, HealthCheckPort=None, HealthCheck=None):
        self.original_tagname_ = None
        super(LBPoolServicePortType, self).__init__(VCloudExtension, )
        self.IsEnabled = IsEnabled
        self.Protocol = Protocol
        self.Algorithm = Algorithm
        self.Port = Port
        self.HealthCheckPort = HealthCheckPort
        if HealthCheck is None:
            self.HealthCheck = []
        else:
            self.HealthCheck = HealthCheck
    def factory(*args_, **kwargs_):
        if LBPoolServicePortType.subclass:
            return LBPoolServicePortType.subclass(*args_, **kwargs_)
        else:
            return LBPoolServicePortType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_Protocol(self): return self.Protocol
    def set_Protocol(self, Protocol): self.Protocol = Protocol
    def get_Algorithm(self): return self.Algorithm
    def set_Algorithm(self, Algorithm): self.Algorithm = Algorithm
    def get_Port(self): return self.Port
    def set_Port(self, Port): self.Port = Port
    def get_HealthCheckPort(self): return self.HealthCheckPort
    def set_HealthCheckPort(self, HealthCheckPort): self.HealthCheckPort = HealthCheckPort
    def get_HealthCheck(self): return self.HealthCheck
    def set_HealthCheck(self, HealthCheck): self.HealthCheck = HealthCheck
    def add_HealthCheck(self, value): self.HealthCheck.append(value)
    def insert_HealthCheck_at(self, index, value): self.HealthCheck.insert(index, value)
    def replace_HealthCheck_at(self, index, value): self.HealthCheck[index] = value
    def hasContent_(self):
        if (
            self.IsEnabled is not None or
            self.Protocol is not None or
            self.Algorithm is not None or
            self.Port is not None or
            self.HealthCheckPort is not None or
            self.HealthCheck or
            super(LBPoolServicePortType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LBPoolServicePortType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LBPoolServicePortType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LBPoolServicePortType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LBPoolServicePortType'):
        super(LBPoolServicePortType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LBPoolServicePortType')
    def exportChildren(self, outfile, level, namespace_='', name_='LBPoolServicePortType', fromsubclass_=False, pretty_print=True):
        super(LBPoolServicePortType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
        if self.Protocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProtocol>%s</%sProtocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.Protocol).encode(ExternalEncoding), input_name='Protocol'), namespace_, eol_))
        if self.Algorithm is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAlgorithm>%s</%sAlgorithm>%s' % (namespace_, self.gds_format_string(quote_xml(self.Algorithm).encode(ExternalEncoding), input_name='Algorithm'), namespace_, eol_))
        if self.Port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPort>%s</%sPort>%s' % (namespace_, self.gds_format_string(quote_xml(self.Port).encode(ExternalEncoding), input_name='Port'), namespace_, eol_))
        if self.HealthCheckPort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHealthCheckPort>%s</%sHealthCheckPort>%s' % (namespace_, self.gds_format_string(quote_xml(self.HealthCheckPort).encode(ExternalEncoding), input_name='HealthCheckPort'), namespace_, eol_))
        for HealthCheck_ in self.HealthCheck:
            HealthCheck_.export(outfile, level, namespace_, name_='HealthCheck', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LBPoolServicePortType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LBPoolServicePortType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LBPoolServicePortType, self).exportLiteralChildren(outfile, level, name_)
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
        if self.Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Protocol=%s,\n' % quote_python(self.Protocol).encode(ExternalEncoding))
        if self.Algorithm is not None:
            showIndent(outfile, level)
            outfile.write('Algorithm=%s,\n' % quote_python(self.Algorithm).encode(ExternalEncoding))
        if self.Port is not None:
            showIndent(outfile, level)
            outfile.write('Port=%s,\n' % quote_python(self.Port).encode(ExternalEncoding))
        if self.HealthCheckPort is not None:
            showIndent(outfile, level)
            outfile.write('HealthCheckPort=%s,\n' % quote_python(self.HealthCheckPort).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('HealthCheck=[\n')
        level += 1
        for HealthCheck_ in self.HealthCheck:
            showIndent(outfile, level)
            outfile.write('model_.LBPoolHealthCheckType(\n')
            HealthCheck_.exportLiteral(outfile, level, name_='LBPoolHealthCheckType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LBPoolServicePortType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'Protocol':
            Protocol_ = child_.text
            Protocol_ = self.gds_validate_string(Protocol_, node, 'Protocol')
            self.Protocol = Protocol_
        elif nodeName_ == 'Algorithm':
            Algorithm_ = child_.text
            Algorithm_ = self.gds_validate_string(Algorithm_, node, 'Algorithm')
            self.Algorithm = Algorithm_
        elif nodeName_ == 'Port':
            Port_ = child_.text
            Port_ = self.gds_validate_string(Port_, node, 'Port')
            self.Port = Port_
        elif nodeName_ == 'HealthCheckPort':
            HealthCheckPort_ = child_.text
            HealthCheckPort_ = self.gds_validate_string(HealthCheckPort_, node, 'HealthCheckPort')
            self.HealthCheckPort = HealthCheckPort_
        elif nodeName_ == 'HealthCheck':
            obj_ = LBPoolHealthCheckType.factory()
            obj_.build(child_)
            self.HealthCheck.append(obj_)
            obj_.original_tagname_ = 'HealthCheck'
        super(LBPoolServicePortType, self).buildChildren(child_, node, nodeName_, True)
# end class LBPoolServicePortType


class LoadBalancerVirtualServerType(VCloudExtensibleType):
    """5.1 Represents a load balancer virtual server."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IsEnabled=None, Name=None, Description=None, Interface=None, IpAddress=None, ServiceProfile=None, Logging=None, Pool=None, LoadBalancerTemplates=None):
        self.original_tagname_ = None
        super(LoadBalancerVirtualServerType, self).__init__(VCloudExtension, )
        self.IsEnabled = IsEnabled
        self.Name = Name
        self.Description = Description
        self.Interface = Interface
        self.IpAddress = IpAddress
        if ServiceProfile is None:
            self.ServiceProfile = []
        else:
            self.ServiceProfile = ServiceProfile
        self.Logging = Logging
        self.Pool = Pool
        if LoadBalancerTemplates is None:
            self.LoadBalancerTemplates = []
        else:
            self.LoadBalancerTemplates = LoadBalancerTemplates
    def factory(*args_, **kwargs_):
        if LoadBalancerVirtualServerType.subclass:
            return LoadBalancerVirtualServerType.subclass(*args_, **kwargs_)
        else:
            return LoadBalancerVirtualServerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Interface(self): return self.Interface
    def set_Interface(self, Interface): self.Interface = Interface
    def get_IpAddress(self): return self.IpAddress
    def set_IpAddress(self, IpAddress): self.IpAddress = IpAddress
    def get_ServiceProfile(self): return self.ServiceProfile
    def set_ServiceProfile(self, ServiceProfile): self.ServiceProfile = ServiceProfile
    def add_ServiceProfile(self, value): self.ServiceProfile.append(value)
    def insert_ServiceProfile_at(self, index, value): self.ServiceProfile.insert(index, value)
    def replace_ServiceProfile_at(self, index, value): self.ServiceProfile[index] = value
    def get_Logging(self): return self.Logging
    def set_Logging(self, Logging): self.Logging = Logging
    def get_Pool(self): return self.Pool
    def set_Pool(self, Pool): self.Pool = Pool
    def get_LoadBalancerTemplates(self): return self.LoadBalancerTemplates
    def set_LoadBalancerTemplates(self, LoadBalancerTemplates): self.LoadBalancerTemplates = LoadBalancerTemplates
    def add_LoadBalancerTemplates(self, value): self.LoadBalancerTemplates.append(value)
    def insert_LoadBalancerTemplates_at(self, index, value): self.LoadBalancerTemplates.insert(index, value)
    def replace_LoadBalancerTemplates_at(self, index, value): self.LoadBalancerTemplates[index] = value
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.IsEnabled is not None or
            self.Name is not None or
            self.Description is not None or
            self.Interface is not None or
            self.IpAddress is not None or
            self.ServiceProfile or
            self.Logging is not None or
            self.Pool is not None or
            self.LoadBalancerTemplates or
            super(LoadBalancerVirtualServerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LoadBalancerVirtualServerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LoadBalancerVirtualServerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LoadBalancerVirtualServerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LoadBalancerVirtualServerType'):
        super(LoadBalancerVirtualServerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LoadBalancerVirtualServerType')
    def exportChildren(self, outfile, level, namespace_='', name_='LoadBalancerVirtualServerType', fromsubclass_=False, pretty_print=True):
        super(LoadBalancerVirtualServerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        if self.Interface is not None:
            self.Interface.export(outfile, level, namespace_, name_='Interface', pretty_print=pretty_print)
        if self.IpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIpAddress>%s</%sIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.IpAddress).encode(ExternalEncoding), input_name='IpAddress'), namespace_, eol_))
        for ServiceProfile_ in self.ServiceProfile:
            ServiceProfile_.export(outfile, level, namespace_, name_='ServiceProfile', pretty_print=pretty_print)
        if self.Logging is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLogging>%s</%sLogging>%s' % (namespace_, self.gds_format_boolean(self.Logging, input_name='Logging'), namespace_, eol_))
        if self.Pool is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPool>%s</%sPool>%s' % (namespace_, self.gds_format_string(quote_xml(self.Pool).encode(ExternalEncoding), input_name='Pool'), namespace_, eol_))
        for LoadBalancerTemplates_ in self.LoadBalancerTemplates:
            LoadBalancerTemplates_.export(outfile, level, namespace_, name_='LoadBalancerTemplates', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LoadBalancerVirtualServerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LoadBalancerVirtualServerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LoadBalancerVirtualServerType, self).exportLiteralChildren(outfile, level, name_)
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.Interface is not None:
            showIndent(outfile, level)
            outfile.write('Interface=model_.ReferenceType(\n')
            self.Interface.exportLiteral(outfile, level, name_='Interface')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IpAddress is not None:
            showIndent(outfile, level)
            outfile.write('IpAddress=%s,\n' % quote_python(self.IpAddress).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('ServiceProfile=[\n')
        level += 1
        for ServiceProfile_ in self.ServiceProfile:
            showIndent(outfile, level)
            outfile.write('model_.LBVirtualServerServiceProfileType(\n')
            ServiceProfile_.exportLiteral(outfile, level, name_='LBVirtualServerServiceProfileType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Logging is not None:
            showIndent(outfile, level)
            outfile.write('Logging=%s,\n' % self.Logging)
        if self.Pool is not None:
            showIndent(outfile, level)
            outfile.write('Pool=%s,\n' % quote_python(self.Pool).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('LoadBalancerTemplates=[\n')
        level += 1
        for LoadBalancerTemplates_ in self.LoadBalancerTemplates:
            showIndent(outfile, level)
            outfile.write('model_.VendorTemplateType(\n')
            LoadBalancerTemplates_.exportLiteral(outfile, level, name_='VendorTemplateType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LoadBalancerVirtualServerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Interface':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Interface = obj_
            obj_.original_tagname_ = 'Interface'
        elif nodeName_ == 'IpAddress':
            IpAddress_ = child_.text
            IpAddress_ = self.gds_validate_string(IpAddress_, node, 'IpAddress')
            self.IpAddress = IpAddress_
            self.validate_IpAddressType(self.IpAddress)    # validate type IpAddressType
        elif nodeName_ == 'ServiceProfile':
            obj_ = LBVirtualServerServiceProfileType.factory()
            obj_.build(child_)
            self.ServiceProfile.append(obj_)
            obj_.original_tagname_ = 'ServiceProfile'
        elif nodeName_ == 'Logging':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Logging')
            self.Logging = ival_
        elif nodeName_ == 'Pool':
            Pool_ = child_.text
            Pool_ = self.gds_validate_string(Pool_, node, 'Pool')
            self.Pool = Pool_
        elif nodeName_ == 'LoadBalancerTemplates':
            obj_ = VendorTemplateType.factory()
            obj_.build(child_)
            self.LoadBalancerTemplates.append(obj_)
            obj_.original_tagname_ = 'LoadBalancerTemplates'
        super(LoadBalancerVirtualServerType, self).buildChildren(child_, node, nodeName_, True)
# end class LoadBalancerVirtualServerType


class LoadBalancerPoolType(VCloudExtensibleType):
    """5.1 Represents a load balancer pool."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Id=None, Name=None, Description=None, ServicePort=None, Member=None, Operational=None, ErrorDetails=None):
        self.original_tagname_ = None
        super(LoadBalancerPoolType, self).__init__(VCloudExtension, )
        self.Id = Id
        self.Name = Name
        self.Description = Description
        if ServicePort is None:
            self.ServicePort = []
        else:
            self.ServicePort = ServicePort
        if Member is None:
            self.Member = []
        else:
            self.Member = Member
        self.Operational = Operational
        self.ErrorDetails = ErrorDetails
    def factory(*args_, **kwargs_):
        if LoadBalancerPoolType.subclass:
            return LoadBalancerPoolType.subclass(*args_, **kwargs_)
        else:
            return LoadBalancerPoolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_ServicePort(self): return self.ServicePort
    def set_ServicePort(self, ServicePort): self.ServicePort = ServicePort
    def add_ServicePort(self, value): self.ServicePort.append(value)
    def insert_ServicePort_at(self, index, value): self.ServicePort.insert(index, value)
    def replace_ServicePort_at(self, index, value): self.ServicePort[index] = value
    def get_Member(self): return self.Member
    def set_Member(self, Member): self.Member = Member
    def add_Member(self, value): self.Member.append(value)
    def insert_Member_at(self, index, value): self.Member.insert(index, value)
    def replace_Member_at(self, index, value): self.Member[index] = value
    def get_Operational(self): return self.Operational
    def set_Operational(self, Operational): self.Operational = Operational
    def get_ErrorDetails(self): return self.ErrorDetails
    def set_ErrorDetails(self, ErrorDetails): self.ErrorDetails = ErrorDetails
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None or
            self.Description is not None or
            self.ServicePort or
            self.Member or
            self.Operational is not None or
            self.ErrorDetails is not None or
            super(LoadBalancerPoolType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LoadBalancerPoolType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LoadBalancerPoolType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LoadBalancerPoolType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LoadBalancerPoolType'):
        super(LoadBalancerPoolType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LoadBalancerPoolType')
    def exportChildren(self, outfile, level, namespace_='', name_='LoadBalancerPoolType', fromsubclass_=False, pretty_print=True):
        super(LoadBalancerPoolType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sId>%s</%sId>%s' % (namespace_, self.gds_format_string(quote_xml(self.Id).encode(ExternalEncoding), input_name='Id'), namespace_, eol_))
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        for ServicePort_ in self.ServicePort:
            ServicePort_.export(outfile, level, namespace_, name_='ServicePort', pretty_print=pretty_print)
        for Member_ in self.Member:
            Member_.export(outfile, level, namespace_, name_='Member', pretty_print=pretty_print)
        if self.Operational is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOperational>%s</%sOperational>%s' % (namespace_, self.gds_format_boolean(self.Operational, input_name='Operational'), namespace_, eol_))
        if self.ErrorDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sErrorDetails>%s</%sErrorDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.ErrorDetails).encode(ExternalEncoding), input_name='ErrorDetails'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='LoadBalancerPoolType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LoadBalancerPoolType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LoadBalancerPoolType, self).exportLiteralChildren(outfile, level, name_)
        if self.Id is not None:
            showIndent(outfile, level)
            outfile.write('Id=%s,\n' % quote_python(self.Id).encode(ExternalEncoding))
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('ServicePort=[\n')
        level += 1
        for ServicePort_ in self.ServicePort:
            showIndent(outfile, level)
            outfile.write('model_.LBPoolServicePortType(\n')
            ServicePort_.exportLiteral(outfile, level, name_='LBPoolServicePortType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Member=[\n')
        level += 1
        for Member_ in self.Member:
            showIndent(outfile, level)
            outfile.write('model_.LBPoolMemberType(\n')
            Member_.exportLiteral(outfile, level, name_='LBPoolMemberType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Operational is not None:
            showIndent(outfile, level)
            outfile.write('Operational=%s,\n' % self.Operational)
        if self.ErrorDetails is not None:
            showIndent(outfile, level)
            outfile.write('ErrorDetails=%s,\n' % quote_python(self.ErrorDetails).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LoadBalancerPoolType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'ServicePort':
            obj_ = LBPoolServicePortType.factory()
            obj_.build(child_)
            self.ServicePort.append(obj_)
            obj_.original_tagname_ = 'ServicePort'
        elif nodeName_ == 'Member':
            obj_ = LBPoolMemberType.factory()
            obj_.build(child_)
            self.Member.append(obj_)
            obj_.original_tagname_ = 'Member'
        elif nodeName_ == 'Operational':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Operational')
            self.Operational = ival_
        elif nodeName_ == 'ErrorDetails':
            ErrorDetails_ = child_.text
            ErrorDetails_ = self.gds_validate_string(ErrorDetails_, node, 'ErrorDetails')
            self.ErrorDetails = ErrorDetails_
        super(LoadBalancerPoolType, self).buildChildren(child_, node, nodeName_, True)
# end class LoadBalancerPoolType


class DhcpPoolServiceType(VCloudExtensibleType):
    """5.1 Represents DHCP pool service."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IsEnabled=None, Network=None, DefaultLeaseTime=None, MaxLeaseTime=None, LowIpAddress=None, HighIpAddress=None):
        self.original_tagname_ = None
        super(DhcpPoolServiceType, self).__init__(VCloudExtension, )
        self.IsEnabled = IsEnabled
        self.Network = Network
        self.DefaultLeaseTime = DefaultLeaseTime
        self.MaxLeaseTime = MaxLeaseTime
        self.LowIpAddress = LowIpAddress
        self.HighIpAddress = HighIpAddress
    def factory(*args_, **kwargs_):
        if DhcpPoolServiceType.subclass:
            return DhcpPoolServiceType.subclass(*args_, **kwargs_)
        else:
            return DhcpPoolServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_Network(self): return self.Network
    def set_Network(self, Network): self.Network = Network
    def get_DefaultLeaseTime(self): return self.DefaultLeaseTime
    def set_DefaultLeaseTime(self, DefaultLeaseTime): self.DefaultLeaseTime = DefaultLeaseTime
    def get_MaxLeaseTime(self): return self.MaxLeaseTime
    def set_MaxLeaseTime(self, MaxLeaseTime): self.MaxLeaseTime = MaxLeaseTime
    def get_LowIpAddress(self): return self.LowIpAddress
    def set_LowIpAddress(self, LowIpAddress): self.LowIpAddress = LowIpAddress
    def get_HighIpAddress(self): return self.HighIpAddress
    def set_HighIpAddress(self, HighIpAddress): self.HighIpAddress = HighIpAddress
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.IsEnabled is not None or
            self.Network is not None or
            self.DefaultLeaseTime is not None or
            self.MaxLeaseTime is not None or
            self.LowIpAddress is not None or
            self.HighIpAddress is not None or
            super(DhcpPoolServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DhcpPoolServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DhcpPoolServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DhcpPoolServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DhcpPoolServiceType'):
        super(DhcpPoolServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DhcpPoolServiceType')
    def exportChildren(self, outfile, level, namespace_='', name_='DhcpPoolServiceType', fromsubclass_=False, pretty_print=True):
        super(DhcpPoolServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
        if self.Network is not None:
            self.Network.export(outfile, level, namespace_, name_='Network', pretty_print=pretty_print)
        if self.DefaultLeaseTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDefaultLeaseTime>%s</%sDefaultLeaseTime>%s' % (namespace_, self.gds_format_integer(self.DefaultLeaseTime, input_name='DefaultLeaseTime'), namespace_, eol_))
        if self.MaxLeaseTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMaxLeaseTime>%s</%sMaxLeaseTime>%s' % (namespace_, self.gds_format_integer(self.MaxLeaseTime, input_name='MaxLeaseTime'), namespace_, eol_))
        if self.LowIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLowIpAddress>%s</%sLowIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.LowIpAddress).encode(ExternalEncoding), input_name='LowIpAddress'), namespace_, eol_))
        if self.HighIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHighIpAddress>%s</%sHighIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.HighIpAddress).encode(ExternalEncoding), input_name='HighIpAddress'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DhcpPoolServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DhcpPoolServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DhcpPoolServiceType, self).exportLiteralChildren(outfile, level, name_)
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
        if self.Network is not None:
            showIndent(outfile, level)
            outfile.write('Network=model_.ReferenceType(\n')
            self.Network.exportLiteral(outfile, level, name_='Network')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.DefaultLeaseTime is not None:
            showIndent(outfile, level)
            outfile.write('DefaultLeaseTime=%d,\n' % self.DefaultLeaseTime)
        if self.MaxLeaseTime is not None:
            showIndent(outfile, level)
            outfile.write('MaxLeaseTime=%d,\n' % self.MaxLeaseTime)
        if self.LowIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('LowIpAddress=%s,\n' % quote_python(self.LowIpAddress).encode(ExternalEncoding))
        if self.HighIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('HighIpAddress=%s,\n' % quote_python(self.HighIpAddress).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DhcpPoolServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'Network':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Network = obj_
            obj_.original_tagname_ = 'Network'
        elif nodeName_ == 'DefaultLeaseTime':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'DefaultLeaseTime')
            self.DefaultLeaseTime = ival_
        elif nodeName_ == 'MaxLeaseTime':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'MaxLeaseTime')
            self.MaxLeaseTime = ival_
        elif nodeName_ == 'LowIpAddress':
            LowIpAddress_ = child_.text
            LowIpAddress_ = self.gds_validate_string(LowIpAddress_, node, 'LowIpAddress')
            self.LowIpAddress = LowIpAddress_
            self.validate_IpAddressType(self.LowIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'HighIpAddress':
            HighIpAddress_ = child_.text
            HighIpAddress_ = self.gds_validate_string(HighIpAddress_, node, 'HighIpAddress')
            self.HighIpAddress = HighIpAddress_
            self.validate_IpAddressType(self.HighIpAddress)    # validate type IpAddressType
        super(DhcpPoolServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class DhcpPoolServiceType


class StaticRouteType(VCloudExtensibleType):
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Name=None, Network=None, NextHopIp=None, Interface=None, GatewayInterface=None):
        self.original_tagname_ = None
        super(StaticRouteType, self).__init__(VCloudExtension, )
        self.Name = Name
        self.Network = Network
        self.NextHopIp = NextHopIp
        self.Interface = Interface
        self.GatewayInterface = GatewayInterface
    def factory(*args_, **kwargs_):
        if StaticRouteType.subclass:
            return StaticRouteType.subclass(*args_, **kwargs_)
        else:
            return StaticRouteType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Network(self): return self.Network
    def set_Network(self, Network): self.Network = Network
    def get_NextHopIp(self): return self.NextHopIp
    def set_NextHopIp(self, NextHopIp): self.NextHopIp = NextHopIp
    def get_Interface(self): return self.Interface
    def set_Interface(self, Interface): self.Interface = Interface
    def get_GatewayInterface(self): return self.GatewayInterface
    def set_GatewayInterface(self, GatewayInterface): self.GatewayInterface = GatewayInterface
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Network is not None or
            self.NextHopIp is not None or
            self.Interface is not None or
            self.GatewayInterface is not None or
            super(StaticRouteType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StaticRouteType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StaticRouteType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StaticRouteType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StaticRouteType'):
        super(StaticRouteType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StaticRouteType')
    def exportChildren(self, outfile, level, namespace_='', name_='StaticRouteType', fromsubclass_=False, pretty_print=True):
        super(StaticRouteType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Network is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNetwork>%s</%sNetwork>%s' % (namespace_, self.gds_format_string(quote_xml(self.Network).encode(ExternalEncoding), input_name='Network'), namespace_, eol_))
        if self.NextHopIp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNextHopIp>%s</%sNextHopIp>%s' % (namespace_, self.gds_format_string(quote_xml(self.NextHopIp).encode(ExternalEncoding), input_name='NextHopIp'), namespace_, eol_))
        if self.Interface is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInterface>%s</%sInterface>%s' % (namespace_, self.gds_format_string(quote_xml(self.Interface).encode(ExternalEncoding), input_name='Interface'), namespace_, eol_))
        if self.GatewayInterface is not None:
            self.GatewayInterface.export(outfile, level, namespace_, name_='GatewayInterface', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StaticRouteType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StaticRouteType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StaticRouteType, self).exportLiteralChildren(outfile, level, name_)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Network is not None:
            showIndent(outfile, level)
            outfile.write('Network=%s,\n' % quote_python(self.Network).encode(ExternalEncoding))
        if self.NextHopIp is not None:
            showIndent(outfile, level)
            outfile.write('NextHopIp=%s,\n' % quote_python(self.NextHopIp).encode(ExternalEncoding))
        if self.Interface is not None:
            showIndent(outfile, level)
            outfile.write('Interface=%s,\n' % quote_python(self.Interface).encode(ExternalEncoding))
        if self.GatewayInterface is not None:
            showIndent(outfile, level)
            outfile.write('GatewayInterface=model_.ReferenceType(\n')
            self.GatewayInterface.exportLiteral(outfile, level, name_='GatewayInterface')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StaticRouteType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Network':
            Network_ = child_.text
            Network_ = self.gds_validate_string(Network_, node, 'Network')
            self.Network = Network_
        elif nodeName_ == 'NextHopIp':
            NextHopIp_ = child_.text
            NextHopIp_ = self.gds_validate_string(NextHopIp_, node, 'NextHopIp')
            self.NextHopIp = NextHopIp_
            self.validate_IpAddressType(self.NextHopIp)    # validate type IpAddressType
        elif nodeName_ == 'Interface':
            Interface_ = child_.text
            Interface_ = self.gds_validate_string(Interface_, node, 'Interface')
            self.Interface = Interface_
        elif nodeName_ == 'GatewayInterface':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.GatewayInterface = obj_
            obj_.original_tagname_ = 'GatewayInterface'
        super(StaticRouteType, self).buildChildren(child_, node, nodeName_, True)
# end class StaticRouteType


class IpsecVpnPeerType(VCloudExtensibleType):
    """1.5 Gives more details of peer end point."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IpsecVpnPeerType, self).__init__(VCloudExtension, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if IpsecVpnPeerType.subclass:
            return IpsecVpnPeerType.subclass(*args_, **kwargs_)
        else:
            return IpsecVpnPeerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(IpsecVpnPeerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpsecVpnPeerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnPeerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpsecVpnPeerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpsecVpnPeerType'):
        super(IpsecVpnPeerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnPeerType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IpsecVpnPeerType', fromsubclass_=False, pretty_print=True):
        super(IpsecVpnPeerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IpsecVpnPeerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpsecVpnPeerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpsecVpnPeerType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IpsecVpnPeerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IpsecVpnPeerType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IpsecVpnPeerType


class IpsecVpnTunnelType(VCloudExtensibleType):
    """1.5 Represents details of an IPSec-VPN tunnel."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Name=None, Description=None, IpsecVpnPeer=None, PeerIpAddress=None, PeerNetworkAddress=None, PeerNetworkMask=None, SharedSecret=None, EncryptionProtocol=None, Mtu=None, IsEnabled=None, IsOperational=None, ErrorDetails=None):
        self.original_tagname_ = None
        super(IpsecVpnTunnelType, self).__init__(VCloudExtension, )
        self.Name = Name
        self.Description = Description
        self.IpsecVpnPeer = IpsecVpnPeer
        self.PeerIpAddress = PeerIpAddress
        self.PeerNetworkAddress = PeerNetworkAddress
        self.PeerNetworkMask = PeerNetworkMask
        self.SharedSecret = SharedSecret
        self.EncryptionProtocol = EncryptionProtocol
        self.Mtu = Mtu
        self.IsEnabled = IsEnabled
        self.IsOperational = IsOperational
        self.ErrorDetails = ErrorDetails
    def factory(*args_, **kwargs_):
        if IpsecVpnTunnelType.subclass:
            return IpsecVpnTunnelType.subclass(*args_, **kwargs_)
        else:
            return IpsecVpnTunnelType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_IpsecVpnPeer(self): return self.IpsecVpnPeer
    def set_IpsecVpnPeer(self, IpsecVpnPeer): self.IpsecVpnPeer = IpsecVpnPeer
    def get_PeerIpAddress(self): return self.PeerIpAddress
    def set_PeerIpAddress(self, PeerIpAddress): self.PeerIpAddress = PeerIpAddress
    def get_PeerNetworkAddress(self): return self.PeerNetworkAddress
    def set_PeerNetworkAddress(self, PeerNetworkAddress): self.PeerNetworkAddress = PeerNetworkAddress
    def get_PeerNetworkMask(self): return self.PeerNetworkMask
    def set_PeerNetworkMask(self, PeerNetworkMask): self.PeerNetworkMask = PeerNetworkMask
    def get_SharedSecret(self): return self.SharedSecret
    def set_SharedSecret(self, SharedSecret): self.SharedSecret = SharedSecret
    def get_EncryptionProtocol(self): return self.EncryptionProtocol
    def set_EncryptionProtocol(self, EncryptionProtocol): self.EncryptionProtocol = EncryptionProtocol
    def get_Mtu(self): return self.Mtu
    def set_Mtu(self, Mtu): self.Mtu = Mtu
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_IsOperational(self): return self.IsOperational
    def set_IsOperational(self, IsOperational): self.IsOperational = IsOperational
    def get_ErrorDetails(self): return self.ErrorDetails
    def set_ErrorDetails(self, ErrorDetails): self.ErrorDetails = ErrorDetails
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Description is not None or
            self.IpsecVpnPeer is not None or
            self.PeerIpAddress is not None or
            self.PeerNetworkAddress is not None or
            self.PeerNetworkMask is not None or
            self.SharedSecret is not None or
            self.EncryptionProtocol is not None or
            self.Mtu is not None or
            self.IsEnabled is not None or
            self.IsOperational is not None or
            self.ErrorDetails is not None or
            super(IpsecVpnTunnelType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpsecVpnTunnelType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnTunnelType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpsecVpnTunnelType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpsecVpnTunnelType'):
        super(IpsecVpnTunnelType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnTunnelType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpsecVpnTunnelType', fromsubclass_=False, pretty_print=True):
        super(IpsecVpnTunnelType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        if self.IpsecVpnPeer is not None:
            self.IpsecVpnPeer.export(outfile, level, namespace_, name_='IpsecVpnPeer', pretty_print=pretty_print)
        if self.PeerIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPeerIpAddress>%s</%sPeerIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.PeerIpAddress).encode(ExternalEncoding), input_name='PeerIpAddress'), namespace_, eol_))
        if self.PeerNetworkAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPeerNetworkAddress>%s</%sPeerNetworkAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.PeerNetworkAddress).encode(ExternalEncoding), input_name='PeerNetworkAddress'), namespace_, eol_))
        if self.PeerNetworkMask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPeerNetworkMask>%s</%sPeerNetworkMask>%s' % (namespace_, self.gds_format_string(quote_xml(self.PeerNetworkMask).encode(ExternalEncoding), input_name='PeerNetworkMask'), namespace_, eol_))
        if self.SharedSecret is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSharedSecret>%s</%sSharedSecret>%s' % (namespace_, self.gds_format_string(quote_xml(self.SharedSecret).encode(ExternalEncoding), input_name='SharedSecret'), namespace_, eol_))
        if self.EncryptionProtocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEncryptionProtocol>%s</%sEncryptionProtocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.EncryptionProtocol).encode(ExternalEncoding), input_name='EncryptionProtocol'), namespace_, eol_))
        if self.Mtu is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMtu>%s</%sMtu>%s' % (namespace_, self.gds_format_integer(self.Mtu, input_name='Mtu'), namespace_, eol_))
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
        if self.IsOperational is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsOperational>%s</%sIsOperational>%s' % (namespace_, self.gds_format_boolean(self.IsOperational, input_name='IsOperational'), namespace_, eol_))
        if self.ErrorDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sErrorDetails>%s</%sErrorDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.ErrorDetails).encode(ExternalEncoding), input_name='ErrorDetails'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IpsecVpnTunnelType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpsecVpnTunnelType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpsecVpnTunnelType, self).exportLiteralChildren(outfile, level, name_)
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.IpsecVpnPeer is not None:
            showIndent(outfile, level)
            outfile.write('IpsecVpnPeer=model_.IpsecVpnPeer(\n')
            self.IpsecVpnPeer.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PeerIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('PeerIpAddress=%s,\n' % quote_python(self.PeerIpAddress).encode(ExternalEncoding))
        if self.PeerNetworkAddress is not None:
            showIndent(outfile, level)
            outfile.write('PeerNetworkAddress=%s,\n' % quote_python(self.PeerNetworkAddress).encode(ExternalEncoding))
        if self.PeerNetworkMask is not None:
            showIndent(outfile, level)
            outfile.write('PeerNetworkMask=%s,\n' % quote_python(self.PeerNetworkMask).encode(ExternalEncoding))
        if self.SharedSecret is not None:
            showIndent(outfile, level)
            outfile.write('SharedSecret=%s,\n' % quote_python(self.SharedSecret).encode(ExternalEncoding))
        if self.EncryptionProtocol is not None:
            showIndent(outfile, level)
            outfile.write('EncryptionProtocol=%s,\n' % quote_python(self.EncryptionProtocol).encode(ExternalEncoding))
        if self.Mtu is not None:
            showIndent(outfile, level)
            outfile.write('Mtu=%d,\n' % self.Mtu)
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
        if self.IsOperational is not None:
            showIndent(outfile, level)
            outfile.write('IsOperational=%s,\n' % self.IsOperational)
        if self.ErrorDetails is not None:
            showIndent(outfile, level)
            outfile.write('ErrorDetails=%s,\n' % quote_python(self.ErrorDetails).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpsecVpnTunnelType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'IpsecVpnPeer':
            class_obj_ = self.get_class_obj_(child_, IpsecVpnPeerType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.IpsecVpnPeer = obj_
            obj_.original_tagname_ = 'IpsecVpnPeer'
        elif nodeName_ == 'IpsecVpnLocalPeer':
            obj_ = IpsecVpnLocalPeerType.factory()
            obj_.build(child_)
            self.IpsecVpnPeer = obj_
            obj_.original_tagname_ = 'IpsecVpnLocalPeer'
        elif nodeName_ == 'IpsecVpnRemotePeer':
            obj_ = IpsecVpnRemotePeerType.factory()
            obj_.build(child_)
            self.IpsecVpnPeer = obj_
            obj_.original_tagname_ = 'IpsecVpnRemotePeer'
        elif nodeName_ == 'IpsecVpnThirdPartyPeer':
            obj_ = IpsecVpnThirdPartyPeerType.factory()
            obj_.build(child_)
            self.IpsecVpnPeer = obj_
            obj_.original_tagname_ = 'IpsecVpnThirdPartyPeer'
        elif nodeName_ == 'PeerIpAddress':
            PeerIpAddress_ = child_.text
            PeerIpAddress_ = self.gds_validate_string(PeerIpAddress_, node, 'PeerIpAddress')
            self.PeerIpAddress = PeerIpAddress_
            self.validate_IpAddressType(self.PeerIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'PeerNetworkAddress':
            PeerNetworkAddress_ = child_.text
            PeerNetworkAddress_ = self.gds_validate_string(PeerNetworkAddress_, node, 'PeerNetworkAddress')
            self.PeerNetworkAddress = PeerNetworkAddress_
            self.validate_IpAddressType(self.PeerNetworkAddress)    # validate type IpAddressType
        elif nodeName_ == 'PeerNetworkMask':
            PeerNetworkMask_ = child_.text
            PeerNetworkMask_ = self.gds_validate_string(PeerNetworkMask_, node, 'PeerNetworkMask')
            self.PeerNetworkMask = PeerNetworkMask_
            self.validate_IpAddressType(self.PeerNetworkMask)    # validate type IpAddressType
        elif nodeName_ == 'SharedSecret':
            SharedSecret_ = child_.text
            SharedSecret_ = self.gds_validate_string(SharedSecret_, node, 'SharedSecret')
            self.SharedSecret = SharedSecret_
        elif nodeName_ == 'EncryptionProtocol':
            EncryptionProtocol_ = child_.text
            EncryptionProtocol_ = self.gds_validate_string(EncryptionProtocol_, node, 'EncryptionProtocol')
            self.EncryptionProtocol = EncryptionProtocol_
        elif nodeName_ == 'Mtu':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Mtu')
            self.Mtu = ival_
        elif nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'IsOperational':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsOperational')
            self.IsOperational = ival_
        elif nodeName_ == 'ErrorDetails':
            ErrorDetails_ = child_.text
            ErrorDetails_ = self.gds_validate_string(ErrorDetails_, node, 'ErrorDetails')
            self.ErrorDetails = ErrorDetails_
        super(IpsecVpnTunnelType, self).buildChildren(child_, node, nodeName_, True)
# end class IpsecVpnTunnelType


class FirewallRuleType(VCloudExtensibleType):
    """0.9 Represents a firewall rule."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Id=None, IsEnabled=None, MatchOnTranslate=None, Description=None, Policy=None, Protocols=None, IcmpSubType=None, Port=None, DestinationPortRange=None, DestinationIp=None, DestinationVm=None, SourcePort=None, SourcePortRange=None, SourceIp=None, SourceVm=None, Direction=None, EnableLogging=None):
        self.original_tagname_ = None
        super(FirewallRuleType, self).__init__(VCloudExtension, )
        self.Id = Id
        self.IsEnabled = IsEnabled
        self.MatchOnTranslate = MatchOnTranslate
        self.Description = Description
        self.Policy = Policy
        self.Protocols = Protocols
        self.IcmpSubType = IcmpSubType
        self.Port = Port
        self.DestinationPortRange = DestinationPortRange
        self.DestinationIp = DestinationIp
        self.DestinationVm = DestinationVm
        self.SourcePort = SourcePort
        self.SourcePortRange = SourcePortRange
        self.SourceIp = SourceIp
        self.SourceVm = SourceVm
        self.Direction = Direction
        self.EnableLogging = EnableLogging
    def factory(*args_, **kwargs_):
        if FirewallRuleType.subclass:
            return FirewallRuleType.subclass(*args_, **kwargs_)
        else:
            return FirewallRuleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_MatchOnTranslate(self): return self.MatchOnTranslate
    def set_MatchOnTranslate(self, MatchOnTranslate): self.MatchOnTranslate = MatchOnTranslate
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Policy(self): return self.Policy
    def set_Policy(self, Policy): self.Policy = Policy
    def get_Protocols(self): return self.Protocols
    def set_Protocols(self, Protocols): self.Protocols = Protocols
    def get_IcmpSubType(self): return self.IcmpSubType
    def set_IcmpSubType(self, IcmpSubType): self.IcmpSubType = IcmpSubType
    def get_Port(self): return self.Port
    def set_Port(self, Port): self.Port = Port
    def get_DestinationPortRange(self): return self.DestinationPortRange
    def set_DestinationPortRange(self, DestinationPortRange): self.DestinationPortRange = DestinationPortRange
    def get_DestinationIp(self): return self.DestinationIp
    def set_DestinationIp(self, DestinationIp): self.DestinationIp = DestinationIp
    def get_DestinationVm(self): return self.DestinationVm
    def set_DestinationVm(self, DestinationVm): self.DestinationVm = DestinationVm
    def get_SourcePort(self): return self.SourcePort
    def set_SourcePort(self, SourcePort): self.SourcePort = SourcePort
    def get_SourcePortRange(self): return self.SourcePortRange
    def set_SourcePortRange(self, SourcePortRange): self.SourcePortRange = SourcePortRange
    def get_SourceIp(self): return self.SourceIp
    def set_SourceIp(self, SourceIp): self.SourceIp = SourceIp
    def get_SourceVm(self): return self.SourceVm
    def set_SourceVm(self, SourceVm): self.SourceVm = SourceVm
    def get_Direction(self): return self.Direction
    def set_Direction(self, Direction): self.Direction = Direction
    def get_EnableLogging(self): return self.EnableLogging
    def set_EnableLogging(self, EnableLogging): self.EnableLogging = EnableLogging
    def validate_FirewallIpAddressType(self, value):
        # Validate type FirewallIpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Id is not None or
            self.IsEnabled is not None or
            self.MatchOnTranslate is not None or
            self.Description is not None or
            self.Policy is not None or
            self.Protocols is not None or
            self.IcmpSubType is not None or
            self.Port is not None or
            self.DestinationPortRange is not None or
            self.DestinationIp is not None or
            self.DestinationVm is not None or
            self.SourcePort is not None or
            self.SourcePortRange is not None or
            self.SourceIp is not None or
            self.SourceVm is not None or
            self.Direction is not None or
            self.EnableLogging is not None or
            super(FirewallRuleType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FirewallRuleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FirewallRuleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FirewallRuleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FirewallRuleType'):
        super(FirewallRuleType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FirewallRuleType')
    def exportChildren(self, outfile, level, namespace_='', name_='FirewallRuleType', fromsubclass_=False, pretty_print=True):
        super(FirewallRuleType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sId>%s</%sId>%s' % (namespace_, self.gds_format_string(quote_xml(self.Id).encode(ExternalEncoding), input_name='Id'), namespace_, eol_))
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
        if self.MatchOnTranslate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMatchOnTranslate>%s</%sMatchOnTranslate>%s' % (namespace_, self.gds_format_boolean(self.MatchOnTranslate, input_name='MatchOnTranslate'), namespace_, eol_))
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        if self.Policy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPolicy>%s</%sPolicy>%s' % (namespace_, self.gds_format_string(quote_xml(self.Policy).encode(ExternalEncoding), input_name='Policy'), namespace_, eol_))
        if self.Protocols is not None:
            self.Protocols.export(outfile, level, namespace_, name_='Protocols', pretty_print=pretty_print)
        if self.IcmpSubType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIcmpSubType>%s</%sIcmpSubType>%s' % (namespace_, self.gds_format_string(quote_xml(self.IcmpSubType).encode(ExternalEncoding), input_name='IcmpSubType'), namespace_, eol_))
        if self.Port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPort>%s</%sPort>%s' % (namespace_, self.gds_format_integer(self.Port, input_name='Port'), namespace_, eol_))
        if self.DestinationPortRange is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDestinationPortRange>%s</%sDestinationPortRange>%s' % (namespace_, self.gds_format_string(quote_xml(self.DestinationPortRange).encode(ExternalEncoding), input_name='DestinationPortRange'), namespace_, eol_))
        if self.DestinationIp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDestinationIp>%s</%sDestinationIp>%s' % (namespace_, self.gds_format_string(quote_xml(self.DestinationIp).encode(ExternalEncoding), input_name='DestinationIp'), namespace_, eol_))
        if self.DestinationVm is not None:
            self.DestinationVm.export(outfile, level, namespace_, name_='DestinationVm', pretty_print=pretty_print)
        if self.SourcePort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSourcePort>%s</%sSourcePort>%s' % (namespace_, self.gds_format_integer(self.SourcePort, input_name='SourcePort'), namespace_, eol_))
        if self.SourcePortRange is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSourcePortRange>%s</%sSourcePortRange>%s' % (namespace_, self.gds_format_string(quote_xml(self.SourcePortRange).encode(ExternalEncoding), input_name='SourcePortRange'), namespace_, eol_))
        if self.SourceIp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSourceIp>%s</%sSourceIp>%s' % (namespace_, self.gds_format_string(quote_xml(self.SourceIp).encode(ExternalEncoding), input_name='SourceIp'), namespace_, eol_))
        if self.SourceVm is not None:
            self.SourceVm.export(outfile, level, namespace_, name_='SourceVm', pretty_print=pretty_print)
        if self.Direction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDirection>%s</%sDirection>%s' % (namespace_, self.gds_format_string(quote_xml(self.Direction).encode(ExternalEncoding), input_name='Direction'), namespace_, eol_))
        if self.EnableLogging is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEnableLogging>%s</%sEnableLogging>%s' % (namespace_, self.gds_format_boolean(self.EnableLogging, input_name='EnableLogging'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='FirewallRuleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(FirewallRuleType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FirewallRuleType, self).exportLiteralChildren(outfile, level, name_)
        if self.Id is not None:
            showIndent(outfile, level)
            outfile.write('Id=%s,\n' % quote_python(self.Id).encode(ExternalEncoding))
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
        if self.MatchOnTranslate is not None:
            showIndent(outfile, level)
            outfile.write('MatchOnTranslate=%s,\n' % self.MatchOnTranslate)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.Policy is not None:
            showIndent(outfile, level)
            outfile.write('Policy=%s,\n' % quote_python(self.Policy).encode(ExternalEncoding))
        if self.Protocols is not None:
            showIndent(outfile, level)
            outfile.write('Protocols=model_.ProtocolsType(\n')
            self.Protocols.exportLiteral(outfile, level, name_='Protocols')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IcmpSubType is not None:
            showIndent(outfile, level)
            outfile.write('IcmpSubType=%s,\n' % quote_python(self.IcmpSubType).encode(ExternalEncoding))
        if self.Port is not None:
            showIndent(outfile, level)
            outfile.write('Port=%d,\n' % self.Port)
        if self.DestinationPortRange is not None:
            showIndent(outfile, level)
            outfile.write('DestinationPortRange=%s,\n' % quote_python(self.DestinationPortRange).encode(ExternalEncoding))
        if self.DestinationIp is not None:
            showIndent(outfile, level)
            outfile.write('DestinationIp=%s,\n' % quote_python(self.DestinationIp).encode(ExternalEncoding))
        if self.DestinationVm is not None:
            showIndent(outfile, level)
            outfile.write('DestinationVm=model_.VmSelectionType(\n')
            self.DestinationVm.exportLiteral(outfile, level, name_='DestinationVm')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SourcePort is not None:
            showIndent(outfile, level)
            outfile.write('SourcePort=%d,\n' % self.SourcePort)
        if self.SourcePortRange is not None:
            showIndent(outfile, level)
            outfile.write('SourcePortRange=%s,\n' % quote_python(self.SourcePortRange).encode(ExternalEncoding))
        if self.SourceIp is not None:
            showIndent(outfile, level)
            outfile.write('SourceIp=%s,\n' % quote_python(self.SourceIp).encode(ExternalEncoding))
        if self.SourceVm is not None:
            showIndent(outfile, level)
            outfile.write('SourceVm=model_.VmSelectionType(\n')
            self.SourceVm.exportLiteral(outfile, level, name_='SourceVm')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Direction is not None:
            showIndent(outfile, level)
            outfile.write('Direction=%s,\n' % quote_python(self.Direction).encode(ExternalEncoding))
        if self.EnableLogging is not None:
            showIndent(outfile, level)
            outfile.write('EnableLogging=%s,\n' % self.EnableLogging)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(FirewallRuleType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'MatchOnTranslate':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'MatchOnTranslate')
            self.MatchOnTranslate = ival_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Policy':
            Policy_ = child_.text
            Policy_ = self.gds_validate_string(Policy_, node, 'Policy')
            self.Policy = Policy_
        elif nodeName_ == 'Protocols':
            obj_ = ProtocolsType.factory()
            obj_.build(child_)
            self.Protocols = obj_
            obj_.original_tagname_ = 'Protocols'
        elif nodeName_ == 'IcmpSubType':
            IcmpSubType_ = child_.text
            IcmpSubType_ = self.gds_validate_string(IcmpSubType_, node, 'IcmpSubType')
            self.IcmpSubType = IcmpSubType_
        elif nodeName_ == 'Port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Port')
            self.Port = ival_
        elif nodeName_ == 'DestinationPortRange':
            DestinationPortRange_ = child_.text
            DestinationPortRange_ = self.gds_validate_string(DestinationPortRange_, node, 'DestinationPortRange')
            self.DestinationPortRange = DestinationPortRange_
        elif nodeName_ == 'DestinationIp':
            DestinationIp_ = child_.text
            DestinationIp_ = self.gds_validate_string(DestinationIp_, node, 'DestinationIp')
            self.DestinationIp = DestinationIp_
            self.validate_FirewallIpAddressType(self.DestinationIp)    # validate type FirewallIpAddressType
        elif nodeName_ == 'DestinationVm':
            obj_ = VmSelectionType.factory()
            obj_.build(child_)
            self.DestinationVm = obj_
            obj_.original_tagname_ = 'DestinationVm'
        elif nodeName_ == 'SourcePort':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'SourcePort')
            self.SourcePort = ival_
        elif nodeName_ == 'SourcePortRange':
            SourcePortRange_ = child_.text
            SourcePortRange_ = self.gds_validate_string(SourcePortRange_, node, 'SourcePortRange')
            self.SourcePortRange = SourcePortRange_
        elif nodeName_ == 'SourceIp':
            SourceIp_ = child_.text
            SourceIp_ = self.gds_validate_string(SourceIp_, node, 'SourceIp')
            self.SourceIp = SourceIp_
            self.validate_FirewallIpAddressType(self.SourceIp)    # validate type FirewallIpAddressType
        elif nodeName_ == 'SourceVm':
            obj_ = VmSelectionType.factory()
            obj_.build(child_)
            self.SourceVm = obj_
            obj_.original_tagname_ = 'SourceVm'
        elif nodeName_ == 'Direction':
            Direction_ = child_.text
            Direction_ = self.gds_validate_string(Direction_, node, 'Direction')
            self.Direction = Direction_
        elif nodeName_ == 'EnableLogging':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'EnableLogging')
            self.EnableLogging = ival_
        super(FirewallRuleType, self).buildChildren(child_, node, nodeName_, True)
# end class FirewallRuleType


class VmSelectionType(VCloudExtensibleType):
    """5.1 Represents details of an vm+nic+iptype selection."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, VAppScopedVmId=None, VmNicId=None, IpType=None):
        self.original_tagname_ = None
        super(VmSelectionType, self).__init__(VCloudExtension, )
        self.VAppScopedVmId = VAppScopedVmId
        self.VmNicId = VmNicId
        self.IpType = IpType
    def factory(*args_, **kwargs_):
        if VmSelectionType.subclass:
            return VmSelectionType.subclass(*args_, **kwargs_)
        else:
            return VmSelectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_VAppScopedVmId(self): return self.VAppScopedVmId
    def set_VAppScopedVmId(self, VAppScopedVmId): self.VAppScopedVmId = VAppScopedVmId
    def get_VmNicId(self): return self.VmNicId
    def set_VmNicId(self, VmNicId): self.VmNicId = VmNicId
    def get_IpType(self): return self.IpType
    def set_IpType(self, IpType): self.IpType = IpType
    def hasContent_(self):
        if (
            self.VAppScopedVmId is not None or
            self.VmNicId is not None or
            self.IpType is not None or
            super(VmSelectionType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VmSelectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VmSelectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VmSelectionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VmSelectionType'):
        super(VmSelectionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VmSelectionType')
    def exportChildren(self, outfile, level, namespace_='', name_='VmSelectionType', fromsubclass_=False, pretty_print=True):
        super(VmSelectionType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.VAppScopedVmId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVAppScopedVmId>%s</%sVAppScopedVmId>%s' % (namespace_, self.gds_format_string(quote_xml(self.VAppScopedVmId).encode(ExternalEncoding), input_name='VAppScopedVmId'), namespace_, eol_))
        if self.VmNicId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVmNicId>%s</%sVmNicId>%s' % (namespace_, self.gds_format_integer(self.VmNicId, input_name='VmNicId'), namespace_, eol_))
        if self.IpType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIpType>%s</%sIpType>%s' % (namespace_, self.gds_format_string(quote_xml(self.IpType).encode(ExternalEncoding), input_name='IpType'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VmSelectionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VmSelectionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VmSelectionType, self).exportLiteralChildren(outfile, level, name_)
        if self.VAppScopedVmId is not None:
            showIndent(outfile, level)
            outfile.write('VAppScopedVmId=%s,\n' % quote_python(self.VAppScopedVmId).encode(ExternalEncoding))
        if self.VmNicId is not None:
            showIndent(outfile, level)
            outfile.write('VmNicId=%d,\n' % self.VmNicId)
        if self.IpType is not None:
            showIndent(outfile, level)
            outfile.write('IpType=%s,\n' % quote_python(self.IpType).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VmSelectionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'VAppScopedVmId':
            VAppScopedVmId_ = child_.text
            VAppScopedVmId_ = self.gds_validate_string(VAppScopedVmId_, node, 'VAppScopedVmId')
            self.VAppScopedVmId = VAppScopedVmId_
        elif nodeName_ == 'VmNicId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'VmNicId')
            self.VmNicId = ival_
        elif nodeName_ == 'IpType':
            IpType_ = child_.text
            IpType_ = self.gds_validate_string(IpType_, node, 'IpType')
            self.IpType = IpType_
        super(VmSelectionType, self).buildChildren(child_, node, nodeName_, True)
# end class VmSelectionType


class NatVmRuleType(VCloudExtensibleType):
    """0.9 Represents the NAT rule for port forwarding between VM NIC/port
    and external IP/port."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, ExternalIpAddress=None, ExternalPort=None, VAppScopedVmId=None, VmNicId=None, InternalPort=None, Protocol=None):
        self.original_tagname_ = None
        super(NatVmRuleType, self).__init__(VCloudExtension, )
        self.ExternalIpAddress = ExternalIpAddress
        self.ExternalPort = ExternalPort
        self.VAppScopedVmId = VAppScopedVmId
        self.VmNicId = VmNicId
        self.InternalPort = InternalPort
        self.Protocol = Protocol
    def factory(*args_, **kwargs_):
        if NatVmRuleType.subclass:
            return NatVmRuleType.subclass(*args_, **kwargs_)
        else:
            return NatVmRuleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ExternalIpAddress(self): return self.ExternalIpAddress
    def set_ExternalIpAddress(self, ExternalIpAddress): self.ExternalIpAddress = ExternalIpAddress
    def get_ExternalPort(self): return self.ExternalPort
    def set_ExternalPort(self, ExternalPort): self.ExternalPort = ExternalPort
    def get_VAppScopedVmId(self): return self.VAppScopedVmId
    def set_VAppScopedVmId(self, VAppScopedVmId): self.VAppScopedVmId = VAppScopedVmId
    def get_VmNicId(self): return self.VmNicId
    def set_VmNicId(self, VmNicId): self.VmNicId = VmNicId
    def get_InternalPort(self): return self.InternalPort
    def set_InternalPort(self, InternalPort): self.InternalPort = InternalPort
    def get_Protocol(self): return self.Protocol
    def set_Protocol(self, Protocol): self.Protocol = Protocol
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.ExternalIpAddress is not None or
            self.ExternalPort is not None or
            self.VAppScopedVmId is not None or
            self.VmNicId is not None or
            self.InternalPort is not None or
            self.Protocol is not None or
            super(NatVmRuleType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NatVmRuleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NatVmRuleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NatVmRuleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NatVmRuleType'):
        super(NatVmRuleType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NatVmRuleType')
    def exportChildren(self, outfile, level, namespace_='', name_='NatVmRuleType', fromsubclass_=False, pretty_print=True):
        super(NatVmRuleType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExternalIpAddress>%s</%sExternalIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.ExternalIpAddress).encode(ExternalEncoding), input_name='ExternalIpAddress'), namespace_, eol_))
        if self.ExternalPort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExternalPort>%s</%sExternalPort>%s' % (namespace_, self.gds_format_integer(self.ExternalPort, input_name='ExternalPort'), namespace_, eol_))
        if self.VAppScopedVmId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVAppScopedVmId>%s</%sVAppScopedVmId>%s' % (namespace_, self.gds_format_string(quote_xml(self.VAppScopedVmId).encode(ExternalEncoding), input_name='VAppScopedVmId'), namespace_, eol_))
        if self.VmNicId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVmNicId>%s</%sVmNicId>%s' % (namespace_, self.gds_format_integer(self.VmNicId, input_name='VmNicId'), namespace_, eol_))
        if self.InternalPort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInternalPort>%s</%sInternalPort>%s' % (namespace_, self.gds_format_integer(self.InternalPort, input_name='InternalPort'), namespace_, eol_))
        if self.Protocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProtocol>%s</%sProtocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.Protocol).encode(ExternalEncoding), input_name='Protocol'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NatVmRuleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NatVmRuleType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NatVmRuleType, self).exportLiteralChildren(outfile, level, name_)
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('ExternalIpAddress=%s,\n' % quote_python(self.ExternalIpAddress).encode(ExternalEncoding))
        if self.ExternalPort is not None:
            showIndent(outfile, level)
            outfile.write('ExternalPort=%d,\n' % self.ExternalPort)
        if self.VAppScopedVmId is not None:
            showIndent(outfile, level)
            outfile.write('VAppScopedVmId=%s,\n' % quote_python(self.VAppScopedVmId).encode(ExternalEncoding))
        if self.VmNicId is not None:
            showIndent(outfile, level)
            outfile.write('VmNicId=%d,\n' % self.VmNicId)
        if self.InternalPort is not None:
            showIndent(outfile, level)
            outfile.write('InternalPort=%d,\n' % self.InternalPort)
        if self.Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Protocol=%s,\n' % quote_python(self.Protocol).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NatVmRuleType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ExternalIpAddress':
            ExternalIpAddress_ = child_.text
            ExternalIpAddress_ = self.gds_validate_string(ExternalIpAddress_, node, 'ExternalIpAddress')
            self.ExternalIpAddress = ExternalIpAddress_
            self.validate_IpAddressType(self.ExternalIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'ExternalPort':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ExternalPort')
            self.ExternalPort = ival_
        elif nodeName_ == 'VAppScopedVmId':
            VAppScopedVmId_ = child_.text
            VAppScopedVmId_ = self.gds_validate_string(VAppScopedVmId_, node, 'VAppScopedVmId')
            self.VAppScopedVmId = VAppScopedVmId_
        elif nodeName_ == 'VmNicId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'VmNicId')
            self.VmNicId = ival_
        elif nodeName_ == 'InternalPort':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'InternalPort')
            self.InternalPort = ival_
        elif nodeName_ == 'Protocol':
            Protocol_ = child_.text
            Protocol_ = self.gds_validate_string(Protocol_, node, 'Protocol')
            self.Protocol = Protocol_
        super(NatVmRuleType, self).buildChildren(child_, node, nodeName_, True)
# end class NatVmRuleType


class NatPortForwardingRuleType(VCloudExtensibleType):
    """0.9 Represents the NAT rule for port forwarding between internal
    IP/port and external IP/port."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, ExternalIpAddress=None, ExternalPort=None, InternalIpAddress=None, InternalPort=None, Protocol=None):
        self.original_tagname_ = None
        super(NatPortForwardingRuleType, self).__init__(VCloudExtension, )
        self.ExternalIpAddress = ExternalIpAddress
        self.ExternalPort = ExternalPort
        self.InternalIpAddress = InternalIpAddress
        self.InternalPort = InternalPort
        self.Protocol = Protocol
    def factory(*args_, **kwargs_):
        if NatPortForwardingRuleType.subclass:
            return NatPortForwardingRuleType.subclass(*args_, **kwargs_)
        else:
            return NatPortForwardingRuleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ExternalIpAddress(self): return self.ExternalIpAddress
    def set_ExternalIpAddress(self, ExternalIpAddress): self.ExternalIpAddress = ExternalIpAddress
    def get_ExternalPort(self): return self.ExternalPort
    def set_ExternalPort(self, ExternalPort): self.ExternalPort = ExternalPort
    def get_InternalIpAddress(self): return self.InternalIpAddress
    def set_InternalIpAddress(self, InternalIpAddress): self.InternalIpAddress = InternalIpAddress
    def get_InternalPort(self): return self.InternalPort
    def set_InternalPort(self, InternalPort): self.InternalPort = InternalPort
    def get_Protocol(self): return self.Protocol
    def set_Protocol(self, Protocol): self.Protocol = Protocol
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.ExternalIpAddress is not None or
            self.ExternalPort is not None or
            self.InternalIpAddress is not None or
            self.InternalPort is not None or
            self.Protocol is not None or
            super(NatPortForwardingRuleType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NatPortForwardingRuleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NatPortForwardingRuleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NatPortForwardingRuleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NatPortForwardingRuleType'):
        super(NatPortForwardingRuleType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NatPortForwardingRuleType')
    def exportChildren(self, outfile, level, namespace_='', name_='NatPortForwardingRuleType', fromsubclass_=False, pretty_print=True):
        super(NatPortForwardingRuleType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExternalIpAddress>%s</%sExternalIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.ExternalIpAddress).encode(ExternalEncoding), input_name='ExternalIpAddress'), namespace_, eol_))
        if self.ExternalPort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExternalPort>%s</%sExternalPort>%s' % (namespace_, self.gds_format_integer(self.ExternalPort, input_name='ExternalPort'), namespace_, eol_))
        if self.InternalIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInternalIpAddress>%s</%sInternalIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.InternalIpAddress).encode(ExternalEncoding), input_name='InternalIpAddress'), namespace_, eol_))
        if self.InternalPort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInternalPort>%s</%sInternalPort>%s' % (namespace_, self.gds_format_integer(self.InternalPort, input_name='InternalPort'), namespace_, eol_))
        if self.Protocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProtocol>%s</%sProtocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.Protocol).encode(ExternalEncoding), input_name='Protocol'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NatPortForwardingRuleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NatPortForwardingRuleType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NatPortForwardingRuleType, self).exportLiteralChildren(outfile, level, name_)
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('ExternalIpAddress=%s,\n' % quote_python(self.ExternalIpAddress).encode(ExternalEncoding))
        if self.ExternalPort is not None:
            showIndent(outfile, level)
            outfile.write('ExternalPort=%d,\n' % self.ExternalPort)
        if self.InternalIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('InternalIpAddress=%s,\n' % quote_python(self.InternalIpAddress).encode(ExternalEncoding))
        if self.InternalPort is not None:
            showIndent(outfile, level)
            outfile.write('InternalPort=%d,\n' % self.InternalPort)
        if self.Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Protocol=%s,\n' % quote_python(self.Protocol).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NatPortForwardingRuleType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ExternalIpAddress':
            ExternalIpAddress_ = child_.text
            ExternalIpAddress_ = self.gds_validate_string(ExternalIpAddress_, node, 'ExternalIpAddress')
            self.ExternalIpAddress = ExternalIpAddress_
            self.validate_IpAddressType(self.ExternalIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'ExternalPort':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ExternalPort')
            self.ExternalPort = ival_
        elif nodeName_ == 'InternalIpAddress':
            InternalIpAddress_ = child_.text
            InternalIpAddress_ = self.gds_validate_string(InternalIpAddress_, node, 'InternalIpAddress')
            self.InternalIpAddress = InternalIpAddress_
            self.validate_IpAddressType(self.InternalIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'InternalPort':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'InternalPort')
            self.InternalPort = ival_
        elif nodeName_ == 'Protocol':
            Protocol_ = child_.text
            Protocol_ = self.gds_validate_string(Protocol_, node, 'Protocol')
            self.Protocol = Protocol_
        super(NatPortForwardingRuleType, self).buildChildren(child_, node, nodeName_, True)
# end class NatPortForwardingRuleType


class NatOneToOneVmRuleType(VCloudExtensibleType):
    """0.9 Represents the NAT rule for one to one mapping of VM NIC and
    external IP addresses from a network."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, MappingMode=None, ExternalIpAddress=None, VAppScopedVmId=None, VmNicId=None):
        self.original_tagname_ = None
        super(NatOneToOneVmRuleType, self).__init__(VCloudExtension, )
        self.MappingMode = MappingMode
        self.ExternalIpAddress = ExternalIpAddress
        self.VAppScopedVmId = VAppScopedVmId
        self.VmNicId = VmNicId
    def factory(*args_, **kwargs_):
        if NatOneToOneVmRuleType.subclass:
            return NatOneToOneVmRuleType.subclass(*args_, **kwargs_)
        else:
            return NatOneToOneVmRuleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MappingMode(self): return self.MappingMode
    def set_MappingMode(self, MappingMode): self.MappingMode = MappingMode
    def get_ExternalIpAddress(self): return self.ExternalIpAddress
    def set_ExternalIpAddress(self, ExternalIpAddress): self.ExternalIpAddress = ExternalIpAddress
    def get_VAppScopedVmId(self): return self.VAppScopedVmId
    def set_VAppScopedVmId(self, VAppScopedVmId): self.VAppScopedVmId = VAppScopedVmId
    def get_VmNicId(self): return self.VmNicId
    def set_VmNicId(self, VmNicId): self.VmNicId = VmNicId
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.MappingMode is not None or
            self.ExternalIpAddress is not None or
            self.VAppScopedVmId is not None or
            self.VmNicId is not None or
            super(NatOneToOneVmRuleType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NatOneToOneVmRuleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NatOneToOneVmRuleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NatOneToOneVmRuleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NatOneToOneVmRuleType'):
        super(NatOneToOneVmRuleType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NatOneToOneVmRuleType')
    def exportChildren(self, outfile, level, namespace_='', name_='NatOneToOneVmRuleType', fromsubclass_=False, pretty_print=True):
        super(NatOneToOneVmRuleType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.MappingMode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMappingMode>%s</%sMappingMode>%s' % (namespace_, self.gds_format_string(quote_xml(self.MappingMode).encode(ExternalEncoding), input_name='MappingMode'), namespace_, eol_))
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExternalIpAddress>%s</%sExternalIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.ExternalIpAddress).encode(ExternalEncoding), input_name='ExternalIpAddress'), namespace_, eol_))
        if self.VAppScopedVmId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVAppScopedVmId>%s</%sVAppScopedVmId>%s' % (namespace_, self.gds_format_string(quote_xml(self.VAppScopedVmId).encode(ExternalEncoding), input_name='VAppScopedVmId'), namespace_, eol_))
        if self.VmNicId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVmNicId>%s</%sVmNicId>%s' % (namespace_, self.gds_format_integer(self.VmNicId, input_name='VmNicId'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NatOneToOneVmRuleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NatOneToOneVmRuleType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NatOneToOneVmRuleType, self).exportLiteralChildren(outfile, level, name_)
        if self.MappingMode is not None:
            showIndent(outfile, level)
            outfile.write('MappingMode=%s,\n' % quote_python(self.MappingMode).encode(ExternalEncoding))
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('ExternalIpAddress=%s,\n' % quote_python(self.ExternalIpAddress).encode(ExternalEncoding))
        if self.VAppScopedVmId is not None:
            showIndent(outfile, level)
            outfile.write('VAppScopedVmId=%s,\n' % quote_python(self.VAppScopedVmId).encode(ExternalEncoding))
        if self.VmNicId is not None:
            showIndent(outfile, level)
            outfile.write('VmNicId=%d,\n' % self.VmNicId)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NatOneToOneVmRuleType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MappingMode':
            MappingMode_ = child_.text
            MappingMode_ = self.gds_validate_string(MappingMode_, node, 'MappingMode')
            self.MappingMode = MappingMode_
        elif nodeName_ == 'ExternalIpAddress':
            ExternalIpAddress_ = child_.text
            ExternalIpAddress_ = self.gds_validate_string(ExternalIpAddress_, node, 'ExternalIpAddress')
            self.ExternalIpAddress = ExternalIpAddress_
            self.validate_IpAddressType(self.ExternalIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'VAppScopedVmId':
            VAppScopedVmId_ = child_.text
            VAppScopedVmId_ = self.gds_validate_string(VAppScopedVmId_, node, 'VAppScopedVmId')
            self.VAppScopedVmId = VAppScopedVmId_
        elif nodeName_ == 'VmNicId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'VmNicId')
            self.VmNicId = ival_
        super(NatOneToOneVmRuleType, self).buildChildren(child_, node, nodeName_, True)
# end class NatOneToOneVmRuleType


class NatOneToOneBasicRuleType(VCloudExtensibleType):
    """0.9 Represents the NAT basic rule for one to one mapping of internal
    and external IP addresses from a network."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, MappingMode=None, ExternalIpAddress=None, InternalIpAddress=None):
        self.original_tagname_ = None
        super(NatOneToOneBasicRuleType, self).__init__(VCloudExtension, )
        self.MappingMode = MappingMode
        self.ExternalIpAddress = ExternalIpAddress
        self.InternalIpAddress = InternalIpAddress
    def factory(*args_, **kwargs_):
        if NatOneToOneBasicRuleType.subclass:
            return NatOneToOneBasicRuleType.subclass(*args_, **kwargs_)
        else:
            return NatOneToOneBasicRuleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MappingMode(self): return self.MappingMode
    def set_MappingMode(self, MappingMode): self.MappingMode = MappingMode
    def get_ExternalIpAddress(self): return self.ExternalIpAddress
    def set_ExternalIpAddress(self, ExternalIpAddress): self.ExternalIpAddress = ExternalIpAddress
    def get_InternalIpAddress(self): return self.InternalIpAddress
    def set_InternalIpAddress(self, InternalIpAddress): self.InternalIpAddress = InternalIpAddress
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.MappingMode is not None or
            self.ExternalIpAddress is not None or
            self.InternalIpAddress is not None or
            super(NatOneToOneBasicRuleType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NatOneToOneBasicRuleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NatOneToOneBasicRuleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NatOneToOneBasicRuleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NatOneToOneBasicRuleType'):
        super(NatOneToOneBasicRuleType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NatOneToOneBasicRuleType')
    def exportChildren(self, outfile, level, namespace_='', name_='NatOneToOneBasicRuleType', fromsubclass_=False, pretty_print=True):
        super(NatOneToOneBasicRuleType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.MappingMode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMappingMode>%s</%sMappingMode>%s' % (namespace_, self.gds_format_string(quote_xml(self.MappingMode).encode(ExternalEncoding), input_name='MappingMode'), namespace_, eol_))
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExternalIpAddress>%s</%sExternalIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.ExternalIpAddress).encode(ExternalEncoding), input_name='ExternalIpAddress'), namespace_, eol_))
        if self.InternalIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInternalIpAddress>%s</%sInternalIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.InternalIpAddress).encode(ExternalEncoding), input_name='InternalIpAddress'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NatOneToOneBasicRuleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NatOneToOneBasicRuleType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NatOneToOneBasicRuleType, self).exportLiteralChildren(outfile, level, name_)
        if self.MappingMode is not None:
            showIndent(outfile, level)
            outfile.write('MappingMode=%s,\n' % quote_python(self.MappingMode).encode(ExternalEncoding))
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('ExternalIpAddress=%s,\n' % quote_python(self.ExternalIpAddress).encode(ExternalEncoding))
        if self.InternalIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('InternalIpAddress=%s,\n' % quote_python(self.InternalIpAddress).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NatOneToOneBasicRuleType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MappingMode':
            MappingMode_ = child_.text
            MappingMode_ = self.gds_validate_string(MappingMode_, node, 'MappingMode')
            self.MappingMode = MappingMode_
        elif nodeName_ == 'ExternalIpAddress':
            ExternalIpAddress_ = child_.text
            ExternalIpAddress_ = self.gds_validate_string(ExternalIpAddress_, node, 'ExternalIpAddress')
            self.ExternalIpAddress = ExternalIpAddress_
            self.validate_IpAddressType(self.ExternalIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'InternalIpAddress':
            InternalIpAddress_ = child_.text
            InternalIpAddress_ = self.gds_validate_string(InternalIpAddress_, node, 'InternalIpAddress')
            self.InternalIpAddress = InternalIpAddress_
            self.validate_IpAddressType(self.InternalIpAddress)    # validate type IpAddressType
        super(NatOneToOneBasicRuleType, self).buildChildren(child_, node, nodeName_, True)
# end class NatOneToOneBasicRuleType


class GatewayNatRuleType(VCloudExtensibleType):
    """5.1 Represents the SNAT and DNAT rules."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Interface=None, OriginalIp=None, OriginalPort=None, TranslatedIp=None, TranslatedPort=None, Protocol=None, IcmpSubType=None):
        self.original_tagname_ = None
        super(GatewayNatRuleType, self).__init__(VCloudExtension, )
        self.Interface = Interface
        self.OriginalIp = OriginalIp
        self.OriginalPort = OriginalPort
        self.TranslatedIp = TranslatedIp
        self.TranslatedPort = TranslatedPort
        self.Protocol = Protocol
        self.IcmpSubType = IcmpSubType
    def factory(*args_, **kwargs_):
        if GatewayNatRuleType.subclass:
            return GatewayNatRuleType.subclass(*args_, **kwargs_)
        else:
            return GatewayNatRuleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Interface(self): return self.Interface
    def set_Interface(self, Interface): self.Interface = Interface
    def get_OriginalIp(self): return self.OriginalIp
    def set_OriginalIp(self, OriginalIp): self.OriginalIp = OriginalIp
    def get_OriginalPort(self): return self.OriginalPort
    def set_OriginalPort(self, OriginalPort): self.OriginalPort = OriginalPort
    def get_TranslatedIp(self): return self.TranslatedIp
    def set_TranslatedIp(self, TranslatedIp): self.TranslatedIp = TranslatedIp
    def get_TranslatedPort(self): return self.TranslatedPort
    def set_TranslatedPort(self, TranslatedPort): self.TranslatedPort = TranslatedPort
    def get_Protocol(self): return self.Protocol
    def set_Protocol(self, Protocol): self.Protocol = Protocol
    def get_IcmpSubType(self): return self.IcmpSubType
    def set_IcmpSubType(self, IcmpSubType): self.IcmpSubType = IcmpSubType
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Interface is not None or
            self.OriginalIp is not None or
            self.OriginalPort is not None or
            self.TranslatedIp is not None or
            self.TranslatedPort is not None or
            self.Protocol is not None or
            self.IcmpSubType is not None or
            super(GatewayNatRuleType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayNatRuleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayNatRuleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayNatRuleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayNatRuleType'):
        super(GatewayNatRuleType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayNatRuleType')
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayNatRuleType', fromsubclass_=False, pretty_print=True):
        super(GatewayNatRuleType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Interface is not None:
            self.Interface.export(outfile, level, namespace_, name_='Interface', pretty_print=pretty_print)
        if self.OriginalIp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOriginalIp>%s</%sOriginalIp>%s' % (namespace_, self.gds_format_string(quote_xml(self.OriginalIp).encode(ExternalEncoding), input_name='OriginalIp'), namespace_, eol_))
        if self.OriginalPort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOriginalPort>%s</%sOriginalPort>%s' % (namespace_, self.gds_format_string(quote_xml(self.OriginalPort).encode(ExternalEncoding), input_name='OriginalPort'), namespace_, eol_))
        if self.TranslatedIp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTranslatedIp>%s</%sTranslatedIp>%s' % (namespace_, self.gds_format_string(quote_xml(self.TranslatedIp).encode(ExternalEncoding), input_name='TranslatedIp'), namespace_, eol_))
        if self.TranslatedPort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTranslatedPort>%s</%sTranslatedPort>%s' % (namespace_, self.gds_format_string(quote_xml(self.TranslatedPort).encode(ExternalEncoding), input_name='TranslatedPort'), namespace_, eol_))
        if self.Protocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProtocol>%s</%sProtocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.Protocol).encode(ExternalEncoding), input_name='Protocol'), namespace_, eol_))
        if self.IcmpSubType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIcmpSubType>%s</%sIcmpSubType>%s' % (namespace_, self.gds_format_string(quote_xml(self.IcmpSubType).encode(ExternalEncoding), input_name='IcmpSubType'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='GatewayNatRuleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GatewayNatRuleType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayNatRuleType, self).exportLiteralChildren(outfile, level, name_)
        if self.Interface is not None:
            showIndent(outfile, level)
            outfile.write('Interface=model_.ReferenceType(\n')
            self.Interface.exportLiteral(outfile, level, name_='Interface')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.OriginalIp is not None:
            showIndent(outfile, level)
            outfile.write('OriginalIp=%s,\n' % quote_python(self.OriginalIp).encode(ExternalEncoding))
        if self.OriginalPort is not None:
            showIndent(outfile, level)
            outfile.write('OriginalPort=%s,\n' % quote_python(self.OriginalPort).encode(ExternalEncoding))
        if self.TranslatedIp is not None:
            showIndent(outfile, level)
            outfile.write('TranslatedIp=%s,\n' % quote_python(self.TranslatedIp).encode(ExternalEncoding))
        if self.TranslatedPort is not None:
            showIndent(outfile, level)
            outfile.write('TranslatedPort=%s,\n' % quote_python(self.TranslatedPort).encode(ExternalEncoding))
        if self.Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Protocol=%s,\n' % quote_python(self.Protocol).encode(ExternalEncoding))
        if self.IcmpSubType is not None:
            showIndent(outfile, level)
            outfile.write('IcmpSubType=%s,\n' % quote_python(self.IcmpSubType).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GatewayNatRuleType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Interface':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Interface = obj_
            obj_.original_tagname_ = 'Interface'
        elif nodeName_ == 'OriginalIp':
            OriginalIp_ = child_.text
            OriginalIp_ = self.gds_validate_string(OriginalIp_, node, 'OriginalIp')
            self.OriginalIp = OriginalIp_
            self.validate_IpAddressType(self.OriginalIp)    # validate type IpAddressType
        elif nodeName_ == 'OriginalPort':
            OriginalPort_ = child_.text
            OriginalPort_ = self.gds_validate_string(OriginalPort_, node, 'OriginalPort')
            self.OriginalPort = OriginalPort_
        elif nodeName_ == 'TranslatedIp':
            TranslatedIp_ = child_.text
            TranslatedIp_ = self.gds_validate_string(TranslatedIp_, node, 'TranslatedIp')
            self.TranslatedIp = TranslatedIp_
            self.validate_IpAddressType(self.TranslatedIp)    # validate type IpAddressType
        elif nodeName_ == 'TranslatedPort':
            TranslatedPort_ = child_.text
            TranslatedPort_ = self.gds_validate_string(TranslatedPort_, node, 'TranslatedPort')
            self.TranslatedPort = TranslatedPort_
        elif nodeName_ == 'Protocol':
            Protocol_ = child_.text
            Protocol_ = self.gds_validate_string(Protocol_, node, 'Protocol')
            self.Protocol = Protocol_
        elif nodeName_ == 'IcmpSubType':
            IcmpSubType_ = child_.text
            IcmpSubType_ = self.gds_validate_string(IcmpSubType_, node, 'IcmpSubType')
            self.IcmpSubType = IcmpSubType_
        super(GatewayNatRuleType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayNatRuleType


class NatRuleType(VCloudExtensibleType):
    """0.9 Represents a NAT rule."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Description=None, RuleType=None, IsEnabled=None, Id=None, GatewayNatRule=None, OneToOneBasicRule=None, OneToOneVmRule=None, PortForwardingRule=None, VmRule=None):
        self.original_tagname_ = None
        super(NatRuleType, self).__init__(VCloudExtension, )
        self.Description = Description
        self.RuleType = RuleType
        self.IsEnabled = IsEnabled
        self.Id = Id
        self.GatewayNatRule = GatewayNatRule
        self.OneToOneBasicRule = OneToOneBasicRule
        self.OneToOneVmRule = OneToOneVmRule
        self.PortForwardingRule = PortForwardingRule
        self.VmRule = VmRule
    def factory(*args_, **kwargs_):
        if NatRuleType.subclass:
            return NatRuleType.subclass(*args_, **kwargs_)
        else:
            return NatRuleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_RuleType(self): return self.RuleType
    def set_RuleType(self, RuleType): self.RuleType = RuleType
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_GatewayNatRule(self): return self.GatewayNatRule
    def set_GatewayNatRule(self, GatewayNatRule): self.GatewayNatRule = GatewayNatRule
    def get_OneToOneBasicRule(self): return self.OneToOneBasicRule
    def set_OneToOneBasicRule(self, OneToOneBasicRule): self.OneToOneBasicRule = OneToOneBasicRule
    def get_OneToOneVmRule(self): return self.OneToOneVmRule
    def set_OneToOneVmRule(self, OneToOneVmRule): self.OneToOneVmRule = OneToOneVmRule
    def get_PortForwardingRule(self): return self.PortForwardingRule
    def set_PortForwardingRule(self, PortForwardingRule): self.PortForwardingRule = PortForwardingRule
    def get_VmRule(self): return self.VmRule
    def set_VmRule(self, VmRule): self.VmRule = VmRule
    def hasContent_(self):
        if (
            self.Description is not None or
            self.RuleType is not None or
            self.IsEnabled is not None or
            self.Id is not None or
            self.GatewayNatRule is not None or
            self.OneToOneBasicRule is not None or
            self.OneToOneVmRule is not None or
            self.PortForwardingRule is not None or
            self.VmRule is not None or
            super(NatRuleType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NatRuleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NatRuleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NatRuleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NatRuleType'):
        super(NatRuleType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NatRuleType')
    def exportChildren(self, outfile, level, namespace_='', name_='NatRuleType', fromsubclass_=False, pretty_print=True):
        super(NatRuleType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        if self.RuleType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRuleType>%s</%sRuleType>%s' % (namespace_, self.gds_format_string(quote_xml(self.RuleType).encode(ExternalEncoding), input_name='RuleType'), namespace_, eol_))
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
        if self.Id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sId>%s</%sId>%s' % (namespace_, self.gds_format_integer(self.Id, input_name='Id'), namespace_, eol_))
        if self.GatewayNatRule is not None:
            self.GatewayNatRule.export(outfile, level, namespace_, name_='GatewayNatRule', pretty_print=pretty_print)
        if self.OneToOneBasicRule is not None:
            self.OneToOneBasicRule.export(outfile, level, namespace_, name_='OneToOneBasicRule', pretty_print=pretty_print)
        if self.OneToOneVmRule is not None:
            self.OneToOneVmRule.export(outfile, level, namespace_, name_='OneToOneVmRule', pretty_print=pretty_print)
        if self.PortForwardingRule is not None:
            self.PortForwardingRule.export(outfile, level, namespace_, name_='PortForwardingRule', pretty_print=pretty_print)
        if self.VmRule is not None:
            self.VmRule.export(outfile, level, namespace_, name_='VmRule', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NatRuleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NatRuleType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NatRuleType, self).exportLiteralChildren(outfile, level, name_)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.RuleType is not None:
            showIndent(outfile, level)
            outfile.write('RuleType=%s,\n' % quote_python(self.RuleType).encode(ExternalEncoding))
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
        if self.Id is not None:
            showIndent(outfile, level)
            outfile.write('Id=%d,\n' % self.Id)
        if self.GatewayNatRule is not None:
            showIndent(outfile, level)
            outfile.write('GatewayNatRule=model_.GatewayNatRuleType(\n')
            self.GatewayNatRule.exportLiteral(outfile, level, name_='GatewayNatRule')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.OneToOneBasicRule is not None:
            showIndent(outfile, level)
            outfile.write('OneToOneBasicRule=model_.NatOneToOneBasicRuleType(\n')
            self.OneToOneBasicRule.exportLiteral(outfile, level, name_='OneToOneBasicRule')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.OneToOneVmRule is not None:
            showIndent(outfile, level)
            outfile.write('OneToOneVmRule=model_.NatOneToOneVmRuleType(\n')
            self.OneToOneVmRule.exportLiteral(outfile, level, name_='OneToOneVmRule')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PortForwardingRule is not None:
            showIndent(outfile, level)
            outfile.write('PortForwardingRule=model_.NatPortForwardingRuleType(\n')
            self.PortForwardingRule.exportLiteral(outfile, level, name_='PortForwardingRule')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.VmRule is not None:
            showIndent(outfile, level)
            outfile.write('VmRule=model_.NatVmRuleType(\n')
            self.VmRule.exportLiteral(outfile, level, name_='VmRule')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NatRuleType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'RuleType':
            RuleType_ = child_.text
            RuleType_ = self.gds_validate_string(RuleType_, node, 'RuleType')
            self.RuleType = RuleType_
        elif nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'Id':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Id')
            self.Id = ival_
        elif nodeName_ == 'GatewayNatRule':
            obj_ = GatewayNatRuleType.factory()
            obj_.build(child_)
            self.GatewayNatRule = obj_
            obj_.original_tagname_ = 'GatewayNatRule'
        elif nodeName_ == 'OneToOneBasicRule':
            obj_ = NatOneToOneBasicRuleType.factory()
            obj_.build(child_)
            self.OneToOneBasicRule = obj_
            obj_.original_tagname_ = 'OneToOneBasicRule'
        elif nodeName_ == 'OneToOneVmRule':
            obj_ = NatOneToOneVmRuleType.factory()
            obj_.build(child_)
            self.OneToOneVmRule = obj_
            obj_.original_tagname_ = 'OneToOneVmRule'
        elif nodeName_ == 'PortForwardingRule':
            obj_ = NatPortForwardingRuleType.factory()
            obj_.build(child_)
            self.PortForwardingRule = obj_
            obj_.original_tagname_ = 'PortForwardingRule'
        elif nodeName_ == 'VmRule':
            obj_ = NatVmRuleType.factory()
            obj_.build(child_)
            self.VmRule = obj_
            obj_.original_tagname_ = 'VmRule'
        super(NatRuleType, self).buildChildren(child_, node, nodeName_, True)
# end class NatRuleType


class NetworkServiceType(VCloudExtensibleType):
    """This is the root of the substitution group for network services.
    Replace it with any of NatService, LoadBalancerService
    IpsecVpnService/GatewayIpsecVpnService,
    DhcpService/GatewayDhcpService, FirewallService, or
    StaticRoutingService."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IsEnabled=None, extensiontype_=None):
        self.original_tagname_ = None
        super(NetworkServiceType, self).__init__(VCloudExtension, extensiontype_, )
        self.IsEnabled = IsEnabled
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if NetworkServiceType.subclass:
            return NetworkServiceType.subclass(*args_, **kwargs_)
        else:
            return NetworkServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.IsEnabled is not None or
            super(NetworkServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NetworkServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkServiceType'):
        super(NetworkServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkServiceType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkServiceType', fromsubclass_=False, pretty_print=True):
        super(NetworkServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsEnabled>%s</%sIsEnabled>%s' % (namespace_, self.gds_format_boolean(self.IsEnabled, input_name='IsEnabled'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NetworkServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NetworkServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NetworkServiceType, self).exportLiteralChildren(outfile, level, name_)
        if self.IsEnabled is not None:
            showIndent(outfile, level)
            outfile.write('IsEnabled=%s,\n' % self.IsEnabled)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(NetworkServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        super(NetworkServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class NetworkServiceType


class NetworkType(EntityType):
    """0.9 Represents a Network in the vCloud model."""
    subclass = None
    superclass = EntityType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, Configuration=None, extensiontype_=None):
        self.original_tagname_ = None
        super(NetworkType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, name, Description, Tasks, extensiontype_, )
        self.Configuration = Configuration
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if NetworkType.subclass:
            return NetworkType.subclass(*args_, **kwargs_)
        else:
            return NetworkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Configuration(self): return self.Configuration
    def set_Configuration(self, Configuration): self.Configuration = Configuration
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Configuration is not None or
            super(NetworkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NetworkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkType'):
        super(NetworkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkType', fromsubclass_=False, pretty_print=True):
        super(NetworkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Configuration is not None:
            self.Configuration.export(outfile, level, namespace_, name_='Configuration', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NetworkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NetworkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NetworkType, self).exportLiteralChildren(outfile, level, name_)
        if self.Configuration is not None:
            showIndent(outfile, level)
            outfile.write('Configuration=model_.NetworkConfigurationType(\n')
            self.Configuration.exportLiteral(outfile, level, name_='Configuration')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(NetworkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Configuration':
            obj_ = NetworkConfigurationType.factory()
            obj_.build(child_)
            self.Configuration = obj_
            obj_.original_tagname_ = 'Configuration'
        super(NetworkType, self).buildChildren(child_, node, nodeName_, True)
# end class NetworkType


class OrgVdcNetworkType(NetworkType):
    """5.1 Represents an Org vDC network in the vCloud model. none Creation
    status of the org vDC network. One of:<br> 0 (The org vDC
    network is not completely created)<br> 1 (The org vDC network is
    ready) false"""
    subclass = None
    superclass = NetworkType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, Configuration=None, status=None, EdgeGateway=None, ServiceConfig=None, IsShared=None):
        self.original_tagname_ = None
        super(OrgVdcNetworkType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, name, Description, Tasks, Configuration, )
        self.status = _cast(int, status)
        self.EdgeGateway = EdgeGateway
        self.ServiceConfig = ServiceConfig
        self.IsShared = IsShared
    def factory(*args_, **kwargs_):
        if OrgVdcNetworkType.subclass:
            return OrgVdcNetworkType.subclass(*args_, **kwargs_)
        else:
            return OrgVdcNetworkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_EdgeGateway(self): return self.EdgeGateway
    def set_EdgeGateway(self, EdgeGateway): self.EdgeGateway = EdgeGateway
    def get_ServiceConfig(self): return self.ServiceConfig
    def set_ServiceConfig(self, ServiceConfig): self.ServiceConfig = ServiceConfig
    def get_IsShared(self): return self.IsShared
    def set_IsShared(self, IsShared): self.IsShared = IsShared
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def hasContent_(self):
        if (
            self.EdgeGateway is not None or
            self.ServiceConfig is not None or
            self.IsShared is not None or
            super(OrgVdcNetworkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OrgVdcNetworkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OrgVdcNetworkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OrgVdcNetworkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OrgVdcNetworkType'):
        super(OrgVdcNetworkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OrgVdcNetworkType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status="%s"' % self.gds_format_integer(self.status, input_name='status'))
    def exportChildren(self, outfile, level, namespace_='', name_='OrgVdcNetworkType', fromsubclass_=False, pretty_print=True):
        super(OrgVdcNetworkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.EdgeGateway is not None:
            self.EdgeGateway.export(outfile, level, namespace_, name_='EdgeGateway', pretty_print=pretty_print)
        if self.ServiceConfig is not None:
            self.ServiceConfig.export(outfile, level, namespace_, name_='ServiceConfig', pretty_print=pretty_print)
        if self.IsShared is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsShared>%s</%sIsShared>%s' % (namespace_, self.gds_format_boolean(self.IsShared, input_name='IsShared'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='OrgVdcNetworkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status=%d,\n' % (self.status,))
        super(OrgVdcNetworkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(OrgVdcNetworkType, self).exportLiteralChildren(outfile, level, name_)
        if self.EdgeGateway is not None:
            showIndent(outfile, level)
            outfile.write('EdgeGateway=model_.ReferenceType(\n')
            self.EdgeGateway.exportLiteral(outfile, level, name_='EdgeGateway')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ServiceConfig is not None:
            showIndent(outfile, level)
            outfile.write('ServiceConfig=model_.GatewayFeaturesType(\n')
            self.ServiceConfig.exportLiteral(outfile, level, name_='ServiceConfig')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IsShared is not None:
            showIndent(outfile, level)
            outfile.write('IsShared=%s,\n' % self.IsShared)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            try:
                self.status = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(OrgVdcNetworkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'EdgeGateway':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.EdgeGateway = obj_
            obj_.original_tagname_ = 'EdgeGateway'
        elif nodeName_ == 'ServiceConfig':
            obj_ = GatewayFeaturesType.factory()
            obj_.build(child_)
            self.ServiceConfig = obj_
            obj_.original_tagname_ = 'ServiceConfig'
        elif nodeName_ == 'IsShared':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsShared')
            self.IsShared = ival_
        super(OrgVdcNetworkType, self).buildChildren(child_, node, nodeName_, True)
# end class OrgVdcNetworkType


class GatewayIpsecVpnServiceType(NetworkServiceType):
    """5.1 Represents gateway IPsec VPN service."""
    subclass = None
    superclass = NetworkServiceType
    def __init__(self, VCloudExtension=None, IsEnabled=None, Endpoint=None, Tunnel=None):
        self.original_tagname_ = None
        super(GatewayIpsecVpnServiceType, self).__init__(VCloudExtension, IsEnabled, )
        if Endpoint is None:
            self.Endpoint = []
        else:
            self.Endpoint = Endpoint
        if Tunnel is None:
            self.Tunnel = []
        else:
            self.Tunnel = Tunnel
    def factory(*args_, **kwargs_):
        if GatewayIpsecVpnServiceType.subclass:
            return GatewayIpsecVpnServiceType.subclass(*args_, **kwargs_)
        else:
            return GatewayIpsecVpnServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Endpoint(self): return self.Endpoint
    def set_Endpoint(self, Endpoint): self.Endpoint = Endpoint
    def add_Endpoint(self, value): self.Endpoint.append(value)
    def insert_Endpoint_at(self, index, value): self.Endpoint.insert(index, value)
    def replace_Endpoint_at(self, index, value): self.Endpoint[index] = value
    def get_Tunnel(self): return self.Tunnel
    def set_Tunnel(self, Tunnel): self.Tunnel = Tunnel
    def add_Tunnel(self, value): self.Tunnel.append(value)
    def insert_Tunnel_at(self, index, value): self.Tunnel.insert(index, value)
    def replace_Tunnel_at(self, index, value): self.Tunnel[index] = value
    def hasContent_(self):
        if (
            self.Endpoint or
            self.Tunnel or
            super(GatewayIpsecVpnServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayIpsecVpnServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayIpsecVpnServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayIpsecVpnServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayIpsecVpnServiceType'):
        super(GatewayIpsecVpnServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayIpsecVpnServiceType')
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayIpsecVpnServiceType', fromsubclass_=False, pretty_print=True):
        super(GatewayIpsecVpnServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Endpoint_ in self.Endpoint:
            Endpoint_.export(outfile, level, namespace_, name_='Endpoint', pretty_print=pretty_print)
        for Tunnel_ in self.Tunnel:
            Tunnel_.export(outfile, level, namespace_, name_='Tunnel', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GatewayIpsecVpnServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GatewayIpsecVpnServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayIpsecVpnServiceType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Endpoint=[\n')
        level += 1
        for Endpoint_ in self.Endpoint:
            showIndent(outfile, level)
            outfile.write('model_.GatewayIpsecVpnEndpointType(\n')
            Endpoint_.exportLiteral(outfile, level, name_='GatewayIpsecVpnEndpointType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Tunnel=[\n')
        level += 1
        for Tunnel_ in self.Tunnel:
            showIndent(outfile, level)
            outfile.write('model_.GatewayIpsecVpnTunnelType(\n')
            Tunnel_.exportLiteral(outfile, level, name_='GatewayIpsecVpnTunnelType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GatewayIpsecVpnServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Endpoint':
            obj_ = GatewayIpsecVpnEndpointType.factory()
            obj_.build(child_)
            self.Endpoint.append(obj_)
            obj_.original_tagname_ = 'Endpoint'
        elif nodeName_ == 'Tunnel':
            obj_ = GatewayIpsecVpnTunnelType.factory()
            obj_.build(child_)
            self.Tunnel.append(obj_)
            obj_.original_tagname_ = 'Tunnel'
        super(GatewayIpsecVpnServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayIpsecVpnServiceType


class LoadBalancerServiceType(NetworkServiceType):
    """5.1 Represents gateway load balancer service."""
    subclass = None
    superclass = NetworkServiceType
    def __init__(self, VCloudExtension=None, IsEnabled=None, Pool=None, VirtualServer=None):
        self.original_tagname_ = None
        super(LoadBalancerServiceType, self).__init__(VCloudExtension, IsEnabled, )
        if Pool is None:
            self.Pool = []
        else:
            self.Pool = Pool
        if VirtualServer is None:
            self.VirtualServer = []
        else:
            self.VirtualServer = VirtualServer
    def factory(*args_, **kwargs_):
        if LoadBalancerServiceType.subclass:
            return LoadBalancerServiceType.subclass(*args_, **kwargs_)
        else:
            return LoadBalancerServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Pool(self): return self.Pool
    def set_Pool(self, Pool): self.Pool = Pool
    def add_Pool(self, value): self.Pool.append(value)
    def insert_Pool_at(self, index, value): self.Pool.insert(index, value)
    def replace_Pool_at(self, index, value): self.Pool[index] = value
    def get_VirtualServer(self): return self.VirtualServer
    def set_VirtualServer(self, VirtualServer): self.VirtualServer = VirtualServer
    def add_VirtualServer(self, value): self.VirtualServer.append(value)
    def insert_VirtualServer_at(self, index, value): self.VirtualServer.insert(index, value)
    def replace_VirtualServer_at(self, index, value): self.VirtualServer[index] = value
    def hasContent_(self):
        if (
            self.Pool or
            self.VirtualServer or
            super(LoadBalancerServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LoadBalancerServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LoadBalancerServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LoadBalancerServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LoadBalancerServiceType'):
        super(LoadBalancerServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LoadBalancerServiceType')
    def exportChildren(self, outfile, level, namespace_='', name_='LoadBalancerServiceType', fromsubclass_=False, pretty_print=True):
        super(LoadBalancerServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Pool_ in self.Pool:
            Pool_.export(outfile, level, namespace_, name_='Pool', pretty_print=pretty_print)
        for VirtualServer_ in self.VirtualServer:
            VirtualServer_.export(outfile, level, namespace_, name_='VirtualServer', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LoadBalancerServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LoadBalancerServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LoadBalancerServiceType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Pool=[\n')
        level += 1
        for Pool_ in self.Pool:
            showIndent(outfile, level)
            outfile.write('model_.LoadBalancerPoolType(\n')
            Pool_.exportLiteral(outfile, level, name_='LoadBalancerPoolType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('VirtualServer=[\n')
        level += 1
        for VirtualServer_ in self.VirtualServer:
            showIndent(outfile, level)
            outfile.write('model_.LoadBalancerVirtualServerType(\n')
            VirtualServer_.exportLiteral(outfile, level, name_='LoadBalancerVirtualServerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LoadBalancerServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Pool':
            obj_ = LoadBalancerPoolType.factory()
            obj_.build(child_)
            self.Pool.append(obj_)
            obj_.original_tagname_ = 'Pool'
        elif nodeName_ == 'VirtualServer':
            obj_ = LoadBalancerVirtualServerType.factory()
            obj_.build(child_)
            self.VirtualServer.append(obj_)
            obj_.original_tagname_ = 'VirtualServer'
        super(LoadBalancerServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class LoadBalancerServiceType


class GatewayDhcpServiceType(NetworkServiceType):
    """5.1 Represents Gateway DHCP service."""
    subclass = None
    superclass = NetworkServiceType
    def __init__(self, VCloudExtension=None, IsEnabled=None, Pool=None):
        self.original_tagname_ = None
        super(GatewayDhcpServiceType, self).__init__(VCloudExtension, IsEnabled, )
        if Pool is None:
            self.Pool = []
        else:
            self.Pool = Pool
    def factory(*args_, **kwargs_):
        if GatewayDhcpServiceType.subclass:
            return GatewayDhcpServiceType.subclass(*args_, **kwargs_)
        else:
            return GatewayDhcpServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Pool(self): return self.Pool
    def set_Pool(self, Pool): self.Pool = Pool
    def add_Pool(self, value): self.Pool.append(value)
    def insert_Pool_at(self, index, value): self.Pool.insert(index, value)
    def replace_Pool_at(self, index, value): self.Pool[index] = value
    def hasContent_(self):
        if (
            self.Pool or
            super(GatewayDhcpServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GatewayDhcpServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayDhcpServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GatewayDhcpServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GatewayDhcpServiceType'):
        super(GatewayDhcpServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GatewayDhcpServiceType')
    def exportChildren(self, outfile, level, namespace_='', name_='GatewayDhcpServiceType', fromsubclass_=False, pretty_print=True):
        super(GatewayDhcpServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Pool_ in self.Pool:
            Pool_.export(outfile, level, namespace_, name_='Pool', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GatewayDhcpServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(GatewayDhcpServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GatewayDhcpServiceType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Pool=[\n')
        level += 1
        for Pool_ in self.Pool:
            showIndent(outfile, level)
            outfile.write('model_.DhcpPoolServiceType(\n')
            Pool_.exportLiteral(outfile, level, name_='DhcpPoolServiceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GatewayDhcpServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Pool':
            obj_ = DhcpPoolServiceType.factory()
            obj_.build(child_)
            self.Pool.append(obj_)
            obj_.original_tagname_ = 'Pool'
        super(GatewayDhcpServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class GatewayDhcpServiceType


class StaticRoutingServiceType(NetworkServiceType):
    """1.5 Represents Static Routing network service."""
    subclass = None
    superclass = NetworkServiceType
    def __init__(self, VCloudExtension=None, IsEnabled=None, StaticRoute=None):
        self.original_tagname_ = None
        super(StaticRoutingServiceType, self).__init__(VCloudExtension, IsEnabled, )
        if StaticRoute is None:
            self.StaticRoute = []
        else:
            self.StaticRoute = StaticRoute
    def factory(*args_, **kwargs_):
        if StaticRoutingServiceType.subclass:
            return StaticRoutingServiceType.subclass(*args_, **kwargs_)
        else:
            return StaticRoutingServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_StaticRoute(self): return self.StaticRoute
    def set_StaticRoute(self, StaticRoute): self.StaticRoute = StaticRoute
    def add_StaticRoute(self, value): self.StaticRoute.append(value)
    def insert_StaticRoute_at(self, index, value): self.StaticRoute.insert(index, value)
    def replace_StaticRoute_at(self, index, value): self.StaticRoute[index] = value
    def hasContent_(self):
        if (
            self.StaticRoute or
            super(StaticRoutingServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StaticRoutingServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StaticRoutingServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StaticRoutingServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StaticRoutingServiceType'):
        super(StaticRoutingServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StaticRoutingServiceType')
    def exportChildren(self, outfile, level, namespace_='', name_='StaticRoutingServiceType', fromsubclass_=False, pretty_print=True):
        super(StaticRoutingServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for StaticRoute_ in self.StaticRoute:
            StaticRoute_.export(outfile, level, namespace_, name_='StaticRoute', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StaticRoutingServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StaticRoutingServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StaticRoutingServiceType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('StaticRoute=[\n')
        level += 1
        for StaticRoute_ in self.StaticRoute:
            showIndent(outfile, level)
            outfile.write('model_.StaticRouteType(\n')
            StaticRoute_.exportLiteral(outfile, level, name_='StaticRouteType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StaticRoutingServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'StaticRoute':
            obj_ = StaticRouteType.factory()
            obj_.build(child_)
            self.StaticRoute.append(obj_)
            obj_.original_tagname_ = 'StaticRoute'
        super(StaticRoutingServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class StaticRoutingServiceType


class IpsecVpnUnmanagedPeerType(IpsecVpnPeerType):
    """1.5 Gives more details of peer end point not managed by vCloud
    Director."""
    subclass = None
    superclass = IpsecVpnPeerType
    def __init__(self, VCloudExtension=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IpsecVpnUnmanagedPeerType, self).__init__(VCloudExtension, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if IpsecVpnUnmanagedPeerType.subclass:
            return IpsecVpnUnmanagedPeerType.subclass(*args_, **kwargs_)
        else:
            return IpsecVpnUnmanagedPeerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(IpsecVpnUnmanagedPeerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpsecVpnUnmanagedPeerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnUnmanagedPeerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpsecVpnUnmanagedPeerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpsecVpnUnmanagedPeerType'):
        super(IpsecVpnUnmanagedPeerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnUnmanagedPeerType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IpsecVpnUnmanagedPeerType', fromsubclass_=False, pretty_print=True):
        super(IpsecVpnUnmanagedPeerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IpsecVpnUnmanagedPeerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpsecVpnUnmanagedPeerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpsecVpnUnmanagedPeerType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IpsecVpnUnmanagedPeerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IpsecVpnUnmanagedPeerType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IpsecVpnUnmanagedPeerType


class IpsecVpnManagedPeerType(IpsecVpnPeerType):
    """1.5 Gives more details of peer end point."""
    subclass = None
    superclass = IpsecVpnPeerType
    def __init__(self, VCloudExtension=None, Id=None, Name=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IpsecVpnManagedPeerType, self).__init__(VCloudExtension, extensiontype_, )
        self.Id = Id
        self.Name = Name
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if IpsecVpnManagedPeerType.subclass:
            return IpsecVpnManagedPeerType.subclass(*args_, **kwargs_)
        else:
            return IpsecVpnManagedPeerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None or
            super(IpsecVpnManagedPeerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpsecVpnManagedPeerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnManagedPeerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpsecVpnManagedPeerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpsecVpnManagedPeerType'):
        super(IpsecVpnManagedPeerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnManagedPeerType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IpsecVpnManagedPeerType', fromsubclass_=False, pretty_print=True):
        super(IpsecVpnManagedPeerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sId>%s</%sId>%s' % (namespace_, self.gds_format_string(quote_xml(self.Id).encode(ExternalEncoding), input_name='Id'), namespace_, eol_))
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IpsecVpnManagedPeerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpsecVpnManagedPeerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpsecVpnManagedPeerType, self).exportLiteralChildren(outfile, level, name_)
        if self.Id is not None:
            showIndent(outfile, level)
            outfile.write('Id=%s,\n' % quote_python(self.Id).encode(ExternalEncoding))
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IpsecVpnManagedPeerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        super(IpsecVpnManagedPeerType, self).buildChildren(child_, node, nodeName_, True)
# end class IpsecVpnManagedPeerType


class IpsecVpnServiceType(NetworkServiceType):
    """1.5 Represents an IPSec-VPN network service."""
    subclass = None
    superclass = NetworkServiceType
    def __init__(self, VCloudExtension=None, IsEnabled=None, ExternalIpAddress=None, PublicIpAddress=None, IpsecVpnTunnel=None):
        self.original_tagname_ = None
        super(IpsecVpnServiceType, self).__init__(VCloudExtension, IsEnabled, )
        self.ExternalIpAddress = ExternalIpAddress
        self.PublicIpAddress = PublicIpAddress
        if IpsecVpnTunnel is None:
            self.IpsecVpnTunnel = []
        else:
            self.IpsecVpnTunnel = IpsecVpnTunnel
    def factory(*args_, **kwargs_):
        if IpsecVpnServiceType.subclass:
            return IpsecVpnServiceType.subclass(*args_, **kwargs_)
        else:
            return IpsecVpnServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ExternalIpAddress(self): return self.ExternalIpAddress
    def set_ExternalIpAddress(self, ExternalIpAddress): self.ExternalIpAddress = ExternalIpAddress
    def get_PublicIpAddress(self): return self.PublicIpAddress
    def set_PublicIpAddress(self, PublicIpAddress): self.PublicIpAddress = PublicIpAddress
    def get_IpsecVpnTunnel(self): return self.IpsecVpnTunnel
    def set_IpsecVpnTunnel(self, IpsecVpnTunnel): self.IpsecVpnTunnel = IpsecVpnTunnel
    def add_IpsecVpnTunnel(self, value): self.IpsecVpnTunnel.append(value)
    def insert_IpsecVpnTunnel_at(self, index, value): self.IpsecVpnTunnel.insert(index, value)
    def replace_IpsecVpnTunnel_at(self, index, value): self.IpsecVpnTunnel[index] = value
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.ExternalIpAddress is not None or
            self.PublicIpAddress is not None or
            self.IpsecVpnTunnel or
            super(IpsecVpnServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpsecVpnServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpsecVpnServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpsecVpnServiceType'):
        super(IpsecVpnServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnServiceType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpsecVpnServiceType', fromsubclass_=False, pretty_print=True):
        super(IpsecVpnServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExternalIpAddress>%s</%sExternalIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.ExternalIpAddress).encode(ExternalEncoding), input_name='ExternalIpAddress'), namespace_, eol_))
        if self.PublicIpAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPublicIpAddress>%s</%sPublicIpAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.PublicIpAddress).encode(ExternalEncoding), input_name='PublicIpAddress'), namespace_, eol_))
        for IpsecVpnTunnel_ in self.IpsecVpnTunnel:
            IpsecVpnTunnel_.export(outfile, level, namespace_, name_='IpsecVpnTunnel', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IpsecVpnServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpsecVpnServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpsecVpnServiceType, self).exportLiteralChildren(outfile, level, name_)
        if self.ExternalIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('ExternalIpAddress=%s,\n' % quote_python(self.ExternalIpAddress).encode(ExternalEncoding))
        if self.PublicIpAddress is not None:
            showIndent(outfile, level)
            outfile.write('PublicIpAddress=%s,\n' % quote_python(self.PublicIpAddress).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('IpsecVpnTunnel=[\n')
        level += 1
        for IpsecVpnTunnel_ in self.IpsecVpnTunnel:
            showIndent(outfile, level)
            outfile.write('model_.IpsecVpnTunnelType(\n')
            IpsecVpnTunnel_.exportLiteral(outfile, level, name_='IpsecVpnTunnelType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpsecVpnServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ExternalIpAddress':
            ExternalIpAddress_ = child_.text
            ExternalIpAddress_ = self.gds_validate_string(ExternalIpAddress_, node, 'ExternalIpAddress')
            self.ExternalIpAddress = ExternalIpAddress_
            self.validate_IpAddressType(self.ExternalIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'PublicIpAddress':
            PublicIpAddress_ = child_.text
            PublicIpAddress_ = self.gds_validate_string(PublicIpAddress_, node, 'PublicIpAddress')
            self.PublicIpAddress = PublicIpAddress_
            self.validate_IpAddressType(self.PublicIpAddress)    # validate type IpAddressType
        elif nodeName_ == 'IpsecVpnTunnel':
            obj_ = IpsecVpnTunnelType.factory()
            obj_.build(child_)
            self.IpsecVpnTunnel.append(obj_)
            obj_.original_tagname_ = 'IpsecVpnTunnel'
        super(IpsecVpnServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class IpsecVpnServiceType


class FirewallServiceType(NetworkServiceType):
    """Represents a network firewall service."""
    subclass = None
    superclass = NetworkServiceType
    def __init__(self, VCloudExtension=None, IsEnabled=None, DefaultAction=None, LogDefaultAction=None, FirewallRule=None):
        self.original_tagname_ = None
        super(FirewallServiceType, self).__init__(VCloudExtension, IsEnabled, )
        self.DefaultAction = DefaultAction
        self.LogDefaultAction = LogDefaultAction
        if FirewallRule is None:
            self.FirewallRule = []
        else:
            self.FirewallRule = FirewallRule
    def factory(*args_, **kwargs_):
        if FirewallServiceType.subclass:
            return FirewallServiceType.subclass(*args_, **kwargs_)
        else:
            return FirewallServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DefaultAction(self): return self.DefaultAction
    def set_DefaultAction(self, DefaultAction): self.DefaultAction = DefaultAction
    def get_LogDefaultAction(self): return self.LogDefaultAction
    def set_LogDefaultAction(self, LogDefaultAction): self.LogDefaultAction = LogDefaultAction
    def get_FirewallRule(self): return self.FirewallRule
    def set_FirewallRule(self, FirewallRule): self.FirewallRule = FirewallRule
    def add_FirewallRule(self, value): self.FirewallRule.append(value)
    def insert_FirewallRule_at(self, index, value): self.FirewallRule.insert(index, value)
    def replace_FirewallRule_at(self, index, value): self.FirewallRule[index] = value
    def hasContent_(self):
        if (
            self.DefaultAction is not None or
            self.LogDefaultAction is not None or
            self.FirewallRule or
            super(FirewallServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FirewallServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FirewallServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FirewallServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FirewallServiceType'):
        super(FirewallServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FirewallServiceType')
    def exportChildren(self, outfile, level, namespace_='', name_='FirewallServiceType', fromsubclass_=False, pretty_print=True):
        super(FirewallServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DefaultAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDefaultAction>%s</%sDefaultAction>%s' % (namespace_, self.gds_format_string(quote_xml(self.DefaultAction).encode(ExternalEncoding), input_name='DefaultAction'), namespace_, eol_))
        if self.LogDefaultAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLogDefaultAction>%s</%sLogDefaultAction>%s' % (namespace_, self.gds_format_boolean(self.LogDefaultAction, input_name='LogDefaultAction'), namespace_, eol_))
        for FirewallRule_ in self.FirewallRule:
            FirewallRule_.export(outfile, level, namespace_, name_='FirewallRule', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FirewallServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(FirewallServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FirewallServiceType, self).exportLiteralChildren(outfile, level, name_)
        if self.DefaultAction is not None:
            showIndent(outfile, level)
            outfile.write('DefaultAction=%s,\n' % quote_python(self.DefaultAction).encode(ExternalEncoding))
        if self.LogDefaultAction is not None:
            showIndent(outfile, level)
            outfile.write('LogDefaultAction=%s,\n' % self.LogDefaultAction)
        showIndent(outfile, level)
        outfile.write('FirewallRule=[\n')
        level += 1
        for FirewallRule_ in self.FirewallRule:
            showIndent(outfile, level)
            outfile.write('model_.FirewallRuleType(\n')
            FirewallRule_.exportLiteral(outfile, level, name_='FirewallRuleType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(FirewallServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DefaultAction':
            DefaultAction_ = child_.text
            DefaultAction_ = self.gds_validate_string(DefaultAction_, node, 'DefaultAction')
            self.DefaultAction = DefaultAction_
        elif nodeName_ == 'LogDefaultAction':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'LogDefaultAction')
            self.LogDefaultAction = ival_
        elif nodeName_ == 'FirewallRule':
            obj_ = FirewallRuleType.factory()
            obj_.build(child_)
            self.FirewallRule.append(obj_)
            obj_.original_tagname_ = 'FirewallRule'
        super(FirewallServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class FirewallServiceType


class NatServiceType(NetworkServiceType):
    """Represents a NAT network service."""
    subclass = None
    superclass = NetworkServiceType
    def __init__(self, VCloudExtension=None, IsEnabled=None, NatType=None, Policy=None, NatRule=None, ExternalIp=None):
        self.original_tagname_ = None
        super(NatServiceType, self).__init__(VCloudExtension, IsEnabled, )
        self.NatType = NatType
        self.Policy = Policy
        if NatRule is None:
            self.NatRule = []
        else:
            self.NatRule = NatRule
        self.ExternalIp = ExternalIp
    def factory(*args_, **kwargs_):
        if NatServiceType.subclass:
            return NatServiceType.subclass(*args_, **kwargs_)
        else:
            return NatServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NatType(self): return self.NatType
    def set_NatType(self, NatType): self.NatType = NatType
    def get_Policy(self): return self.Policy
    def set_Policy(self, Policy): self.Policy = Policy
    def get_NatRule(self): return self.NatRule
    def set_NatRule(self, NatRule): self.NatRule = NatRule
    def add_NatRule(self, value): self.NatRule.append(value)
    def insert_NatRule_at(self, index, value): self.NatRule.insert(index, value)
    def replace_NatRule_at(self, index, value): self.NatRule[index] = value
    def get_ExternalIp(self): return self.ExternalIp
    def set_ExternalIp(self, ExternalIp): self.ExternalIp = ExternalIp
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.NatType is not None or
            self.Policy is not None or
            self.NatRule or
            self.ExternalIp is not None or
            super(NatServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NatServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NatServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NatServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NatServiceType'):
        super(NatServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NatServiceType')
    def exportChildren(self, outfile, level, namespace_='', name_='NatServiceType', fromsubclass_=False, pretty_print=True):
        super(NatServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.NatType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNatType>%s</%sNatType>%s' % (namespace_, self.gds_format_string(quote_xml(self.NatType).encode(ExternalEncoding), input_name='NatType'), namespace_, eol_))
        if self.Policy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPolicy>%s</%sPolicy>%s' % (namespace_, self.gds_format_string(quote_xml(self.Policy).encode(ExternalEncoding), input_name='Policy'), namespace_, eol_))
        for NatRule_ in self.NatRule:
            NatRule_.export(outfile, level, namespace_, name_='NatRule', pretty_print=pretty_print)
        if self.ExternalIp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExternalIp>%s</%sExternalIp>%s' % (namespace_, self.gds_format_string(quote_xml(self.ExternalIp).encode(ExternalEncoding), input_name='ExternalIp'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NatServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NatServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NatServiceType, self).exportLiteralChildren(outfile, level, name_)
        if self.NatType is not None:
            showIndent(outfile, level)
            outfile.write('NatType=%s,\n' % quote_python(self.NatType).encode(ExternalEncoding))
        if self.Policy is not None:
            showIndent(outfile, level)
            outfile.write('Policy=%s,\n' % quote_python(self.Policy).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('NatRule=[\n')
        level += 1
        for NatRule_ in self.NatRule:
            showIndent(outfile, level)
            outfile.write('model_.NatRuleType(\n')
            NatRule_.exportLiteral(outfile, level, name_='NatRuleType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.ExternalIp is not None:
            showIndent(outfile, level)
            outfile.write('ExternalIp=%s,\n' % quote_python(self.ExternalIp).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NatServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NatType':
            NatType_ = child_.text
            NatType_ = self.gds_validate_string(NatType_, node, 'NatType')
            self.NatType = NatType_
        elif nodeName_ == 'Policy':
            Policy_ = child_.text
            Policy_ = self.gds_validate_string(Policy_, node, 'Policy')
            self.Policy = Policy_
        elif nodeName_ == 'NatRule':
            obj_ = NatRuleType.factory()
            obj_.build(child_)
            self.NatRule.append(obj_)
            obj_.original_tagname_ = 'NatRule'
        elif nodeName_ == 'ExternalIp':
            ExternalIp_ = child_.text
            ExternalIp_ = self.gds_validate_string(ExternalIp_, node, 'ExternalIp')
            self.ExternalIp = ExternalIp_
            self.validate_IpAddressType(self.ExternalIp)    # validate type IpAddressType
        super(NatServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class NatServiceType


class DhcpServiceType(NetworkServiceType):
    """Represents a DHCP network service."""
    subclass = None
    superclass = NetworkServiceType
    def __init__(self, VCloudExtension=None, IsEnabled=None, DefaultLeaseTime=None, MaxLeaseTime=None, IpRange=None, RouterIp=None, SubMask=None, PrimaryNameServer=None, SecondaryNameServer=None, DomainName=None):
        self.original_tagname_ = None
        super(DhcpServiceType, self).__init__(VCloudExtension, IsEnabled, )
        self.DefaultLeaseTime = DefaultLeaseTime
        self.MaxLeaseTime = MaxLeaseTime
        self.IpRange = IpRange
        self.RouterIp = RouterIp
        self.SubMask = SubMask
        self.PrimaryNameServer = PrimaryNameServer
        self.SecondaryNameServer = SecondaryNameServer
        self.DomainName = DomainName
    def factory(*args_, **kwargs_):
        if DhcpServiceType.subclass:
            return DhcpServiceType.subclass(*args_, **kwargs_)
        else:
            return DhcpServiceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DefaultLeaseTime(self): return self.DefaultLeaseTime
    def set_DefaultLeaseTime(self, DefaultLeaseTime): self.DefaultLeaseTime = DefaultLeaseTime
    def get_MaxLeaseTime(self): return self.MaxLeaseTime
    def set_MaxLeaseTime(self, MaxLeaseTime): self.MaxLeaseTime = MaxLeaseTime
    def get_IpRange(self): return self.IpRange
    def set_IpRange(self, IpRange): self.IpRange = IpRange
    def get_RouterIp(self): return self.RouterIp
    def set_RouterIp(self, RouterIp): self.RouterIp = RouterIp
    def get_SubMask(self): return self.SubMask
    def set_SubMask(self, SubMask): self.SubMask = SubMask
    def get_PrimaryNameServer(self): return self.PrimaryNameServer
    def set_PrimaryNameServer(self, PrimaryNameServer): self.PrimaryNameServer = PrimaryNameServer
    def get_SecondaryNameServer(self): return self.SecondaryNameServer
    def set_SecondaryNameServer(self, SecondaryNameServer): self.SecondaryNameServer = SecondaryNameServer
    def get_DomainName(self): return self.DomainName
    def set_DomainName(self, DomainName): self.DomainName = DomainName
    def validate_IpAddressType(self, value):
        # Validate type IpAddressType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.DefaultLeaseTime is not None or
            self.MaxLeaseTime is not None or
            self.IpRange is not None or
            self.RouterIp is not None or
            self.SubMask is not None or
            self.PrimaryNameServer is not None or
            self.SecondaryNameServer is not None or
            self.DomainName is not None or
            super(DhcpServiceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DhcpServiceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DhcpServiceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DhcpServiceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DhcpServiceType'):
        super(DhcpServiceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DhcpServiceType')
    def exportChildren(self, outfile, level, namespace_='', name_='DhcpServiceType', fromsubclass_=False, pretty_print=True):
        super(DhcpServiceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DefaultLeaseTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDefaultLeaseTime>%s</%sDefaultLeaseTime>%s' % (namespace_, self.gds_format_integer(self.DefaultLeaseTime, input_name='DefaultLeaseTime'), namespace_, eol_))
        if self.MaxLeaseTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMaxLeaseTime>%s</%sMaxLeaseTime>%s' % (namespace_, self.gds_format_integer(self.MaxLeaseTime, input_name='MaxLeaseTime'), namespace_, eol_))
        if self.IpRange is not None:
            self.IpRange.export(outfile, level, namespace_, name_='IpRange', pretty_print=pretty_print)
        if self.RouterIp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRouterIp>%s</%sRouterIp>%s' % (namespace_, self.gds_format_string(quote_xml(self.RouterIp).encode(ExternalEncoding), input_name='RouterIp'), namespace_, eol_))
        if self.SubMask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSubMask>%s</%sSubMask>%s' % (namespace_, self.gds_format_string(quote_xml(self.SubMask).encode(ExternalEncoding), input_name='SubMask'), namespace_, eol_))
        if self.PrimaryNameServer is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPrimaryNameServer>%s</%sPrimaryNameServer>%s' % (namespace_, self.gds_format_string(quote_xml(self.PrimaryNameServer).encode(ExternalEncoding), input_name='PrimaryNameServer'), namespace_, eol_))
        if self.SecondaryNameServer is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSecondaryNameServer>%s</%sSecondaryNameServer>%s' % (namespace_, self.gds_format_string(quote_xml(self.SecondaryNameServer).encode(ExternalEncoding), input_name='SecondaryNameServer'), namespace_, eol_))
        if self.DomainName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDomainName>%s</%sDomainName>%s' % (namespace_, self.gds_format_string(quote_xml(self.DomainName).encode(ExternalEncoding), input_name='DomainName'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DhcpServiceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DhcpServiceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DhcpServiceType, self).exportLiteralChildren(outfile, level, name_)
        if self.DefaultLeaseTime is not None:
            showIndent(outfile, level)
            outfile.write('DefaultLeaseTime=%d,\n' % self.DefaultLeaseTime)
        if self.MaxLeaseTime is not None:
            showIndent(outfile, level)
            outfile.write('MaxLeaseTime=%d,\n' % self.MaxLeaseTime)
        if self.IpRange is not None:
            showIndent(outfile, level)
            outfile.write('IpRange=model_.IpRangeType(\n')
            self.IpRange.exportLiteral(outfile, level, name_='IpRange')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.RouterIp is not None:
            showIndent(outfile, level)
            outfile.write('RouterIp=%s,\n' % quote_python(self.RouterIp).encode(ExternalEncoding))
        if self.SubMask is not None:
            showIndent(outfile, level)
            outfile.write('SubMask=%s,\n' % quote_python(self.SubMask).encode(ExternalEncoding))
        if self.PrimaryNameServer is not None:
            showIndent(outfile, level)
            outfile.write('PrimaryNameServer=%s,\n' % quote_python(self.PrimaryNameServer).encode(ExternalEncoding))
        if self.SecondaryNameServer is not None:
            showIndent(outfile, level)
            outfile.write('SecondaryNameServer=%s,\n' % quote_python(self.SecondaryNameServer).encode(ExternalEncoding))
        if self.DomainName is not None:
            showIndent(outfile, level)
            outfile.write('DomainName=%s,\n' % quote_python(self.DomainName).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DhcpServiceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DefaultLeaseTime':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'DefaultLeaseTime')
            self.DefaultLeaseTime = ival_
        elif nodeName_ == 'MaxLeaseTime':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'MaxLeaseTime')
            self.MaxLeaseTime = ival_
        elif nodeName_ == 'IpRange':
            obj_ = IpRangeType.factory()
            obj_.build(child_)
            self.IpRange = obj_
            obj_.original_tagname_ = 'IpRange'
        elif nodeName_ == 'RouterIp':
            RouterIp_ = child_.text
            RouterIp_ = self.gds_validate_string(RouterIp_, node, 'RouterIp')
            self.RouterIp = RouterIp_
            self.validate_IpAddressType(self.RouterIp)    # validate type IpAddressType
        elif nodeName_ == 'SubMask':
            SubMask_ = child_.text
            SubMask_ = self.gds_validate_string(SubMask_, node, 'SubMask')
            self.SubMask = SubMask_
            self.validate_IpAddressType(self.SubMask)    # validate type IpAddressType
        elif nodeName_ == 'PrimaryNameServer':
            PrimaryNameServer_ = child_.text
            PrimaryNameServer_ = self.gds_validate_string(PrimaryNameServer_, node, 'PrimaryNameServer')
            self.PrimaryNameServer = PrimaryNameServer_
        elif nodeName_ == 'SecondaryNameServer':
            SecondaryNameServer_ = child_.text
            SecondaryNameServer_ = self.gds_validate_string(SecondaryNameServer_, node, 'SecondaryNameServer')
            self.SecondaryNameServer = SecondaryNameServer_
        elif nodeName_ == 'DomainName':
            DomainName_ = child_.text
            DomainName_ = self.gds_validate_string(DomainName_, node, 'DomainName')
            self.DomainName = DomainName_
        super(DhcpServiceType, self).buildChildren(child_, node, nodeName_, True)
# end class DhcpServiceType


class VAppNetworkType(NetworkType):
    """1.5 Represents a vApp network. 1.5none True if the network is
    deployed. false"""
    subclass = None
    superclass = NetworkType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, Configuration=None, deployed=None):
        self.original_tagname_ = None
        super(VAppNetworkType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, name, Description, Tasks, Configuration, )
        self.deployed = _cast(bool, deployed)
    def factory(*args_, **kwargs_):
        if VAppNetworkType.subclass:
            return VAppNetworkType.subclass(*args_, **kwargs_)
        else:
            return VAppNetworkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_deployed(self): return self.deployed
    def set_deployed(self, deployed): self.deployed = deployed
    def hasContent_(self):
        if (
            super(VAppNetworkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VAppNetworkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VAppNetworkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VAppNetworkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VAppNetworkType'):
        super(VAppNetworkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VAppNetworkType')
        if self.deployed is not None and 'deployed' not in already_processed:
            already_processed.add('deployed')
            outfile.write(' deployed="%s"' % self.gds_format_boolean(self.deployed, input_name='deployed'))
    def exportChildren(self, outfile, level, namespace_='', name_='VAppNetworkType', fromsubclass_=False, pretty_print=True):
        super(VAppNetworkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VAppNetworkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.deployed is not None and 'deployed' not in already_processed:
            already_processed.add('deployed')
            showIndent(outfile, level)
            outfile.write('deployed=%s,\n' % (self.deployed,))
        super(VAppNetworkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VAppNetworkType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('deployed', node)
        if value is not None and 'deployed' not in already_processed:
            already_processed.add('deployed')
            if value in ('true', '1'):
                self.deployed = True
            elif value in ('false', '0'):
                self.deployed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(VAppNetworkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(VAppNetworkType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class VAppNetworkType


class OrgNetworkType(NetworkType):
    """0.95.1 Represents an organization network in the vCloud model."""
    subclass = None
    superclass = NetworkType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None, operationKey=None, id=None, name=None, Description=None, Tasks=None, Configuration=None, NetworkPool=None, AllowedExternalIpAddresses=None):
        self.original_tagname_ = None
        super(OrgNetworkType, self).__init__(VCloudExtension, href, type_, Link, operationKey, id, name, Description, Tasks, Configuration, )
        self.NetworkPool = NetworkPool
        self.AllowedExternalIpAddresses = AllowedExternalIpAddresses
    def factory(*args_, **kwargs_):
        if OrgNetworkType.subclass:
            return OrgNetworkType.subclass(*args_, **kwargs_)
        else:
            return OrgNetworkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NetworkPool(self): return self.NetworkPool
    def set_NetworkPool(self, NetworkPool): self.NetworkPool = NetworkPool
    def get_AllowedExternalIpAddresses(self): return self.AllowedExternalIpAddresses
    def set_AllowedExternalIpAddresses(self, AllowedExternalIpAddresses): self.AllowedExternalIpAddresses = AllowedExternalIpAddresses
    def hasContent_(self):
        if (
            self.NetworkPool is not None or
            self.AllowedExternalIpAddresses is not None or
            super(OrgNetworkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OrgNetworkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OrgNetworkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OrgNetworkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OrgNetworkType'):
        super(OrgNetworkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OrgNetworkType')
    def exportChildren(self, outfile, level, namespace_='', name_='OrgNetworkType', fromsubclass_=False, pretty_print=True):
        super(OrgNetworkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.NetworkPool is not None:
            self.NetworkPool.export(outfile, level, namespace_, name_='NetworkPool', pretty_print=pretty_print)
        if self.AllowedExternalIpAddresses is not None:
            self.AllowedExternalIpAddresses.export(outfile, level, namespace_, name_='AllowedExternalIpAddresses', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OrgNetworkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(OrgNetworkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(OrgNetworkType, self).exportLiteralChildren(outfile, level, name_)
        if self.NetworkPool is not None:
            showIndent(outfile, level)
            outfile.write('NetworkPool=model_.ReferenceType(\n')
            self.NetworkPool.exportLiteral(outfile, level, name_='NetworkPool')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AllowedExternalIpAddresses is not None:
            showIndent(outfile, level)
            outfile.write('AllowedExternalIpAddresses=model_.IpAddressesType(\n')
            self.AllowedExternalIpAddresses.exportLiteral(outfile, level, name_='AllowedExternalIpAddresses')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OrgNetworkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NetworkPool':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.NetworkPool = obj_
            obj_.original_tagname_ = 'NetworkPool'
        elif nodeName_ == 'AllowedExternalIpAddresses':
            obj_ = IpAddressesType.factory()
            obj_.build(child_)
            self.AllowedExternalIpAddresses = obj_
            obj_.original_tagname_ = 'AllowedExternalIpAddresses'
        super(OrgNetworkType, self).buildChildren(child_, node, nodeName_, True)
# end class OrgNetworkType


class IpsecVpnThirdPartyPeerType(IpsecVpnUnmanagedPeerType):
    """1.5 Gives more details of third party peer end point."""
    subclass = None
    superclass = IpsecVpnUnmanagedPeerType
    def __init__(self, VCloudExtension=None, PeerId=None):
        self.original_tagname_ = None
        super(IpsecVpnThirdPartyPeerType, self).__init__(VCloudExtension, )
        self.PeerId = PeerId
    def factory(*args_, **kwargs_):
        if IpsecVpnThirdPartyPeerType.subclass:
            return IpsecVpnThirdPartyPeerType.subclass(*args_, **kwargs_)
        else:
            return IpsecVpnThirdPartyPeerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PeerId(self): return self.PeerId
    def set_PeerId(self, PeerId): self.PeerId = PeerId
    def hasContent_(self):
        if (
            self.PeerId is not None or
            super(IpsecVpnThirdPartyPeerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpsecVpnThirdPartyPeerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnThirdPartyPeerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpsecVpnThirdPartyPeerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpsecVpnThirdPartyPeerType'):
        super(IpsecVpnThirdPartyPeerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnThirdPartyPeerType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpsecVpnThirdPartyPeerType', fromsubclass_=False, pretty_print=True):
        super(IpsecVpnThirdPartyPeerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PeerId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPeerId>%s</%sPeerId>%s' % (namespace_, self.gds_format_string(quote_xml(self.PeerId).encode(ExternalEncoding), input_name='PeerId'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IpsecVpnThirdPartyPeerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpsecVpnThirdPartyPeerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpsecVpnThirdPartyPeerType, self).exportLiteralChildren(outfile, level, name_)
        if self.PeerId is not None:
            showIndent(outfile, level)
            outfile.write('PeerId=%s,\n' % quote_python(self.PeerId).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpsecVpnThirdPartyPeerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PeerId':
            PeerId_ = child_.text
            PeerId_ = self.gds_validate_string(PeerId_, node, 'PeerId')
            self.PeerId = PeerId_
        super(IpsecVpnThirdPartyPeerType, self).buildChildren(child_, node, nodeName_, True)
# end class IpsecVpnThirdPartyPeerType


class IpsecVpnRemotePeerType(IpsecVpnManagedPeerType):
    """1.5 Gives more details of remote peer end point."""
    subclass = None
    superclass = IpsecVpnManagedPeerType
    def __init__(self, VCloudExtension=None, Id=None, Name=None, VcdUrl=None, VcdOrganization=None, VcdUsername=None):
        self.original_tagname_ = None
        super(IpsecVpnRemotePeerType, self).__init__(VCloudExtension, Id, Name, )
        self.VcdUrl = VcdUrl
        self.VcdOrganization = VcdOrganization
        self.VcdUsername = VcdUsername
    def factory(*args_, **kwargs_):
        if IpsecVpnRemotePeerType.subclass:
            return IpsecVpnRemotePeerType.subclass(*args_, **kwargs_)
        else:
            return IpsecVpnRemotePeerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_VcdUrl(self): return self.VcdUrl
    def set_VcdUrl(self, VcdUrl): self.VcdUrl = VcdUrl
    def get_VcdOrganization(self): return self.VcdOrganization
    def set_VcdOrganization(self, VcdOrganization): self.VcdOrganization = VcdOrganization
    def get_VcdUsername(self): return self.VcdUsername
    def set_VcdUsername(self, VcdUsername): self.VcdUsername = VcdUsername
    def hasContent_(self):
        if (
            self.VcdUrl is not None or
            self.VcdOrganization is not None or
            self.VcdUsername is not None or
            super(IpsecVpnRemotePeerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpsecVpnRemotePeerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnRemotePeerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpsecVpnRemotePeerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpsecVpnRemotePeerType'):
        super(IpsecVpnRemotePeerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnRemotePeerType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpsecVpnRemotePeerType', fromsubclass_=False, pretty_print=True):
        super(IpsecVpnRemotePeerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.VcdUrl is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVcdUrl>%s</%sVcdUrl>%s' % (namespace_, self.gds_format_string(quote_xml(self.VcdUrl).encode(ExternalEncoding), input_name='VcdUrl'), namespace_, eol_))
        if self.VcdOrganization is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVcdOrganization>%s</%sVcdOrganization>%s' % (namespace_, self.gds_format_string(quote_xml(self.VcdOrganization).encode(ExternalEncoding), input_name='VcdOrganization'), namespace_, eol_))
        if self.VcdUsername is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVcdUsername>%s</%sVcdUsername>%s' % (namespace_, self.gds_format_string(quote_xml(self.VcdUsername).encode(ExternalEncoding), input_name='VcdUsername'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='IpsecVpnRemotePeerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpsecVpnRemotePeerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpsecVpnRemotePeerType, self).exportLiteralChildren(outfile, level, name_)
        if self.VcdUrl is not None:
            showIndent(outfile, level)
            outfile.write('VcdUrl=%s,\n' % quote_python(self.VcdUrl).encode(ExternalEncoding))
        if self.VcdOrganization is not None:
            showIndent(outfile, level)
            outfile.write('VcdOrganization=%s,\n' % quote_python(self.VcdOrganization).encode(ExternalEncoding))
        if self.VcdUsername is not None:
            showIndent(outfile, level)
            outfile.write('VcdUsername=%s,\n' % quote_python(self.VcdUsername).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpsecVpnRemotePeerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'VcdUrl':
            VcdUrl_ = child_.text
            VcdUrl_ = self.gds_validate_string(VcdUrl_, node, 'VcdUrl')
            self.VcdUrl = VcdUrl_
        elif nodeName_ == 'VcdOrganization':
            VcdOrganization_ = child_.text
            VcdOrganization_ = self.gds_validate_string(VcdOrganization_, node, 'VcdOrganization')
            self.VcdOrganization = VcdOrganization_
        elif nodeName_ == 'VcdUsername':
            VcdUsername_ = child_.text
            VcdUsername_ = self.gds_validate_string(VcdUsername_, node, 'VcdUsername')
            self.VcdUsername = VcdUsername_
        super(IpsecVpnRemotePeerType, self).buildChildren(child_, node, nodeName_, True)
# end class IpsecVpnRemotePeerType


class IpsecVpnLocalPeerType(IpsecVpnManagedPeerType):
    """1.5 Gives more details of local peer end point."""
    subclass = None
    superclass = IpsecVpnManagedPeerType
    def __init__(self, VCloudExtension=None, Id=None, Name=None):
        self.original_tagname_ = None
        super(IpsecVpnLocalPeerType, self).__init__(VCloudExtension, Id, Name, )
    def factory(*args_, **kwargs_):
        if IpsecVpnLocalPeerType.subclass:
            return IpsecVpnLocalPeerType.subclass(*args_, **kwargs_)
        else:
            return IpsecVpnLocalPeerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(IpsecVpnLocalPeerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IpsecVpnLocalPeerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnLocalPeerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IpsecVpnLocalPeerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IpsecVpnLocalPeerType'):
        super(IpsecVpnLocalPeerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IpsecVpnLocalPeerType')
    def exportChildren(self, outfile, level, namespace_='', name_='IpsecVpnLocalPeerType', fromsubclass_=False, pretty_print=True):
        super(IpsecVpnLocalPeerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IpsecVpnLocalPeerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IpsecVpnLocalPeerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IpsecVpnLocalPeerType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IpsecVpnLocalPeerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IpsecVpnLocalPeerType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IpsecVpnLocalPeerType


GDSClassesMapping = {
    'ControlAccessParams': ControlAccessParamsType,
    'LoadBalancerService': LoadBalancerServiceType,
    'SubnetParticipation': SubnetParticipationType,
    'Metadata': MetadataType,
    'IpsecVpnRemotePeer': IpsecVpnRemotePeerType,
    'VendorTemplates': VendorTemplateType,
    'GatewayIpsecVpnService': GatewayIpsecVpnServiceType,
    'Protocols': ProtocolsType,
    'Task': TaskType,
    'IpsecVpnService': IpsecVpnServiceType,
    'OneToOneBasicRule': NatOneToOneBasicRuleType,
    'SubAllocation': SubAllocationType,
    'Organization': ReferenceType,
    'SourceVm': VmSelectionType,
    'VmRule': NatVmRuleType,
    'ServiceConfig': GatewayFeaturesType,
    'Reference': ReferenceType,
    'Entity': EntityType,
    'IpRanges': IpRangesType,
    'EdgeGateway': GatewayType,
    'OrgVdcNetwork': OrgVdcNetworkType,
    'Subject': ReferenceType,
    'Network': ReferenceType,
    'IpsecVpnTunnel': IpsecVpnTunnelType,
    'NatRule': NatRuleType,
    'StaticRoute': StaticRouteType,
    'AllowedExternalIpAddresses': IpAddressesType,
    'NatService': NatServiceType,
    'MetadataValue': MetadataValueType,
    'FirewallService': FirewallServiceType,
    'NetworkServices': NetworkServiceInsertionType,
    'Link': LinkType,
    'GatewayInterfaces': GatewayInterfacesType,
    'Interface': ReferenceType,
    'Configuration': GatewayConfigurationType,
    'LoadBalancerTemplates': VendorTemplateType,
    'VCloudExtension': VCloudExtensionType,
    'NetworkServiceInsertion': NetworkServiceInsertionType,
    'Tunnel': GatewayIpsecVpnTunnelType,
    'HealthCheck': LBPoolHealthCheckType,
    'IpScopes': IpScopesType,
    'RouterInfo': RouterInfoType,
    'IpsecVpnPeer': IpsecVpnPeerType,
    'Domain': MetadataDomainTagType,
    'Tasks': TasksInProgressType,
    'FirewallRule': FirewallRuleType,
    'AccessSetting': AccessSettingType,
    'PortForwardingRule': NatPortForwardingRuleType,
    'Owner': ReferenceType,
    'GatewayNatRule': GatewayNatRuleType,
    'LocalSubnet': IpsecVpnSubnetType,
    'IpsecVpnLocalPeer': IpsecVpnLocalPeerType,
    'VAppNetwork': VAppNetworkType,
    'EdgeGatewayServiceConfiguration': GatewayFeaturesType,
    'VendorTemplateAttributes': VendorTemplateAttributesType,
    'Member': LBPoolMemberType,
    'GatewayInterface': GatewayInterfaceType,
    'IpScope': IpScopeType,
    'QueryList': QueryListType,
    'User': ReferenceType,
    'AccessSettings': AccessSettingsType,
    'GatewayDhcpService': GatewayDhcpServiceType,
    'DestinationVm': VmSelectionType,
    'Error': ErrorType,
    'NetworkPool': ReferenceType,
    'Features': NetworkFeaturesType,
    'MetadataEntry': MetadataEntryType,
    'ParentNetwork': ReferenceType,
    'References': ReferencesType,
    'SubAllocations': SubAllocationsType,
    'AllocatedIpAddresses': AllocatedIpAddressType,
    'PeerSubnet': IpsecVpnSubnetType,
    'ServiceProfile': LBVirtualServerServiceProfileType,
    'StaticRoutingService': StaticRoutingServiceType,
    'VirtualServer': LoadBalancerVirtualServerType,
    'IpAddress': IpAddressesType,
    'Persistence': LBPersistenceType,
    'NetworkService': NetworkServiceType,
    'OneToOneVmRule': NatOneToOneVmRuleType,
    'SyslogServerSettings': SyslogServerSettingsType,
    'Endpoint': GatewayIpsecVpnEndpointType,
    'TypedValue': MetadataTypedValue,
    'EdgeGatewayServices': NetworkServiceInsertionType,
    'IpRange': IpRangeType,
    'Pool': LoadBalancerPoolType,
    'ServicePort': LBPoolServicePortType,
    'IpsecVpnThirdPartyPeer': IpsecVpnThirdPartyPeerType,
    'DhcpService': DhcpServiceType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'NetworkType'
        rootClass = NetworkType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'NetworkType'
        rootClass = NetworkType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'NetworkType'
        rootClass = NetworkType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'NetworkType'
        rootClass = NetworkType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from networkType import *\n\n')
        sys.stdout.write('import networkType as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "AccessSettingType",
    "AccessSettingsType",
    "AllocatedIpAddressType",
    "AllocatedIpAddressesType",
    "CapacityType",
    "CapacityWithUsageType",
    "ContainerType",
    "ControlAccessParamsType",
    "DhcpPoolServiceType",
    "DhcpServiceType",
    "EntityLinkType",
    "EntityReferenceType",
    "EntityType",
    "ErrorType",
    "FileUploadParamsType",
    "FileUploadSocketType",
    "FirewallRuleType",
    "FirewallServiceType",
    "GatewayConfigurationType",
    "GatewayDhcpServiceType",
    "GatewayFeaturesType",
    "GatewayInterfaceType",
    "GatewayInterfacesType",
    "GatewayIpsecVpnEndpointType",
    "GatewayIpsecVpnServiceType",
    "GatewayIpsecVpnTunnelType",
    "GatewayNatRuleType",
    "GatewayType",
    "IdentifiableResourceType",
    "IpAddressesType",
    "IpRangeType",
    "IpRangesType",
    "IpScopeType",
    "IpScopesType",
    "IpsecVpnLocalPeerType",
    "IpsecVpnManagedPeerType",
    "IpsecVpnPeerType",
    "IpsecVpnRemotePeerType",
    "IpsecVpnServiceType",
    "IpsecVpnSubnetType",
    "IpsecVpnThirdPartyPeerType",
    "IpsecVpnTunnelType",
    "IpsecVpnUnmanagedPeerType",
    "LBPersistenceType",
    "LBPoolHealthCheckType",
    "LBPoolMemberType",
    "LBPoolServicePortType",
    "LBVirtualServerServiceProfileType",
    "LinkType",
    "LoadBalancerPoolType",
    "LoadBalancerServiceType",
    "LoadBalancerVirtualServerType",
    "MetadataBooleanValue",
    "MetadataDateTimeValue",
    "MetadataDomainTagType",
    "MetadataEntryType",
    "MetadataNumberValue",
    "MetadataStringValue",
    "MetadataType",
    "MetadataTypedValue",
    "MetadataValueType",
    "NatOneToOneBasicRuleType",
    "NatOneToOneVmRuleType",
    "NatPortForwardingRuleType",
    "NatRuleType",
    "NatServiceType",
    "NatVmRuleType",
    "NetworkConfigurationType",
    "NetworkFeaturesType",
    "NetworkServiceInsertionType",
    "NetworkServiceType",
    "NetworkType",
    "OrgNetworkType",
    "OrgVdcNetworkType",
    "OwnerType",
    "ParamsType",
    "ProtocolsType",
    "QueryListType",
    "ReferenceType",
    "ReferencesType",
    "ResourceReferenceType",
    "ResourceType",
    "RouterInfoType",
    "StaticRouteType",
    "StaticRoutingServiceType",
    "SubAllocationType",
    "SubAllocationsType",
    "SubnetParticipationType",
    "SyslogServerSettingsType",
    "TaskOperationListType",
    "TaskType",
    "TasksInProgressType",
    "VAppNetworkType",
    "VCloudExtensibleType",
    "VCloudExtensionType",
    "VendorServicesType",
    "VendorTemplateAttributesType",
    "VendorTemplateType",
    "VmSelectionType"
]
