# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._maria_db_management_client_enums import *


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Advisor(Resource):
    """Represents a recommendation action advisor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param properties: The properties of a recommendation action advisor.
    :type properties: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        properties: Optional[object] = None,
        **kwargs
    ):
        super(Advisor, self).__init__(**kwargs)
        self.properties = properties


class AdvisorsResultList(msrest.serialization.Model):
    """A list of query statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of recommendation action advisors.
    :vartype value: list[~azure.mgmt.rdbms.mariadb.models.Advisor]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Advisor]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdvisorsResultList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CloudErrorAutoGenerated(msrest.serialization.Model):
    """An error response from the Batch service.

    :param error: Error message.
    :type error: ~azure.mgmt.rdbms.mariadb.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        super(CloudErrorAutoGenerated, self).__init__(**kwargs)
        self.error = error


class Configuration(Resource):
    """Represents a Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param value: Value of the configuration.
    :type value: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration.
    :vartype data_type: str
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :param source: Source of the configuration.
    :type source: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'default_value': {'readonly': True},
        'data_type': {'readonly': True},
        'allowed_values': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'default_value': {'key': 'properties.defaultValue', 'type': 'str'},
        'data_type': {'key': 'properties.dataType', 'type': 'str'},
        'allowed_values': {'key': 'properties.allowedValues', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        source: Optional[str] = None,
        **kwargs
    ):
        super(Configuration, self).__init__(**kwargs)
        self.value = value
        self.description = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.source = source


class ConfigurationListResult(msrest.serialization.Model):
    """A list of server configurations.

    :param value: The list of server configurations.
    :type value: list[~azure.mgmt.rdbms.mariadb.models.Configuration]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Configuration]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Configuration"]] = None,
        **kwargs
    ):
        super(ConfigurationListResult, self).__init__(**kwargs)
        self.value = value


class Database(Resource):
    """Represents a Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param charset: The charset of the database.
    :type charset: str
    :param collation: The collation of the database.
    :type collation: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'charset': {'key': 'properties.charset', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        charset: Optional[str] = None,
        collation: Optional[str] = None,
        **kwargs
    ):
        super(Database, self).__init__(**kwargs)
        self.charset = charset
        self.collation = collation


class DatabaseListResult(msrest.serialization.Model):
    """A List of databases.

    :param value: The list of databases housed in a server.
    :type value: list[~azure.mgmt.rdbms.mariadb.models.Database]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Database"]] = None,
        **kwargs
    ):
        super(DatabaseListResult, self).__init__(**kwargs)
        self.value = value


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.rdbms.mariadb.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.rdbms.mariadb.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FirewallRule(Resource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param start_ip_address: Required. The start IP address of the server firewall rule. Must be
     IPv4 format.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address of the server firewall rule. Must be IPv4
     format.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
        'end_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_ip_address: str,
        end_ip_address: str,
        **kwargs
    ):
        super(FirewallRule, self).__init__(**kwargs)
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class FirewallRuleListResult(msrest.serialization.Model):
    """A list of firewall rules.

    :param value: The list of firewall rules in a server.
    :type value: list[~azure.mgmt.rdbms.mariadb.models.FirewallRule]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallRule]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["FirewallRule"]] = None,
        **kwargs
    ):
        super(FirewallRuleListResult, self).__init__(**kwargs)
        self.value = value


class LogFile(Resource):
    """Represents a log file.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param size_in_kb: Size of the log file.
    :type size_in_kb: long
    :ivar created_time: Creation timestamp of the log file.
    :vartype created_time: ~datetime.datetime
    :ivar last_modified_time: Last modified timestamp of the log file.
    :vartype last_modified_time: ~datetime.datetime
    :param type_properties_type: Type of the log file.
    :type type_properties_type: str
    :ivar url: The url to download the log file from.
    :vartype url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'url': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'size_in_kb': {'key': 'properties.sizeInKB', 'type': 'long'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        size_in_kb: Optional[int] = None,
        type_properties_type: Optional[str] = None,
        **kwargs
    ):
        super(LogFile, self).__init__(**kwargs)
        self.size_in_kb = size_in_kb
        self.created_time = None
        self.last_modified_time = None
        self.type_properties_type = type_properties_type
        self.url = None


class LogFileListResult(msrest.serialization.Model):
    """A list of log files.

    :param value: The list of log files.
    :type value: list[~azure.mgmt.rdbms.mariadb.models.LogFile]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LogFile]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LogFile"]] = None,
        **kwargs
    ):
        super(LogFileListResult, self).__init__(**kwargs)
        self.value = value


class NameAvailability(msrest.serialization.Model):
    """Represents a resource name availability.

    :param message: Error Message.
    :type message: str
    :param name_available: Indicates whether the resource name is available.
    :type name_available: bool
    :param reason: Reason for name being unavailable.
    :type reason: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(NameAvailability, self).__init__(**kwargs)
        self.message = message
        self.name_available = name_available
        self.reason = reason


class NameAvailabilityRequest(msrest.serialization.Model):
    """Request from client to check resource name availability.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Resource type used for verification.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Optional[str] = None,
        **kwargs
    ):
        super(NameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type


class Operation(msrest.serialization.Model):
    """REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation or action.
    :vartype display: ~azure.mgmt.rdbms.mariadb.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values include: "NotSpecified",
     "user", "system".
    :vartype origin: str or ~azure.mgmt.rdbms.mariadb.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, object]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.origin = None
        self.properties = None


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Operation resource provider name.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of resource provider operations.

    :param value: The list of resource provider operations.
    :type value: list[~azure.mgmt.rdbms.mariadb.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value


class PerformanceTierListResult(msrest.serialization.Model):
    """A list of performance tiers.

    :param value: The list of performance tiers.
    :type value: list[~azure.mgmt.rdbms.mariadb.models.PerformanceTierProperties]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PerformanceTierProperties]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PerformanceTierProperties"]] = None,
        **kwargs
    ):
        super(PerformanceTierListResult, self).__init__(**kwargs)
        self.value = value


class PerformanceTierProperties(msrest.serialization.Model):
    """Performance tier properties.

    :param id: ID of the performance tier.
    :type id: str
    :param max_backup_retention_days: Maximum Backup retention in days for the performance tier
     edition.
    :type max_backup_retention_days: int
    :param min_backup_retention_days: Minimum Backup retention in days for the performance tier
     edition.
    :type min_backup_retention_days: int
    :param max_storage_mb: Max storage allowed for a server.
    :type max_storage_mb: int
    :param min_large_storage_mb: Max storage allowed for a server.
    :type min_large_storage_mb: int
    :param max_large_storage_mb: Max storage allowed for a server.
    :type max_large_storage_mb: int
    :param min_storage_mb: Max storage allowed for a server.
    :type min_storage_mb: int
    :param service_level_objectives: Service level objectives associated with the performance tier.
    :type service_level_objectives:
     list[~azure.mgmt.rdbms.mariadb.models.PerformanceTierServiceLevelObjectives]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'max_backup_retention_days': {'key': 'maxBackupRetentionDays', 'type': 'int'},
        'min_backup_retention_days': {'key': 'minBackupRetentionDays', 'type': 'int'},
        'max_storage_mb': {'key': 'maxStorageMB', 'type': 'int'},
        'min_large_storage_mb': {'key': 'minLargeStorageMB', 'type': 'int'},
        'max_large_storage_mb': {'key': 'maxLargeStorageMB', 'type': 'int'},
        'min_storage_mb': {'key': 'minStorageMB', 'type': 'int'},
        'service_level_objectives': {'key': 'serviceLevelObjectives', 'type': '[PerformanceTierServiceLevelObjectives]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        max_backup_retention_days: Optional[int] = None,
        min_backup_retention_days: Optional[int] = None,
        max_storage_mb: Optional[int] = None,
        min_large_storage_mb: Optional[int] = None,
        max_large_storage_mb: Optional[int] = None,
        min_storage_mb: Optional[int] = None,
        service_level_objectives: Optional[List["PerformanceTierServiceLevelObjectives"]] = None,
        **kwargs
    ):
        super(PerformanceTierProperties, self).__init__(**kwargs)
        self.id = id
        self.max_backup_retention_days = max_backup_retention_days
        self.min_backup_retention_days = min_backup_retention_days
        self.max_storage_mb = max_storage_mb
        self.min_large_storage_mb = min_large_storage_mb
        self.max_large_storage_mb = max_large_storage_mb
        self.min_storage_mb = min_storage_mb
        self.service_level_objectives = service_level_objectives


class PerformanceTierServiceLevelObjectives(msrest.serialization.Model):
    """Service level objectives for performance tier.

    :param id: ID for the service level objective.
    :type id: str
    :param edition: Edition of the performance tier.
    :type edition: str
    :param v_core: vCore associated with the service level objective.
    :type v_core: int
    :param hardware_generation: Hardware generation associated with the service level objective.
    :type hardware_generation: str
    :param max_backup_retention_days: Maximum Backup retention in days for the performance tier
     edition.
    :type max_backup_retention_days: int
    :param min_backup_retention_days: Minimum Backup retention in days for the performance tier
     edition.
    :type min_backup_retention_days: int
    :param max_storage_mb: Max storage allowed for a server.
    :type max_storage_mb: int
    :param min_storage_mb: Max storage allowed for a server.
    :type min_storage_mb: int
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'edition': {'key': 'edition', 'type': 'str'},
        'v_core': {'key': 'vCore', 'type': 'int'},
        'hardware_generation': {'key': 'hardwareGeneration', 'type': 'str'},
        'max_backup_retention_days': {'key': 'maxBackupRetentionDays', 'type': 'int'},
        'min_backup_retention_days': {'key': 'minBackupRetentionDays', 'type': 'int'},
        'max_storage_mb': {'key': 'maxStorageMB', 'type': 'int'},
        'min_storage_mb': {'key': 'minStorageMB', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        edition: Optional[str] = None,
        v_core: Optional[int] = None,
        hardware_generation: Optional[str] = None,
        max_backup_retention_days: Optional[int] = None,
        min_backup_retention_days: Optional[int] = None,
        max_storage_mb: Optional[int] = None,
        min_storage_mb: Optional[int] = None,
        **kwargs
    ):
        super(PerformanceTierServiceLevelObjectives, self).__init__(**kwargs)
        self.id = id
        self.edition = edition
        self.v_core = v_core
        self.hardware_generation = hardware_generation
        self.max_backup_retention_days = max_backup_retention_days
        self.min_backup_retention_days = min_backup_retention_days
        self.max_storage_mb = max_storage_mb
        self.min_storage_mb = min_storage_mb


class PrivateEndpointConnection(Resource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.rdbms.mariadb.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.rdbms.mariadb.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.mariadb.models.PrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpointProperty(msrest.serialization.Model):
    """PrivateEndpointProperty.

    :param id: Resource id of the private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointProperty, self).__init__(**kwargs)
        self.id = id


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: The private link resource group id.
    :vartype properties: ~azure.mgmt.rdbms.mariadb.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.properties = None


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.mariadb.models.PrivateLinkResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None


class PrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """PrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status.
    :type status: str
    :param description: Required. The private link service connection description.
    :type description: str
    :ivar actions_required: The actions required for private link service connection.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: str,
        description: str,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class QueryPerformanceInsightResetDataResult(msrest.serialization.Model):
    """Result of Query Performance Insight data reset.

    :param status: Indicates result of the operation. Possible values include: "Succeeded",
     "Failed".
    :type status: str or
     ~azure.mgmt.rdbms.mariadb.models.QueryPerformanceInsightResetDataResultState
    :param message: operation message.
    :type message: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "QueryPerformanceInsightResetDataResultState"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(QueryPerformanceInsightResetDataResult, self).__init__(**kwargs)
        self.status = status
        self.message = message


class QueryStatistic(Resource):
    """Represents a Query Statistic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param query_id: Database query identifier.
    :type query_id: str
    :param start_time: Observation start time.
    :type start_time: ~datetime.datetime
    :param end_time: Observation end time.
    :type end_time: ~datetime.datetime
    :param aggregation_function: Aggregation function name.
    :type aggregation_function: str
    :param database_names: The list of database names.
    :type database_names: list[str]
    :param query_execution_count: Number of query executions in this time interval.
    :type query_execution_count: long
    :param metric_name: Metric name.
    :type metric_name: str
    :param metric_display_name: Metric display name.
    :type metric_display_name: str
    :param metric_value: Metric value.
    :type metric_value: float
    :param metric_value_unit: Metric value unit.
    :type metric_value_unit: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'query_id': {'key': 'properties.queryId', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'aggregation_function': {'key': 'properties.aggregationFunction', 'type': 'str'},
        'database_names': {'key': 'properties.databaseNames', 'type': '[str]'},
        'query_execution_count': {'key': 'properties.queryExecutionCount', 'type': 'long'},
        'metric_name': {'key': 'properties.metricName', 'type': 'str'},
        'metric_display_name': {'key': 'properties.metricDisplayName', 'type': 'str'},
        'metric_value': {'key': 'properties.metricValue', 'type': 'float'},
        'metric_value_unit': {'key': 'properties.metricValueUnit', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        aggregation_function: Optional[str] = None,
        database_names: Optional[List[str]] = None,
        query_execution_count: Optional[int] = None,
        metric_name: Optional[str] = None,
        metric_display_name: Optional[str] = None,
        metric_value: Optional[float] = None,
        metric_value_unit: Optional[str] = None,
        **kwargs
    ):
        super(QueryStatistic, self).__init__(**kwargs)
        self.query_id = query_id
        self.start_time = start_time
        self.end_time = end_time
        self.aggregation_function = aggregation_function
        self.database_names = database_names
        self.query_execution_count = query_execution_count
        self.metric_name = metric_name
        self.metric_display_name = metric_display_name
        self.metric_value = metric_value
        self.metric_value_unit = metric_value_unit


class QueryText(Resource):
    """Represents a Query Text.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param query_id: Query identifier unique to the server.
    :type query_id: str
    :param query_text: Query text.
    :type query_text: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'query_id': {'key': 'properties.queryId', 'type': 'str'},
        'query_text': {'key': 'properties.queryText', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query_id: Optional[str] = None,
        query_text: Optional[str] = None,
        **kwargs
    ):
        super(QueryText, self).__init__(**kwargs)
        self.query_id = query_id
        self.query_text = query_text


class QueryTextsResultList(msrest.serialization.Model):
    """A list of query texts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of query texts.
    :vartype value: list[~azure.mgmt.rdbms.mariadb.models.QueryText]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QueryText]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryTextsResultList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RecommendationAction(Resource):
    """Represents a Recommendation Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param advisor_name: Advisor name.
    :type advisor_name: str
    :param session_id: Recommendation action session identifier.
    :type session_id: str
    :param action_id: Recommendation action identifier.
    :type action_id: int
    :param created_time: Recommendation action creation time.
    :type created_time: ~datetime.datetime
    :param expiration_time: Recommendation action expiration time.
    :type expiration_time: ~datetime.datetime
    :param reason: Recommendation action reason.
    :type reason: str
    :param recommendation_type: Recommendation action type.
    :type recommendation_type: str
    :param details: Recommendation action details.
    :type details: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'advisor_name': {'key': 'properties.advisorName', 'type': 'str'},
        'session_id': {'key': 'properties.sessionId', 'type': 'str'},
        'action_id': {'key': 'properties.actionId', 'type': 'int'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'reason': {'key': 'properties.reason', 'type': 'str'},
        'recommendation_type': {'key': 'properties.recommendationType', 'type': 'str'},
        'details': {'key': 'properties.details', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        advisor_name: Optional[str] = None,
        session_id: Optional[str] = None,
        action_id: Optional[int] = None,
        created_time: Optional[datetime.datetime] = None,
        expiration_time: Optional[datetime.datetime] = None,
        reason: Optional[str] = None,
        recommendation_type: Optional[str] = None,
        details: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(RecommendationAction, self).__init__(**kwargs)
        self.advisor_name = advisor_name
        self.session_id = session_id
        self.action_id = action_id
        self.created_time = created_time
        self.expiration_time = expiration_time
        self.reason = reason
        self.recommendation_type = recommendation_type
        self.details = details


class RecommendationActionsResultList(msrest.serialization.Model):
    """A list of recommendation actions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of recommendation action advisors.
    :vartype value: list[~azure.mgmt.rdbms.mariadb.models.RecommendationAction]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecommendationAction]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecommendationActionsResultList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RecommendedActionSessionsOperationStatus(msrest.serialization.Model):
    """Recommendation action session operation status.

    :param name: Operation identifier.
    :type name: str
    :param start_time: Operation start time.
    :type start_time: ~datetime.datetime
    :param status: Operation status.
    :type status: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(RecommendedActionSessionsOperationStatus, self).__init__(**kwargs)
        self.name = name
        self.start_time = start_time
        self.status = status


class RecoverableServerResource(Resource):
    """A recoverable server resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar last_available_backup_date_time: The last available backup date time.
    :vartype last_available_backup_date_time: str
    :ivar service_level_objective: The service level objective.
    :vartype service_level_objective: str
    :ivar edition: Edition of the performance tier.
    :vartype edition: str
    :ivar v_core: vCore associated with the service level objective.
    :vartype v_core: int
    :ivar hardware_generation: Hardware generation associated with the service level objective.
    :vartype hardware_generation: str
    :ivar version: The MariaDB version.
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_available_backup_date_time': {'readonly': True},
        'service_level_objective': {'readonly': True},
        'edition': {'readonly': True},
        'v_core': {'readonly': True},
        'hardware_generation': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_available_backup_date_time': {'key': 'properties.lastAvailableBackupDateTime', 'type': 'str'},
        'service_level_objective': {'key': 'properties.serviceLevelObjective', 'type': 'str'},
        'edition': {'key': 'properties.edition', 'type': 'str'},
        'v_core': {'key': 'properties.vCore', 'type': 'int'},
        'hardware_generation': {'key': 'properties.hardwareGeneration', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoverableServerResource, self).__init__(**kwargs)
        self.last_available_backup_date_time = None
        self.service_level_objective = None
        self.edition = None
        self.v_core = None
        self.hardware_generation = None
        self.version = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Server(TrackedResource):
    """Represents a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.mariadb.models.Sku
    :param administrator_login: The administrator's login name of a server. Can only be specified
     when the server is being created (and is required for creation).
    :type administrator_login: str
    :param version: Server version. Possible values include: "5.6", "5.7".
    :type version: str or ~azure.mgmt.rdbms.mariadb.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.mariadb.models.SslEnforcementEnum
    :param user_visible_state: A state of a server that is visible to user. Possible values
     include: "Ready", "Dropping", "Disabled".
    :type user_visible_state: str or ~azure.mgmt.rdbms.mariadb.models.ServerState
    :param fully_qualified_domain_name: The fully qualified domain name of a server.
    :type fully_qualified_domain_name: str
    :param earliest_restore_date: Earliest restore point creation time (ISO8601 format).
    :type earliest_restore_date: ~datetime.datetime
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mariadb.models.StorageProfile
    :param replication_role: The replication role of the server.
    :type replication_role: str
    :param master_server_id: The master server id of a replica server.
    :type master_server_id: str
    :param replica_capacity: The maximum number of replicas that a master server can have.
    :type replica_capacity: int
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.mariadb.models.PublicNetworkAccessEnum
    :ivar private_endpoint_connections: List of private endpoint connections on a server.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.rdbms.mariadb.models.ServerPrivateEndpointConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'replica_capacity': {'minimum': 0},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'str'},
        'user_visible_state': {'key': 'properties.userVisibleState', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'master_server_id': {'key': 'properties.masterServerId', 'type': 'str'},
        'replica_capacity': {'key': 'properties.replicaCapacity', 'type': 'int'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ServerPrivateEndpointConnection]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        administrator_login: Optional[str] = None,
        version: Optional[Union[str, "ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "SslEnforcementEnum"]] = None,
        user_visible_state: Optional[Union[str, "ServerState"]] = None,
        fully_qualified_domain_name: Optional[str] = None,
        earliest_restore_date: Optional[datetime.datetime] = None,
        storage_profile: Optional["StorageProfile"] = None,
        replication_role: Optional[str] = None,
        master_server_id: Optional[str] = None,
        replica_capacity: Optional[int] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessEnum"]] = None,
        **kwargs
    ):
        super(Server, self).__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.administrator_login = administrator_login
        self.version = version
        self.ssl_enforcement = ssl_enforcement
        self.user_visible_state = user_visible_state
        self.fully_qualified_domain_name = fully_qualified_domain_name
        self.earliest_restore_date = earliest_restore_date
        self.storage_profile = storage_profile
        self.replication_role = replication_role
        self.master_server_id = master_server_id
        self.replica_capacity = replica_capacity
        self.public_network_access = public_network_access
        self.private_endpoint_connections = None


class ServerForCreate(msrest.serialization.Model):
    """Represents a server to be created.

    All required parameters must be populated in order to send to Azure.

    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.mariadb.models.Sku
    :param properties: Required. Properties of the server.
    :type properties: ~azure.mgmt.rdbms.mariadb.models.ServerPropertiesForCreate
    :param location: Required. The location the resource resides in.
    :type location: str
    :param tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _validation = {
        'properties': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'properties': {'key': 'properties', 'type': 'ServerPropertiesForCreate'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        properties: "ServerPropertiesForCreate",
        location: str,
        sku: Optional["Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ServerForCreate, self).__init__(**kwargs)
        self.sku = sku
        self.properties = properties
        self.location = location
        self.tags = tags


class ServerListResult(msrest.serialization.Model):
    """A list of servers.

    :param value: The list of servers.
    :type value: list[~azure.mgmt.rdbms.mariadb.models.Server]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Server]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Server"]] = None,
        **kwargs
    ):
        super(ServerListResult, self).__init__(**kwargs)
        self.value = value


class ServerPrivateEndpointConnection(msrest.serialization.Model):
    """A private endpoint connection under a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id of the private endpoint connection.
    :vartype id: str
    :ivar properties: Private endpoint connection properties.
    :vartype properties: ~azure.mgmt.rdbms.mariadb.models.ServerPrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ServerPrivateEndpointConnectionProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.properties = None


class ServerPrivateEndpointConnectionProperties(msrest.serialization.Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.rdbms.mariadb.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.rdbms.mariadb.models.ServerPrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection. Possible values include:
     "Approving", "Ready", "Dropping", "Failed", "Rejecting".
    :vartype provisioning_state: str or
     ~azure.mgmt.rdbms.mariadb.models.PrivateEndpointProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'ServerPrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["ServerPrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        super(ServerPrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class ServerPrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """ServerPrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status. Possible values include:
     "Approved", "Pending", "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.rdbms.mariadb.models.PrivateLinkServiceConnectionStateStatus
    :param description: Required. The private link service connection description.
    :type description: str
    :ivar actions_required: The actions required for private link service connection. Possible
     values include: "None".
    :vartype actions_required: str or
     ~azure.mgmt.rdbms.mariadb.models.PrivateLinkServiceConnectionStateActionsRequire
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "PrivateLinkServiceConnectionStateStatus"],
        description: str,
        **kwargs
    ):
        super(ServerPrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class ServerPropertiesForCreate(msrest.serialization.Model):
    """The properties used to create a new server.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ServerPropertiesForDefaultCreate, ServerPropertiesForGeoRestore, ServerPropertiesForRestore, ServerPropertiesForReplica.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "5.6", "5.7".
    :type version: str or ~azure.mgmt.rdbms.mariadb.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.mariadb.models.SslEnforcementEnum
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.mariadb.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mariadb.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.mariadb.models.CreateMode
    """

    _validation = {
        'create_mode': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
    }

    _subtype_map = {
        'create_mode': {'Default': 'ServerPropertiesForDefaultCreate', 'GeoRestore': 'ServerPropertiesForGeoRestore', 'PointInTimeRestore': 'ServerPropertiesForRestore', 'Replica': 'ServerPropertiesForReplica'}
    }

    def __init__(
        self,
        *,
        version: Optional[Union[str, "ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "SslEnforcementEnum"]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["StorageProfile"] = None,
        **kwargs
    ):
        super(ServerPropertiesForCreate, self).__init__(**kwargs)
        self.version = version
        self.ssl_enforcement = ssl_enforcement
        self.public_network_access = public_network_access
        self.storage_profile = storage_profile
        self.create_mode = None  # type: Optional[str]


class ServerPropertiesForDefaultCreate(ServerPropertiesForCreate):
    """The properties used to create a new server.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "5.6", "5.7".
    :type version: str or ~azure.mgmt.rdbms.mariadb.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.mariadb.models.SslEnforcementEnum
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.mariadb.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mariadb.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.mariadb.models.CreateMode
    :param administrator_login: Required. The administrator's login name of a server. Can only be
     specified when the server is being created (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: Required. The password of the administrator login.
    :type administrator_login_password: str
    """

    _validation = {
        'create_mode': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        administrator_login: str,
        administrator_login_password: str,
        version: Optional[Union[str, "ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "SslEnforcementEnum"]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["StorageProfile"] = None,
        **kwargs
    ):
        super(ServerPropertiesForDefaultCreate, self).__init__(version=version, ssl_enforcement=ssl_enforcement, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.create_mode = 'Default'  # type: str
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password


class ServerPropertiesForGeoRestore(ServerPropertiesForCreate):
    """The properties used to create a new server by restoring to a different region from a geo replicated backup.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "5.6", "5.7".
    :type version: str or ~azure.mgmt.rdbms.mariadb.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.mariadb.models.SslEnforcementEnum
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.mariadb.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mariadb.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.mariadb.models.CreateMode
    :param source_server_id: Required. The source server id to restore from.
    :type source_server_id: str
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_server_id: str,
        version: Optional[Union[str, "ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "SslEnforcementEnum"]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["StorageProfile"] = None,
        **kwargs
    ):
        super(ServerPropertiesForGeoRestore, self).__init__(version=version, ssl_enforcement=ssl_enforcement, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.create_mode = 'GeoRestore'  # type: str
        self.source_server_id = source_server_id


class ServerPropertiesForReplica(ServerPropertiesForCreate):
    """The properties to create a new replica.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "5.6", "5.7".
    :type version: str or ~azure.mgmt.rdbms.mariadb.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.mariadb.models.SslEnforcementEnum
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.mariadb.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mariadb.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.mariadb.models.CreateMode
    :param source_server_id: Required. The master server id to create replica from.
    :type source_server_id: str
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_server_id: str,
        version: Optional[Union[str, "ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "SslEnforcementEnum"]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["StorageProfile"] = None,
        **kwargs
    ):
        super(ServerPropertiesForReplica, self).__init__(version=version, ssl_enforcement=ssl_enforcement, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.create_mode = 'Replica'  # type: str
        self.source_server_id = source_server_id


class ServerPropertiesForRestore(ServerPropertiesForCreate):
    """The properties used to create a new server by restoring from a backup.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "5.6", "5.7".
    :type version: str or ~azure.mgmt.rdbms.mariadb.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.mariadb.models.SslEnforcementEnum
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.mariadb.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mariadb.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.mariadb.models.CreateMode
    :param source_server_id: Required. The source server id to restore from.
    :type source_server_id: str
    :param restore_point_in_time: Required. Restore point creation time (ISO8601 format),
     specifying the time to restore from.
    :type restore_point_in_time: ~datetime.datetime
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
        'restore_point_in_time': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
        'restore_point_in_time': {'key': 'restorePointInTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        source_server_id: str,
        restore_point_in_time: datetime.datetime,
        version: Optional[Union[str, "ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "SslEnforcementEnum"]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["StorageProfile"] = None,
        **kwargs
    ):
        super(ServerPropertiesForRestore, self).__init__(version=version, ssl_enforcement=ssl_enforcement, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.create_mode = 'PointInTimeRestore'  # type: str
        self.source_server_id = source_server_id
        self.restore_point_in_time = restore_point_in_time


class ServerSecurityAlertPolicy(Resource):
    """A server security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param state: Specifies the state of the policy, whether it is enabled or disabled. Possible
     values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.rdbms.mariadb.models.ServerSecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly.
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :type retention_days: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "ServerSecurityAlertPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs
    ):
        super(ServerSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days


class ServerUpdateParameters(msrest.serialization.Model):
    """Parameters allowed to update for a server.

    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.mariadb.models.Sku
    :param tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.mariadb.models.StorageProfile
    :param administrator_login_password: The password of the administrator login.
    :type administrator_login_password: str
    :param version: The version of a server. Possible values include: "5.6", "5.7".
    :type version: str or ~azure.mgmt.rdbms.mariadb.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.mariadb.models.SslEnforcementEnum
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.mariadb.models.PublicNetworkAccessEnum
    :param replication_role: The replication role of the server.
    :type replication_role: str
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        storage_profile: Optional["StorageProfile"] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[Union[str, "ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "SslEnforcementEnum"]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessEnum"]] = None,
        replication_role: Optional[str] = None,
        **kwargs
    ):
        super(ServerUpdateParameters, self).__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.storage_profile = storage_profile
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.ssl_enforcement = ssl_enforcement
        self.public_network_access = public_network_access
        self.replication_role = replication_role


class Sku(msrest.serialization.Model):
    """Billing information related properties of a server.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1,
     GP_Gen5_8.
    :type name: str
    :param tier: The tier of the particular SKU, e.g. Basic. Possible values include: "Basic",
     "GeneralPurpose", "MemoryOptimized".
    :type tier: str or ~azure.mgmt.rdbms.mariadb.models.SkuTier
    :param capacity: The scale up/out capacity, representing server's compute units.
    :type capacity: int
    :param size: The size code, to be interpreted by resource as appropriate.
    :type size: str
    :param family: The family of hardware.
    :type family: str
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "SkuTier"]] = None,
        capacity: Optional[int] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity
        self.size = size
        self.family = family


class StorageProfile(msrest.serialization.Model):
    """Storage Profile properties of a server.

    :param backup_retention_days: Backup retention days for the server.
    :type backup_retention_days: int
    :param geo_redundant_backup: Enable Geo-redundant or not for server backup. Possible values
     include: "Enabled", "Disabled".
    :type geo_redundant_backup: str or ~azure.mgmt.rdbms.mariadb.models.GeoRedundantBackup
    :param storage_mb: Max storage allowed for a server.
    :type storage_mb: int
    :param storage_autogrow: Enable Storage Auto Grow. Possible values include: "Enabled",
     "Disabled".
    :type storage_autogrow: str or ~azure.mgmt.rdbms.mariadb.models.StorageAutogrow
    """

    _attribute_map = {
        'backup_retention_days': {'key': 'backupRetentionDays', 'type': 'int'},
        'geo_redundant_backup': {'key': 'geoRedundantBackup', 'type': 'str'},
        'storage_mb': {'key': 'storageMB', 'type': 'int'},
        'storage_autogrow': {'key': 'storageAutogrow', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        backup_retention_days: Optional[int] = None,
        geo_redundant_backup: Optional[Union[str, "GeoRedundantBackup"]] = None,
        storage_mb: Optional[int] = None,
        storage_autogrow: Optional[Union[str, "StorageAutogrow"]] = None,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.backup_retention_days = backup_retention_days
        self.geo_redundant_backup = geo_redundant_backup
        self.storage_mb = storage_mb
        self.storage_autogrow = storage_autogrow


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags


class TopQueryStatisticsInput(msrest.serialization.Model):
    """Input to get top query statistics.

    All required parameters must be populated in order to send to Azure.

    :param number_of_top_queries: Required. Max number of top queries to return.
    :type number_of_top_queries: int
    :param aggregation_function: Required. Aggregation function name.
    :type aggregation_function: str
    :param observed_metric: Required. Observed metric name.
    :type observed_metric: str
    :param observation_start_time: Required. Observation start time.
    :type observation_start_time: ~datetime.datetime
    :param observation_end_time: Required. Observation end time.
    :type observation_end_time: ~datetime.datetime
    :param aggregation_window: Required. Aggregation interval type in ISO 8601 format.
    :type aggregation_window: str
    """

    _validation = {
        'number_of_top_queries': {'required': True},
        'aggregation_function': {'required': True},
        'observed_metric': {'required': True},
        'observation_start_time': {'required': True},
        'observation_end_time': {'required': True},
        'aggregation_window': {'required': True},
    }

    _attribute_map = {
        'number_of_top_queries': {'key': 'properties.numberOfTopQueries', 'type': 'int'},
        'aggregation_function': {'key': 'properties.aggregationFunction', 'type': 'str'},
        'observed_metric': {'key': 'properties.observedMetric', 'type': 'str'},
        'observation_start_time': {'key': 'properties.observationStartTime', 'type': 'iso-8601'},
        'observation_end_time': {'key': 'properties.observationEndTime', 'type': 'iso-8601'},
        'aggregation_window': {'key': 'properties.aggregationWindow', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        number_of_top_queries: int,
        aggregation_function: str,
        observed_metric: str,
        observation_start_time: datetime.datetime,
        observation_end_time: datetime.datetime,
        aggregation_window: str,
        **kwargs
    ):
        super(TopQueryStatisticsInput, self).__init__(**kwargs)
        self.number_of_top_queries = number_of_top_queries
        self.aggregation_function = aggregation_function
        self.observed_metric = observed_metric
        self.observation_start_time = observation_start_time
        self.observation_end_time = observation_end_time
        self.aggregation_window = aggregation_window


class TopQueryStatisticsResultList(msrest.serialization.Model):
    """A list of query statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of top query statistics.
    :vartype value: list[~azure.mgmt.rdbms.mariadb.models.QueryStatistic]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QueryStatistic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopQueryStatisticsResultList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class VirtualNetworkRule(Resource):
    """A virtual network rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param virtual_network_subnet_id: The ARM resource id of the virtual network subnet.
    :type virtual_network_subnet_id: str
    :param ignore_missing_vnet_service_endpoint: Create firewall rule before the virtual network
     has vnet service endpoint enabled.
    :type ignore_missing_vnet_service_endpoint: bool
    :ivar state: Virtual Network Rule State. Possible values include: "Initializing", "InProgress",
     "Ready", "Deleting", "Unknown".
    :vartype state: str or ~azure.mgmt.rdbms.mariadb.models.VirtualNetworkRuleState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
        'ignore_missing_vnet_service_endpoint': {'key': 'properties.ignoreMissingVnetServiceEndpoint', 'type': 'bool'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_subnet_id: Optional[str] = None,
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_subnet_id = virtual_network_subnet_id
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint
        self.state = None


class VirtualNetworkRuleListResult(msrest.serialization.Model):
    """A list of virtual network rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.mariadb.models.VirtualNetworkRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WaitStatistic(Resource):
    """Represents a Wait Statistic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param start_time: Observation start time.
    :type start_time: ~datetime.datetime
    :param end_time: Observation end time.
    :type end_time: ~datetime.datetime
    :param event_name: Wait event name.
    :type event_name: str
    :param event_type_name: Wait event type name.
    :type event_type_name: str
    :param query_id: Database query identifier.
    :type query_id: long
    :param database_name: Database Name.
    :type database_name: str
    :param user_id: Database user identifier.
    :type user_id: long
    :param count: Wait event count observed in this time interval.
    :type count: long
    :param total_time_in_ms: Total time of wait in milliseconds in this time interval.
    :type total_time_in_ms: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'event_name': {'key': 'properties.eventName', 'type': 'str'},
        'event_type_name': {'key': 'properties.eventTypeName', 'type': 'str'},
        'query_id': {'key': 'properties.queryId', 'type': 'long'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'long'},
        'count': {'key': 'properties.count', 'type': 'long'},
        'total_time_in_ms': {'key': 'properties.totalTimeInMs', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        event_name: Optional[str] = None,
        event_type_name: Optional[str] = None,
        query_id: Optional[int] = None,
        database_name: Optional[str] = None,
        user_id: Optional[int] = None,
        count: Optional[int] = None,
        total_time_in_ms: Optional[float] = None,
        **kwargs
    ):
        super(WaitStatistic, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.event_name = event_name
        self.event_type_name = event_type_name
        self.query_id = query_id
        self.database_name = database_name
        self.user_id = user_id
        self.count = count
        self.total_time_in_ms = total_time_in_ms


class WaitStatisticsInput(msrest.serialization.Model):
    """Input to get wait statistics.

    All required parameters must be populated in order to send to Azure.

    :param observation_start_time: Required. Observation start time.
    :type observation_start_time: ~datetime.datetime
    :param observation_end_time: Required. Observation end time.
    :type observation_end_time: ~datetime.datetime
    :param aggregation_window: Required. Aggregation interval type in ISO 8601 format.
    :type aggregation_window: str
    """

    _validation = {
        'observation_start_time': {'required': True},
        'observation_end_time': {'required': True},
        'aggregation_window': {'required': True},
    }

    _attribute_map = {
        'observation_start_time': {'key': 'properties.observationStartTime', 'type': 'iso-8601'},
        'observation_end_time': {'key': 'properties.observationEndTime', 'type': 'iso-8601'},
        'aggregation_window': {'key': 'properties.aggregationWindow', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        observation_start_time: datetime.datetime,
        observation_end_time: datetime.datetime,
        aggregation_window: str,
        **kwargs
    ):
        super(WaitStatisticsInput, self).__init__(**kwargs)
        self.observation_start_time = observation_start_time
        self.observation_end_time = observation_end_time
        self.aggregation_window = aggregation_window


class WaitStatisticsResultList(msrest.serialization.Model):
    """A list of wait statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of wait statistics.
    :vartype value: list[~azure.mgmt.rdbms.mariadb.models.WaitStatistic]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WaitStatistic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WaitStatisticsResultList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
