

import math

# Calculate Fresnel reflectance 
def fresnel(n_w, zenith_i): # incident zenith 

    if zenith_i >= 90:
        print('Warning: incident angle > 90 for fresnel reflection')

    # Refractive index 
    n_a = 1  # air
    # n_w = 1.34 # water
    
    # incident angle == 0
    if zenith_i == 0:
        R = ( (n_w-1)  / (n_w+1) )**2
    
    elif zenith_i < 90 and zenith_i >0:
        # for incident zenith > 0, i=incident, t=transmission 
        
        ### Fresnel's reflection (for both air&water incident) (
        n_i = n_a # incident 
        n_t = n_w # transmitted 
        
        # Transmission angle 
        sin_zenith_i = math.sin( zenith_i/ (180/math.pi))
        zenith_t = math.asin((n_i/n_t)* sin_zenith_i) * (180/math.pi)
        
        # Convert to radian
        z_i = zenith_i/ (180/math.pi)
        z_t = zenith_t/ (180/math.pi)
        
        # Reflectance 
        
        R = 0.5 * ((math.sin(z_i-z_t)/math.sin(z_i+z_t))**2 + (math.tan(z_i-z_t)/math.tan(z_i+z_t))**2)

    else:
        print('Warning: fresnel error: zenith is ' + str(zenith_i))
        R = None

    return R



test = fresnel(1.34, 40)

print(test)



