from django.db import models
from core import models as core_models


class ReportDefinition(core_models.UUIDModel):
    """
    Record report (business modules) templates to be generated by the templating engine (reportbro for PDF,...)
    Initial implementation only integrate ReportBro templating engine
    """
    REPORT_BRO = 0
    REPORT_ENGINE_CHOICES = (
        (REPORT_BRO, "Report Bro - PDF"),
    )

    name = models.CharField(
        max_length=255, blank=False, null=False, unique=True)
    engine = models.IntegerField(
        choices=REPORT_ENGINE_CHOICES, default=REPORT_BRO)
    definition = models.TextField()
    validity_from = models.DateTimeField(blank=True, null=True)
    validity_to = models.DateTimeField(blank=True, null=True)

    class Meta:
        managed = True
        db_table = "report_ReportDefinition"
