"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.KubernetesVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_aws_1 = require("@cdktf/provider-aws");
const k8s = require("@cdktf/provider-kubernetes");
const cdktf_1 = require("cdktf");
const constructs_1 = require("constructs");
const _1 = require(".");
const awsVpc = require("./imports/modules/terraform-aws-modules/vpc/aws");
/**
 * Kubernetes cluster version.
 *
 * @stability stable
 */
class KubernetesVersion {
    /**
     *
     * @param version cluster version number
     */
    constructor(version) {
        this.version = version;
    }
    /**
     * Custom cluster version.
     *
     * @param version custom version number.
     * @stability stable
     */
    static of(version) { return new KubernetesVersion(version); }
}
exports.KubernetesVersion = KubernetesVersion;
_a = JSII_RTTI_SYMBOL_1;
KubernetesVersion[_a] = { fqn: "@pahud/cdktf-aws-eks.KubernetesVersion", version: "0.2.11" };
/**
 * Kubernetes version 1.14.
 *
 * @stability stable
 */
KubernetesVersion.V1_14 = KubernetesVersion.of('1.14');
/**
 * Kubernetes version 1.15.
 *
 * @stability stable
 */
KubernetesVersion.V1_15 = KubernetesVersion.of('1.15');
/**
 * Kubernetes version 1.16.
 *
 * @stability stable
 */
KubernetesVersion.V1_16 = KubernetesVersion.of('1.16');
/**
 * Kubernetes version 1.17.
 *
 * @stability stable
 */
KubernetesVersion.V1_17 = KubernetesVersion.of('1.17');
/**
 * Kubernetes version 1.18.
 *
 * @stability stable
 */
KubernetesVersion.V1_18 = KubernetesVersion.of('1.18');
/**
 * Kubernetes version 1.19.
 *
 * @stability stable
 */
KubernetesVersion.V1_19 = KubernetesVersion.of('1.19');
/**
 * Kubernetes version 1.20.
 *
 * @stability stable
 */
KubernetesVersion.V1_20 = KubernetesVersion.of('1.20');
/**
 * Kubernetes version 1.21.
 *
 * @stability stable
 */
KubernetesVersion.V1_21 = KubernetesVersion.of('1.21');
/**
 * The Amazon EKS Cluster with a default nodegroup.
 *
 * @stability stable
 */
class Cluster extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        this.props = props;
        ;
        this.region = (_c = props.region) !== null && _c !== void 0 ? _c : 'us-east-1';
        new provider_aws_1.AwsProvider(this, 'aws', { region: this.region });
        // no private subnets given
        if (!props.privateSubnets) {
            const vpc = this._createVpc();
            this.vpc = vpc;
            this.vpcId = cdktf_1.Token.asString(vpc.vpcIdOutput);
            this.privateSubnets = cdktf_1.Token.asList(vpc.privateSubnetsOutput);
            this.publicSubnets = cdktf_1.Token.asList(vpc.publicSubnetsOutput);
        }
        else {
            this.privateSubnets = props.privateSubnets;
            this.publicSubnets = props.publicSubnets;
        }
        // create the cluster
        this.clusterName = (_d = props.clusterName) !== null && _d !== void 0 ? _d : `${id}cluster`;
        const cluster = new provider_aws_1.EksCluster(this, 'EksCluster', {
            name: this.clusterName,
            version: props.version.version,
            vpcConfig: [
                {
                    // the cluster should associate with all available subnets
                    subnetIds: this.vpcId ? this.getAllSubnetsFromVpcId(this.vpcId, [this.vpc]).ids :
                        this.privateSubnets.concat(this.publicSubnets),
                },
            ],
            roleArn: this._createClusterRole().arn,
        });
        this.cluster = cluster;
        // cluster should be created after vpc
        if (this.vpc) {
            cluster.node.addDependency(this.vpc);
        }
        this.defaultNodeGroup = new _1.NodeGroup(this, 'NG', {
            clusterName: cluster.name,
            subnets: this.privateSubnets,
            scalingConfig: props.scalingConfig,
            capacityType: props.capacityType,
            instanceTypes: props.instanceTypes,
            dependsOn: [this.cluster],
        });
        const clusterAuthData = new provider_aws_1.DataAwsEksClusterAuth(this, 'DataAwsEksClusterAuth', {
            name: this.clusterName,
        });
        let cert = `\${base64decode(${cluster.certificateAuthority})}`;
        const k8sprovider = new k8s.KubernetesProvider(this, 'Kubernetes', {
            host: cdktf_1.Token.asString(cluster.endpoint),
            token: cdktf_1.Token.asString(clusterAuthData.token),
        });
        k8sprovider.addOverride('cluster_ca_certificate', cert);
        new cdktf_1.TerraformOutput(this, 'KubelctlCommand', {
            value: `aws --region ${this.region} eks update-kubeconfig --name ${this.clusterName}`,
        });
    }
    _createVpc() {
        const vpc = new awsVpc.TerraformAwsModulesVpcAws(this, 'Vpc', {
            cidr: '10.0.0.0/16',
            azs: new provider_aws_1.DataAwsAvailabilityZones(this, 'AZs', {
                state: 'available',
            }).names,
            publicSubnets: ['10.0.1.0/24', '10.0.2.0/24', '10.0.3.0/24'],
            privateSubnets: ['10.0.11.0/24', '10.0.12.0/24', '10.0.13.0/24'],
            singleNatGateway: true,
            enableNatGateway: true,
            oneNatGatewayPerAz: false,
        });
        return vpc;
    }
    _createClusterRole() {
        const role = new provider_aws_1.IamRole(this, 'ClusterRole', {
            assumeRolePolicy: JSON.stringify({
                Version: '2012-10-17',
                Statement: [
                    {
                        Action: 'sts:AssumeRole',
                        Effect: 'Allow',
                        Sid: '',
                        Principal: {
                            Service: 'eks.amazonaws.com',
                        },
                    },
                ],
            }),
        });
        new provider_aws_1.IamPolicyAttachment(this, 'AmazonEKSClusterPolicyAttachment', {
            name: 'AmazonEKSClusterPolicyAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEKSClusterPolicy',
            roles: [role.name],
        });
        new provider_aws_1.IamPolicyAttachment(this, 'AmazonEKSVPCResourceControllerAttachment', {
            name: 'AmazonEKSVPCResourceControllerAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEKSVPCResourceController',
            roles: [role.name],
        });
        return role;
    }
    getAllSubnetsFromVpcId(vpcId, dependable) {
        return new provider_aws_1.DataAwsSubnetIds(this, `${vpcId}subnets`, {
            vpcId,
            dependsOn: dependable,
        });
    }
    /**
     * @stability stable
     */
    addNodeGroup(id, options) {
        var _c, _d, _e;
        new _1.NodeGroup(this, id, {
            ...options,
            clusterName: this.clusterName,
            nodeRole: (_c = options.nodeRole) !== null && _c !== void 0 ? _c : (_d = this.defaultNodeGroup) === null || _d === void 0 ? void 0 : _d.nodeGroupRoleArn,
            subnets: (_e = options.subnets) !== null && _e !== void 0 ? _e : this.privateSubnets,
            dependsOn: [this.cluster],
        });
    }
}
exports.Cluster = Cluster;
_b = JSII_RTTI_SYMBOL_1;
Cluster[_b] = { fqn: "@pahud/cdktf-aws-eks.Cluster", version: "0.2.11" };
//# sourceMappingURL=data:application/json;base64,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