[![PyPI version](https://badge.fury.io/py/swyft.svg)](https://badge.fury.io/py/swyft)
[![Tests](https://github.com/undark-lab/swyft/actions/workflows/tests.yml/badge.svg)](https://github.com/undark-lab/swyft/actions)
[![Syntax](https://github.com/undark-lab/swyft/actions/workflows/syntax.yml/badge.svg)](https://github.com/undark-lab/swyft/actions)
[![codecov](https://codecov.io/gh/undark-lab/swyft/branch/master/graph/badge.svg?token=E253LRJWWE)](https://codecov.io/gh/undark-lab/swyft)
[![Documentation Status](https://readthedocs.org/projects/swyft/badge/?version=latest)](https://swyft.readthedocs.io/en/latest/?badge=latest)
[![Contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat)](https://github.com/undark-lab/swyft/blob/master/CONTRIBUTING.md)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

Check out the quickstart notebook --> [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/undark-lab/swyft/blob/master/notebooks/Quickstart.ipynb)

**This is a beta release. If you encounter problems, please contact the authors or submit a bug report.**

# SWYFT

<p align="center">
Truncated marginal neural ratio estimation
</p>

## Installation

**After installing [pytorch](https://pytorch.org/get-started/locally/)**, please run the command:

`pip install swyft`

## Documentation

Detailed documentation can be found on [readthedocs](https://swyft.readthedocs.io/en/latest/).

## Related tools and repositories

- Our repository applying swyft to benchmarks and example inference problems is available at [tmnre](https://github.com/bkmi/tmnre).
- [sbi](https://github.com/mackelab/sbi) is a collection of likelihood-free / simulator-based methods


## Citing

If you use *swyft* in scientific publications, please cite one or both:

*Truncated Marginal Neural Ratio Estimation*. Benjamin Kurt Miller, Alex Cole, Patrick Forré, Gilles Louppe, Christoph Weniger. https://arxiv.org/abs/2107.01214

*Simulation-efficient marginal posterior estimation with swyft: stop wasting your precious time*. Benjamin Kurt Miller, Alex Cole, Gilles Louppe, Christoph Weniger. https://arxiv.org/abs/2011.13951
