## Copyright 2021 Aon plc
##
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
##
## http://www.apache.org/licenses/LICENSE-2.0
##
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.

from mmap import mmap as MemoryMap
from pathlib import Path
from typing import Union


#: Type for buffer containing bytes of an extracted Cobalt Strike config.
ConfigBuffer = Union[bytearray, bytes]
#: Type for sources that Cobalt Strike configs can be parsed from.
CobaltStrikeSource = Union[ConfigBuffer, Path]
#: Type for data read from a :data:`.CobaltStrikeSource`.
ConfigSourceBuffer = Union[ConfigBuffer, MemoryMap]
