"""empty message

Revision ID: 875c4dd8c271
Revises: 
Create Date: 2023-03-11 22:32:32.995987

"""
import sqlalchemy as sa
from alembic import op
# revision identifiers, used by Alembic.
from sqlalchemy import Inspector

revision = '875c4dd8c271'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    conn = op.get_bind()
    inspector = Inspector.from_engine(conn.engine)
    tables = inspector.get_table_names()

    # ### commands auto generated by Alembic - please adjust! ###
    if "nonebot_plugin_access_control_permission" not in tables:
        op.create_table('nonebot_plugin_access_control_permission',
                        sa.Column('subject', sa.String(), nullable=False),
                        sa.Column('service', sa.String(), nullable=False),
                        sa.Column('allow', sa.Boolean(), nullable=False),
                        sa.PrimaryKeyConstraint('subject', 'service')
                        )

    if "nonebot_plugin_access_control_rate_limit_rule" not in tables:
        op.create_table('nonebot_plugin_access_control_rate_limit_rule',
                        sa.Column('id', sa.String(), nullable=False),
                        sa.Column('subject', sa.String(), nullable=False),
                        sa.Column('service', sa.String(), nullable=False),
                        sa.Column('time_span', sa.Integer(), nullable=False),
                        sa.Column('limit', sa.Integer(), nullable=False),
                        sa.Column('overwrite', sa.Boolean(), nullable=False),
                        sa.PrimaryKeyConstraint('id')
                        )
        with op.batch_alter_table('nonebot_plugin_access_control_rate_limit_rule', schema=None) as batch_op:
            batch_op.create_index('ix_nonebot_plugin_access_control_rate_limit_rule_subject_service',
                                  ['subject', 'service'], unique=False)

    if "nonebot_plugin_access_control_rate_limit_token" not in tables:
        op.create_table('nonebot_plugin_access_control_rate_limit_token',
                        sa.Column('id', sa.Integer(), nullable=False),
                        sa.Column('rule_id', sa.String(), nullable=False),
                        sa.Column('user', sa.String(), nullable=False),
                        sa.Column('acquire_time', sa.DateTime(), nullable=False),
                        sa.ForeignKeyConstraint(['rule_id'], ['nonebot_plugin_access_control_rate_limit_rule.id'], ),
                        sa.PrimaryKeyConstraint('id')
                        )
        with op.batch_alter_table('nonebot_plugin_access_control_rate_limit_token', schema=None) as batch_op:
            batch_op.create_index(batch_op.f('ix_nonebot_plugin_access_control_rate_limit_token_rule_id'), ['rule_id'],
                                  unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('nonebot_plugin_access_control_rate_limit_token', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_nonebot_plugin_access_control_rate_limit_token_rule_id'))

    op.drop_table('nonebot_plugin_access_control_rate_limit_token')
    with op.batch_alter_table('nonebot_plugin_access_control_rate_limit_rule', schema=None) as batch_op:
        batch_op.drop_index('ix_nonebot_plugin_access_control_rate_limit_rule_subject_service')

    op.drop_table('nonebot_plugin_access_control_rate_limit_rule')
    op.drop_table('nonebot_plugin_access_control_permission')
    # ### end Alembic commands ###
