# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class RemoveDocxHeadersAndFootersRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'input_file_bytes': 'str',
        'input_file_url': 'str',
        'remove_headers': 'bool',
        'remove_footers': 'bool'
    }

    attribute_map = {
        'input_file_bytes': 'InputFileBytes',
        'input_file_url': 'InputFileUrl',
        'remove_headers': 'RemoveHeaders',
        'remove_footers': 'RemoveFooters'
    }

    def __init__(self, input_file_bytes=None, input_file_url=None, remove_headers=None, remove_footers=None):  # noqa: E501
        """RemoveDocxHeadersAndFootersRequest - a model defined in Swagger"""  # noqa: E501

        self._input_file_bytes = None
        self._input_file_url = None
        self._remove_headers = None
        self._remove_footers = None
        self.discriminator = None

        if input_file_bytes is not None:
            self.input_file_bytes = input_file_bytes
        if input_file_url is not None:
            self.input_file_url = input_file_url
        if remove_headers is not None:
            self.remove_headers = remove_headers
        if remove_footers is not None:
            self.remove_footers = remove_footers

    @property
    def input_file_bytes(self):
        """Gets the input_file_bytes of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501

        Optional: Bytes of the input file to operate on  # noqa: E501

        :return: The input_file_bytes of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_file_bytes

    @input_file_bytes.setter
    def input_file_bytes(self, input_file_bytes):
        """Sets the input_file_bytes of this RemoveDocxHeadersAndFootersRequest.

        Optional: Bytes of the input file to operate on  # noqa: E501

        :param input_file_bytes: The input_file_bytes of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501
        :type: str
        """
        if input_file_bytes is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', input_file_bytes):  # noqa: E501
            raise ValueError(r"Invalid value for `input_file_bytes`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._input_file_bytes = input_file_bytes

    @property
    def input_file_url(self):
        """Gets the input_file_url of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501

        Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).  # noqa: E501

        :return: The input_file_url of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_file_url

    @input_file_url.setter
    def input_file_url(self, input_file_url):
        """Sets the input_file_url of this RemoveDocxHeadersAndFootersRequest.

        Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).  # noqa: E501

        :param input_file_url: The input_file_url of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501
        :type: str
        """

        self._input_file_url = input_file_url

    @property
    def remove_headers(self):
        """Gets the remove_headers of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501

        True if you would like to remove all headers from the input document, false otherwise  # noqa: E501

        :return: The remove_headers of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501
        :rtype: bool
        """
        return self._remove_headers

    @remove_headers.setter
    def remove_headers(self, remove_headers):
        """Sets the remove_headers of this RemoveDocxHeadersAndFootersRequest.

        True if you would like to remove all headers from the input document, false otherwise  # noqa: E501

        :param remove_headers: The remove_headers of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501
        :type: bool
        """

        self._remove_headers = remove_headers

    @property
    def remove_footers(self):
        """Gets the remove_footers of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501

        True if you would like to remove all footers from the input document, false otherwise  # noqa: E501

        :return: The remove_footers of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501
        :rtype: bool
        """
        return self._remove_footers

    @remove_footers.setter
    def remove_footers(self, remove_footers):
        """Sets the remove_footers of this RemoveDocxHeadersAndFootersRequest.

        True if you would like to remove all footers from the input document, false otherwise  # noqa: E501

        :param remove_footers: The remove_footers of this RemoveDocxHeadersAndFootersRequest.  # noqa: E501
        :type: bool
        """

        self._remove_footers = remove_footers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RemoveDocxHeadersAndFootersRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RemoveDocxHeadersAndFootersRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
