# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class PresentationResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'slide_number': 'int',
        'url': 'str',
        'presentation_contents': 'str'
    }

    attribute_map = {
        'slide_number': 'SlideNumber',
        'url': 'URL',
        'presentation_contents': 'PresentationContents'
    }

    def __init__(self, slide_number=None, url=None, presentation_contents=None):  # noqa: E501
        """PresentationResult - a model defined in Swagger"""  # noqa: E501

        self._slide_number = None
        self._url = None
        self._presentation_contents = None
        self.discriminator = None

        if slide_number is not None:
            self.slide_number = slide_number
        if url is not None:
            self.url = url
        if presentation_contents is not None:
            self.presentation_contents = presentation_contents

    @property
    def slide_number(self):
        """Gets the slide_number of this PresentationResult.  # noqa: E501

        Worksheet number of the converted page, starting with 1 for the left-most worksheet  # noqa: E501

        :return: The slide_number of this PresentationResult.  # noqa: E501
        :rtype: int
        """
        return self._slide_number

    @slide_number.setter
    def slide_number(self, slide_number):
        """Sets the slide_number of this PresentationResult.

        Worksheet number of the converted page, starting with 1 for the left-most worksheet  # noqa: E501

        :param slide_number: The slide_number of this PresentationResult.  # noqa: E501
        :type: int
        """

        self._slide_number = slide_number

    @property
    def url(self):
        """Gets the url of this PresentationResult.  # noqa: E501

        URL to the PPTX file of this slide; file is stored in an in-memory cache and will be deleted  # noqa: E501

        :return: The url of this PresentationResult.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this PresentationResult.

        URL to the PPTX file of this slide; file is stored in an in-memory cache and will be deleted  # noqa: E501

        :param url: The url of this PresentationResult.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def presentation_contents(self):
        """Gets the presentation_contents of this PresentationResult.  # noqa: E501

        Contents of the presentation in bytes  # noqa: E501

        :return: The presentation_contents of this PresentationResult.  # noqa: E501
        :rtype: str
        """
        return self._presentation_contents

    @presentation_contents.setter
    def presentation_contents(self, presentation_contents):
        """Sets the presentation_contents of this PresentationResult.

        Contents of the presentation in bytes  # noqa: E501

        :param presentation_contents: The presentation_contents of this PresentationResult.  # noqa: E501
        :type: str
        """
        if presentation_contents is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', presentation_contents):  # noqa: E501
            raise ValueError(r"Invalid value for `presentation_contents`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._presentation_contents = presentation_contents

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PresentationResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PresentationResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
