
try:
    from ._version import __version__
except ImportError:
    # Fallback when using the package in dev mode without installing
    # in editable mode with pip. It is highly recommended to install
    # the package from a stable release or in editable mode: https://pip.pypa.io/en/stable/topics/local-project-installs/#editable-installs
    import warnings
    warnings.warn("Importing 'jupyterlab_unzip_extension' outside a proper installation.")
    __version__ = "dev"


from .handlers import load_jupyter_server_extension

# This is required for Jupyter Server to find the extension
def _load_jupyter_server_extension(serverapp):
    load_jupyter_server_extension(serverapp)
