import pandas as pd
from typing import Union, Optional, Dict, Any
import json
import logging
from jls_utils.funcs.funcs import post_collections_data
from jls_utils.abstract.abstract import DocsDataCollection, Alias


def create_collection_from_file_df(file: str, name: Optional[str], metadata: Optional[Union[Dict[str, Any], str]], *args, **kwargs) -> Alias.Id:
    data = pd.read_csv(file)
    if name is None: 
        name = file 
    return create_collection_from_df(data, name=file, metadata=metadata, *args, **kwargs)


def create_collection_from_df(data: pd.DataFrame, name: Optional[str], metadata: Optional[Union[Dict[str, Any], str]], *args, **kwargs) -> Alias.Id:
    if metadata is not None:
        if isinstance(metadata, str):
            with open(metadata, 'r') as f:
                metadata = json.load(f)
            metadata = json.dumps(metadata)
        elif isinstance(data, dict):
            metadata = json.dumps(metadata)
        else:
            logging.warning(f"wrong metadata type, ignore")
            metadata = None
    return post_collections_data(DocsDataCollection(data=[row.to_json() for _, row in data.iterrows()], name=name, metadata=metadata), *args, **kwargs)
