import pandas as pd
import numpy as np
import fink_science.agn.kernel as k
import pickle


with open(k.CLASSIFIER_ELASTICC, "rb") as f:
    clf_unit = pickle.load(f)

raw_ztf_unit = pd.DataFrame(
    {
        "objectId": {0: "ZTF19aapwyda", 1: "ZTF19aanojfm"},
        "cjd": {
            0: np.array(
                [
                    2459672.6491088,
                    2459672.669213,
                    2459674.6682755,
                    2459674.7094444,
                    2459674.7099306,
                    2459676.6679861,
                    2459676.6689468,
                    2459676.7099537,
                    2459676.7104398,
                    2459678.668287,
                    2459678.6702083,
                    2459678.7091667,
                    2459678.7096412,
                    2459680.710625,
                    2459680.7110995,
                    2459683.7380093,
                    2459685.6703588,
                    2459685.6708218,
                    2459685.7109838,
                    2459685.7114583,
                    2459688.6562731,
                    2459688.6692824,
                    2459688.6697454,
                    2459693.6685185,
                    2459693.6896875,
                    2459693.7170139,
                    2459695.6696991,
                    2459695.670162,
                    2459697.6697222,
                    2459697.6919213,
                    2459699.665706,
                    2459699.693912,
                    2459701.6636458,
                ]
            ),
            1: np.array(
                [
                    2459674.6877083,
                    2459674.7094444,
                    2459676.6679861,
                    2459676.7094792,
                    2459676.7099537,
                    2459678.6702083,
                    2459678.671169,
                    2459678.7096412,
                    2459678.7106019,
                    2459680.7101389,
                    2459680.710625,
                    2459683.7370718,
                    2459683.7380093,
                    2459684.7523495,
                    2459685.6703588,
                    2459685.7109838,
                    2459687.7571065,
                    2459688.6692824,
                    2459689.6595602,
                    2459689.6687037,
                    2459693.6892245,
                    2459693.6896875,
                    2459693.7165509,
                    2459693.7170139,
                    2459695.6692245,
                    2459695.6696991,
                    2459695.7177662,
                    2459697.6692477,
                    2459697.6697222,
                    2459697.6914468,
                    2459697.6919213,
                    2459699.665706,
                    2459699.6934375,
                    2459699.693912,
                    2459701.6636458,
                ]
            ),
        },
        "cmagpsf": {
            0: np.array(
                [
                    np.nan,
                    18.61039925,
                    np.nan,
                    np.nan,
                    np.nan,
                    18.49259949,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    18.93490028,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    18.79299927,
                    18.81450081,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    18.75589943,
                    np.nan,
                    np.nan,
                    18.62509918,
                    np.nan,
                    np.nan,
                    np.nan,
                    19.2805748,
                ]
            ),
            1: np.array(
                [
                    np.nan,
                    np.nan,
                    15.71949959,
                    16.66970062,
                    16.81200027,
                    np.nan,
                    np.nan,
                    np.nan,
                    17.32189941,
                    15.83580017,
                    15.72430038,
                    np.nan,
                    np.nan,
                    16.54000092,
                    17.01619911,
                    16.38249969,
                    np.nan,
                    17.67440033,
                    16.60289955,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    15.82859993,
                    16.06459999,
                    16.68449974,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    16.77719307,
                ]
            ),
        },
        "csigmapsf": {
            0: np.array(
                [
                    np.nan,
                    0.092524,
                    np.nan,
                    np.nan,
                    np.nan,
                    0.214902,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    0.156846,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    0.21192101,
                    0.19491,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    0.18780801,
                    np.nan,
                    np.nan,
                    0.17827401,
                    np.nan,
                    np.nan,
                    np.nan,
                    0.20185432,
                ]
            ),
            1: np.array(
                [
                    np.nan,
                    np.nan,
                    0.04519,
                    0.065497,
                    0.050263,
                    np.nan,
                    np.nan,
                    np.nan,
                    0.23620901,
                    0.081934,
                    0.049932,
                    np.nan,
                    np.nan,
                    0.076488,
                    0.059029,
                    0.075534,
                    np.nan,
                    0.111783,
                    0.065441,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    0.040475,
                    0.08743,
                    0.077915,
                    np.nan,
                    np.nan,
                    np.nan,
                    np.nan,
                    0.077747,
                ]
            ),
        },
        "cfid": {
            0: np.array(
                [
                    1,
                    2,
                    1,
                    2,
                    2,
                    2,
                    2,
                    1,
                    1,
                    1,
                    1,
                    2,
                    2,
                    2,
                    2,
                    2,
                    1,
                    1,
                    2,
                    2,
                    2,
                    1,
                    1,
                    2,
                    2,
                    1,
                    1,
                    1,
                    2,
                    1,
                    2,
                    1,
                    1,
                ]
            ),
            1: np.array(
                [
                    1,
                    2,
                    2,
                    1,
                    1,
                    1,
                    1,
                    2,
                    2,
                    2,
                    2,
                    2,
                    2,
                    1,
                    1,
                    2,
                    1,
                    1,
                    1,
                    2,
                    2,
                    2,
                    1,
                    1,
                    1,
                    1,
                    2,
                    2,
                    2,
                    1,
                    1,
                    2,
                    1,
                    1,
                    1,
                ]
            ),
        },
        "ra": {0: 137.8234222, 1: 145.2603432},
        "dec": {0: -26.6173773, 1: -25.8382244},
    }
)

formated_unit = pd.DataFrame(
    {
        "index": {0: 0},
        "objectId": {0: 8124896327},
        "csigflux": {
            0: np.array(
                [
                    1502.62963867,
                    1606.54199219,
                    1582.04223633,
                    1611.1574707,
                    750.92407227,
                    635.21099854,
                    857.3762207,
                    718.5189209,
                    869.91143799,
                    1399.2298584,
                    1406.63574219,
                    708.41247559,
                    865.05944824,
                    768.21624756,
                    708.69830322,
                    940.50567627,
                    763.09814453,
                    916.20953369,
                    1359.72033691,
                    1501.91223145,
                    817.52435303,
                    837.57128906,
                    1002.8560791,
                    928.43212891,
                    809.96697998,
                    710.39349365,
                    773.34942627,
                    761.39587402,
                    812.07061768,
                    1836.78149414,
                    1899.80541992,
                    683.23956299,
                    738.84936523,
                    779.66558838,
                    785.44567871,
                    776.2567749,
                    786.74157715,
                    882.00158691,
                    796.6673584,
                    996.82830811,
                    1007.47729492,
                    708.03533936,
                    589.63287354,
                    1431.89294434,
                    831.70898438,
                    829.18359375,
                    1006.94293213,
                    723.45300293,
                    719.43109131,
                    754.58978271,
                    749.17486572,
                    701.07342529,
                    1338.15844727,
                    1565.28344727,
                    1446.27075195,
                    981.92285156,
                    766.62261963,
                    873.25323486,
                    859.58099365,
                    943.72393799,
                    668.26940918,
                    677.24291992,
                    876.71734619,
                    666.69824219,
                    734.7902832,
                    647.72119141,
                    1357.42883301,
                    1348.76135254,
                    1395.13317871,
                    1399.12670898,
                    1535.20361328,
                    1522.61010742,
                    1610.10717773,
                    1591.58325195,
                    1669.56225586,
                    1715.83984375,
                    804.19732666,
                    809.5222168,
                    699.6060791,
                    732.58642578,
                    608.05450439,
                    655.86749268,
                    774.29168701,
                ]
            )
        },
        "hostgal_zphot_err": {0: -9.0},
        "cfid": {
            0: np.array(
                [
                    5,
                    5,
                    5,
                    5,
                    2,
                    2,
                    4,
                    3,
                    4,
                    5,
                    5,
                    3,
                    4,
                    1,
                    2,
                    4,
                    3,
                    4,
                    5,
                    5,
                    3,
                    3,
                    4,
                    4,
                    2,
                    2,
                    3,
                    3,
                    2,
                    5,
                    5,
                    1,
                    2,
                    2,
                    2,
                    3,
                    3,
                    3,
                    3,
                    4,
                    4,
                    2,
                    1,
                    4,
                    3,
                    3,
                    4,
                    2,
                    2,
                    3,
                    3,
                    2,
                    5,
                    5,
                    5,
                    4,
                    2,
                    4,
                    3,
                    4,
                    1,
                    2,
                    4,
                    2,
                    2,
                    2,
                    5,
                    5,
                    5,
                    5,
                    5,
                    5,
                    5,
                    5,
                    5,
                    5,
                    3,
                    3,
                    2,
                    3,
                    1,
                    2,
                    3,
                ]
            )
        },
        "cflux": {
            0: np.array(
                [
                    34214.72265625,
                    34508.83203125,
                    31807.36914062,
                    29471.66015625,
                    63378.30078125,
                    14171.08203125,
                    27589.27148438,
                    22141.30078125,
                    12839.97070312,
                    36845.47265625,
                    27556.65234375,
                    16401.3984375,
                    5118.50976562,
                    80914.9609375,
                    54689.765625,
                    15153.98242188,
                    43955.0,
                    24711.42578125,
                    44892.3046875,
                    12517.09277344,
                    38948.765625,
                    40224.4609375,
                    27817.89453125,
                    24197.35351562,
                    79303.65625,
                    54845.0234375,
                    45571.61328125,
                    41816.19140625,
                    80760.4296875,
                    28612.8828125,
                    41750.44921875,
                    48423.2265625,
                    38934.88671875,
                    81743.796875,
                    81780.3515625,
                    48681.78515625,
                    46776.6328125,
                    17958.078125,
                    17933.28710938,
                    10499.74707031,
                    11109.44433594,
                    45568.5546875,
                    8193.33984375,
                    14396.91308594,
                    27853.91992188,
                    28209.33398438,
                    39530.9375,
                    48850.33203125,
                    48540.32421875,
                    30016.47265625,
                    29736.39453125,
                    51622.00390625,
                    21374.90820312,
                    18683.10351562,
                    14125.87109375,
                    35614.77734375,
                    80540.78125,
                    10796.28808594,
                    9845.95117188,
                    3329.82250977,
                    52424.21484375,
                    37089.046875,
                    34756.57421875,
                    28456.41015625,
                    64485.83203125,
                    16172.27050781,
                    44794.21484375,
                    47538.58203125,
                    38266.36328125,
                    40531.24609375,
                    23683.78710938,
                    25802.16015625,
                    41181.36328125,
                    41461.6484375,
                    38323.4921875,
                    34963.43359375,
                    46897.453125,
                    48564.53125,
                    51182.8671875,
                    24680.29882812,
                    9889.34082031,
                    20663.765625,
                    49807.23828125,
                ]
            )
        },
        "ra": {0: 127.66589503029806},
        "dec": {0: -22.384594277138497},
        "hostgal_zphot": {0: -9.0},
        "cjd": {
            0: np.array(
                [
                    60276.2903,
                    60276.2958,
                    60276.3135,
                    60276.3191,
                    60311.1423,
                    60315.3235,
                    60326.2911,
                    60326.3154,
                    60331.1452,
                    60332.2842,
                    60332.3069,
                    60358.2351,
                    60358.2591,
                    60381.0365,
                    60381.0614,
                    60386.9953,
                    60387.0064,
                    60390.0112,
                    60390.0356,
                    60390.1484,
                    60396.1066,
                    60396.108,
                    60396.1304,
                    60396.1318,
                    60405.0762,
                    60408.0543,
                    60408.0783,
                    60411.083,
                    60411.1075,
                    60414.094,
                    60414.1168,
                    60697.1094,
                    60697.1344,
                    60704.2874,
                    60704.2896,
                    60704.3117,
                    60704.314,
                    60718.0846,
                    60718.0855,
                    60718.2373,
                    60718.2382,
                    60727.223,
                    60727.2472,
                    60748.1948,
                    60780.0979,
                    60780.0983,
                    60780.1218,
                    60993.3031,
                    60993.304,
                    60993.3143,
                    60993.3152,
                    60996.3094,
                    60996.3344,
                    60996.3442,
                    61014.277,
                    61014.2994,
                    61029.3554,
                    61038.3547,
                    61046.3321,
                    61046.3435,
                    61058.3075,
                    61058.335,
                    61066.1203,
                    61084.0841,
                    61084.1088,
                    61086.0669,
                    61093.1758,
                    61093.1762,
                    61093.1984,
                    61093.1988,
                    61102.1769,
                    61102.1773,
                    61102.1995,
                    61102.1999,
                    61102.2237,
                    61102.2463,
                    61105.1966,
                    61105.197,
                    61119.1188,
                    61119.1427,
                    61119.1468,
                    61119.1708,
                    61125.1055,
                ]
            )
        },
        "hostgal_dist": {0: -9},
    }
)


expect1_transformed = pd.DataFrame(
    {
        "index": {0: 0},
        "objectId": {0: 8124896327},
        "csigflux": {0: np.array([], dtype=float)},
        "hostgal_zphot_err": {0: -9.0},
        "cfid": {0: np.array([], dtype=int)},
        "cflux": {0: np.array([], dtype=float)},
        "ra": {0: 127.66589503029806},
        "dec": {0: -22.384594277138497},
        "hostgal_zphot": {0: -9.0},
        "cjd": {0: []},
        "hostgal_dist": {0: -9},
        "peak": {0: -1},
        "snr": {0: np.array([], dtype=float)},
    }
)

expect2_transformed = pd.DataFrame(
    {
        "index": {0: 0},
        "objectId": {0: 8124896327},
        "csigflux": {
            0: np.array(
                [
                    0.00918221,
                    0.00776728,
                    0.00866587,
                    0.00990418,
                    0.0086866,
                    0.0099299,
                    0.00903456,
                    0.00953365,
                    0.00960433,
                    0.00865777,
                    0.00884629,
                    0.00879711,
                    0.00857264,
                    0.00937417,
                    0.00828124,
                    0.0081523,
                    0.00898492,
                    0.00792025,
                    0.0085547,
                    0.00801987,
                ]
            )
        },
        "hostgal_zphot_err": {0: -9.0},
        "cfid": {
            0: np.array([2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2])
        },
        "cflux": {
            0: np.array(
                [
                    0.774982,
                    0.17328223,
                    0.66873967,
                    0.96971528,
                    0.67063815,
                    0.98752852,
                    0.47609097,
                    0.99955301,
                    1.0,
                    0.55720664,
                    0.5973358,
                    0.59354507,
                    0.63122746,
                    0.98484269,
                    0.45352027,
                    0.34796146,
                    0.78852476,
                    0.19775252,
                    0.62585775,
                    0.25267396,
                ]
            )
        },
        "ra": {0: 127.66589503029806},
        "dec": {0: -22.384594277138497},
        "hostgal_zphot": {0: -9.0},
        "cjd": {
            0: np.array(
                [
                    -3.931473e02,
                    -3.889661e02,
                    -3.232282e02,
                    -2.992134e02,
                    -2.962353e02,
                    -2.931821e02,
                    -7.155200e00,
                    -2.200000e-03,
                    0.000000e00,
                    2.293340e01,
                    2.890135e02,
                    2.890144e02,
                    2.920198e02,
                    3.250658e02,
                    3.540454e02,
                    3.797945e02,
                    3.798192e02,
                    3.817773e02,
                    4.148292e02,
                    4.148812e02,
                ]
            )
        },
        "hostgal_dist": {0: -9},
        "peak": {0: 81780.3515625},
        "snr": {
            0: np.array(
                [
                    84.4004116,
                    22.30925167,
                    77.16931927,
                    97.90973979,
                    77.20372431,
                    99.45000832,
                    52.69665043,
                    104.84468995,
                    104.11967852,
                    64.35915293,
                    67.52384997,
                    67.47042879,
                    73.63280656,
                    105.05922887,
                    54.76476133,
                    42.68259365,
                    87.76086661,
                    24.96795029,
                    73.15955181,
                    31.50600671,
                ]
            )
        },
    }
)


all_transformed_unit = [
    expect1_transformed.copy(),
    expect1_transformed.copy(),
    expect2_transformed.copy(),
    expect2_transformed.copy(),
    expect1_transformed.copy(),
    expect1_transformed.copy(),
]


expect_all_features0 = pd.DataFrame(
    {
        "object_id": {0: 8124896327},
        "ra": {0: 127.66589503029806},
        "dec": {0: -22.384594277138497},
        "hostgal_dist": {0: -9},
        "hostgal_zphot": {0: -9.0},
        "hostgal_zphot_err": {0: -9.0},
        "std_0": {0: -1},
        "peak_0": {0: -1},
        "mean_snr_0": {0: -1},
        "nb_points_0": {0: 0},
        "cflux_0": {0: np.array([], dtype=float)},
        "csigflux_0": {0: np.array([], dtype=float)},
        "cjd_0": {0: np.array([], dtype=float)},
    }
)

expect_all_features2 = pd.DataFrame(
    {
        "object_id": {0: 8124896327},
        "ra": {0: 127.66589503029806},
        "dec": {0: -22.384594277138497},
        "hostgal_dist": {0: -9},
        "hostgal_zphot": {0: -9.0},
        "hostgal_zphot_err": {0: -9.0},
        "std_2": {0: 0.2617894645144178},
        "peak_2": {0: 81780.3515625},
        "mean_snr_2": {0: 70.64953356900001},
        "nb_points_2": {0: 20},
        "cflux_2": {
            0: np.array(
                [
                    0.774982,
                    0.17328223,
                    0.66873967,
                    0.96971528,
                    0.67063815,
                    0.98752852,
                    0.47609097,
                    0.99955301,
                    1.0,
                    0.55720664,
                    0.5973358,
                    0.59354507,
                    0.63122746,
                    0.98484269,
                    0.45352027,
                    0.34796146,
                    0.78852476,
                    0.19775252,
                    0.62585775,
                    0.25267396,
                ]
            )
        },
        "csigflux_2": {
            0: np.array(
                [
                    0.00918221,
                    0.00776728,
                    0.00866587,
                    0.00990418,
                    0.0086866,
                    0.0099299,
                    0.00903456,
                    0.00953365,
                    0.00960433,
                    0.00865777,
                    0.00884629,
                    0.00879711,
                    0.00857264,
                    0.00937417,
                    0.00828124,
                    0.0081523,
                    0.00898492,
                    0.00792025,
                    0.0085547,
                    0.00801987,
                ]
            )
        },
        "cjd_2": {
            0: np.array(
                [
                    [
                        -353.1473,
                        -348.9661,
                        -283.2282,
                        -259.2134,
                        -256.2353,
                        -253.1821,
                        32.8448,
                        39.9978,
                        40.0,
                        62.9334,
                        329.0135,
                        329.0144,
                        332.0198,
                        365.0658,
                        394.0454,
                        419.7945,
                        419.8192,
                        421.7773,
                        454.8292,
                        454.8812,
                    ]
                ]
            )
        },
    }
)


all_features_unit = [
    pd.DataFrame(
        {
            "object_id": {0: 8124896327},
            "ra": {0: 127.66589503029806},
            "dec": {0: -22.384594277138497},
            "hostgal_dist": {0: -9},
            "hostgal_zphot": {0: -9.0},
            "hostgal_zphot_err": {0: -9.0},
            "std_0": {0: -1},
            "peak_0": {0: -1},
            "mean_snr_0": {0: -1},
            "nb_points_0": {0: 0},
            "cflux_0": {0: np.array([], dtype=float)},
            "csigflux_0": {0: np.array([], dtype=float)},
            "cjd_0": {0: np.array([], dtype=float)},
        }
    ),
    pd.DataFrame(
        {
            "object_id": {0: 8124896327},
            "ra": {0: 127.66589503029806},
            "dec": {0: -22.384594277138497},
            "hostgal_dist": {0: -9},
            "hostgal_zphot": {0: -9.0},
            "hostgal_zphot_err": {0: -9.0},
            "std_1": {0: 0.34149519287365726},
            "peak_1": {0: 80914.9609375},
            "mean_snr_1": {0: 56.96172837501805},
            "nb_points_1": {0: 5},
            "cflux_1": {
                0: np.array([1.0, 0.5984459, 0.10125865, 0.64789273, 0.12221894])
            },
            "csigflux_1": {
                0: np.array(
                    [0.00949412, 0.00844392, 0.00728707, 0.00825891, 0.00751474]
                )
            },
            "cjd_1": {0: np.array([40.0, 356.0729, 386.2107, 717.271, 778.1103])},
        }
    ),
    pd.DataFrame(
        {
            "object_id": {0: 8124896327},
            "ra": {0: 127.66589503029806},
            "dec": {0: -22.384594277138497},
            "hostgal_dist": {0: -9},
            "hostgal_zphot": {0: -9.0},
            "hostgal_zphot_err": {0: -9.0},
            "std_2": {0: 0.2617894645281559},
            "peak_2": {0: 81780.3515625},
            "mean_snr_2": {0: 70.64953356907958},
            "nb_points_2": {0: 20},
            "cflux_2": {
                0: np.array(
                    [
                        0.774982,
                        0.17328223,
                        0.66873967,
                        0.96971528,
                        0.67063815,
                        0.98752852,
                        0.47609097,
                        0.99955301,
                        1.0,
                        0.55720664,
                        0.5973358,
                        0.59354507,
                        0.63122746,
                        0.98484269,
                        0.45352027,
                        0.34796146,
                        0.78852476,
                        0.19775252,
                        0.62585775,
                        0.25267396,
                    ]
                )
            },
            "csigflux_2": {
                0: np.array(
                    [
                        0.00918221,
                        0.00776728,
                        0.00866587,
                        0.00990418,
                        0.0086866,
                        0.0099299,
                        0.00903456,
                        0.00953365,
                        0.00960433,
                        0.00865777,
                        0.00884629,
                        0.00879711,
                        0.00857264,
                        0.00937417,
                        0.00828124,
                        0.0081523,
                        0.00898492,
                        0.00792025,
                        0.0085547,
                        0.00801987,
                    ]
                )
            },
            "cjd_2": {
                0: np.array(
                    [
                        -353.1473,
                        -348.9661,
                        -283.2282,
                        -259.2134,
                        -256.2353,
                        -253.1821,
                        32.8448,
                        39.9978,
                        40.0,
                        62.9334,
                        329.0135,
                        329.0144,
                        332.0198,
                        365.0658,
                        394.0454,
                        419.7945,
                        419.8192,
                        421.7773,
                        454.8292,
                        454.8812,
                    ]
                )
            },
        }
    ),
    pd.DataFrame(
        {
            "object_id": {0: 8124896327},
            "ra": {0: 127.66589503029806},
            "dec": {0: -22.384594277138497},
            "hostgal_dist": {0: -9},
            "hostgal_zphot": {0: -9.0},
            "hostgal_zphot_err": {0: -9.0},
            "std_3": {0: 0.25016818973739513},
            "peak_3": {0: 49807.23828125},
            "mean_snr_3": {0: 43.04414740266073},
            "nb_points_3": {0: 20},
            "cflux_3": {
                0: np.array(
                    [
                        0.44453982,
                        0.32929749,
                        0.88250225,
                        0.78199007,
                        0.80760272,
                        0.91495965,
                        0.83956053,
                        0.97740382,
                        0.93915331,
                        0.36055157,
                        0.36005383,
                        0.55923438,
                        0.56637017,
                        0.60265282,
                        0.59702958,
                        0.19768113,
                        0.94157907,
                        0.97504967,
                        0.49551631,
                        1.0,
                    ]
                )
            },
            "csigflux_3": {
                0: np.array(
                    [
                        0.01442599,
                        0.01422308,
                        0.01532103,
                        0.01641377,
                        0.01681626,
                        0.01552685,
                        0.01528685,
                        0.01558522,
                        0.01579573,
                        0.0177083,
                        0.01599501,
                        0.01669856,
                        0.01664785,
                        0.0151502,
                        0.01504149,
                        0.01725815,
                        0.01614619,
                        0.0162531,
                        0.01470843,
                        0.01554577,
                    ]
                )
            },
            "cjd_3": {
                0: np.array(
                    [
                        -758.7901,
                        -726.8704,
                        -698.0991,
                        -688.9989,
                        -688.9975,
                        -677.0272,
                        -674.0225,
                        -380.7938,
                        -380.7915,
                        -367.0209,
                        -367.02,
                        -305.0076,
                        -305.0072,
                        -91.7912,
                        -91.7903,
                        -38.7734,
                        20.0911,
                        20.0915,
                        34.0372,
                        40.0,
                    ]
                )
            },
        }
    ),
    pd.DataFrame(
        {
            "object_id": {0: 8124896327},
            "ra": {0: 127.66589503029806},
            "dec": {0: -22.384594277138497},
            "hostgal_dist": {0: -9},
            "hostgal_zphot": {0: -9.0},
            "hostgal_zphot_err": {0: -9.0},
            "std_4": {0: 0.2817400358800651},
            "peak_4": {0: 39530.9375},
            "mean_snr_4": {0: 20.828005379261842},
            "nb_points_4": {0: 15},
            "cflux_4": {
                0: np.array(
                    [
                        0.69791594,
                        0.32480815,
                        0.12948111,
                        0.38334488,
                        0.62511611,
                        0.70369934,
                        0.61211181,
                        0.26560835,
                        0.28103164,
                        0.36419357,
                        1.0,
                        0.9009343,
                        0.27310984,
                        0.08423333,
                        0.87922464,
                    ]
                )
            },
            "csigflux_4": {
                0: np.array(
                    [
                        0.02168874,
                        0.02200584,
                        0.0218831,
                        0.02379164,
                        0.02317703,
                        0.02536889,
                        0.02348622,
                        0.02521641,
                        0.02548579,
                        0.03622208,
                        0.02547228,
                        0.02483935,
                        0.02209038,
                        0.02387305,
                        0.02217801,
                    ]
                )
            },
            "cjd_4": {
                0: np.array(
                    [
                        -413.8307,
                        -408.9766,
                        -381.8627,
                        -353.1265,
                        -350.1106,
                        -343.9914,
                        -343.99,
                        -21.8845,
                        -21.8836,
                        8.073,
                        40.0,
                        274.1776,
                        298.2329,
                        306.2217,
                        325.9985,
                    ]
                )
            },
        }
    ),
    pd.DataFrame(
        {
            "object_id": {0: 8124896327},
            "ra": {0: 127.66589503029806},
            "dec": {0: -22.384594277138497},
            "hostgal_dist": {0: -9},
            "hostgal_zphot": {0: -9.0},
            "hostgal_zphot_err": {0: -9.0},
            "std_5": {0: 0.20375029909212944},
            "peak_5": {0: 47538.58203125},
            "mean_snr_5": {0: 21.614146690086248},
            "nb_points_5": {0: 23},
            "cflux_5": {
                0: np.array(
                    [
                        0.71972535,
                        0.7259121,
                        0.66908536,
                        0.61995244,
                        0.77506461,
                        0.57966921,
                        0.94433411,
                        0.26330387,
                        0.6018876,
                        0.87824347,
                        0.44963285,
                        0.39300927,
                        0.2971454,
                        0.94227074,
                        1.0,
                        0.80495382,
                        0.85259687,
                        0.49820138,
                        0.54276251,
                        0.86627244,
                        0.87216839,
                        0.80615556,
                        0.73547489,
                    ]
                )
            },
            "csigflux_5": {
                0: np.array(
                    [
                        0.03160863,
                        0.03379449,
                        0.03327912,
                        0.03389158,
                        0.02943356,
                        0.02958935,
                        0.02860246,
                        0.03159354,
                        0.0386377,
                        0.03996344,
                        0.02814889,
                        0.03292659,
                        0.03042309,
                        0.02855426,
                        0.02837193,
                        0.02934739,
                        0.02943139,
                        0.03229385,
                        0.03202893,
                        0.03386948,
                        0.03347982,
                        0.03512015,
                        0.03609363,
                    ]
                )
            },
            "cjd_5": {
                0: np.array(
                    [
                        -776.8859,
                        -776.8804,
                        -776.8627,
                        -776.8571,
                        -720.892,
                        -720.8693,
                        -663.1406,
                        -663.0278,
                        -639.0822,
                        -639.0594,
                        -56.8418,
                        -56.832,
                        -38.8992,
                        39.9996,
                        40.0,
                        40.0222,
                        40.0226,
                        49.0007,
                        49.0011,
                        49.0233,
                        49.0237,
                        49.0475,
                        49.0701,
                    ]
                )
            },
        }
    ),
]

features_unit = pd.DataFrame(
    {
        "object_id": {0: 8124896327},
        "ra": {0: 127.66589503029806},
        "dec": {0: -22.384594277138497},
        "hostgal_dist": {0: -9},
        "hostgal_zphot": {0: -9.0},
        "hostgal_zphot_err": {0: -9.0},
        "std_0": {0: -1},
        "std_1": {0: 0.34149519287365726},
        "std_2": {0: 0.2617894645281559},
        "std_3": {0: 0.25016818973739513},
        "std_4": {0: 0.2817400358800651},
        "std_5": {0: 0.20375029909212944},
        "peak_0": {0: -1},
        "peak_1": {0: 80914.9609375},
        "peak_2": {0: 81780.3515625},
        "peak_3": {0: 49807.23828125},
        "peak_4": {0: 39530.9375},
        "peak_5": {0: 47538.58203125},
        "mean_snr_0": {0: -1},
        "mean_snr_1": {0: 56.96172837501805},
        "mean_snr_2": {0: 70.64953356907958},
        "mean_snr_3": {0: 43.04414740266073},
        "mean_snr_4": {0: 20.828005379261842},
        "mean_snr_5": {0: 21.614146690086248},
        "nb_points_0": {0: 0},
        "nb_points_1": {0: 5},
        "nb_points_2": {0: 20},
        "nb_points_3": {0: 20},
        "nb_points_4": {0: 15},
        "nb_points_5": {0: 23},
        "std_color": {0: 23200.220038367013},
        "max_color": {0: -53514.50876297413},
    }
)
