% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentimsr.R
\name{range,OpenTIMS-method}
\alias{range,OpenTIMS-method}
\title{Select a range of frames to extract.}
\usage{
\S4method{range}{OpenTIMS}(x, from, to, by = 1L)
}
\arguments{
\item{x}{OpenTIMS data instance.}

\item{from}{The first frame to extract.}

\item{to}{The last+1 frame to extract. Frame with that number will not get extracted, but some below that number might.}

\item{by}{Extract each by-th frame}
}
\description{
This is similar to using the from:to:by operator in Python.
}
\examples{
\dontrun{
D = OpenTIMS('path/to/your/folder.d')
print(head(range(D, 10,100,3))) # each third frame from 10 to 100.
}
}
