# Generated by Django 2.2.7 on 2019-11-15 12:49

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("django_celery_beat", "0011_auto_20190508_0153"),
    ]

    operations = [
        migrations.CreateModel(
            name="Schedule",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "actor_object_id",
                    models.PositiveIntegerField(
                        null=True, verbose_name="actor object id"
                    ),
                ),
                (
                    "verb",
                    models.CharField(
                        choices=[
                            ("activated", "activated"),
                            ("confirmed", "confirmed"),
                            ("dummy", "dummy"),
                        ],
                        max_length=255,
                        null=True,
                        verbose_name="verb",
                    ),
                ),
                (
                    "trigger_object_id",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="trigger object id"
                    ),
                ),
                (
                    "target_object_id",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="target object id"
                    ),
                ),
                (
                    "limit",
                    models.PositiveIntegerField(
                        help_text="Set to null to always launch the event.",
                        null=True,
                        verbose_name="limit",
                    ),
                ),
                (
                    "counter",
                    models.PositiveIntegerField(
                        blank=True,
                        default=0,
                        help_text="Number of times the schedule has been executed.",
                        verbose_name="counter",
                    ),
                ),
                (
                    "every",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of interval periods to wait before running the task again",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Number of Periods",
                    ),
                ),
                (
                    "period",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("days", "Days"),
                            ("hours", "Hours"),
                            ("minutes", "Minutes"),
                            ("seconds", "Seconds"),
                            ("microseconds", "Microseconds"),
                        ],
                        help_text="The type of period between task runs (Example: days)",
                        max_length=24,
                        null=True,
                        verbose_name="Interval Period",
                    ),
                ),
                (
                    "minute",
                    models.CharField(default="*", max_length=64, verbose_name="minute"),
                ),
                (
                    "hour",
                    models.CharField(default="*", max_length=64, verbose_name="hour"),
                ),
                (
                    "day_of_week",
                    models.CharField(
                        default="*", max_length=64, verbose_name="day of week"
                    ),
                ),
                (
                    "day_of_month",
                    models.CharField(
                        default="*", max_length=64, verbose_name="day of month"
                    ),
                ),
                (
                    "month_of_year",
                    models.CharField(
                        default="*", max_length=64, verbose_name="month of year"
                    ),
                ),
                (
                    "start_time",
                    models.DateTimeField(
                        blank=True,
                        help_text="Datetime when the schedule should begin triggering the task to run",
                        null=True,
                        verbose_name="Start Datetime",
                    ),
                ),
                (
                    "actor_content_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="actor_schedules",
                        to="contenttypes.ContentType",
                        verbose_name="actor content type",
                    ),
                ),
                (
                    "target_content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="target_schedules",
                        to="contenttypes.ContentType",
                        verbose_name="target content type",
                    ),
                ),
                (
                    "task",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="django_celery_beat.Periodictask",
                    ),
                ),
                (
                    "trigger_content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="trigger_schedules",
                        to="contenttypes.ContentType",
                        verbose_name="trigger content type",
                    ),
                ),
            ],
            options={
                "verbose_name": "schedule",
                "verbose_name_plural": "schedules",
                "ordering": ["-created"],
            },
        )
    ]
