# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ErrorFieldContract(msrest.serialization.Model):
    """Error Field contract.

    :param code: Property level error code.
    :type code: str
    :param message: Human-readable representation of property-level error.
    :type message: str
    :param target: Property name.
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorFieldContract, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates Insights service is not able to process the incoming request. The reason is provided in the error message.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Operation(msrest.serialization.Model):
    """CDN REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :param provider: Service provider: Microsoft.Cdn.
    :type provider: str
    :param resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list CDN operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of CDN operations supported by the CDN resource provider.
    :type value: list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name. This is GUID value. The display name should be assigned within
     properties field.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param kind: The kind of workbook. Choices are user and shared. Possible values include:
     "user", "shared".
    :type kind: str or ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class Workbook(Resource):
    """An Application Insights workbook definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name. This is GUID value. The display name should be assigned within
     properties field.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param kind: The kind of workbook. Choices are user and shared. Possible values include:
     "user", "shared".
    :type kind: str or ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param display_name: The user-defined name (display name) of the workbook.
    :type display_name: str
    :param serialized_data: Configuration of this particular workbook. Configuration data is a
     string containing valid JSON.
    :type serialized_data: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     workbook definition.
    :vartype time_modified: str
    :param category: Workbook category, as defined by the user at creation time.
    :type category: str
    :param version: Workbook version.
    :type version: str
    :param tags_properties_tags: A list of 0 or more tags that are associated with this workbook
     definition.
    :type tags_properties_tags: list[str]
    :ivar user_id: Unique user id of the specific user that owns this workbook.
    :vartype user_id: str
    :param source_id: ResourceId for a source resource.
    :type source_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'time_modified': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'serialized_data': {'key': 'properties.serializedData', 'type': 'str'},
        'time_modified': {'key': 'properties.timeModified', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '[str]'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
        'source_id': {'key': 'properties.sourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Workbook, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.serialized_data = kwargs.get('serialized_data', None)
        self.time_modified = None
        self.category = kwargs.get('category', None)
        self.version = kwargs.get('version', None)
        self.tags_properties_tags = kwargs.get('tags_properties_tags', None)
        self.user_id = None
        self.source_id = kwargs.get('source_id', None)


class WorkbookError(msrest.serialization.Model):
    """Error message body that will indicate why the operation failed.

    :param code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :type code: str
    :param message: Human-readable representation of the error.
    :type message: str
    :param details: The list of invalid fields send in request, in case of validation error.
    :type details:
     list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkbookError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class WorkbooksListResult(msrest.serialization.Model):
    """Workbook list result.

    :param value: An array of workbooks.
    :type value: list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.Workbook]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workbook]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkbooksListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class WorkbookUpdateParameters(msrest.serialization.Model):
    """The parameters that can be provided when updating workbook properties properties.

    :param kind: The kind of workbook. Choices are user and shared. Possible values include:
     "user", "shared".
    :type kind: str or ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param display_name: The user-defined name (display name) of the workbook.
    :type display_name: str
    :param serialized_data: Configuration of this particular workbook. Configuration data is a
     string containing valid JSON.
    :type serialized_data: str
    :param category: Workbook category, as defined by the user at creation time.
    :type category: str
    :param tags_properties_tags: A list of 0 or more tags that are associated with this workbook
     definition.
    :type tags_properties_tags: list[str]
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'serialized_data': {'key': 'properties.serializedData', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkbookUpdateParameters, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.tags = kwargs.get('tags', None)
        self.display_name = kwargs.get('display_name', None)
        self.serialized_data = kwargs.get('serialized_data', None)
        self.category = kwargs.get('category', None)
        self.tags_properties_tags = kwargs.get('tags_properties_tags', None)
