"use strict";
const assert_1 = require("@aws-cdk/assert");
const iam = require("@aws-cdk/aws-iam");
const eks = require("../lib");
const util_1 = require("./util");
module.exports = {
    'add Service Account': {
        'defaults should have default namespace and lowercase unique id'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            new eks.ServiceAccount(stack, 'MyServiceAccount', { cluster });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.KubernetesResource.RESOURCE_TYPE, {
                ServiceToken: {
                    'Fn::GetAtt': [
                        'awscdkawseksKubectlProviderNestedStackawscdkawseksKubectlProviderNestedStackResourceA7AEBA6B',
                        'Outputs.StackawscdkawseksKubectlProviderframeworkonEvent8897FD9BArn',
                    ],
                },
                Manifest: {
                    'Fn::Join': [
                        '',
                        [
                            '[{\"apiVersion\":\"v1\",\"kind\":\"ServiceAccount\",\"metadata\":{\"name\":\"stackmyserviceaccount58b9529e\",\"namespace\":\"default\",\"labels\":{\"app.kubernetes.io/name\":\"stackmyserviceaccount58b9529e\"},\"annotations\":{\"eks.amazonaws.com/role-arn\":\"',
                            {
                                'Fn::GetAtt': [
                                    'MyServiceAccountRoleB41709FF',
                                    'Arn',
                                ],
                            },
                            '\"}}}]',
                        ],
                    ],
                },
            }));
            assert_1.expect(stack).to(assert_1.haveResource(iam.CfnRole.CFN_RESOURCE_TYPE_NAME, {
                AssumeRolePolicyDocument: {
                    Statement: [
                        {
                            Action: 'sts:AssumeRoleWithWebIdentity',
                            Effect: 'Allow',
                            Principal: {
                                Federated: {
                                    Ref: 'ClusterOpenIdConnectProviderE7EB0530',
                                },
                            },
                            Condition: {
                                StringEquals: {
                                    'Fn::GetAtt': [
                                        'MyServiceAccountConditionJson1ED3BC54',
                                        'Value',
                                    ],
                                },
                            },
                        },
                    ],
                    Version: '2012-10-17',
                },
            }));
            test.done();
        },
        'should have allow multiple services accounts'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            cluster.addServiceAccount('MyServiceAccount');
            cluster.addServiceAccount('MyOtherServiceAccount');
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.KubernetesResource.RESOURCE_TYPE, {
                ServiceToken: {
                    'Fn::GetAtt': [
                        'awscdkawseksKubectlProviderNestedStackawscdkawseksKubectlProviderNestedStackResourceA7AEBA6B',
                        'Outputs.StackawscdkawseksKubectlProviderframeworkonEvent8897FD9BArn',
                    ],
                },
                Manifest: {
                    'Fn::Join': [
                        '',
                        [
                            '[{\"apiVersion\":\"v1\",\"kind\":\"ServiceAccount\",\"metadata\":{\"name\":\"stackclustermyotherserviceaccounta472761a\",\"namespace\":\"default\",\"labels\":{\"app.kubernetes.io/name\":\"stackclustermyotherserviceaccounta472761a\"},\"annotations\":{\"eks.amazonaws.com/role-arn\":\"',
                            {
                                'Fn::GetAtt': [
                                    'ClusterMyOtherServiceAccountRole764583C5',
                                    'Arn',
                                ],
                            },
                            '\"}}}]',
                        ],
                    ],
                },
            }));
            test.done();
        },
        'should have unique resource name'(test) {
            // GIVEN
            const { cluster } = util_1.testFixtureCluster();
            // WHEN
            cluster.addServiceAccount('MyServiceAccount');
            // THEN
            test.throws(() => cluster.addServiceAccount('MyServiceAccount'));
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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