import os
from pathlib import Path
from arc import color
import xdg

PROJECT_ROOT = Path(__file__).parent.parent
FG_ORANGE = color.fg.rgb(243, 108, 0)
BG_ORANGE = color.bg.rgb(243, 108, 0)

if os.getenv("SCYTHE_ENV") == "development":
    CONFIG_DIR = PROJECT_ROOT / "config"
    CACHE_DIR = CONFIG_DIR
else:
    CONFIG_DIR = xdg.xdg_config_home() / "scythe"
    CACHE_DIR = CONFIG_DIR


CONFIG_FILE = CONFIG_DIR / "config.yaml"
AUTOLOAD_DIR = CONFIG_DIR / "extensions"


# 40 x 21
SCYTHE = """\
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;45;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;45;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;252;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;45;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;235m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;188m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;31;48;5;247m▓\033[38;5;31;48;5;247m▓\033[38;5;45;48;5;244m▓\033[38;5;39;48;5;244m▓\033[38;5;38;48;5;102m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;232;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;252;48;5;252m▓\033[38;5;252;48;5;252m▓\033[38;5;237;48;5;237m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;188;48;5;252m▓\033[38;5;237;48;5;237m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;254;48;5;254m▓\033[38;5;255;48;5;255m▓\033[38;5;255;48;5;255m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;232;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;232;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;235m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;235m▓\033[38;5;236;48;5;235m▓\033[38;5;236;48;5;235m▓\033[38;5;232;48;5;16m▓\033[38;5;232;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;236;48;5;236m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m
\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[38;5;16;48;5;16m▓\033[0m\033[0m"""
